/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.dashboard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.acct.WAcctViewer;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.window.InfoSchedule;
import org.compiere.model.MInfoWindow;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUserDefInfo;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Box;
import org.zkoss.zul.Vbox;
import org.zkoss.zul.Window;

public class DPViews
extends DashboardPanel
implements EventListener<Event> {
    private static final long serialVersionUID = 8375414665766937581L;

    public DPViews() {
        this.setSclass("views-box");
        this.appendChild((Component)this.createViewPanel());
    }

    private Box createViewPanel() {
        ToolBarButton btnViewItem;
        Vbox vbox = new Vbox();
        if (MSysConfig.getBooleanValue((String)"DPViews_ShowInfoAccount", (boolean)true, (int)Env.getAD_Client_ID((Properties)Env.getCtx())) && MRole.getDefault().isShowAcct() && MRole.getDefault().isAllow_Info_Account()) {
            btnViewItem = new ToolBarButton("InfoAccount");
            btnViewItem.setSclass("link");
            btnViewItem.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"InfoAccount")));
            if (ThemeManager.isUseFontIconForImage()) {
                btnViewItem.setIconSclass("z-icon-InfoAccount");
            } else {
                btnViewItem.setImage(ThemeManager.getThemeResource("images/InfoAccount16.png"));
            }
            btnViewItem.addEventListener("onClick", this);
            vbox.appendChild((Component)btnViewItem);
            if (ThemeManager.isUseFontIconForImage()) {
                LayoutUtils.addSclass("medium-toolbarbutton toolbarbutton-with-text", (HtmlBasedComponent)btnViewItem);
            }
        }
        if (MSysConfig.getBooleanValue((String)"DPViews_ShowInfoSchedule", (boolean)true, (int)Env.getAD_Client_ID((Properties)Env.getCtx())) && MRole.getDefault().isAllow_Info_Schedule()) {
            btnViewItem = new ToolBarButton("InfoSchedule");
            btnViewItem.setSclass("link");
            btnViewItem.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"InfoSchedule")));
            if (ThemeManager.isUseFontIconForImage()) {
                btnViewItem.setIconSclass("z-icon-InfoSchedule");
            } else {
                btnViewItem.setImage(ThemeManager.getThemeResource("images/InfoSchedule16.png"));
            }
            btnViewItem.addEventListener("onClick", this);
            vbox.appendChild((Component)btnViewItem);
            if (ThemeManager.isUseFontIconForImage()) {
                LayoutUtils.addSclass("medium-toolbarbutton toolbarbutton-with-text", (HtmlBasedComponent)btnViewItem);
            }
        }
        List listAll = new Query(Env.getCtx(), "AD_InfoWindow", "IsValid='Y'", null).setOnlyActiveRecords(true).list();
        MInfoWindow[] infosAll = listAll.toArray(new MInfoWindow[listAll.size()]);
        ArrayList<ListInfoWindow> selectedInfoWindows = new ArrayList<ListInfoWindow>();
        int i = 0;
        while (i < infosAll.length) {
            MInfoWindow info = infosAll[i];
            if (MInfoWindow.get((int)info.getAD_InfoWindow_ID(), null) != null) {
                MUserDefInfo userDef = MUserDefInfo.getBestMatch((Properties)Env.getCtx(), (int)info.getAD_InfoWindow_ID());
                if (userDef != null) {
                    if (info.isShowInDashboard() && Util.isEmpty((String)userDef.getIsShowInDashboard()) || !Util.isEmpty((String)userDef.getIsShowInDashboard()) && userDef.getIsShowInDashboard().equals("Y")) {
                        int seqNo = userDef.getSeqNo() > 0 ? userDef.getSeqNo() : info.getSeqNo();
                        selectedInfoWindows.add(new ListInfoWindow(info, seqNo));
                    }
                } else if (info.isShowInDashboard()) {
                    selectedInfoWindows.add(new ListInfoWindow(info, info.getSeqNo()));
                }
            }
            ++i;
        }
        Collections.sort(selectedInfoWindows, new SeqNoComparator());
        for (ListInfoWindow so : selectedInfoWindows) {
            MInfoWindow info = so.getInfoWindow();
            if (MInfoWindow.get((int)info.getAD_InfoWindow_ID(), null) == null) continue;
            String name = info.get_Translation("Name");
            String image = Util.isEmpty((String)info.getImageURL()) ? "Info16.png" : info.getImageURL();
            MUserDefInfo userDef = MUserDefInfo.getBestMatch((Properties)Env.getCtx(), (int)info.getAD_InfoWindow_ID());
            if (userDef != null) {
                if (!Util.isEmpty((String)userDef.getName())) {
                    name = userDef.getName();
                }
                if (!Util.isEmpty((String)userDef.getImageURL())) {
                    image = userDef.getImageURL();
                }
            }
            ToolBarButton btnViewItem2 = new ToolBarButton(info.getName());
            btnViewItem2.setSclass("link");
            btnViewItem2.setLabel(name);
            if (ThemeManager.isUseFontIconForImage()) {
                image = image.replace("16.png", "");
                btnViewItem2.setIconSclass("z-icon-" + image);
            } else {
                btnViewItem2.setImage(ThemeManager.getThemeResource("images/" + image));
            }
            btnViewItem2.addEventListener("onClick", this);
            vbox.appendChild((Component)btnViewItem2);
            if (!ThemeManager.isUseFontIconForImage()) continue;
            LayoutUtils.addSclass("medium-toolbarbutton toolbarbutton-with-text", (HtmlBasedComponent)btnViewItem2);
        }
        return vbox;
    }

    public void onEvent(Event event) {
        Component comp = event.getTarget();
        String eventName = event.getName();
        if (eventName.equals("onClick") && comp instanceof ToolBarButton) {
            ToolBarButton btn = (ToolBarButton)comp;
            String actionCommand = btn.getName();
            if (actionCommand.equals("InfoAccount")) {
                new WAcctViewer();
            } else if (actionCommand.equals("InfoSchedule")) {
                InfoSchedule is = new InfoSchedule(null, false);
                is.setAttribute("mode", Window.Mode.EMBEDDED);
                AEnv.showWindow(is);
            } else {
                int infoWindowID = new Query(Env.getCtx(), "AD_InfoWindow", "Name = ?", null).setParameters(new Object[]{actionCommand}).setOnlyActiveRecords(true).firstIdOnly();
                if (infoWindowID <= 0) {
                    return;
                }
                SessionManager.getAppDesktop().openInfo(infoWindowID);
            }
        }
    }

    private class ListInfoWindow {
        MInfoWindow iw = null;
        int seqNo = 0;

        public ListInfoWindow(MInfoWindow infoWindow, int seqNo) {
            this.iw = infoWindow;
            this.seqNo = seqNo;
        }

        public int getSeqNo() {
            return this.seqNo;
        }

        public MInfoWindow getInfoWindow() {
            return this.iw;
        }
    }

    public static class SeqNoComparator
    implements Comparator<ListInfoWindow> {
        @Override
        public int compare(ListInfoWindow iw1, ListInfoWindow iw2) {
            return Integer.valueOf(iw1.getSeqNo()).compareTo(iw2.getSeqNo());
        }
    }
}

