/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.dashboard;

import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Properties;
import org.adempiere.base.Core;
import org.adempiere.base.event.EventManager;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ServerPushTemplate;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.distributed.IMessageService;
import org.idempiere.distributed.ITopic;
import org.idempiere.distributed.ITopicSubscriber;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zul.A;
import org.zkoss.zul.Box;
import org.zkoss.zul.Image;
import org.zkoss.zul.Panel;
import org.zkoss.zul.Panelchildren;
import org.zkoss.zul.Toolbar;
import org.zkoss.zul.Vbox;

public class DPRunningJobs
extends DashboardPanel
implements EventListener<org.zkoss.zk.ui.event.Event>,
EventHandler {
    private static final long serialVersionUID = -8515643315156488709L;
    private static final String AD_PINSTANCE_ID_ATTR = "AD_PInstance_ID";
    private static TopicSubscriber topicSubscriber;
    private Box bxJobs;
    private int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
    private WeakReference<Desktop> desktop;
    private DesktopCleanup listener;

    public DPRunningJobs() {
        Panel panel = new Panel();
        this.appendChild((Component)panel);
        Panelchildren jobsContent = new Panelchildren();
        panel.appendChild((Component)jobsContent);
        this.bxJobs = new Vbox();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.bxJobs, "1");
        this.setSclass("recentitems-box");
        jobsContent.appendChild((Component)this.bxJobs);
        Toolbar jobsToolbar = new Toolbar();
        this.appendChild((Component)jobsToolbar);
        if (ThemeManager.isUseFontIconForImage()) {
            ToolBarButton btn = new ToolBarButton();
            btn.setIconSclass("z-icon-Refresh");
            btn.setSclass("trash-toolbarbutton");
            jobsToolbar.appendChild((Component)btn);
            btn.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh")));
            btn.addEventListener("onClick", this);
        } else {
            Image imgr = new Image(ThemeManager.getThemeResource("images/Refresh24.png"));
            jobsToolbar.appendChild((Component)imgr);
            imgr.setStyle("text-align: right; cursor: pointer; width:24px; height:24px;");
            imgr.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh")));
            imgr.addEventListener("onClick", (EventListener)this);
        }
        DPRunningJobs.createTopicSubscriber();
        this.listener = new DesktopCleanup(){

            public void cleanup(Desktop desktop) throws Exception {
                DPRunningJobs.this.cleanup();
            }
        };
    }

    protected void cleanup() {
        EventManager.getInstance().unregister((EventHandler)this);
        this.desktop = null;
    }

    private static synchronized void createTopicSubscriber() {
        if (topicSubscriber == null) {
            topicSubscriber = new TopicSubscriber();
            IMessageService service = Core.getMessageService();
            if (service != null) {
                ITopic topic = service.getTopic("onRunningJobChanged");
                topic.subscribe((ITopicSubscriber)topicSubscriber);
            }
        }
    }

    public void onEvent(org.zkoss.zk.ui.event.Event event) throws Exception {
        Component comp = event.getTarget();
        String eventName = event.getName();
        if (eventName.equals("onClick")) {
            this.doOnClick(comp);
        }
    }

    private void doOnClick(Component comp) {
        if (comp instanceof A) {
            A btn = (A)comp;
            int AD_PInstance_ID = 0;
            try {
                AD_PInstance_ID = Integer.valueOf((String)btn.getAttribute(AD_PINSTANCE_ID_ATTR));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (AD_PInstance_ID > 0) {
                AEnv.zoom(282, AD_PInstance_ID);
            }
        }
        if (comp instanceof Image || comp instanceof ToolBarButton) {
            this.refresh();
        }
    }

    private synchronized void refresh() {
        List childs = this.bxJobs.getChildren();
        int childCount = childs.size();
        int c = childCount - 1;
        while (c >= 0) {
            Component comp = (Component)childs.get(c);
            if (comp instanceof A) {
                comp.removeEventListener("onClick", (EventListener)this);
            }
            this.bxJobs.removeChild(comp);
            --c;
        }
        List<MPInstance> pis = DPRunningJobs.getRunningJobForUser(this.AD_User_ID);
        for (MPInstance pi : pis) {
            MProcess process = new MProcess(pi.getCtx(), pi.getAD_Process_ID(), pi.get_TrxName());
            String label = String.valueOf(process.getName()) + " [" + Msg.getElement((Properties)pi.getCtx(), (String)"Created") + " = " + pi.getCreated() + "]";
            A btnJob = new A();
            btnJob.setAttribute(AD_PINSTANCE_ID_ATTR, (Object)String.valueOf(pi.getAD_PInstance_ID()));
            this.bxJobs.appendChild((Component)btnJob);
            btnJob.setLabel(label);
            if (ThemeManager.isUseFontIconForImage()) {
                btnJob.setIconSclass("z-icon-Window");
            } else {
                btnJob.setImage(ThemeManager.getThemeResource("images/mWindow.png"));
            }
            btnJob.addEventListener("onClick", (EventListener)this);
            btnJob.setSclass("menu-href");
            ZKUpdateUtil.setHflex((HtmlBasedComponent)btnJob, "1");
        }
    }

    public static List<MPInstance> getRunningJobForUser(int AD_User_ID) {
        List pis = new Query(Env.getCtx(), "AD_PInstance", "Coalesce(AD_User_ID,0)=? AND IsProcessing='Y' AND IsRunAsJob='Y'", null).setOnlyActiveRecords(true).setClient_ID().setParameters(new Object[]{AD_User_ID}).setOrderBy("Updated DESC").list();
        return pis;
    }

    @Override
    public void refresh(ServerPushTemplate template) {
        template.executeAsync(this);
    }

    @Override
    public void updateUI() {
        this.refresh();
        if (this.bxJobs != null) {
            this.bxJobs.invalidate();
        }
        this.updateDesktopReference();
    }

    protected void updateDesktopReference() {
        if (this.desktop == null || this.desktop.get() == null || this.desktop.get() != null && this.desktop.get() != this.getDesktop()) {
            if (this.desktop != null && this.desktop.get() != null) {
                ((Desktop)this.desktop.get()).removeListener((Object)this.listener);
            }
            this.desktop = new WeakReference<Desktop>(this.getDesktop());
            if (this.desktop != null && this.desktop.get() != null) {
                ((Desktop)this.desktop.get()).addListener((Object)this.listener);
            }
        }
    }

    public void handleEvent(Event event) {
        int id;
        Object property;
        if (event.getTopic().equals("onRunningJobChanged") && event.getProperty("AD_User_ID") != null && (property = event.getProperty("AD_User_ID")) instanceof Number && (id = ((Number)property).intValue()) == this.AD_User_ID) {
            try {
                if (this.desktop != null && this.desktop.get() != null && ((Desktop)this.desktop.get()).isAlive()) {
                    ServerPushTemplate template = new ServerPushTemplate((Desktop)this.desktop.get());
                    this.refresh(template);
                }
            }
            catch (Exception e) {
                EventManager.getInstance().unregister((EventHandler)this);
            }
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null) {
            EventManager.getInstance().register("onRunningJobChanged", (EventHandler)this);
            this.updateDesktopReference();
        }
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        this.cleanup();
    }

    @Override
    public boolean isLazy() {
        return true;
    }

    static class TopicSubscriber
    implements ITopicSubscriber<Integer> {
        TopicSubscriber() {
        }

        public void onMessage(Integer message) {
            MPInstance.postOnChangedEvent((int)message);
        }
    }
}

