/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.dashboard;

import org.adempiere.webui.apps.graph.WPAPanel;
import org.adempiere.webui.dashboard.DashboardPanel;
import org.adempiere.webui.util.ServerPushTemplate;
import org.compiere.model.MGoal;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.util.Clients;

public class DPPerformance
extends DashboardPanel {
    private static final long serialVersionUID = -8878665031716441912L;
    private WPAPanel paPanel;
    private MGoal[] performanceData;

    public DPPerformance() {
        this.setSclass("performance-widget");
        this.paPanel = new WPAPanel();
        this.appendChild((Component)this.paPanel);
        this.paPanel.addEventListener("onAfterRenderChart", e -> this.onPostRender());
    }

    @Override
    public void refresh(ServerPushTemplate template) {
        this.performanceData = WPAPanel.loadGoal();
        if (Executions.getCurrent() != null) {
            this.updateUI();
        } else {
            template.executeAsync(this);
        }
    }

    public void onPostRender() {
        if (this.getFirstChild() != null) {
            Component grid = this.getFirstChild().getFirstChild();
            String script = "setTimeout(function() { let grid = jq('#" + grid.getUuid() + "');";
            script = String.valueOf(script) + "grid.parent().height(grid.css('height'));}, 10);";
            if (Executions.getCurrent() != null) {
                Clients.response((AuResponse)new AuScript(script));
            }
        }
    }

    @Override
    public void updateUI() {
        this.paPanel.setGoals(this.performanceData, null);
        this.performanceData = null;
    }

    @Override
    public boolean isLazy() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.performanceData.length <= 0;
    }
}

