/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.model.MWlistboxCustomization;
import org.adempiere.webui.component.ListHead;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.WListItemRenderer;
import org.adempiere.webui.component.WTableColumn;
import org.adempiere.webui.event.TableValueChangeEvent;
import org.adempiere.webui.event.TableValueChangeListener;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.exception.ApplicationException;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MRole;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Listhead;
import org.zkoss.zul.Listheader;

public class WListbox
extends Listbox
implements IMiniTable,
TableValueChangeListener,
WTableModelListener {
    private static final long serialVersionUID = -5501893389366975849L;
    private static final CLogger logger = CLogger.getCLogger(WListbox.class);
    private boolean showTotals = false;
    protected int m_keyColumnIndex = -1;
    private ArrayList<Integer> m_readWriteColumn = new ArrayList();
    private ColumnInfo[] m_layout = null;
    private ArrayList<Class<?>> m_modelHeaderClass = new ArrayList();
    private int m_colorColumnIndex = -1;
    private Object m_colorDataCompare = Env.ZERO;
    private boolean allowIDColumnForReadWrite = false;
    private String wListBoxName = null;

    public WListbox() {
        WListItemRenderer rowRenderer = new WListItemRenderer();
        rowRenderer.addTableValueChangeListener(this);
        this.setItemRenderer(rowRenderer);
        this.setModel((ListModel<?>)new ListModelTable());
    }

    public void setData(ListModelTable model, List<? extends String> columnNames) {
        WListItemRenderer rowRenderer = null;
        if (columnNames != null && columnNames.size() > 0) {
            rowRenderer = new WListItemRenderer(columnNames);
            rowRenderer.addTableValueChangeListener(this);
        }
        this.setModel((ListModel<?>)model);
        if (rowRenderer != null) {
            this.getModel().setNoColumns(columnNames.size());
            this.setItemRenderer(rowRenderer);
            ListHead head = this.getListHead();
            if (head != null) {
                head.getChildren().clear();
                rowRenderer.renderListHead(head);
            }
        }
        this.repaint();
    }

    public void setModel(ListModel<?> model) {
        if (this.getModel() == model) {
            return;
        }
        super.setModel(model);
        if (model instanceof ListModelTable) {
            ((ListModelTable)model).addTableModelListener(this);
        }
    }

    public void initialiseHeader() {
        ListHead head = this.getListHead();
        if (head == null) {
            head = new ListHead();
            this.appendChild((Component)head);
        } else if (head.getChildren().size() > 0) {
            if (this.getItemRenderer() instanceof WListItemRenderer) {
                boolean clearTableColumns = false;
                WListItemRenderer renderer = (WListItemRenderer)this.getItemRenderer();
                if (renderer.getTableColumns().size() != head.getChildren().size()) {
                    clearTableColumns = true;
                } else {
                    List<WTableColumn> m_tableColumns = renderer.getTableColumns();
                    int columnIndex = 0;
                    while (columnIndex < m_tableColumns.size()) {
                        WTableColumn column = m_tableColumns.get(columnIndex);
                        ListHeader header = renderer.getListHeader(columnIndex);
                        if (header != null && !header.getLabel().equals(column.getHeaderValue())) {
                            clearTableColumns = true;
                            break;
                        }
                        ++columnIndex;
                    }
                    if (!clearTableColumns) {
                        return;
                    }
                }
                if (clearTableColumns) {
                    head.getChildren().clear();
                }
            } else {
                return;
            }
        }
        if (!(this.getItemRenderer() instanceof WListItemRenderer)) {
            throw new ApplicationException("Rendering of the ListHead is unsupported for " + this.getItemRenderer().getClass().getSimpleName());
        }
        ((WListItemRenderer)this.getItemRenderer()).renderListHead(head);
    }

    public boolean isCellEditable(int row, int column) {
        Object val = this.getValueAt(row, 0);
        if (column != 0 && val instanceof Boolean && !((Boolean)val).booleanValue()) {
            return false;
        }
        if (this.allowIDColumnForReadWrite && column != 0 && val instanceof IDColumn && !((IDColumn)val).isSelected()) {
            return false;
        }
        return this.m_readWriteColumn.contains(column);
    }

    public Object getValueAt(int row, int column) {
        return this.getModel().getDataAt(row, this.convertColumnIndexToModel(column));
    }

    public ListModelTable getModel() {
        if (super.getModel() == null) {
            return null;
        }
        if (super.getModel() instanceof ListModelTable) {
            return (ListModelTable)super.getModel();
        }
        throw new IllegalArgumentException("Model must be instance of " + ListModelTable.class.getName());
    }

    public void setValueAt(Object value, int row, int column) {
        this.getModel().setDataAt(value, row, this.convertColumnIndexToModel(column));
    }

    public int convertColumnIndexToModel(int viewColumnIndex) {
        return viewColumnIndex;
    }

    public void setColumnReadOnly(int index, boolean readOnly) {
        Integer indexObject = index;
        if (this.m_readWriteColumn.contains(indexObject)) {
            if (readOnly) {
                this.m_readWriteColumn.remove(indexObject);
            }
        } else if (!readOnly) {
            this.m_readWriteColumn.add(indexObject);
        }
    }

    public String prepareTable(ColumnInfo[] layout, String from, String where, boolean multiSelection, String tableName) {
        return this.prepareTable(layout, from, where, multiSelection, tableName, true);
    }

    public String prepareTable(ColumnInfo[] layout, String from, String where, boolean multiSelection, String tableName, boolean addAccessSQL) {
        int columnIndex = 0;
        StringBuilder sql = new StringBuilder("SELECT ");
        this.setLayout(layout);
        this.clearColumns();
        this.setMultiSelection(multiSelection);
        columnIndex = 0;
        while (columnIndex < layout.length) {
            if (columnIndex > 0) {
                sql.append(", ");
            }
            sql.append(layout[columnIndex].getColSQL());
            if (layout[columnIndex].isKeyPairCol()) {
                sql.append(",").append(layout[columnIndex].getKeyPairColSQL());
            }
            this.addColumn(layout[columnIndex].getColHeader(), layout[columnIndex].getColDescription(), layout[columnIndex].getAD_Reference_ID());
            if (layout[columnIndex].isColorColumn()) {
                this.setColorColumn(columnIndex);
            }
            if (layout[columnIndex].getColClass() == IDColumn.class) {
                this.m_keyColumnIndex = columnIndex;
            }
            ++columnIndex;
        }
        columnIndex = 0;
        while (columnIndex < layout.length) {
            this.setColumnClass(columnIndex, layout[columnIndex].getColClass(), layout[columnIndex].isReadOnly(), layout[columnIndex].getColHeader());
            ++columnIndex;
        }
        sql.append(" FROM ").append(from);
        sql.append(" WHERE ").append(where);
        if (from.length() == 0) {
            return sql.toString();
        }
        if (addAccessSQL) {
            String finalSQL = MRole.getDefault().addAccessSQL(sql.toString(), tableName, true, false);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest(finalSQL);
            }
            return finalSQL;
        }
        return sql.toString();
    }

    private void clearColumns() {
        ((WListItemRenderer)this.getItemRenderer()).clearColumns();
        this.getModel().setNoColumns(0);
    }

    public void addColumn(String header) {
        this.addColumn(header, null);
    }

    public void addColumn(String header, String description) {
        this.addColumn(header, description, 0);
    }

    public void addColumn(String header, String description, int AD_Reference_ID) {
        WListItemRenderer renderer = (WListItemRenderer)this.getItemRenderer();
        renderer.addColumn(Util.cleanAmp((String)header), description, AD_Reference_ID);
        this.getModel().addColumn();
    }

    public void setColumnClass(int index, Class<?> classType, boolean readOnly, String header) {
        WListItemRenderer renderer = (WListItemRenderer)this.getItemRenderer();
        this.setColumnReadOnly(index, readOnly);
        renderer.setColumnHeader(index, header);
        renderer.setColumnClass(index, classType);
        if (index < this.m_modelHeaderClass.size()) {
            this.m_modelHeaderClass.set(index, classType);
        } else {
            this.m_modelHeaderClass.add(classType);
        }
    }

    public void setColumnClass(int index, Class<?> classType, boolean readOnly) {
        this.setColumnReadOnly(index, readOnly);
        WListItemRenderer renderer = (WListItemRenderer)this.getItemRenderer();
        renderer.setColumnClass(index, classType);
        this.m_modelHeaderClass.add(classType);
    }

    public void addColumn(Class<?> classType, boolean readOnly, String header) {
        this.m_modelHeaderClass.add(classType);
        this.setColumnReadOnly(this.m_modelHeaderClass.size() - 1, readOnly);
        this.addColumn(header);
        WListItemRenderer renderer = (WListItemRenderer)this.getItemRenderer();
        renderer.setColumnClass(renderer.getNoColumns() - 1, classType);
    }

    public void setColorColumn(int modelIndex) {
        this.m_colorColumnIndex = modelIndex;
    }

    public void loadTable(ResultSet rs) {
        int row = 0;
        int col = 0;
        Object data = null;
        int rsColIndex = 0;
        int rsColOffset = 1;
        if (this.getLayout() == null) {
            throw new UnsupportedOperationException("Layout not defined");
        }
        this.clearTable();
        try {
            while (rs.next()) {
                row = this.getItemCount();
                this.setRowCount(row + 1);
                rsColOffset = 1;
                col = 0;
                while (col < this.m_layout.length) {
                    data = null;
                    Class columnClass = this.m_layout[col].getColClass();
                    rsColIndex = col + rsColOffset;
                    if (this.isColumnClassMismatch(col, columnClass)) {
                        throw new ApplicationException("Cannot enter a " + columnClass.getName() + " in column " + col + ". " + "An object of type " + this.m_modelHeaderClass.get(col).getSimpleName() + " was expected.");
                    }
                    if (columnClass == IDColumn.class) {
                        data = new IDColumn(rs.getInt(rsColIndex));
                    } else if (columnClass == Boolean.class) {
                        data = rs.getString(rsColIndex).equals("Y");
                    } else if (columnClass == Timestamp.class) {
                        data = rs.getTimestamp(rsColIndex);
                    } else if (columnClass == BigDecimal.class) {
                        data = rs.getBigDecimal(rsColIndex);
                    } else if (columnClass == Double.class) {
                        data = rs.getDouble(rsColIndex);
                    } else if (columnClass == Integer.class) {
                        data = rs.getInt(rsColIndex);
                    } else if (columnClass == KeyNamePair.class) {
                        String display = rs.getString(rsColIndex);
                        int key = rs.getInt(rsColIndex + 1);
                        data = new KeyNamePair(key, display);
                        ++rsColOffset;
                    } else {
                        String s = rs.getString(rsColIndex);
                        data = s != null ? s.trim() : null;
                    }
                    this.getModel().setDataAt(data, row, col);
                    ++col;
                }
            }
        }
        catch (SQLException exception) {
            logger.log(Level.SEVERE, "", (Throwable)exception);
        }
        if (this.getShowTotals()) {
            this.addTotals(this.m_layout);
        }
        this.repaint();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Row(rs)=" + this.getRowCount());
        }
    }

    private boolean isColumnClassMismatch(int col, Class<?> columnClass) {
        return !columnClass.equals(this.m_modelHeaderClass.get(col));
    }

    public void loadTable(PO[] pos) {
        int row = 0;
        int col = 0;
        int poIndex = 0;
        if (this.m_layout == null) {
            throw new UnsupportedOperationException("Layout not defined");
        }
        this.clearTable();
        poIndex = 0;
        while (poIndex < pos.length) {
            PO myPO = pos[poIndex];
            row = this.getRowCount();
            this.setRowCount(row + 1);
            col = 0;
            while (col < this.m_layout.length) {
                String columnName = this.m_layout[col].getColSQL();
                Object data = myPO.get_Value(columnName);
                if (data != null) {
                    Class columnClass = this.m_layout[col].getColClass();
                    if (this.isColumnClassMismatch(col, columnClass)) {
                        throw new ApplicationException("Cannot enter a " + columnClass.getName() + " in column " + col + ". " + "An object of type " + this.m_modelHeaderClass.get(col).getSimpleName() + " was expected.");
                    }
                    if (columnClass == IDColumn.class) {
                        data = new IDColumn(((Integer)data).intValue());
                    } else if (columnClass == Double.class) {
                        data = ((BigDecimal)data).doubleValue();
                    }
                }
                this.getModel().setDataAt(data, row, col);
                ++col;
            }
            ++poIndex;
        }
        if (this.getShowTotals()) {
            this.addTotals(this.m_layout);
        }
        this.repaint();
        if (logger.isLoggable(Level.CONFIG)) {
            logger.config("Row(array)=" + this.getRowCount());
        }
    }

    public void clear() {
        this.getChildren().clear();
    }

    public Integer getSelectedRowKey() {
        if (this.m_layout == null) {
            throw new UnsupportedOperationException("Layout not defined");
        }
        int row = this.getSelectedRow();
        return this.getRowKeyAt(row);
    }

    public Integer getRowKeyAt(int index) {
        if (index < 0 || this.m_keyColumnIndex < 0) {
            return null;
        }
        Object data = this.getModel().getDataAt(index, this.m_keyColumnIndex);
        if (data instanceof IDColumn) {
            data = ((IDColumn)data).getRecord_ID();
        }
        if (data instanceof Integer) {
            return (Integer)data;
        }
        return null;
    }

    public void setSelectedByKeys(List<Integer> lsKey) {
        if (this.m_keyColumnIndex < 0) {
            return;
        }
        ListModelTable model = this.getModel();
        ArrayList<Object> lsSelectedItem = new ArrayList<Object>();
        int index = 0;
        while (index < model.getSize()) {
            Integer key = this.getRowKeyAt(index);
            if (key != null && lsKey.contains(key)) {
                lsSelectedItem.add(model.getElementAt(index));
            }
            ++index;
        }
        model.setSelection(lsSelectedItem);
    }

    public Integer getFirstRowKey() {
        if (this.m_layout == null) {
            throw new UnsupportedOperationException("Layout not defined");
        }
        if (this.getRowCount() <= 0) {
            return null;
        }
        return this.getRowKeyAt(0);
    }

    public int getSelectedRow() {
        return this.getSelectedIndex();
    }

    public void setRowCount(int rowCount) {
        this.getModel().setNoRows(rowCount);
    }

    public void setwListBoxName(String wListBoxName) {
        this.wListBoxName = wListBoxName;
    }

    public String getwListBoxName() {
        return this.wListBoxName;
    }

    public ColumnInfo[] getLayoutInfo() {
        return this.getLayout();
    }

    public void clearTable() {
        WListItemRenderer renderer = null;
        this.getModel().clear();
        if (!(this.getItemRenderer() instanceof WListItemRenderer)) {
            throw new IllegalArgumentException("Renderer must be instance of WListItemRenderer");
        }
        renderer = (WListItemRenderer)this.getItemRenderer();
        renderer.clearSelection();
    }

    public int getRowCount() {
        return this.getModel().getSize();
    }

    public void setMultiSelection(boolean multiSelection) {
        this.setMultiple(multiSelection);
    }

    public boolean isMultiSelection() {
        return this.isMultiple();
    }

    public void setShowTotals(boolean show) {
        this.showTotals = show;
    }

    public boolean getShowTotals() {
        return this.showTotals;
    }

    public void setColorCompare(Object dataCompare) {
        this.m_colorDataCompare = dataCompare;
    }

    public int getColorCode(int row) {
        boolean valPositive = true;
        int valNegative = -1;
        boolean valOtherwise = false;
        int cmp = 0;
        if (this.m_colorColumnIndex == -1) {
            return 0;
        }
        Object data = this.getModel().getDataAt(row, this.m_colorColumnIndex);
        if (data == null) {
            return 0;
        }
        try {
            if (data instanceof Timestamp) {
                if (this.m_colorDataCompare == null || !(this.m_colorDataCompare instanceof Timestamp)) {
                    this.m_colorDataCompare = new Timestamp(System.currentTimeMillis());
                }
                cmp = ((Timestamp)this.m_colorDataCompare).compareTo((Timestamp)data);
            } else {
                if (this.m_colorDataCompare == null || !(this.m_colorDataCompare instanceof BigDecimal)) {
                    this.m_colorDataCompare = Env.ZERO;
                }
                if (!(data instanceof BigDecimal)) {
                    data = new BigDecimal(data.toString());
                }
                cmp = ((BigDecimal)this.m_colorDataCompare).compareTo((BigDecimal)data);
            }
        }
        catch (Exception exception) {
            return 0;
        }
        if (cmp > 0) {
            return -1;
        }
        if (cmp < 0) {
            return 1;
        }
        return 0;
    }

    @Override
    public void tableValueChange(TableValueChangeEvent event) {
        int col = event.getColumn();
        int row = event.getRow();
        if (col >= 0 && row >= 0) {
            if (this.getValueAt(row, col) instanceof IDColumn && event.getNewValue() instanceof Boolean) {
                boolean newBoolean = (Boolean)event.getNewValue();
                IDColumn idColumn = (IDColumn)this.getValueAt(row, col);
                idColumn.setSelected(newBoolean);
                this.setValueAt(idColumn, row, col);
            } else {
                this.setValueAt(event.getNewValue(), row, col);
            }
        }
    }

    public void repaint() {
        this.initialiseHeader();
        this.renderCustomHeaderWidth();
        this.invalidate();
    }

    public ColumnInfo[] getLayout() {
        return this.m_layout;
    }

    private void setLayout(ColumnInfo[] layout) {
        this.m_layout = layout;
        this.getModel().setNoColumns(this.m_layout.length);
    }

    @Override
    public void tableChanged(WTableModelEvent event) {
        if (event.getType() == 0 && event.getColumn() == -1 && event.getFirstRow() == -1) {
            this.repaint();
            ListModelTable model = this.getModel();
            model.updateComponent(0, model.getSize() - 1);
        } else if (event.getType() == 0 && event.getFirstRow() != -1 && !this.m_readWriteColumn.isEmpty()) {
            int[] indices = this.getSelectedIndices();
            ListModelTable model = this.getModel();
            if (event.getLastRow() > event.getFirstRow()) {
                model.updateComponent(event.getFirstRow(), event.getLastRow());
            } else {
                model.updateComponent(event.getFirstRow());
            }
            if (indices != null && indices.length > 0) {
                this.setSelectedIndices(indices);
            }
        }
    }

    @Deprecated
    public void autoSize() {
    }

    public int getColumnCount() {
        return this.getModel() != null ? this.getModel().getNoColumns() : 0;
    }

    public int getKeyColumnIndex() {
        return this.m_keyColumnIndex;
    }

    public void addTotals(ColumnInfo[] layout) {
        int col;
        if (this.getRowCount() == 0 || layout.length == 0) {
            return;
        }
        Object[] total = new Object[layout.length];
        int row = 0;
        while (row < this.getRowCount()) {
            col = 0;
            while (col < layout.length) {
                Number amt;
                Number subtotal;
                Object data = this.getModel().getValueAt(row, col);
                Class c = layout[col].getColClass();
                if (c == BigDecimal.class) {
                    subtotal = Env.ZERO;
                    if (total[col] != null) {
                        subtotal = (BigDecimal)total[col];
                    }
                    amt = (BigDecimal)data;
                    if (subtotal == null) {
                        subtotal = Env.ZERO;
                    }
                    if (amt == null) {
                        amt = Env.ZERO;
                    }
                    total[col] = ((BigDecimal)subtotal).add((BigDecimal)amt);
                } else if (c == Double.class) {
                    subtotal = 0.0;
                    if (total[col] != null) {
                        subtotal = (Double)total[col];
                    }
                    amt = (Double)data;
                    if (subtotal == null) {
                        subtotal = 0.0;
                    }
                    if (amt == null) {
                        amt = 0.0;
                    }
                    total[col] = (Double)subtotal + (Double)amt;
                }
                ++col;
            }
            ++row;
        }
        row = this.getRowCount() + 1;
        this.setRowCount(row);
        col = 0;
        while (col < layout.length) {
            Class c = layout[col].getColClass();
            if (c == BigDecimal.class) {
                this.setValueAt(total[col], row - 1, col);
            } else if (c == Double.class) {
                this.setValueAt(total[col], row - 1, col);
            } else if (col == 0) {
                this.setValueAt(" \u03a3  ", row - 1, col);
            } else {
                this.setValueAt(null, row - 1, col);
            }
            ++col;
        }
    }

    public boolean isAllowIDColumnForReadWrite() {
        return this.allowIDColumnForReadWrite;
    }

    public void setAllowIDColumnForReadWrite(boolean allowIDColumnForReadWrite) {
        this.allowIDColumnForReadWrite = allowIDColumnForReadWrite;
    }

    private String getColumnWidth(String columnName, List<String> columnList) {
        String width = "null";
        for (String column : columnList) {
            String[] w = column.trim().split("=");
            if (!w[0].equals(columnName)) continue;
            return w[1];
        }
        return width;
    }

    public void renderCustomHeaderWidth() {
        MWlistboxCustomization WListBoxCustomization;
        Boolean isHasCustomizeData;
        if (this.wListBoxName != null && this.getListHead() != null && (isHasCustomizeData = Boolean.valueOf((WListBoxCustomization = MWlistboxCustomization.get((Properties)Env.getCtx(), (int)Env.getAD_User_ID((Properties)Env.getCtx()), (String)this.wListBoxName, null)) != null && WListBoxCustomization.getAD_Wlistbox_Customization_ID() > 0 && WListBoxCustomization.getCustom() != null && WListBoxCustomization.getCustom().trim().length() > 0)).booleanValue()) {
            String[] custom = WListBoxCustomization.getCustom().trim().split(",");
            List<String> columnList = Arrays.asList(custom);
            ColumnInfo[] Columns2 = this.getLayout();
            Listhead listHead = this.getListhead();
            if (listHead != null && columnList.size() > 0) {
                List headers = listHead.getChildren();
                int i = 0;
                for (Object obj : headers) {
                    Listheader header = (Listheader)obj;
                    String columnWidth = this.getColumnWidth(Columns2[i].getColumnName(), columnList);
                    if (!"null".equals(columnWidth)) {
                        ZKUpdateUtil.setWidth((HtmlBasedComponent)header, columnWidth);
                    }
                    ++i;
                }
            }
        }
    }

    public void saveColumnWidth() {
        if (!Util.isEmpty((String)this.getwListBoxName())) {
            StringBuilder custom = new StringBuilder();
            ListHead listHead = this.getListHead();
            ColumnInfo[] layout = this.getLayout();
            if (listHead != null && layout != null) {
                List headers = listHead.getChildren();
                if (headers.size() != layout.length) {
                    return;
                }
                int i = 0;
                for (Object obj : headers) {
                    Listheader header = (Listheader)obj;
                    String width = header.getWidth();
                    String colName = layout[i].getColumnName();
                    if (colName != null && !colName.isEmpty()) {
                        custom.append(String.valueOf(colName) + "=");
                        if (width == null) {
                            width = "null";
                        }
                        custom.append(width);
                        custom.append(",");
                    }
                    ++i;
                }
                if (custom.length() > 0) {
                    custom.deleteCharAt(custom.length() - 1);
                }
                MWlistboxCustomization.saveData((Properties)Env.getCtx(), (String)this.getwListBoxName(), (int)Env.getAD_User_ID((Properties)Env.getCtx()), (String)custom.toString(), null);
            }
        }
    }
}

