/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Properties;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MSysConfig;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Decimalbox;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Vbox;

public class NumberBox
extends Div {
    private static final long serialVersionUID = 8543853599051754172L;
    private Textbox txtCalc = new Textbox();
    protected boolean integral = false;
    protected NumberFormat format = null;
    private Decimalbox decimalBox = null;
    private Button btn;
    private Popup popup;

    public NumberBox(boolean integral) {
        this(integral, false);
    }

    public NumberBox(boolean integral, boolean tableEditor) {
        this.integral = integral;
        this.init(tableEditor);
    }

    private void init(boolean tableEditor) {
        this.decimalBox = new Decimalbox();
        if (this.integral) {
            this.decimalBox.setScale(0);
        }
        this.decimalBox.setStyle("display: inline-block;text-align:right");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.decimalBox, "0");
        this.decimalBox.setSclass("editor-input");
        this.decimalBox.setId(this.decimalBox.getUuid());
        char separatorChar = DisplayType.getNumberFormat((int)22, null).getDecimalFormatSymbols().getDecimalSeparator();
        String separator = Character.toString(separatorChar);
        boolean processDotKeypad = MSysConfig.getBooleanValue((String)"ZK_DECIMALBOX_PROCESS_DOTKEYPAD", (boolean)true, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        if (processDotKeypad && !".".equals(separator)) {
            StringBuffer funct = new StringBuffer();
            funct.append("function(evt)");
            funct.append("{");
            funct.append("    if (!this._shallIgnore(evt, '0123456789-%'))");
            funct.append("    {");
            funct.append("        this.$doKeyPress_(evt);");
            funct.append("    }");
            funct.append("}");
            this.decimalBox.setWidgetOverride("doKeyPress_", funct.toString());
            funct = new StringBuffer();
            funct.append("(function(event) {");
            funct.append("let key=0;");
            funct.append("if (window.event)");
            funct.append("    key = event.keyCode;");
            funct.append("else");
            funct.append("    key = event.which;");
            funct.append("if (key == 108 || key == 110 || key == 188 || key == 190 || key == 194) {");
            funct.append("    let id = '$'.concat('").append(this.decimalBox.getId()).append("');");
            funct.append("    let calcText = jq(id)[0];");
            funct.append("    let position = calcText.selectionStart;");
            funct.append("    let newValue = calcText.value.substring(0, position) + '").append(separator).append("' + calcText.value.substring(position);");
            funct.append("    calcText.value = newValue;");
            funct.append("    calcText.setSelectionRange(position+1, position+1);");
            funct.append("    event.stop;");
            funct.append("}})(event);");
            this.decimalBox.setWidgetListener("onKeyDown", funct.toString());
        }
        this.appendChild((Component)this.decimalBox);
        this.btn = new Button();
        if (ThemeManager.isUseFontIconForImage()) {
            this.btn.setIconSclass("z-icon-Calculator");
        } else {
            this.btn.setImage(ThemeManager.getThemeResource("images/Calculator16.png"));
        }
        this.btn.setTabindex(-1);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.btn, "0");
        this.btn.addEventListener("onClick", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (NumberBox.this.popup != null) {
                    NumberBox.this.popup.open((Component)NumberBox.this, "after_start");
                    String curValue = "";
                    if (NumberBox.this.decimalBox.getValue() != null) {
                        curValue = NumberBox.this.decimalBox.getValue().toString();
                        boolean processDotKeypad = MSysConfig.getBooleanValue((String)"ZK_DECIMALBOX_PROCESS_DOTKEYPAD", (boolean)true, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
                        if (processDotKeypad) {
                            char separatorChar = DisplayType.getNumberFormat((int)22, null).getDecimalFormatSymbols().getDecimalSeparator();
                            String separator = Character.toString(separatorChar);
                            curValue = curValue.replace(".", separator);
                        }
                        if ("0".equals(curValue)) {
                            curValue = "";
                        }
                    }
                    String txtCalcId = NumberBox.this.txtCalc.getId();
                    Clients.evalJavaScript((String)("calc.append('" + txtCalcId + "', '" + curValue + "')"));
                }
            }
        });
        LayoutUtils.addSclass("editor-button", (HtmlBasedComponent)this.btn);
        this.appendChild((Component)this.btn);
        this.popup = this.getCalculatorPopup();
        this.appendChild((Component)this.popup);
        this.btn.setStyle("text-align: center;");
        LayoutUtils.addSclass("number-box", (HtmlBasedComponent)this);
        LayoutUtils.addSclass("editor-box", (HtmlBasedComponent)this);
        if (ClientInfo.isMobile()) {
            LayoutUtils.addSclass("mobile", (HtmlBasedComponent)this.decimalBox);
            this.btn.setVisible(false);
        }
    }

    public void setFormat(NumberFormat format) {
        this.format = format;
    }

    public void setValue(Object value) {
        if (value == null) {
            this.decimalBox.setValue(null);
        } else if (value instanceof BigDecimal) {
            this.decimalBox.setValue((BigDecimal)value);
        } else if (value instanceof Number) {
            this.decimalBox.setValue(BigDecimal.valueOf(((Number)value).doubleValue()));
        } else {
            this.decimalBox.setValue(new BigDecimal(value.toString()));
        }
    }

    public BigDecimal getValue() {
        return this.decimalBox.getValue();
    }

    public String getText() {
        BigDecimal value = this.decimalBox.getValue();
        if (value == null) {
            return null;
        }
        return this.decimalBox.getText();
    }

    public void setValue(String value) {
        Number numberValue = null;
        if (this.format != null) {
            try {
                numberValue = this.format.parse(value);
                this.setValue(numberValue);
            }
            catch (ParseException parseException) {}
        } else {
            this.decimalBox.setValue(new BigDecimal(value));
        }
    }

    private Popup getCalculatorPopup() {
        Popup popup = new Popup();
        Vbox vbox = new Vbox();
        char separatorChar = DisplayType.getNumberFormat((int)22, null).getDecimalFormatSymbols().getDecimalSeparator();
        String separator = Character.toString(separatorChar);
        this.txtCalc = new Textbox();
        this.decimalBox.setId(this.decimalBox.getUuid());
        this.txtCalc.setId(this.txtCalc.getUuid());
        boolean processDotKeypad = MSysConfig.getBooleanValue((String)"ZK_DECIMALBOX_PROCESS_DOTKEYPAD", (boolean)true, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        StringBuffer funct = new StringBuffer();
        funct.append("function(evt)");
        funct.append("{");
        if (processDotKeypad) {
            funct.append("    if (!this._shallIgnore(evt, '= -/()*%+0123456789'))");
        } else {
            String decimalSep = separator;
            if (!".".equals(separator)) {
                decimalSep = String.valueOf(decimalSep) + ".";
            }
            funct.append("    if (!this._shallIgnore(evt, '= -/()*%+0123456789").append(decimalSep).append("'))");
        }
        funct.append("    {");
        funct.append("        this.$doKeyPress_(evt);");
        funct.append("    }");
        funct.append("}");
        this.txtCalc.setWidgetOverride("doKeyPress_", funct.toString());
        this.txtCalc.setWidgetListener("onKeyDown", "calc.validateDown('" + this.decimalBox.getId() + "','" + this.txtCalc.getId() + "'," + this.integral + "," + separatorChar + ", event, " + (processDotKeypad ? "true" : "false") + ");");
        this.txtCalc.setMaxlength(250);
        this.txtCalc.setCols(30);
        String txtCalcId = this.txtCalc.getId();
        vbox.appendChild((Component)this.txtCalc);
        Hbox row1 = new Hbox();
        Button btnAC = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btnAC, "40px");
        btnAC.setLabel("AC");
        btnAC.setWidgetListener("onClick", "calc.clearAll('" + txtCalcId + "')");
        Button btn7 = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btn7, "30px");
        btn7.setLabel("7");
        btn7.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', '7')");
        Button btn8 = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btn8, "30px");
        btn8.setLabel("8");
        btn8.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', '8')");
        Button btn9 = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btn9, "30px");
        btn9.setLabel("9");
        btn9.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', '9')");
        Button btnMultiply = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btnMultiply, "30px");
        btnMultiply.setLabel("*");
        btnMultiply.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', ' * ')");
        row1.appendChild((Component)btnAC);
        row1.appendChild((Component)btn7);
        row1.appendChild((Component)btn8);
        row1.appendChild((Component)btn9);
        row1.appendChild((Component)btnMultiply);
        Hbox row2 = new Hbox();
        Button btnC = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btnC, "40px");
        btnC.setLabel("C");
        btnC.setWidgetListener("onClick", "calc.clear('" + txtCalcId + "')");
        Button btn4 = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btn4, "30px");
        btn4.setLabel("4");
        btn4.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', '4')");
        Button btn5 = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btn5, "30px");
        btn5.setLabel("5");
        btn5.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', '5')");
        Button btn6 = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btn6, "30px");
        btn6.setLabel("6");
        btn6.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', '6')");
        Button btnDivide = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btnDivide, "30px");
        btnDivide.setLabel("/");
        btnDivide.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', ' / ')");
        row2.appendChild((Component)btnC);
        row2.appendChild((Component)btn4);
        row2.appendChild((Component)btn5);
        row2.appendChild((Component)btn6);
        row2.appendChild((Component)btnDivide);
        Hbox row3 = new Hbox();
        Button btnModulo = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btnModulo, "40px");
        btnModulo.setLabel("%");
        btnModulo.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', ' % ')");
        Button btn1 = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btn1, "30px");
        btn1.setLabel("1");
        btn1.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', '1')");
        Button btn2 = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btn2, "30px");
        btn2.setLabel("2");
        btn2.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', '2')");
        Button btn3 = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btn3, "30px");
        btn3.setLabel("3");
        btn3.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', '3')");
        Button btnSubstract = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btnSubstract, "30px");
        btnSubstract.setLabel("-");
        btnSubstract.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', ' - ')");
        row3.appendChild((Component)btnModulo);
        row3.appendChild((Component)btn1);
        row3.appendChild((Component)btn2);
        row3.appendChild((Component)btn3);
        row3.appendChild((Component)btnSubstract);
        Hbox row4 = new Hbox();
        Button btnCurrency = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btnCurrency, "40px");
        btnCurrency.setLabel("$");
        btnCurrency.setDisabled(true);
        Button btn0 = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btn0, "30px");
        btn0.setLabel("0");
        btn0.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', '0')");
        Button btnDot = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btnDot, "30px");
        btnDot.setLabel(separator);
        btnDot.setDisabled(this.integral);
        btnDot.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', '" + separator + "')");
        Button btnEqual = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btnEqual, "30px");
        btnEqual.setLabel("=");
        btnEqual.setWidgetListener("onClick", "calc.evaluate('" + this.decimalBox.getId() + "','" + txtCalcId + "','" + separator + "')");
        Button btnAdd = new Button();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)btnAdd, "30px");
        btnAdd.setLabel("+");
        btnAdd.setWidgetListener("onClick", "calc.append('" + txtCalcId + "', ' + ')");
        row4.appendChild((Component)btnCurrency);
        row4.appendChild((Component)btnDot);
        row4.appendChild((Component)btn0);
        row4.appendChild((Component)btnEqual);
        row4.appendChild((Component)btnAdd);
        vbox.appendChild((Component)row1);
        vbox.appendChild((Component)row2);
        vbox.appendChild((Component)row3);
        vbox.appendChild((Component)row4);
        popup.appendChild((Component)vbox);
        popup.setWidgetListener("onOpen", "calc.clearAll('" + txtCalcId + "')");
        popup.addEventListener("onCancel", e -> popup.close());
        return popup;
    }

    public boolean isIntegral() {
        return this.integral;
    }

    public void setIntegral(boolean integral) {
        this.integral = integral;
        if (integral) {
            this.decimalBox.setScale(0);
        } else {
            this.decimalBox.setScale(-1000000000);
        }
    }

    public void setEnabled(boolean enabled) {
        this.decimalBox.setReadonly(!enabled);
        this.decimalBox.setDisabled(!enabled);
        this.btn.setEnabled(enabled);
        if (enabled) {
            if (this.btn.getParent() != this.decimalBox.getParent()) {
                this.btn.setParent(this.decimalBox.getParent());
            }
        } else if (this.btn.getParent() != null) {
            this.btn.detach();
        }
        if (enabled) {
            LayoutUtils.removeSclass("editor-input-disd", (HtmlBasedComponent)this.decimalBox);
        } else {
            LayoutUtils.addSclass("editor-input-disd", (HtmlBasedComponent)this.decimalBox);
        }
    }

    public boolean isEnabled() {
        return !this.decimalBox.isReadonly();
    }

    public boolean addEventListener(String evtnm, EventListener<?> listener) {
        if ("onClick".equals(evtnm)) {
            return this.btn.addEventListener(evtnm, listener);
        }
        return this.decimalBox.addEventListener(evtnm, listener);
    }

    public void focus() {
        this.decimalBox.focus();
    }

    public Decimalbox getDecimalbox() {
        return this.decimalBox;
    }

    public Button getButton() {
        return this.btn;
    }

    public void setTableEditorMode(boolean flag) {
        if (flag) {
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this, "0");
            LayoutUtils.addSclass("grid-editor-input", (HtmlBasedComponent)this.decimalBox);
            LayoutUtils.addSclass("grid-editor-button", (HtmlBasedComponent)this.btn);
        } else {
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this, "1");
            LayoutUtils.removeSclass("grid-editor-input", (HtmlBasedComponent)this.decimalBox);
            LayoutUtils.removeSclass("grid-editor-button", (HtmlBasedComponent)this.btn);
        }
    }
}

