/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.HashMap;
import java.util.Properties;
import org.adempiere.util.Callback;
import org.adempiere.webui.AdempiereIdGenerator;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WStringEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zhtml.Text;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.select.annotation.Listen;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Image;
import org.zkoss.zul.Vbox;

public class Messagebox
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 8928526331932742124L;
    private static final String MESSAGE_PANEL_STYLE = "text-align:left; word-break: break-all; overflow: auto; max-height: 350pt; min-width: 230pt; max-width: 450pt;";
    private static final String SMALLER_MESSAGE_PANEL_STYLE = "text-align:left; word-break: break-all; overflow: auto; max-height: 350pt; min-width: 180pt; ";
    private String msg = "";
    private String imgSrc = "";
    private Text lblMsg = new Text();
    private Button btnOk;
    private Button btnCancel;
    private Button btnYes;
    private Button btnNo;
    private Button btnAbort;
    private Button btnRetry;
    private Button btnIgnore;
    private WEditor inputField;
    private boolean isInputMandatory;
    private boolean isExceptionThrown = false;
    private Image img = new Image();
    private int returnValue;
    private Callback callback;
    private boolean isInput = false;
    public static final int OK = 1;
    public static final int CANCEL = 2;
    public static final int YES = 16;
    public static final int NO = 32;
    public static final int ABORT = 256;
    public static final int RETRY = 512;
    public static final int IGNORE = 1024;
    public static final int INPUT = 2048;
    public static final String QUESTION = "~./zul/img/msgbox/question-btn.png";
    public static final String EXCLAMATION = "~./zul/img/msgbox/warning-btn.png";
    public static final String INFORMATION = "~./zul/img/msgbox/info-btn.png";
    public static final String ERROR = "~./zul/img/msgbox/stop-btn.png";
    public static final String NONE = null;

    private void init() {
        this.setSclass("popup-dialog");
        Properties ctx = Env.getCtx();
        this.lblMsg.setEncode(false);
        this.lblMsg.setValue(this.msg);
        this.lblMsg.setClientAttribute("style", "word-break: normal;");
        this.btnOk = ButtonFactory.createNamedButton("Ok");
        this.btnOk.setId("btnOk");
        this.btnOk.addEventListener("onClick", this);
        this.btnCancel = ButtonFactory.createNamedButton("Cancel");
        this.btnCancel.addEventListener("onClick", this);
        this.btnCancel.setId("btnCancel");
        String yesLabel = Util.cleanAmp((String)Msg.getMsg((Properties)ctx, (String)"Yes"));
        this.btnYes = ButtonFactory.createButton(ButtonFactory.isWithText() ? yesLabel : null, ButtonFactory.isWithImage() ? (ButtonFactory.isWithText() ? ThemeManager.getThemeResource("images/Ok16.png") : ThemeManager.getThemeResource("images/Ok24.png")) : null, ButtonFactory.isWithText() ? null : yesLabel);
        this.btnYes.addEventListener("onClick", this);
        this.btnYes.setId("btnYes");
        String noLabel = Util.cleanAmp((String)Msg.getMsg((Properties)ctx, (String)"No"));
        this.btnNo = ButtonFactory.createButton(ButtonFactory.isWithText() ? noLabel : null, ButtonFactory.isWithImage() ? (ButtonFactory.isWithText() ? ThemeManager.getThemeResource("images/Cancel16.png") : ThemeManager.getThemeResource("images/Cancel24.png")) : null, ButtonFactory.isWithText() ? null : noLabel);
        this.btnNo.addEventListener("onClick", this);
        this.btnNo.setId("btnNo");
        this.btnAbort = ButtonFactory.createButton("Abort", null, null);
        this.btnAbort.addEventListener("onClick", this);
        this.btnAbort.setId("btnAbort");
        this.btnRetry = ButtonFactory.createButton("Retry", null, null);
        this.btnRetry.addEventListener("onClick", this);
        this.btnRetry.setId("btnRetry");
        this.btnIgnore = ButtonFactory.createNamedButton("Ignore");
        this.btnIgnore.addEventListener("onClick", this);
        this.btnIgnore.setId("btnIgnore");
        Panel pnlMessage = new Panel();
        if (ClientInfo.maxWidth(399)) {
            pnlMessage.setStyle(SMALLER_MESSAGE_PANEL_STYLE);
            this.setWidth("100%");
        } else {
            pnlMessage.setStyle(MESSAGE_PANEL_STYLE);
        }
        pnlMessage.appendChild((Component)this.lblMsg);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)pnlMessage, "min");
        Panel pnlInput = new Panel();
        pnlInput.setStyle(MESSAGE_PANEL_STYLE);
        pnlInput.appendChild(this.inputField.getComponent());
        Vbox pnlText = new Vbox();
        pnlText.appendChild((Component)pnlMessage);
        pnlText.appendChild((Component)pnlInput);
        Hbox pnlImage = new Hbox();
        String iconSclass = null;
        Label label = null;
        if (ThemeManager.isUseFontIconForImage()) {
            if (this.imgSrc.equals(QUESTION)) {
                iconSclass = "z-icon-QuestionMessageBox";
            } else if (this.imgSrc.equals(EXCLAMATION)) {
                iconSclass = "z-icon-ExclamationMessageBox";
            } else if (this.imgSrc.equals(INFORMATION)) {
                iconSclass = "z-icon-InformationMessageBox";
            } else if (this.imgSrc.equals(ERROR)) {
                iconSclass = "z-icon-ErrorMessageBox";
            }
        }
        if (ThemeManager.isUseFontIconForImage() && iconSclass != null) {
            label = new Label();
            label.setSclass(iconSclass);
        } else {
            this.img.setSrc(this.imgSrc);
        }
        ZKUpdateUtil.setWidth((HtmlBasedComponent)pnlImage, "72px");
        pnlImage.setAlign("center");
        pnlImage.setPack("center");
        if (ThemeManager.isUseFontIconForImage() && iconSclass != null) {
            pnlImage.appendChild((Component)label);
        } else {
            pnlImage.appendChild((Component)this.img);
        }
        Hbox north = new Hbox();
        north.setAlign("center");
        this.appendChild((Component)north);
        north.appendChild((Component)pnlImage);
        north.appendChild((Component)pnlText);
        north.setSclass("dialog-content");
        north.setWidth("100%");
        Hbox pnlButtons = new Hbox();
        pnlButtons.setAlign("center");
        pnlButtons.setPack("end");
        pnlButtons.appendChild((Component)this.btnOk);
        pnlButtons.appendChild((Component)this.btnCancel);
        pnlButtons.appendChild((Component)this.btnYes);
        pnlButtons.appendChild((Component)this.btnNo);
        pnlButtons.appendChild((Component)this.btnAbort);
        pnlButtons.appendChild((Component)this.btnRetry);
        pnlButtons.appendChild((Component)this.btnIgnore);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)pnlButtons, "100%");
        this.appendChild((Component)pnlButtons);
        pnlButtons.setSclass("dialog-footer");
        this.setBorder("normal");
        this.setContentStyle("background-color:#ffffff;");
        this.setPosition("left, top");
    }

    public int show(String message, String title, int buttons, String icon) {
        return this.show(message, title, buttons, icon, null);
    }

    public int show(String message, String title, int buttons, String icon, Callback<Integer> callback) {
        return this.show(message, title, buttons, icon, callback, false);
    }

    public int show(String message, String title, int buttons, String icon, Callback<?> callback, boolean modal) {
        return this.show(message, title, buttons, icon, null, false, callback, modal);
    }

    public int show(String message, String title, int buttons, String icon, WEditor editor, boolean isInputMandatory, Callback<?> callback, boolean modal) {
        this.msg = message;
        this.imgSrc = icon;
        this.callback = callback;
        this.inputField = editor == null ? new WStringEditor() : editor;
        this.isInputMandatory = isInputMandatory;
        this.init();
        this.btnOk.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnYes.setVisible(false);
        this.btnNo.setVisible(false);
        this.btnRetry.setVisible(false);
        this.btnAbort.setVisible(false);
        this.btnIgnore.setVisible(false);
        this.inputField.setVisible(false);
        if ((buttons & 1) != 0) {
            this.btnOk.setVisible(true);
        }
        if ((buttons & 2) != 0) {
            this.btnCancel.setVisible(true);
        }
        if ((buttons & 0x10) != 0) {
            this.btnYes.setVisible(true);
        }
        if ((buttons & 0x20) != 0) {
            this.btnNo.setVisible(true);
        }
        if ((buttons & 0x200) != 0) {
            this.btnRetry.setVisible(true);
        }
        if ((buttons & 0x100) != 0) {
            this.btnAbort.setVisible(true);
        }
        if ((buttons & 0x400) != 0) {
            this.btnIgnore.setVisible(true);
        }
        if ((buttons & 0x800) != 0) {
            this.inputField.setVisible(true);
            this.isInput = true;
            this.inputField.addValueChangeListener(new ValueChangeListener(){

                @Override
                public void valueChange(ValueChangeEvent evt) {
                    Messagebox.this.isExceptionThrown = false;
                }
            });
        }
        this.setTitle(title);
        this.setPosition("center");
        this.setClosable(true);
        this.setAttribute("mode", modal ? "modal" : "highlighted");
        this.setSizable(true);
        this.setVisible(true);
        String id = "MessageBox_" + AdempiereIdGenerator.escapeId(title);
        Page page = AEnv.getDesktop().getFirstPage();
        Component fellow = page.getFellowIfAny(id);
        if (fellow != null) {
            int count = 0;
            String newId = null;
            while (fellow != null) {
                newId = String.valueOf(id) + "_" + ++count;
                fellow = page.getFellowIfAny(newId);
            }
            id = newId;
        }
        this.setId(id);
        AEnv.showCenterScreen(this);
        return this.returnValue;
    }

    public static int showDialog(String message, String title, int buttons, String icon) {
        return Messagebox.showDialog(message, title, buttons, icon, null);
    }

    public static int showDialog(String message, String title, int buttons, String icon, Callback<Integer> callback) {
        return Messagebox.showDialog(message, title, buttons, icon, callback, false);
    }

    public static int showDialog(String message, String title, int buttons, String icon, Callback<?> callback, boolean modal) {
        return Messagebox.showDialog(message, title, buttons, icon, null, false, callback, modal);
    }

    public static int showDialog(String message, String title, int buttons, String icon, WEditor editor, Callback<?> callback, boolean modal) {
        return Messagebox.showDialog(message, title, buttons, icon, editor, false, callback, modal);
    }

    public static int showDialog(String message, String title, int buttons, String icon, WEditor editor, boolean isInputMandatory, Callback<?> callback, boolean modal) {
        Messagebox msg = new Messagebox();
        return msg.show(message, title, buttons, icon, editor, isInputMandatory, callback, modal);
    }

    @Listen(value="onCancel")
    public void onCancel() throws Exception {
        this.returnValue = 2;
        this.close();
    }

    public void onEvent(Event event) throws Exception {
        if (event == null) {
            return;
        }
        this.returnValue = event.getTarget() == this.btnOk ? 1 : (event.getTarget() == this.btnCancel ? 2 : (event.getTarget() == this.btnYes ? 16 : (event.getTarget() == this.btnNo ? 32 : (event.getTarget() == this.btnAbort ? 256 : (event.getTarget() == this.btnRetry ? 512 : (event.getTarget() == this.btnIgnore ? 1024 : 0))))));
        this.validateOnClose();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void validateOnClose() {
        if (this.returnValue == 2 || !this.isInputMandatory || this.isInputMandatory && !Util.isEmpty((String)String.valueOf(this.inputField.getValue()))) {
            if (Util.isEmpty((String)this.inputField.getValidInput())) {
                this.close();
                return;
            }
            if (this.returnValue == 2 || this.inputField.isValid(String.valueOf(this.inputField.getValue())) && this.returnValue == 1) {
                this.close();
                return;
            }
            this.isExceptionThrown = true;
            this.returnValue = 0;
            throw new WrongValueException(this.inputField.getComponent(), Msg.getMsg((Properties)Env.getCtx(), (String)"ValueNotCorrect"));
        }
        this.isExceptionThrown = true;
        this.returnValue = 0;
        throw new WrongValueException(this.inputField.getComponent(), Msg.getMsg((Properties)Env.getCtx(), (String)"AnswerMandatory"));
    }

    private void close() {
        block2: {
            try {
                this.detach();
            }
            catch (NullPointerException npe) {
                if (SessionManager.getSessionApplication() == null) break block2;
                throw npe;
            }
        }
    }

    @Override
    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        if (this.callback != null && !this.isInput) {
            this.callback.onCallback((Object)this.returnValue);
        } else if (this.callback != null && this.isInput && !this.btnCancel.isVisible() && !this.btnNo.isVisible()) {
            this.callback.onCallback(this.inputField.getValue());
        } else if (this.callback != null && this.isInput && (this.btnCancel.isVisible() || this.btnNo.isVisible())) {
            HashMap<Boolean, Object> map = new HashMap<Boolean, Object>();
            map.put(this.returnValue == 1 || this.returnValue == 16, this.isExceptionThrown ? "" : this.inputField.getValue());
            this.callback.onCallback(map.entrySet().iterator().next());
        }
    }
}

