/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.adwindow.ADTabpanel;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.component.ADTreeFavoriteOnDropListener;
import org.adempiere.webui.component.SimpleTreeModel;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.desktop.AbstractDesktop;
import org.adempiere.webui.desktop.FavouriteController;
import org.adempiere.webui.desktop.IDesktop;
import org.adempiere.webui.exception.ApplicationException;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.compiere.model.MMenu;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.MToolBarButtonRestrict;
import org.compiere.model.MTreeNode;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeModel;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.Treecell;
import org.zkoss.zul.Treecol;
import org.zkoss.zul.Treecols;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.TreeitemRenderer;
import org.zkoss.zul.Treerow;

public class FavoriteSimpleTreeModel
extends SimpleTreeModel
implements EventListener<Event>,
TreeitemRenderer<Object> {
    private static final long serialVersionUID = 6950349031548896628L;
    private static final CLogger LOG = CLogger.getCLogger(FavoriteSimpleTreeModel.class);
    public static final String MOBILE_TOOLBAR_CTX_MENU = "MobileFavCtxMenu";
    private List<EventListener<Event>> onDropListners = new ArrayList<EventListener<Event>>();
    private boolean itemDraggable;

    public FavoriteSimpleTreeModel(DefaultTreeNode<Object> root) {
        super(root);
    }

    public static FavoriteSimpleTreeModel initADTree(Tree tree, String trxName) {
        FavouriteController controller = FavouriteController.getInstance(Executions.getCurrent().getDesktop().getSession());
        MTreeNode root = controller.getRootNode();
        FavoriteSimpleTreeModel treeModel = FavoriteSimpleTreeModel.createFrom(root);
        treeModel.addOnDropEventListener(new ADTreeFavoriteOnDropListener(tree, treeModel));
        treeModel.setItemDraggable(true);
        if (tree.getTreecols() == null) {
            Treecols treeCols = new Treecols();
            tree.appendChild((Component)treeCols);
            Treecol treeCol = new Treecol();
            treeCols.appendChild((Component)treeCol);
        }
        tree.setPageSize(-1);
        try {
            tree.setItemRenderer((TreeitemRenderer)treeModel);
            tree.setModel((TreeModel)treeModel);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to setup favourite tree");
        }
        controller.setTreeAndModel(treeModel, tree);
        return treeModel;
    }

    public static FavoriteSimpleTreeModel createFrom(MTreeNode root) {
        Enumeration nodeEnum = root.children();
        DefaultTreeNode stRoot = new DefaultTreeNode((Object)root, (Collection)(nodeEnum.hasMoreElements() ? new ArrayList() : null));
        FavoriteSimpleTreeModel.populate((DefaultTreeNode<Object>)stRoot, root);
        return new FavoriteSimpleTreeModel((DefaultTreeNode<Object>)stRoot);
    }

    private static void populate(DefaultTreeNode<Object> stNode, MTreeNode root) {
        Enumeration nodeEnum = root.children();
        while (nodeEnum.hasMoreElements()) {
            MTreeNode childNode = (MTreeNode)nodeEnum.nextElement();
            DefaultTreeNode stChildNode = childNode.getChildCount() > 0 ? new DefaultTreeNode((Object)childNode, new ArrayList()) : new DefaultTreeNode((Object)childNode);
            stNode.getChildren().add(stChildNode);
            if (childNode.getChildCount() <= 0) continue;
            FavoriteSimpleTreeModel.populate((DefaultTreeNode<Object>)stChildNode, childNode);
        }
    }

    @Override
    public void render(Treeitem ti, Object node, int index) {
        DefaultTreeNode stn = (DefaultTreeNode)node;
        MTreeNode mNode = (MTreeNode)stn.getData();
        Treecell tc = new Treecell(Objects.toString(node));
        Treerow tr2 = null;
        if (ti.getTreerow() == null) {
            tr2 = new Treerow();
            tr2.setParent((Component)ti);
            if (this.isItemDraggable()) {
                tr2.setDraggable("true");
            }
            if (!this.onDropListners.isEmpty()) {
                ti.getTreerow().addEventListener("onClick", (EventListener)this);
                tr2.setDroppable("true");
                tr2.addEventListener("onSelect", (EventListener)this);
                tr2.addEventListener("onDrop", (EventListener)this);
                if (!ClientInfo.isMobile()) {
                    tr2.addEventListener("onRightClick", (EventListener)this);
                }
            }
            ti.setOpen(!mNode.isCollapsible());
            ti.setTooltiptext(mNode.getDescription());
            if (mNode.getColor() != null) {
                String hex = ZkCssHelper.createHexColorString(mNode.getColor());
                ZkCssHelper.appendStyle((HtmlBasedComponent)tc, "color: #" + hex);
            }
            if (ThemeManager.isUseFontIconForImage()) {
                tc.setIconSclass(FavoriteSimpleTreeModel.getIconSclass(mNode));
            } else {
                tc.setImage(ThemeManager.getThemeResource(FavoriteSimpleTreeModel.getIconFile(mNode)));
            }
            if (mNode.isSummary()) {
                tc.addSclass("fav-summary-folder");
            }
            if (mNode.isWindow() && !MToolBarButtonRestrict.isNewButtonRestricted((int)MMenu.get((int)mNode.getMenu_ID()).getAD_Window_ID())) {
                Toolbarbutton newBtn = new Toolbarbutton();
                newBtn.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"New")));
                newBtn.addEventListener("onClick", (EventListener)this);
                tc.appendChild((Component)newBtn);
                if (ThemeManager.isUseFontIconForImage()) {
                    newBtn.setIconSclass("z-icon-New");
                    newBtn.setSclass("new-toolbarbutton");
                } else {
                    newBtn.setSclass("menu-href-newbtn");
                    newBtn.setImage(ThemeManager.getThemeResource("images/New10.png"));
                }
            }
            if (ClientInfo.isMobile()) {
                Toolbarbutton btnContextMenu = new Toolbarbutton();
                btnContextMenu.setClass("fav-mobile-ctx-menu");
                btnContextMenu.setIconSclass("z-icon-More");
                btnContextMenu.setAttribute(MOBILE_TOOLBAR_CTX_MENU, (Object)true);
                btnContextMenu.addEventListener("onClick", (EventListener)this);
                tc.appendChild((Component)btnContextMenu);
            }
        } else {
            tr2 = ti.getTreerow();
            tr2.getChildren().clear();
        }
        tc.setParent((Component)tr2);
        ti.setValue(node);
    }

    @Override
    public void onEvent(Event event) throws Exception {
        Component comp = event.getTarget();
        String eventName = event.getName();
        if ("onDrop".equals(eventName) || "onRightClick".equals(eventName) || "onClick".equals(eventName) && comp instanceof Toolbarbutton && ((Toolbarbutton)event.getTarget()).getAttribute(MOBILE_TOOLBAR_CTX_MENU) != null && ((Boolean)((Toolbarbutton)event.getTarget()).getAttribute(MOBILE_TOOLBAR_CTX_MENU)).booleanValue()) {
            for (EventListener<Event> listener : this.onDropListners) {
                listener.onEvent(event);
            }
        } else if ("onClick".equals(eventName) || "onSelect".equals(eventName)) {
            boolean newRecord = false;
            if (comp instanceof Toolbarbutton) {
                comp = comp.getParent().getParent();
                newRecord = true;
            }
            if (comp instanceof Treerow) {
                Treerow treerow = (Treerow)comp;
                Treeitem treeitem = (Treeitem)treerow.getParent();
                Object value = treeitem.getValue();
                DefaultTreeNode dtNode = (DefaultTreeNode)value;
                MTreeNode mtn = (MTreeNode)dtNode.getData();
                if (newRecord) {
                    this.onNewRecord(mtn.getMenu_ID());
                } else if (!mtn.isSummary()) {
                    int menuID = mtn.getMenu_ID();
                    SessionManager.getAppDesktop().onMenuSelected(menuID);
                }
            }
        }
    }

    @Override
    public void addNode(DefaultTreeNode<Object> newNode) {
        DefaultTreeNode<Object> root = this.getRoot();
        root.getChildren().add(newNode);
        this.fireEvent(1, this.getPath((TreeNode)root), root.getChildCount() - 1, root.getChildCount() - 1);
    }

    public DefaultTreeNode<Object> getChild(DefaultTreeNode<Object> parent, int index) {
        return (DefaultTreeNode)parent.getChildAt(index);
    }

    private void onNewRecord(int menuID) {
        try {
            MMenu menu = (MMenu)MTable.get((Properties)Env.getCtx(), (int)116).getPO(menuID, null);
            IDesktop desktop = SessionManager.getAppDesktop();
            if (desktop instanceof AbstractDesktop) {
                ((AbstractDesktop)desktop).setPredefinedContextVariables(menu.getPredefinedContextVariables());
            }
            MQuery query = new MQuery("");
            query.addRestriction("1=2");
            query.setRecordCount(0);
            SessionManager.getAppDesktop().openWindow(menu.getAD_Window_ID(), query, new Callback<ADWindow>(){

                public void onCallback(ADWindow result) {
                    if (result == null) {
                        return;
                    }
                    result.getADWindowContent().onNew();
                    ADTabpanel adtabpanel = (ADTabpanel)result.getADWindowContent().getADTab().getSelectedTabpanel();
                    adtabpanel.focusToFirstEditor(false);
                }
            });
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    @Override
    public void addOnDropEventListener(EventListener<Event> listener) {
        this.onDropListners.add(listener);
    }

    @Override
    public void setItemDraggable(boolean isDraggable) {
        this.itemDraggable = isDraggable;
    }

    @Override
    public boolean isItemDraggable() {
        return this.itemDraggable;
    }

    private static String getIconFile(MTreeNode mt) {
        if (mt.isSummary()) {
            return "images/Folder16.png";
        }
        if (mt.isWindow()) {
            return "images/mWindow.png";
        }
        if (mt.isReport()) {
            return "images/mReport.png";
        }
        if (mt.isTask() || mt.isProcess()) {
            return "images/mProcess.png";
        }
        if (mt.isWorkFlow()) {
            return "images/mWorkFlow.png";
        }
        if (mt.isForm()) {
            return "images/mForm.png";
        }
        if (mt.isInfo()) {
            return "images/mInfo.png";
        }
        return "images/mWindow.png";
    }

    private static String getIconSclass(MTreeNode mt) {
        if (mt.isSummary()) {
            return "z-icon-Folder";
        }
        if (mt.isWindow()) {
            return "z-icon-Window";
        }
        if (mt.isReport()) {
            return "z-icon-Report";
        }
        if (mt.isProcess()) {
            return "z-icon-Process";
        }
        if (mt.isTask()) {
            return "z-icon-Task";
        }
        if (mt.isWorkFlow()) {
            return "z-icon-WorkFlow";
        }
        if (mt.isForm()) {
            return "z-icon-Form";
        }
        if (mt.isInfo()) {
            return "z-icon-Info";
        }
        return "z-icon-Window";
    }
}

