/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.adempiere.webui.component.Datebox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Timebox;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.EventListener;

public class DatetimeBox
extends Panel {
    private static final long serialVersionUID = -1075410511739601354L;
    private Datebox dateBox = new Datebox();
    private Timebox timeBox;
    private TimeZone timeZone;

    public DatetimeBox() {
        this.dateBox.setCols(10);
        this.timeBox = new Timebox();
        this.timeBox.setCols(10);
        this.appendChild((Component)this.dateBox);
        this.appendChild((Component)this.timeBox);
        this.initComponents();
    }

    private void initComponents() {
        this.setSclass("datetime-box");
    }

    public void setValue(Date date) {
        this.dateBox.setValue(date);
        this.timeBox.setValue(date);
    }

    public void setText(String text) {
        if (text != null && text.trim().length() > 0) {
            String[] s = text.split("\\s");
            this.dateBox.setText(s[0]);
            this.timeBox.setText(s[1]);
        } else {
            this.dateBox.setValue(null);
            this.timeBox.setValue(null);
        }
    }

    public String getText() {
        return String.valueOf(this.dateBox.getText()) + " " + this.timeBox.getText();
    }

    public boolean addEventListener(String evtnm, EventListener<?> listener) {
        return this.dateBox.addEventListener(evtnm, listener) && this.timeBox.addEventListener(evtnm, listener);
    }

    public boolean isEnabled() {
        return !this.dateBox.isReadonly();
    }

    public void setEnabled(boolean readWrite) {
        this.dateBox.setReadonly(!readWrite);
        this.timeBox.setReadonly(!readWrite);
        this.dateBox.setButtonVisible(readWrite);
        this.timeBox.setButtonVisible(readWrite);
    }

    public Date getValue() {
        Date d = null;
        if (this.timeZone != null) {
            ZonedDateTime zonedDate = this.dateBox.getValueInZonedDateTime();
            if (zonedDate != null) {
                d = Date.from(zonedDate.toInstant().atZone(this.timeZone.toZoneId()).toInstant());
            }
            Date t = null;
            ZonedDateTime zonedTime = this.timeBox.getValueInZonedDateTime();
            if (zonedTime != null) {
                t = Date.from(zonedTime.toInstant().atZone(this.timeZone.toZoneId()).toInstant());
            }
            if (d != null && t != null) {
                Calendar cd = Calendar.getInstance();
                cd.setTimeZone(this.dateBox.getTimeZone());
                cd.setTime(d);
                Calendar ct = Calendar.getInstance();
                ct.setTimeZone(this.timeBox.getTimeZone());
                ct.setTime(t);
                cd.set(cd.get(1), cd.get(2), cd.get(5), ct.get(11), ct.get(12), ct.get(13));
                d = cd.getTime();
            }
        } else {
            d = this.dateBox.getValue();
            Date t = this.timeBox.getValue();
            if (d != null && t != null) {
                Calendar cd = Calendar.getInstance();
                cd.setTime(d);
                Calendar ct = Calendar.getInstance();
                ct.setTime(t);
                cd.set(cd.get(1), cd.get(2), cd.get(5), ct.get(11), ct.get(12), ct.get(13));
                d = cd.getTime();
            }
        }
        return d;
    }

    public void setDateFormat(SimpleDateFormat dateFormat) {
        this.dateBox.setFormat(dateFormat.toPattern());
    }

    public Datebox getDatebox() {
        return this.dateBox;
    }

    public Timebox getTimebox() {
        return this.timeBox;
    }

    public void setTimeZone(TimeZone tz) {
        this.timeZone = tz;
        this.dateBox.setTimeZone(tz);
        this.timeBox.setTimeZone(tz);
        if (tz == null) {
            this.timeBox.setCols(10);
        } else {
            this.timeBox.setCols(14);
        }
    }

    public void setValueInLocalDateTime(LocalDateTime localTime) {
        this.dateBox.setValueInLocalDateTime(localTime);
        this.timeBox.setValueInLocalDateTime(localTime);
    }

    public void setValueInZonedDateTime(ZonedDateTime zdt) {
        this.dateBox.setValueInZonedDateTime(zdt);
        this.timeBox.setValueInZonedDateTime(zdt);
    }
}

