/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.List;
import org.adempiere.webui.AdempiereIdGenerator;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.ComboItem;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Comboitem;

public class Combobox
extends org.zkoss.zul.Combobox
implements IdSpace {
    private static final long serialVersionUID = -6278632602577424842L;

    public Combobox() {
        this.override();
        this.init();
    }

    public Combobox(String value) throws WrongValueException {
        super(value);
        this.override();
        this.init();
    }

    private void init() {
        this.setCtrlKeys("^#down");
        this.addEventListener("onCtrlKey", e -> {
            if (this.isEnabled() && LayoutUtils.isReallyVisible((Component)this)) {
                if (!this.isOpen()) {
                    this.setOpen(true);
                }
                e.stopPropagation();
            }
        });
    }

    private void override() {
        this.setWidgetOverride("shallIgnoreClick_", "function(evt) { return false; }");
    }

    public void setEnabled(boolean enabled) {
        this.setDisabled(!enabled);
        if (!enabled && this.getPage() != null) {
            String script = "(function(){let w=zk('#" + this.getUuid() + "').$(); if (w){w.close();let j=jq('#" + this.getUuid() + " :focus');if(j.get(0)){j.blur();}}" + "})()";
            Clients.response((AuResponse)new AuScript(script));
        }
    }

    public Comboitem appendItem(String label) {
        ComboItem item = new ComboItem(label);
        String id = AdempiereIdGenerator.escapeId(label);
        if (this.getFellowIfAny(id) == null) {
            item.setId(id);
        }
        item.setParent((Component)this);
        return item;
    }

    public boolean isEnabled() {
        return !this.isDisabled();
    }

    public void removeAllItems() {
        int cnt = this.getItemCount();
        int i = cnt - 1;
        while (i >= 0) {
            this.removeItemAt(i);
            --i;
        }
    }

    public void appendItem(String name, Object value) {
        ComboItem item = new ComboItem(name, value);
        String id = AdempiereIdGenerator.escapeId(name);
        if (this.getFellowIfAny(id) == null) {
            item.setId(id);
        }
        this.appendChild((Component)item);
    }

    public void setValue(Object value) {
        this.setSelectedItem(null);
        if (value == null) {
            return;
        }
        List items = this.getItems();
        for (Comboitem item : items) {
            if (value.getClass() != item.getValue().getClass()) {
                String stringItem;
                String stringValue = value.toString();
                if (!stringValue.equals(stringItem = item.getValue().toString())) continue;
                this.setSelectedItem(item);
                break;
            }
            if (!value.equals(item.getValue())) continue;
            this.setSelectedItem(item);
            break;
        }
    }

    public boolean isSelected(Object value) {
        if (value == null) {
            return false;
        }
        Comboitem item = this.getSelectedItem();
        if (item == null) {
            return false;
        }
        return item.getValue().equals(value);
    }

    public void clearLastSel() {
        String script = "zk('#" + this.getUuid() + "').$()._lastsel=null;";
        AuScript response = new AuScript(script);
        Clients.response((AuResponse)response);
    }

    public void addScrollSelectedIntoViewListener() {
        String script = "(function(me){let id='#'+me.uuid+'-pp .z-comboitem-selected';let selected=zk($(id));if(selected.jq.length==1)selected.scrollIntoView();})(this)";
        this.setWidgetListener("onKeyUp", script);
    }

    public void onPageDetached(Page page) {
        this.setWidgetListener("onKeyUp", null);
        super.onPageDetached(page);
    }
}

