/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.component;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.adwindow.ADTabpanel;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.ADWindowContent;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.component.SimpleTreeModel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.TreeUtils;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.DefaultTreeNode;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.Tree;
import org.zkoss.zul.TreeNode;
import org.zkoss.zul.Treeitem;
import org.zkoss.zul.Treerow;

public class ADTreeOnDropListener
implements EventListener<Event> {
    private SimpleTreeModel treeModel;
    private MTree mTree;
    private int windowNo;
    private Tree tree;
    private static final CLogger log = CLogger.getCLogger(ADTreeOnDropListener.class);

    public ADTreeOnDropListener(Tree tree, SimpleTreeModel model, MTree mTree, int windowNo) {
        this.tree = tree;
        this.treeModel = model;
        this.mTree = mTree;
        this.windowNo = windowNo;
    }

    public void onEvent(Event event) throws Exception {
        if (event instanceof DropEvent) {
            DropEvent de = (DropEvent)event;
            if (log.isLoggable(Level.FINE)) {
                log.fine("Source=" + de.getDragged() + " Target=" + de.getTarget());
            }
            if (de.getDragged() != de.getTarget()) {
                Treeitem src = (Treeitem)((Treerow)de.getDragged()).getParent();
                Treeitem target = (Treeitem)((Treerow)de.getTarget()).getParent();
                this.moveNode((DefaultTreeNode<Object>)((DefaultTreeNode)src.getValue()), (DefaultTreeNode<Object>)((DefaultTreeNode)target.getValue()));
            }
        }
    }

    private void moveNode(DefaultTreeNode<Object> movingNode, DefaultTreeNode<Object> toNode) {
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(movingNode.toString()) + " to " + toNode.toString());
        }
        if (movingNode == toNode) {
            return;
        }
        MTreeNode toMNode = (MTreeNode)toNode.getData();
        if (!toMNode.isSummary()) {
            this.moveNode(movingNode, toNode, false);
        } else {
            int[] path = this.treeModel.getPath((TreeNode)toNode);
            Treeitem toItem = this.tree.renderItemByPath(path);
            MenuListener listener = new MenuListener(movingNode, toNode);
            Menupopup popup = new Menupopup();
            Menuitem menuItem = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"InsertAfter"));
            menuItem.setValue("InsertAfter");
            menuItem.setParent((Component)popup);
            menuItem.addEventListener("onClick", (EventListener)listener);
            menuItem = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"MoveInto"));
            menuItem.setValue("MoveInto");
            menuItem.setParent((Component)popup);
            menuItem.addEventListener("onClick", (EventListener)listener);
            popup.setPage(this.tree.getPage());
            popup.open((Component)toItem.getTreerow());
        }
    }

    private void moveNode(DefaultTreeNode<Object> movingNode, DefaultTreeNode<Object> toNode, boolean moveInto) {
        int index;
        DefaultTreeNode<Object> newParent;
        DefaultTreeNode<Object> oldParent = this.treeModel.getParent(movingNode);
        this.treeModel.removeNode(movingNode);
        if (!moveInto) {
            newParent = this.treeModel.getParent(toNode);
            index = newParent.getChildren().indexOf(toNode) + 1;
        } else {
            newParent = toNode;
            index = 0;
        }
        newParent = this.treeModel.addNode(newParent, movingNode, index);
        int[] path = this.treeModel.getPath((TreeNode)movingNode);
        if (TreeUtils.isOnInitRenderPosted(this.tree) || this.tree.getTreechildren() == null) {
            this.tree.onInitRender();
        }
        Treeitem movingItem = this.tree.renderItemByPath(path);
        Trx trx = Trx.get((String)Trx.createTrxName((String)"ADTree"), (boolean)true);
        trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_moveNode");
        try {
            try {
                MTreeNode oldMParent = (MTreeNode)oldParent.getData();
                int i = 0;
                while (i < oldParent.getChildCount()) {
                    DefaultTreeNode nd = (DefaultTreeNode)oldParent.getChildAt(i);
                    MTreeNode md = (MTreeNode)nd.getData();
                    this.updateNodePO(oldMParent, md, i, trx.getTrxName());
                    ++i;
                }
                if (oldParent != newParent) {
                    MTreeNode newMParent = (MTreeNode)newParent.getData();
                    int i2 = 0;
                    while (i2 < newParent.getChildCount()) {
                        DefaultTreeNode nd = (DefaultTreeNode)newParent.getChildAt(i2);
                        MTreeNode md = (MTreeNode)nd.getData();
                        this.updateNodePO(newMParent, md, i2, trx.getTrxName());
                        ++i2;
                    }
                }
                trx.commit(true);
                Component c = SessionManager.getAppDesktop().getActiveWindow();
                ADWindow adwindow = ADWindow.findADWindow(c);
                if (adwindow != null) {
                    ADWindowContent adwindowContent = adwindow.getADWindowContent();
                    if (trx.hasChangesMadeByEventListener()) {
                        Clients.showBusy(null);
                        Executions.schedule((Desktop)c.getDesktop(), e -> {
                            adwindowContent.onRefresh();
                            Executions.schedule((Desktop)c.getDesktop(), e1 -> Clients.clearBusy(), (Event)new Event("onEchangeIndicatorchoClearBusy"));
                        }, (Event)new Event("onPostTreeOnDrop"));
                    } else {
                        adwindowContent.focusToActivePanel();
                        IADTabpanel selected = adwindowContent.getADTab().getSelectedTabpanel();
                        if (selected instanceof ADTabpanel) {
                            ((ADTabpanel)selected).setSelectedNode();
                        }
                    }
                }
            }
            catch (Exception e2) {
                trx.rollback();
                Dialog.error(this.windowNo, "TreeUpdateError", e2.getLocalizedMessage());
                trx.close();
                trx = null;
            }
        }
        finally {
            trx.close();
            trx = null;
        }
    }

    private void updateNodePO(MTreeNode mtnParentNode, MTreeNode mtnMovingNode, int NodeIndex, String trxName) {
        StringBuilder whereClause = new StringBuilder("AD_Tree_ID=").append(this.mTree.getAD_Tree_ID()).append(" AND Node_ID=").append(mtnMovingNode.getNode_ID());
        PO mnPO = new Query(Env.getCtx(), this.mTree.getNodeTableName(), whereClause.toString(), trxName).first();
        mnPO.set_ValueNoCheck("Parent_ID", (Object)mtnParentNode.getNode_ID());
        mnPO.set_ValueNoCheck("SeqNo", (Object)NodeIndex);
        if (mnPO.is_Changed()) {
            mnPO.saveEx(trxName);
        }
    }

    class MenuListener
    implements EventListener<Event> {
        private DefaultTreeNode<Object> movingNode;
        private DefaultTreeNode<Object> toNode;

        MenuListener(DefaultTreeNode<Object> movingNode, DefaultTreeNode<Object> toNode) {
            this.movingNode = movingNode;
            this.toNode = toNode;
        }

        public void onEvent(Event event) throws Exception {
            if ("onClick".equals(event.getName()) && event.getTarget() instanceof Menuitem) {
                Menuitem menuItem = (Menuitem)event.getTarget();
                if ("InsertAfter".equals(menuItem.getValue())) {
                    ADTreeOnDropListener.this.moveNode(this.movingNode, this.toNode, false);
                } else if ("MoveInto".equals(menuItem.getValue())) {
                    ADTreeOnDropListener.this.moveNode(this.movingNode, this.toNode, true);
                }
            }
        }
    }
}

