/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.wf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListHeader;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.WListItemRenderer;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.StatusBarPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.Lookup;
import org.compiere.model.MColumn;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.model.MRefList;
import org.compiere.model.MSysConfig;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.compiere.util.ValueNamePair;
import org.compiere.wf.MWFActivity;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFProcess;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Html;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.North;
import org.zkoss.zul.South;
import org.zkoss.zul.Vlayout;

@Form(name="org.compiere.apps.wf.WFActivity")
public class WWFActivity
extends ADForm
implements EventListener<Event> {
    private static final long serialVersionUID = -1658595186719510159L;
    private int m_WindowNo = 0;
    private MWFActivity[] m_activities = null;
    private MWFActivity m_activity = null;
    private int m_index = 0;
    private MColumn m_column = null;
    private static final CLogger log = CLogger.getCLogger(WWFActivity.class);
    private Label lNode = new Label(Msg.translate((Properties)Env.getCtx(), (String)"AD_WF_Node_ID"));
    private Textbox fNode = new Textbox();
    private Label lDesctiption = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Description"));
    private Textbox fDescription = new Textbox();
    private Label lHelp = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Help"));
    private Textbox fHelp = new Textbox();
    private Label lHistory = new Label(Msg.translate((Properties)Env.getCtx(), (String)"History"));
    private Html fHistory = new Html();
    private Label lAnswer = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Answer"));
    private Textbox fAnswerText = new Textbox();
    private Listbox fAnswerList = new Listbox();
    private Button fAnswerButton = new Button();
    private Button bZoom = new Button();
    private Label lTextMsg = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Messages"));
    private Textbox fTextMsg = new Textbox();
    private Button bOK = new Button();
    private WSearchEditor fForward = null;
    private Label lForward = new Label(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Forward")) + " (" + Msg.translate((Properties)Env.getCtx(), (String)"Optional") + ")");
    private StatusBarPanel statusBar = new StatusBarPanel();
    private Button bRefresh = new Button();
    private ListModelTable model = null;
    private WListbox listbox = new WListbox();
    private static final String HISTORY_DIV_START_TAG = "<div style='overflow-y:scroll;height: 100px; border: 1px solid #7F9DB9;'>";

    public WWFActivity() {
        LayoutUtils.addSclass("workflow-activity-form", (HtmlBasedComponent)this);
    }

    @Override
    protected void initForm() {
        this.loadActivities();
        this.fAnswerList.setMold("select");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bZoom.setIconSclass("z-icon-Zoom");
            this.bOK.setIconSclass("z-icon-Ok");
            this.bRefresh.setIconSclass("z-icon-Refresh");
        } else {
            this.bZoom.setImage(ThemeManager.getThemeResource("images/Zoom16.png"));
            this.bOK.setImage(ThemeManager.getThemeResource("images/Ok16.png"));
            this.bRefresh.setImage(ThemeManager.getThemeResource("images/Refresh16.png"));
        }
        this.setTooltipText(this.bZoom, "Zoom");
        this.setTooltipText(this.bOK, "Ok");
        this.setTooltipText(this.bRefresh, "Refresh");
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)0, (int)10443, (int)30);
        this.fForward = new WSearchEditor((Lookup)lookup, Msg.translate((Properties)Env.getCtx(), (String)"AD_User_ID"), "", true, false, true);
        this.init();
        this.display(-1);
    }

    private void setTooltipText(Button btn, String key) {
        String text = Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)key));
        if (!Util.isEmpty((String)text, (boolean)true)) {
            btn.setTooltiptext(text);
        }
    }

    private void init() {
        Grid grid = new Grid();
        grid.setStyle("margin:0; padding:0;");
        grid.makeNoStrip();
        Columns columns = new Columns();
        grid.appendChild((Component)columns);
        Column column = new Column();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "30%");
        columns.appendChild((Component)column);
        column = new Column();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "70%");
        columns.appendChild((Component)column);
        Rows rows = new Rows();
        grid.appendChild((Component)rows);
        Row row = new Row();
        rows.appendChild((Component)row);
        Div div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lNode);
        row.appendChild((Component)div);
        row.appendChild((Component)this.fNode);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fNode, "true");
        this.fNode.setReadonly(true);
        row = new Row();
        rows.appendChild((Component)row);
        row.setValign("top");
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lDesctiption);
        row.appendChild((Component)div);
        row.appendChild((Component)this.fDescription);
        this.fDescription.setMultiline(true);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fDescription, "true");
        this.fDescription.setReadonly(true);
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lHelp);
        row.appendChild((Component)div);
        row.appendChild((Component)this.fHelp);
        this.fHelp.setMultiline(true);
        this.fHelp.setRows(3);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fHelp, "true");
        this.fHelp.setReadonly(true);
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lHistory);
        row.appendChild((Component)div);
        row.appendChild((Component)this.fHistory);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fHistory, "true");
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lAnswer);
        row.appendChild((Component)div);
        Hbox hbox = new Hbox();
        hbox.appendChild((Component)this.fAnswerText);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fAnswerText, "true");
        hbox.appendChild((Component)this.fAnswerList);
        hbox.appendChild((Component)this.fAnswerButton);
        hbox.appendChild((Component)this.bZoom);
        row.appendChild((Component)hbox);
        this.fAnswerButton.addEventListener("onClick", this);
        this.bZoom.addEventListener("onClick", this);
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lTextMsg);
        row.appendChild((Component)div);
        row.appendChild((Component)this.fTextMsg);
        this.fTextMsg.setMultiline(true);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fTextMsg, "100%");
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.lForward);
        row.appendChild((Component)div);
        hbox = new Hbox();
        hbox.appendChild((Component)this.fForward.getComponent());
        hbox.appendChild((Component)this.bOK);
        hbox.appendChild((Component)this.bRefresh);
        row.appendChild((Component)hbox);
        this.bOK.addEventListener("onClick", this);
        this.bRefresh.addEventListener("onClick", this);
        Borderlayout layout = new Borderlayout();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)layout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)layout, "100%");
        layout.setStyle("background-color: transparent; position: relative;");
        North north = new North();
        north.appendChild((Component)this.listbox);
        north.setSplittable(true);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.listbox, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.listbox, "1");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)north, "49%");
        layout.appendChild((Component)north);
        north.setStyle("background-color: transparent");
        this.listbox.addEventListener("onSelect", this);
        Center center = new Center();
        Vlayout vlayout = new Vlayout();
        vlayout.appendChild((Component)grid);
        vlayout.setWidth("100%");
        vlayout.setHeight("99%");
        center.appendChild((Component)vlayout);
        layout.appendChild((Component)center);
        center.setStyle("background-color: transparent; overflow:auto");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)grid, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)grid, "1");
        South south = new South();
        south.appendChild((Component)this.statusBar);
        layout.appendChild((Component)south);
        south.setStyle("background-color: transparent");
        this.appendChild((Component)layout);
        this.setStyle("height: 100%; width: 100%; position: relative;");
    }

    @Override
    public void onEvent(Event event) throws Exception {
        Component comp = event.getTarget();
        String eventName = event.getName();
        if (eventName.equals("onClick")) {
            if (comp == this.bZoom) {
                this.cmd_zoom();
            } else if (comp == this.bRefresh) {
                Clients.showBusy((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
                Executions.schedule((Desktop)this.getDesktop(), e -> {
                    this.loadActivities();
                    Clients.clearBusy();
                }, (Event)new Event("onRefresh"));
            } else if (comp == this.bOK) {
                Clients.showBusy((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
                Events.echoEvent((String)"onOK", (Component)this, null);
            } else if (comp == this.fAnswerButton) {
                this.cmd_button();
            }
        } else if ("onSelect".equals(eventName) && comp == this.listbox) {
            this.m_index = this.listbox.getSelectedIndex();
            if (this.m_index >= 0) {
                this.display(this.m_index);
            }
        } else {
            super.onEvent(event);
        }
    }

    public int getActivitiesCount() {
        int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
        int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        int count = new Query(Env.getCtx(), "AD_WF_Activity", MWFActivity.getWhereUserPendingActivities(), null).setApplyAccessFilter(true, false).setParameters(new Object[]{AD_User_ID, AD_User_ID, AD_User_ID, AD_User_ID, AD_User_ID, AD_Client_ID}).count();
        return count;
    }

    public int loadActivities() {
        long start = System.currentTimeMillis();
        int MAX_ACTIVITIES_IN_LIST = MSysConfig.getIntValue((String)"MAX_ACTIVITIES_IN_LIST", (int)200, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        this.model = new ListModelTable();
        int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
        int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
        Iterator it = new Query(Env.getCtx(), "AD_WF_Activity", MWFActivity.getWhereUserPendingActivities(), null).setApplyAccessFilter(true, false).setParameters(new Object[]{AD_User_ID, AD_User_ID, AD_User_ID, AD_User_ID, AD_User_ID, AD_Client_ID}).setOrderBy("AD_WF_Activity.Priority DESC, AD_WF_Activity.Created").iterate();
        ArrayList<MWFActivity> list = new ArrayList<MWFActivity>();
        while (it.hasNext()) {
            MWFActivity activity = (MWFActivity)it.next();
            list.add(activity);
            ArrayList<Object> rowData = new ArrayList<Object>();
            rowData.add(activity.getPriority());
            rowData.add(activity.getNodeName());
            rowData.add(activity.getSummary());
            this.model.add(rowData);
            if (list.size() <= MAX_ACTIVITIES_IN_LIST || MAX_ACTIVITIES_IN_LIST <= 0) continue;
            log.warning("More than " + MAX_ACTIVITIES_IN_LIST + " Activities - ignored");
            break;
        }
        this.m_activities = new MWFActivity[list.size()];
        list.toArray(this.m_activities);
        if (log.isLoggable(Level.FINE)) {
            log.fine("#" + this.m_activities.length + "(" + (System.currentTimeMillis() - start) + "ms)");
        }
        this.m_index = 0;
        String[] columns = new String[]{Msg.translate((Properties)Env.getCtx(), (String)"Priority"), Msg.translate((Properties)Env.getCtx(), (String)"AD_WF_Node_ID"), Msg.translate((Properties)Env.getCtx(), (String)"Summary")};
        WListItemRenderer renderer = new WListItemRenderer(Arrays.asList(columns));
        ListHeader header = new ListHeader();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)header, "60px");
        renderer.setListHeader(0, header);
        header = new ListHeader();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)header, null);
        renderer.setListHeader(1, header);
        header = new ListHeader();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)header, null);
        renderer.setListHeader(2, header);
        renderer.addTableValueChangeListener(this.listbox);
        this.model.setNoColumns(columns.length);
        this.listbox.setModel((ListModel<?>)this.model);
        this.listbox.setItemRenderer(renderer);
        this.listbox.initialiseHeader();
        this.listbox.setSizedByContent(false);
        return this.m_activities.length;
    }

    private MWFActivity resetDisplay(int selIndex) {
        this.fAnswerText.setVisible(false);
        this.fAnswerList.setVisible(false);
        this.fAnswerButton.setVisible(false);
        if (ThemeManager.isUseFontIconForImage()) {
            this.fAnswerButton.setIconSclass("z-icon-Window");
        } else {
            this.fAnswerButton.setImage(ThemeManager.getThemeResource("images/mWindow.png"));
        }
        this.fTextMsg.setReadonly(selIndex < 0);
        this.fTextMsg.setValue("");
        this.bZoom.setEnabled(selIndex >= 0);
        this.bOK.setEnabled(selIndex >= 0);
        this.fForward.setValue(null);
        this.fForward.setReadWrite(selIndex >= 0);
        this.statusBar.setStatusDB(String.valueOf(String.valueOf(selIndex + 1)) + "/" + this.m_activities.length);
        this.m_activity = null;
        this.m_column = null;
        if (this.m_activities.length > 0 && selIndex >= 0 && selIndex < this.m_activities.length) {
            this.m_activity = this.m_activities[selIndex];
        }
        if (this.m_activity == null) {
            this.fNode.setText("");
            this.fDescription.setText("");
            this.fHelp.setText("");
            this.fHistory.setContent("<div style='overflow-y:scroll;height: 100px; border: 1px solid #7F9DB9;'>&nbsp;</div>");
            this.statusBar.setStatusDB("0/" + this.m_activities.length);
            this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"WFNoActivities"));
        }
        return this.m_activity;
    }

    public void display(int index) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Index=" + index);
        }
        this.m_activity = this.resetDisplay(index);
        if (this.m_activity == null) {
            return;
        }
        this.fNode.setText(this.m_activity.getNodeName());
        this.fDescription.setValue(this.m_activity.getNodeDescription());
        this.fHelp.setValue(this.m_activity.getNodeHelp());
        this.fHistory.setContent(HISTORY_DIV_START_TAG + this.m_activity.getHistoryHTML() + "</div>");
        MWFNode node = this.m_activity.getNode();
        if ("C".equals(node.getAction())) {
            if (this.m_column == null) {
                this.m_column = node.getColumn();
            }
            if (this.m_column != null && this.m_column.get_ID() != 0) {
                this.fAnswerList.removeAllItems();
                int dt = this.m_column.getAD_Reference_ID();
                if (dt == 20) {
                    ValueNamePair[] values = MRefList.getList((Properties)Env.getCtx(), (int)319, (boolean)false);
                    int i = 0;
                    while (i < values.length) {
                        this.fAnswerList.appendItem(values[i].getName(), values[i].getValue());
                        ++i;
                    }
                    this.fAnswerList.setVisible(true);
                } else if (DisplayType.isList((int)dt)) {
                    ValueNamePair[] values = MRefList.getList((Properties)Env.getCtx(), (int)this.m_column.getAD_Reference_Value_ID(), (boolean)false);
                    int i = 0;
                    while (i < values.length) {
                        this.fAnswerList.appendItem(values[i].getName(), values[i].getValue());
                        ++i;
                    }
                    this.fAnswerList.setVisible(true);
                } else {
                    this.fAnswerText.setText("");
                    this.fAnswerText.setVisible(true);
                }
            }
        } else if ("W".equals(node.getAction()) || "X".equals(node.getAction()) || "I".equals(node.getAction())) {
            this.fAnswerButton.setLabel(node.getName());
            this.fAnswerButton.setTooltiptext(node.getDescription());
            this.fAnswerButton.setVisible(true);
        } else {
            log.log(Level.SEVERE, "Unknown Node Action: " + node.getAction());
        }
        this.statusBar.setStatusDB(String.valueOf(this.m_index + 1) + "/" + this.m_activities.length);
        this.statusBar.setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"WFActivities"));
    }

    private void cmd_zoom() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Activity=" + this.m_activity);
        }
        if (this.m_activity == null) {
            return;
        }
        AEnv.zoom(this.m_activity.getAD_Table_ID(), this.m_activity.getRecord_ID());
    }

    private void cmd_button() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Activity=" + this.m_activity);
        }
        if (this.m_activity == null) {
            return;
        }
        MWFNode node = this.m_activity.getNode();
        if ("W".equals(node.getAction())) {
            int AD_Window_ID = node.getAD_Window_ID();
            String ColumnName = String.valueOf(this.m_activity.getPO().get_TableName()) + "_ID";
            int Record_ID = this.m_activity.getRecord_ID();
            MQuery query = MQuery.getEqualQuery((String)ColumnName, (int)Record_ID);
            boolean IsSOTrx = this.m_activity.isSOTrx();
            if (log.isLoggable(Level.INFO)) {
                log.info("Zoom to AD_Window_ID=" + AD_Window_ID + " - " + query + " (IsSOTrx=" + IsSOTrx + ")");
            }
            AEnv.zoom(AD_Window_ID, query);
        } else if ("X".equals(node.getAction())) {
            int AD_Form_ID = node.getAD_Form_ID();
            ADForm form = ADForm.openForm(AD_Form_ID);
            form.setAttribute("mode", form.getWindowMode());
            AEnv.showWindow(form);
        } else if ("I".equals(node.getAction())) {
            SessionManager.getAppDesktop().openInfo(node.getAD_InfoWindow_ID());
        } else {
            log.log(Level.SEVERE, "No User Action:" + node.getAction());
        }
    }

    public void onOK() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Activity=" + this.m_activity);
        }
        if (this.m_activity == null) {
            Clients.clearBusy();
            return;
        }
        int AD_User_ID = Env.getAD_User_ID((Properties)Env.getCtx());
        String textMsg = this.fTextMsg.getValue();
        MWFNode node = this.m_activity.getNode();
        Object forward = this.fForward.getValue();
        Trx trx = null;
        try {
            trx = Trx.get((String)Trx.createTrxName((String)"FWFA"), (boolean)true);
            trx.setDisplayName(String.valueOf(this.getClass().getName()) + "_onOK");
            this.m_activity.set_TrxName(trx.getTrxName());
            if (forward != null) {
                int fw;
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Forward to " + forward);
                }
                if ((fw = ((Integer)forward).intValue()) == AD_User_ID || fw == 0) {
                    log.log(Level.SEVERE, "Forward User=" + fw);
                    trx.rollback();
                    trx.close();
                    return;
                }
                if (!this.m_activity.forwardTo(fw, textMsg)) {
                    Dialog.error(this.m_WindowNo, "CannotForward");
                    trx.rollback();
                    trx.close();
                    return;
                }
            } else {
                if ("C".equals(node.getAction())) {
                    ListItem li;
                    if (this.m_column == null) {
                        this.m_column = node.getColumn();
                    }
                    int dt = this.m_column.getAD_Reference_ID();
                    String value = this.fAnswerText.getText();
                    if ((dt == 20 || DisplayType.isList((int)dt)) && (li = this.fAnswerList.getSelectedItem()) != null) {
                        value = li.getValue().toString();
                    }
                    if (value == null || value.length() == 0) {
                        Dialog.error(this.m_WindowNo, "FillMandatory", Msg.getMsg((Properties)Env.getCtx(), (String)"Answer"));
                        trx.rollback();
                        trx.close();
                        return;
                    }
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config("Answer=" + value + " - " + textMsg);
                    }
                    try {
                        this.m_activity.setUserChoice(AD_User_ID, value, dt, textMsg);
                        MWFProcess wfpr = new MWFProcess(this.m_activity.getCtx(), this.m_activity.getAD_WF_Process_ID(), this.m_activity.get_TrxName());
                        wfpr.checkCloseActivities(this.m_activity.get_TrxName());
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, node.getName(), (Throwable)e);
                        Dialog.error(this.m_WindowNo, "Error", e.toString());
                        trx.rollback();
                        trx.close();
                        Clients.clearBusy();
                        if (trx != null) {
                            trx.close();
                        }
                        return;
                    }
                }
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Action=" + node.getAction() + " - " + textMsg);
                }
                try {
                    this.m_activity.setUserConfirmation(AD_User_ID, textMsg);
                    MWFProcess wfpr = new MWFProcess(this.m_activity.getCtx(), this.m_activity.getAD_WF_Process_ID(), this.m_activity.get_TrxName());
                    wfpr.checkCloseActivities(this.m_activity.get_TrxName());
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, node.getName(), (Throwable)e);
                    Dialog.error(this.m_WindowNo, "Error", e.toString());
                    trx.rollback();
                    trx.close();
                    Clients.clearBusy();
                    if (trx != null) {
                        trx.close();
                    }
                    return;
                }
            }
            trx.commit();
        }
        finally {
            Clients.clearBusy();
            if (trx != null) {
                trx.close();
            }
        }
        this.loadActivities();
        this.display(-1);
    }
}

