/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.wf;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.wf.WFEditor;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.Window;
import org.compiere.model.MQuery;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Label;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Separator;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vbox;

public class WFPopupItem
extends Menuitem {
    private static final long serialVersionUID = -8409752634782368108L;
    public static final int WFPOPUPITEM_DELETENODE = -1;
    public static final int WFPOPUPITEM_PROPERTIES = -2;
    public static final int WFPOPUPITEM_ZOOM = -3;
    private int m_AD_Workflow_ID;
    private static final CLogger log = CLogger.getCLogger(WFPopupItem.class);
    private MWFNode m_node;
    private MWFNodeNext m_line;
    private int m_AD_WF_NodeTo_ID;

    public WFPopupItem(String title, MWFNode node, int AD_WF_NodeTo_ID) {
        super(title);
        this.m_node = node;
        this.m_AD_WF_NodeTo_ID = AD_WF_NodeTo_ID;
        this.m_AD_Workflow_ID = node.getAD_Workflow_ID();
    }

    public WFPopupItem(String title, MWFNodeNext line) {
        super(title);
        this.m_line = line;
        this.m_AD_Workflow_ID = line.getAD_WF_Node().getAD_Workflow_ID();
    }

    public void execute(WFEditor wfp) {
        if (this.m_node != null && this.m_AD_WF_NodeTo_ID > 0) {
            int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
            MWFNodeNext newLine = new MWFNodeNext(this.m_node, this.m_AD_WF_NodeTo_ID);
            newLine.setClientOrg(AD_Client_ID, 0);
            newLine.setSeqNo(0);
            if (AD_Client_ID > 11) {
                newLine.setEntityType(MSysConfig.getValue((String)"DEFAULT_ENTITYTYPE", (String)"U"));
            }
            newLine.saveEx();
            if (log.isLoggable(Level.INFO)) {
                log.info("Add Line to " + this.m_node + " -> " + newLine);
            }
            wfp.reload(this.m_AD_Workflow_ID, true);
        } else if (this.m_node != null && this.m_AD_WF_NodeTo_ID == -2) {
            this.editNode(wfp);
        } else if (this.m_node != null && this.m_AD_WF_NodeTo_ID == -3) {
            int AD_Window_ID = MTable.get((Properties)Env.getCtx(), (int)129).getAD_Window_ID();
            if (AD_Window_ID > 0) {
                MQuery query = new MQuery();
                query.setZoomColumnName("AD_WF_Node_ID");
                query.setZoomTableName("AD_WF_Node");
                query.setZoomValue((Object)this.m_node.getAD_WF_Node_ID());
                query.addRestriction("AD_WF_Node_ID", "=", this.m_node.getAD_WF_Node_ID());
                query.setRecordCount(1);
                AEnv.zoom(AD_Window_ID, query);
            }
        } else if (this.m_node != null && this.m_AD_WF_NodeTo_ID == -1) {
            if (log.isLoggable(Level.INFO)) {
                log.info("Delete Node: " + this.m_node);
            }
            this.m_node.delete(false);
            wfp.reload(this.m_AD_Workflow_ID, true);
        } else if (this.m_line != null) {
            if (log.isLoggable(Level.INFO)) {
                log.info("Delete Line: " + this.m_line);
            }
            this.m_line.delete(false);
            wfp.reload(this.m_AD_Workflow_ID, true);
        } else {
            log.warning("No Action??");
        }
    }

    private void editNode(final WFEditor wfp) {
        String title = Msg.getMsg((Properties)Env.getCtx(), (String)"Properties");
        final Window w = new Window();
        w.setTitle(title);
        Vbox vbox = new Vbox();
        w.appendChild((Component)vbox);
        vbox.appendChild((Component)new Separator());
        String labelName = Msg.getElement((Properties)Env.getCtx(), (String)"Name");
        Hbox hboxName = new Hbox();
        hboxName.appendChild((Component)new Label(labelName));
        hboxName.appendChild((Component)new Space());
        final Textbox textName = new Textbox(this.m_node.getName());
        hboxName.appendChild((Component)textName);
        vbox.appendChild((Component)hboxName);
        String labelDescription = Msg.getElement((Properties)Env.getCtx(), (String)"Description");
        Hbox hboxDescription = new Hbox();
        hboxDescription.appendChild((Component)new Label(labelDescription));
        hboxDescription.appendChild((Component)new Space());
        final Textbox textDescription = new Textbox(this.m_node.getDescription());
        hboxDescription.appendChild((Component)textDescription);
        vbox.appendChild((Component)hboxDescription);
        vbox.appendChild((Component)new Separator());
        final ConfirmPanel panel = new ConfirmPanel(true, false, false, false, false, false, false);
        vbox.appendChild((Component)panel);
        panel.addActionListener("onClick", new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event.getTarget() == panel.getButton("Cancel")) {
                    textName.setText("");
                }
                w.onClose();
            }
        });
        w.setBorder("normal");
        w.setPage(this.getPage());
        w.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                String name = textName.getText();
                if (name != null && name.length() > 0) {
                    WFPopupItem.this.m_node.setName(name);
                    WFPopupItem.this.m_node.setDescription(textDescription.getText());
                    WFPopupItem.this.m_node.saveEx();
                    wfp.reload(WFPopupItem.this.m_AD_Workflow_ID, true);
                }
            }
        });
        w.doHighlighted();
    }
}

