/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.wf;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.apps.wf.WFNodeContainer;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.apps.wf.WFNodeWidget;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;
import org.zkoss.zhtml.Table;
import org.zkoss.zhtml.Td;
import org.zkoss.zhtml.Tr;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Html;
import org.zkoss.zul.South;

public class WFPanel
extends Borderlayout
implements EventListener<Event>,
IHelpContext {
    private static final long serialVersionUID = 8777798080154603970L;
    private int m_WindowNo = 0;
    private MWorkflow m_wf = null;
    private static final CLogger log = CLogger.getCLogger(WFPanel.class);
    private WFNodeContainer nodeContainer = new WFNodeContainer();
    private Html infoTextPane = new Html();
    private Div contentPanel = new Div();
    private Table table;

    public WFPanel() {
        try {
            this.jbInit();
            this.addEventListener("onWindowContainerSelectionChanged", this);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "WFPanel", (Throwable)e);
        }
        this.m_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
    }

    private void jbInit() throws Exception {
        this.setStyle("height: 100%; width: 100%; position: absolute");
        Center center = new Center();
        this.appendChild((Component)center);
        this.createTable();
        center.appendChild((Component)this.table);
        this.contentPanel.setStyle("width: 100%; heigh: 100%;");
        center.setAutoscroll(true);
        South south = new South();
        this.appendChild((Component)south);
        Div div = new Div();
        div.setStyle("width:100%; height: 100%");
        div.appendChild((Component)this.infoTextPane);
        south.appendChild((Component)div);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)south, "25%");
        south.setSplittable(true);
        south.setCollapsible(true);
        south.setAutoscroll(true);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)div, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)div, "1");
    }

    private void createTable() {
        this.table = new Table();
        this.table.setDynamicProperty("cellpadding", (Object)"0");
        this.table.setDynamicProperty("cellspacing", (Object)"0");
        this.table.setDynamicProperty("border", (Object)"none");
        this.table.setStyle("margin:0;padding:0");
    }

    public void dispose() {
        SessionManager.getAppDesktop().closeActiveWindow();
    }

    public void load(int AD_Workflow_ID) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("AD_Workflow_ID=" + AD_Workflow_ID);
        }
        if (AD_Workflow_ID == 0) {
            return;
        }
        this.m_wf = new MWorkflow(Env.getCtx(), AD_Workflow_ID, null);
        this.nodeContainer.removeAll();
        this.nodeContainer.setWorkflow(this.m_wf);
        MWFNode[] nodes = this.m_wf.getNodes(true, Env.getAD_Client_ID((Properties)Env.getCtx()));
        ArrayList added = new ArrayList();
        int i = 0;
        while (i < nodes.length) {
            if (!added.contains(nodes[i].getAD_WF_Node_ID())) {
                this.nodeContainer.addNode(nodes[i]);
            }
            ++i;
        }
        i = 0;
        while (i < nodes.length) {
            MWFNodeNext[] nexts = nodes[i].getTransitions(Env.getAD_Client_ID((Properties)Env.getCtx()));
            int j = 0;
            while (j < nexts.length) {
                this.nodeContainer.addEdge(nexts[j]);
                ++j;
            }
            ++i;
        }
        Dimension dimension = this.nodeContainer.getDimension();
        BufferedImage bi = new BufferedImage(dimension.width, dimension.height, 2);
        Graphics2D graphics = bi.createGraphics();
        this.nodeContainer.validate(graphics);
        this.nodeContainer.paint(graphics);
        try {
            int row = this.nodeContainer.getRowCount();
            int maxCol = this.nodeContainer.getMaxColumnWithNode();
            int i2 = 0;
            while (i2 < row) {
                Tr tr2 = new Tr();
                this.table.appendChild((Component)tr2);
                int c = 0;
                while (c < maxCol) {
                    BufferedImage t = new BufferedImage(184, 133, 2);
                    Graphics2D tg = t.createGraphics();
                    Td td2 = new Td();
                    td2.setSclass("workflow-panel-table");
                    tr2.appendChild((Component)td2);
                    int x = c * 184;
                    int y = i2 * 133;
                    tg.drawImage((Image)bi.getSubimage(x, y, 184, 133), 0, 0, null);
                    org.zkoss.zul.Image image = new org.zkoss.zul.Image();
                    image.setContent((RenderedImage)t);
                    td2.appendChild((Component)image);
                    WFNodeWidget widget = this.nodeContainer.findWidget(i2 + 1, c + 1);
                    if (widget != null) {
                        MWFNode node = widget.getModel();
                        if (node.getHelp(true) != null) {
                            image.setTooltiptext(node.getHelp(true));
                        }
                        image.setAttribute("AD_WF_Node_ID", (Object)node.getAD_WF_Node_ID());
                        image.addEventListener("onClick", (EventListener)this);
                        image.setStyle("cursor:pointer;border:none;margin:0;padding:0;");
                    } else {
                        image.setStyle("border:none;margin:0;padding:0;");
                    }
                    tg.dispose();
                    ++c;
                }
                ++i2;
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
        }
        StringBuilder msg = new StringBuilder("");
        msg.append("<H2>").append(this.m_wf.getName(true)).append("</H2>");
        String s = this.m_wf.getDescription(true);
        if (s != null && s.length() > 0) {
            msg.append("<B>").append(s).append("</B>");
        }
        if ((s = this.m_wf.getHelp(true)) != null && s.length() > 0) {
            msg.append("<BR>").append(s);
        }
        this.infoTextPane.setContent(msg.toString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WorkflowPanel[");
        if (this.m_wf != null) {
            sb.append(this.m_wf.getAD_Workflow_ID());
        }
        sb.append("]");
        return sb.toString();
    }

    public MWorkflow getWorkflow() {
        return this.m_wf;
    }

    public void onEvent(Event event) throws Exception {
        if ("onClick".equals(event.getName())) {
            Integer id = (Integer)event.getTarget().getAttribute("AD_WF_Node_ID");
            if (id != null) {
                MWFNode[] nodes;
                MWFNode[] mWFNodeArray = nodes = this.m_wf.getNodes(true, Env.getAD_Client_ID((Properties)Env.getCtx()));
                int n = nodes.length;
                int n2 = 0;
                while (n2 < n) {
                    MWFNode node = mWFNodeArray[n2];
                    if (node.getAD_WF_Node_ID() == id.intValue()) {
                        this.start(node);
                        break;
                    }
                    ++n2;
                }
            }
        } else if (event.getName().equals("onWindowContainerSelectionChanged")) {
            SessionManager.getAppDesktop().updateHelpContext("W", this.m_wf.getAD_Workflow_ID());
        }
    }

    private void start(MWFNode wfn) {
        String action = wfn.getAction();
        if ("W".equals(action) && wfn.getAD_Window_ID() > 0) {
            SessionManager.getAppDesktop().openWindow(wfn.getAD_Window_ID(), null);
        } else if ("X".equals(action) && wfn.getAD_Form_ID() > 0) {
            SessionManager.getAppDesktop().openForm(wfn.getAD_Form_ID());
        } else if ("P".equals(action) && wfn.getAD_Process_ID() > 0) {
            SessionManager.getAppDesktop().openProcessDialog(wfn.getAD_Process_ID(), false);
        } else if ("T".equals(action) && wfn.getAD_Task_ID() > 0) {
            SessionManager.getAppDesktop().openTask(wfn.getAD_Task_ID());
        } else if ("F".equals(action) && wfn.getWorkflow_ID() > 0) {
            SessionManager.getAppDesktop().openWorkflow(wfn.getWorkflow_ID());
        } else if (wfn.getAD_InfoWindow_ID() > 0) {
            SessionManager.getAppDesktop().openInfo(wfn.getAD_InfoWindow_ID());
        }
    }
}

