/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.wf;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.wf.WFNodeContainer;
import org.adempiere.webui.apps.wf.WFPopupItem;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.ToolBar;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.apps.wf.WFNodeWidget;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.wf.MWFNode;
import org.compiere.wf.MWFNodeNext;
import org.compiere.wf.MWorkflow;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zhtml.Table;
import org.zkoss.zhtml.Td;
import org.zkoss.zhtml.Tr;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.DropEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Image;
import org.zkoss.zul.Label;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;
import org.zkoss.zul.Toolbarbutton;
import org.zkoss.zul.Vbox;

@Form(name="org.compiere.apps.wf.WFPanel")
public class WFEditor
extends ADForm {
    private static final long serialVersionUID = 4293422396394778274L;
    private Listbox workflowList;
    private int m_workflowId = 0;
    private Toolbarbutton zoomButton;
    private Toolbarbutton refreshButton;
    private Toolbarbutton newButton;
    private Table table;
    private Center center;
    private MWorkflow m_wf;
    private WFNodeContainer nodeContainer;

    @Override
    protected void initForm() {
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "100%");
        Borderlayout layout = new Borderlayout();
        layout.setStyle("width: 100%; height: 100%; position: relative;");
        this.appendChild((Component)layout);
        boolean isBaseLanguage = Env.isBaseLanguage((Properties)Env.getCtx(), (String)"AD_Workflow");
        String sql = isBaseLanguage ? MRole.getDefault().addAccessSQL("SELECT AD_Workflow_ID, Name FROM AD_Workflow WHERE IsActive='Y' ORDER BY 2", "AD_Workflow", false, false) : MRole.getDefault().addAccessSQL("SELECT AD_Workflow.AD_Workflow_ID, AD_Workflow_Trl.Name FROM AD_Workflow INNER JOIN AD_Workflow_Trl ON (AD_Workflow.AD_Workflow_ID=AD_Workflow_Trl.AD_Workflow_ID)  WHERE AD_Workflow.IsActive='Y' AND AD_Workflow_Trl.AD_Language='" + Env.getAD_Language((Properties)Env.getCtx()) + "' ORDER BY 2", "AD_Workflow", true, false);
        KeyNamePair[] pp = DB.getKeyNamePairs((String)sql, (boolean)true);
        this.workflowList = ListboxFactory.newDropdownListbox();
        KeyNamePair[] keyNamePairArray = pp;
        int n = pp.length;
        int n2 = 0;
        while (n2 < n) {
            KeyNamePair knp = keyNamePairArray[n2];
            this.workflowList.addItem(knp);
            ++n2;
        }
        this.workflowList.addEventListener("onSelect", this);
        North north = new North();
        layout.appendChild((Component)north);
        ToolBar toolbar = new ToolBar();
        north.appendChild((Component)toolbar);
        toolbar.appendChild((Component)this.workflowList);
        this.zoomButton = new Toolbarbutton();
        if (ThemeManager.isUseFontIconForImage()) {
            this.zoomButton.setIconSclass("z-icon-Zoom");
        } else {
            this.zoomButton.setImage(ThemeManager.getThemeResource("images/Zoom16.png"));
        }
        toolbar.appendChild((Component)this.zoomButton);
        this.zoomButton.addEventListener("onClick", (EventListener)this);
        this.zoomButton.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Zoom")));
        this.newButton = new Toolbarbutton();
        if (ThemeManager.isUseFontIconForImage()) {
            this.newButton.setIconSclass("z-icon-New");
        } else {
            this.newButton.setImage(ThemeManager.getThemeResource("images/New16.png"));
        }
        toolbar.appendChild((Component)this.newButton);
        this.newButton.addEventListener("onClick", (EventListener)this);
        this.newButton.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"CreateNewNode"));
        this.refreshButton = new Toolbarbutton();
        if (ThemeManager.isUseFontIconForImage()) {
            this.refreshButton.setIconSclass("z-icon-Refresh");
        } else {
            this.refreshButton.setImage(ThemeManager.getThemeResource("images/Refresh16.png"));
        }
        toolbar.appendChild((Component)this.refreshButton);
        this.refreshButton.addEventListener("onClick", (EventListener)this);
        this.refreshButton.setTooltiptext(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh")));
        ZKUpdateUtil.setHeight((HtmlBasedComponent)north, "30px");
        this.createTable();
        this.center = new Center();
        layout.appendChild((Component)this.center);
        this.center.setAutoscroll(true);
        this.center.appendChild((Component)this.table);
        ConfirmPanel confirmPanel = new ConfirmPanel(true);
        confirmPanel.addActionListener(this);
        South south = new South();
        layout.appendChild((Component)south);
        south.appendChild((Component)confirmPanel);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)south, "36px");
    }

    private void createTable() {
        this.table = new Table();
        this.table.setDynamicProperty("cellpadding", (Object)"0");
        this.table.setDynamicProperty("cellspacing", (Object)"0");
        this.table.setDynamicProperty("border", (Object)"none");
        this.table.setStyle("margin:0;padding:0");
    }

    @Override
    public void onEvent(Event event) throws Exception {
        if (event.getTarget().getId().equals("Cancel")) {
            this.detach();
        } else if (event.getTarget().getId().equals("Ok")) {
            this.detach();
        } else if (event.getTarget() == this.workflowList) {
            KeyNamePair knp;
            this.center.removeChild((Component)this.table);
            this.createTable();
            this.center.appendChild((Component)this.table);
            ListItem item = this.workflowList.getSelectedItem();
            KeyNamePair keyNamePair = knp = item != null ? item.toKeyNamePair() : null;
            if (knp != null && knp.getKey() > 0) {
                this.load(knp.getKey(), true);
            }
        } else if (event.getTarget() == this.zoomButton) {
            if (this.workflowList.getSelectedIndex() > 0) {
                this.zoom();
            }
        } else if (event.getTarget() == this.refreshButton) {
            if (this.workflowList.getSelectedIndex() > 0) {
                this.reload(this.m_workflowId, true);
            }
        } else if (event.getTarget() == this.newButton) {
            if (this.workflowList.getSelectedIndex() > 0) {
                this.createNewNode();
            }
        } else if (event.getTarget() instanceof WFPopupItem) {
            WFPopupItem item = (WFPopupItem)event.getTarget();
            item.execute(this);
        } else if (event.getName().equals("onDrop")) {
            MWFNode node;
            WFNodeWidget widget;
            DropEvent dropEvent = (DropEvent)event;
            Integer AD_WF_Node_ID = (Integer)dropEvent.getDragged().getAttribute("AD_WF_Node_ID");
            Integer xPosition = (Integer)event.getTarget().getAttribute("Node.XPosition");
            Integer yPosition = (Integer)event.getTarget().getAttribute("Node.YPosition");
            if (AD_WF_Node_ID != null && (widget = (WFNodeWidget)this.nodeContainer.getGraphScene().findWidget((Object)AD_WF_Node_ID)) != null && (node = widget.getModel()).getAD_Client_ID() == Env.getAD_Client_ID((Properties)Env.getCtx())) {
                node.setXPosition(xPosition.intValue());
                node.setYPosition(yPosition.intValue());
                node.saveEx();
                this.reload(this.m_workflowId, true);
            }
        }
    }

    private void createNewNode() {
        String nameLabel = Msg.getElement((Properties)Env.getCtx(), (String)"Name");
        String title = Msg.getMsg((Properties)Env.getCtx(), (String)"CreateNewNode");
        final Window w = new Window();
        w.setTitle(title);
        Vbox vbox = new Vbox();
        w.appendChild((Component)vbox);
        vbox.appendChild((Component)new Separator());
        Hbox hbox = new Hbox();
        hbox.appendChild((Component)new Label(nameLabel));
        hbox.appendChild((Component)new Space());
        final Textbox text = new Textbox();
        hbox.appendChild((Component)text);
        vbox.appendChild((Component)hbox);
        vbox.appendChild((Component)new Separator());
        final ConfirmPanel panel = new ConfirmPanel(true, false, false, false, false, false, false);
        vbox.appendChild((Component)panel);
        panel.addActionListener("onClick", new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                if (event.getTarget() == panel.getButton("Cancel")) {
                    text.setText("");
                }
                w.onClose();
            }
        });
        w.setBorder("normal");
        w.setPage(this.getPage());
        w.addEventListener("onWindowClose", (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                String name = text.getText();
                if (name != null && name.length() > 0) {
                    int AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
                    MWFNode node = new MWFNode(WFEditor.this.m_wf, name, name);
                    node.setClientOrg(AD_Client_ID, 0);
                    if (AD_Client_ID > 11) {
                        node.setEntityType(MSysConfig.getValue((String)"DEFAULT_ENTITYTYPE", (String)"U"));
                    }
                    node.saveEx();
                    WFEditor.this.reload(WFEditor.this.m_wf.getAD_Workflow_ID(), true);
                }
            }
        });
        w.doHighlighted();
    }

    protected void reload(int workflowId, boolean reread) {
        this.center.removeChild((Component)this.table);
        this.createTable();
        this.center.appendChild((Component)this.table);
        this.load(workflowId, reread);
    }

    private void load(int workflowId, boolean reread) {
        this.m_wf = MWorkflow.getCopy((Properties)Env.getCtx(), (int)workflowId, null);
        this.m_workflowId = workflowId;
        this.nodeContainer = new WFNodeContainer();
        this.nodeContainer.setWorkflow(this.m_wf);
        if (reread) {
            this.m_wf.reloadNodes();
        }
        MWFNode[] nodes = this.m_wf.getNodes(true, Env.getAD_Client_ID((Properties)Env.getCtx()));
        ArrayList added = new ArrayList();
        int i = 0;
        while (i < nodes.length) {
            if (!added.contains(nodes[i].getAD_WF_Node_ID())) {
                this.nodeContainer.addNode(nodes[i]);
            }
            ++i;
        }
        i = 0;
        while (i < nodes.length) {
            MWFNodeNext[] nexts = nodes[i].getTransitions(Env.getAD_Client_ID((Properties)Env.getCtx()));
            int j = 0;
            while (j < nexts.length) {
                this.nodeContainer.addEdge(nexts[j]);
                ++j;
            }
            ++i;
        }
        Dimension dimension = this.nodeContainer.getDimension();
        BufferedImage bi = new BufferedImage(dimension.width, dimension.height, 2);
        Graphics2D graphics = bi.createGraphics();
        this.nodeContainer.validate(graphics);
        this.nodeContainer.paint(graphics);
        try {
            int row = this.nodeContainer.getRowCount();
            int i2 = 0;
            while (i2 < row + 1) {
                Tr tr2 = new Tr();
                this.table.appendChild((Component)tr2);
                int c = 0;
                while (c < 4) {
                    BufferedImage t = new BufferedImage(184, 133, 2);
                    Graphics2D tg = t.createGraphics();
                    Td td2 = new Td();
                    td2.setStyle("border: 1px dotted lightgray");
                    tr2.appendChild((Component)td2);
                    if (i2 < row) {
                        int x = c * 184;
                        int y = i2 * 133;
                        tg.drawImage((java.awt.Image)bi.getSubimage(x, y, 184, 133), 0, 0, null);
                        Image image = new Image();
                        image.setContent((RenderedImage)t);
                        td2.appendChild((Component)image);
                        String imgStyle = "border:none;margin:0;padding:0";
                        WFNodeWidget widget = this.nodeContainer.findWidget(i2 + 1, c + 1);
                        if (widget != null) {
                            MWFNode node = widget.getModel();
                            if (node.getHelp(true) != null) {
                                image.setTooltiptext(node.getHelp(true));
                            }
                            image.setAttribute("AD_WF_Node_ID", (Object)node.getAD_WF_Node_ID());
                            image.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                                public void onEvent(Event event) throws Exception {
                                    WFEditor.this.showNodeMenu(event.getTarget());
                                }
                            });
                            image.setDraggable("WFNode");
                            imgStyle = String.valueOf(imgStyle) + ";cursor:pointer";
                        } else {
                            image.setDroppable("WFNode");
                            image.addEventListener("onDrop", (EventListener)this);
                            image.setAttribute("Node.XPosition", (Object)(c + 1));
                            image.setAttribute("Node.YPosition", (Object)(i2 + 1));
                        }
                        image.setStyle(imgStyle);
                    } else {
                        Div div = new Div();
                        ZKUpdateUtil.setWidth((HtmlBasedComponent)div, "184px");
                        ZKUpdateUtil.setHeight((HtmlBasedComponent)div, "133px");
                        div.setAttribute("Node.XPosition", (Object)(c + 1));
                        div.setAttribute("Node.YPosition", (Object)(i2 + 1));
                        div.setDroppable("WFNode");
                        div.addEventListener("onDrop", (EventListener)this);
                        td2.appendChild((Component)div);
                    }
                    tg.dispose();
                    ++c;
                }
                ++i2;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void showNodeMenu(Component target) {
        WFNodeWidget widget;
        Integer AD_WF_Node_ID = (Integer)target.getAttribute("AD_WF_Node_ID");
        if (AD_WF_Node_ID != null && (widget = (WFNodeWidget)this.nodeContainer.getGraphScene().findWidget((Object)AD_WF_Node_ID)) != null) {
            String title;
            MWFNode node = widget.getModel();
            Menupopup popupMenu = new Menupopup();
            this.addMenuItem(popupMenu, Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Zoom")), node, -3);
            if (node.getAD_Client_ID() == Env.getAD_Client_ID((Properties)Env.getCtx())) {
                this.addMenuItem(popupMenu, Msg.getMsg((Properties)Env.getCtx(), (String)"Properties"), node, -2);
                String title2 = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"DeleteNode")) + ": " + node.getName(true);
                this.addMenuItem(popupMenu, title2, node, -1);
            }
            MWFNode[] nodes = this.m_wf.getNodes(true, Env.getAD_Client_ID((Properties)Env.getCtx()));
            MWFNodeNext[] lines = node.getTransitions(Env.getAD_Client_ID((Properties)Env.getCtx()));
            MWFNode[] mWFNodeArray = nodes;
            int n = nodes.length;
            int n2 = 0;
            while (n2 < n) {
                MWFNode nn = mWFNodeArray[n2];
                if (nn.getAD_WF_Node_ID() != node.getAD_WF_Node_ID() && nn.getAD_WF_Node_ID() != node.getAD_Workflow().getAD_WF_Node_ID()) {
                    boolean found = false;
                    MWFNodeNext[] mWFNodeNextArray = lines;
                    int n3 = lines.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        MWFNodeNext line = mWFNodeNextArray[n4];
                        if (nn.getAD_WF_Node_ID() == line.getAD_WF_Next_ID()) {
                            found = true;
                            break;
                        }
                        ++n4;
                    }
                    if (!found) {
                        mWFNodeNextArray = nn.getTransitions(Env.getAD_Client_ID((Properties)Env.getCtx()));
                        n3 = mWFNodeNextArray.length;
                        n4 = 0;
                        while (n4 < n3) {
                            MWFNodeNext revline = mWFNodeNextArray[n4];
                            if (node.getAD_WF_Node_ID() == revline.getAD_WF_Next_ID()) {
                                found = true;
                                break;
                            }
                            ++n4;
                        }
                    }
                    if (!found) {
                        title = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"AddLine")) + ": " + node.getName(true) + " -> " + nn.getName(true);
                        this.addMenuItem(popupMenu, title, node, nn.getAD_WF_Node_ID());
                    }
                }
                ++n2;
            }
            mWFNodeArray = lines;
            n = lines.length;
            n2 = 0;
            while (n2 < n) {
                MWFNode line = mWFNodeArray[n2];
                if (line.getAD_Client_ID() == Env.getAD_Client_ID((Properties)Env.getCtx())) {
                    MWFNode next = MWFNode.get((Properties)Env.getCtx(), (int)line.getAD_WF_Next_ID());
                    title = String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"DeleteLine")) + ": " + node.getName(true) + " -> " + next.getName(true);
                    this.addMenuItem(popupMenu, title, (MWFNodeNext)line);
                }
                ++n2;
            }
            popupMenu.setPage(target.getPage());
            popupMenu.open(target);
        }
    }

    private void zoom() {
        if (this.m_workflowId > 0) {
            AEnv.zoom(117, this.m_workflowId);
        }
    }

    private void addMenuItem(Menupopup menu, String title, MWFNode node, int AD_WF_NodeTo_ID) {
        WFPopupItem item = new WFPopupItem(title, node, AD_WF_NodeTo_ID);
        menu.appendChild((Component)item);
        item.addEventListener("onClick", this);
    }

    private void addMenuItem(Menupopup menu, String title, MWFNodeNext line) {
        WFPopupItem item = new WFPopupItem(title, line);
        menu.appendChild((Component)item);
        item.addEventListener("onClick", this);
    }
}

