/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.graph.jfreegraph;

import java.awt.image.BufferedImage;
import java.util.logging.Level;
import org.adempiere.apps.graph.ChartBuilder;
import org.adempiere.webui.apps.AEnv;
import org.compiere.model.MChart;
import org.compiere.model.MQuery;
import org.compiere.util.CLogger;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.encoders.EncoderUtil;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.TimeSeriesDataItem;
import org.zkoss.image.AImage;
import org.zkoss.image.Image;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.MouseEvent;
import org.zkoss.zul.Area;
import org.zkoss.zul.Imagemap;

@Deprecated
class ChartRenderer {
    private static final CLogger log = CLogger.getCLogger(ChartRenderer.class);
    private MChart chartModel;
    private ChartBuilder chartBuilder;

    public ChartRenderer(MChart chartModel) {
        this.chartModel = chartModel;
    }

    public void render(Component parent, int width, int height, boolean showTitle) {
        this.chartBuilder = new ChartBuilder(this.chartModel);
        JFreeChart chart = this.chartBuilder.createChart();
        if (!showTitle) {
            chart.setTitle("");
        }
        chart.getPlot().setForegroundAlpha(0.6f);
        ChartRenderingInfo info = new ChartRenderingInfo();
        BufferedImage bi = chart.createBufferedImage(width, height, 3, info);
        try {
            byte[] bytes = EncoderUtil.encode((BufferedImage)bi, (String)"png", (boolean)true);
            AImage image = new AImage("", bytes);
            Imagemap myImage = new Imagemap();
            myImage.setContent((Image)image);
            parent.appendChild((Component)myImage);
            int count = 0;
            for (ChartEntity entity : info.getEntityCollection().getEntities()) {
                Comparable sectionKey;
                CategoryItemEntity item;
                String key = null;
                String seriesName = null;
                if (entity instanceof CategoryItemEntity) {
                    item = (CategoryItemEntity)entity;
                    Comparable colKey = item.getColumnKey();
                    Comparable rowKey = item.getRowKey();
                    if (colKey != null && rowKey != null) {
                        key = colKey.toString();
                        seriesName = rowKey.toString();
                    }
                } else if (entity instanceof PieSectionEntity && (sectionKey = ((PieSectionEntity)entity).getSectionKey()) != null) {
                    key = sectionKey.toString();
                }
                if (entity instanceof XYItemEntity && (item = (XYItemEntity)entity).getDataset() instanceof TimeSeriesCollection) {
                    TimeSeriesCollection data = (TimeSeriesCollection)item.getDataset();
                    TimeSeries series = data.getSeries(item.getSeriesIndex());
                    TimeSeriesDataItem dataitem = series.getDataItem(item.getItem());
                    seriesName = series.getKey().toString();
                    key = dataitem.getPeriod().toString();
                }
                if (key == null) continue;
                Area area = new Area();
                myImage.appendChild((Component)area);
                area.setCoords(entity.getShapeCoords());
                area.setShape(entity.getShapeType());
                area.setTooltiptext(entity.getToolTipText());
                area.setId(String.valueOf(count) + "_WG__" + seriesName + "__" + key + "__" + System.currentTimeMillis());
                ++count;
            }
            myImage.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                public void onEvent(Event event) throws Exception {
                    String[] strs;
                    MouseEvent me = (MouseEvent)event;
                    String areaId = me.getArea();
                    if (areaId != null && (strs = areaId.split("__")).length == 4) {
                        ChartRenderer.this.chartMouseClicked(strs[2], strs[1]);
                    }
                }
            });
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
    }

    public void chartMouseClicked(String key, String category) {
        MQuery query = this.chartBuilder.getQuery("null".equals(category) ? key : String.valueOf(category) + "__" + key);
        if (query != null) {
            AEnv.zoom(query);
        }
    }
}

