/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ADTabpanel;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WLocatorEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.panel.StatusBarPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.apps.IStatusBar;
import org.compiere.apps.form.TrxMaterial;
import org.compiere.model.Lookup;
import org.compiere.model.MLocatorLookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.LayoutRegion;
import org.zkoss.zul.North;
import org.zkoss.zul.South;

@Form(name="org.compiere.apps.form.VTrxMaterial")
public class WTrxMaterial
extends TrxMaterial
implements IFormController,
EventListener<Event>,
ValueChangeListener {
    private CustomForm form = new CustomForm();
    private ADTabpanel m_gridController = null;
    private Panel mainPanel = new Panel();
    private Borderlayout mainLayout = new Borderlayout();
    private Panel parameterPanel = new Panel();
    private Grid parameterLayout = GridFactory.newGridLayout();
    private Label orgLabel = new Label();
    private WTableDirEditor orgField;
    private Label locatorLabel = new Label();
    private WLocatorEditor locatorField;
    private Label productLabel = new Label();
    private WSearchEditor productField;
    private Label dateFLabel = new Label();
    private WDateEditor dateFField;
    private Label dateTLabel = new Label();
    private WDateEditor dateTField;
    private Label mtypeLabel = new Label();
    private WTableDirEditor mtypeField;
    private Panel southPanel = new Panel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true, true, false, false, false, true, false);
    private StatusBarPanel statusBar = new StatusBarPanel();
    private int noOfColumns;

    public WTrxMaterial() {
        if (log.isLoggable(Level.INFO)) {
            log.info("");
        }
        try {
            this.m_WindowNo = this.form.getWindowNo();
            this.dynParameter();
            this.zkInit();
            this.dynInit();
            if (ClientInfo.isMobile()) {
                ClientInfo.onClientInfo((Component)this.form, this::onClientInfo);
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    void zkInit() throws Exception {
        this.form.appendChild((Component)this.mainPanel);
        this.mainPanel.setStyle("width: 100%; height: 100%; border: none; padding: 0; margin: 0");
        this.mainPanel.appendChild((Component)this.mainLayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.mainLayout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.mainLayout, "100%");
        this.parameterPanel.appendChild((Component)this.parameterLayout);
        this.orgLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        this.locatorLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_Locator_ID"));
        this.productLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"Product"));
        this.dateFLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
        this.dateTLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
        this.mtypeLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"MovementType"));
        North north = new North();
        this.mainLayout.appendChild((Component)north);
        north.appendChild((Component)this.parameterPanel);
        north.setSplittable(true);
        north.setCollapsible(true);
        north.setAutoscroll(true);
        LayoutUtils.addSlideSclass((LayoutRegion)north);
        this.layoutParameters();
        this.southPanel.appendChild((Component)this.confirmPanel);
        this.southPanel.appendChild((Component)this.statusBar);
        South south = new South();
        south.setStyle("border: none");
        this.mainLayout.appendChild((Component)south);
        south.appendChild((Component)this.southPanel);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.southPanel, "64px");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)south, "64px");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.confirmPanel, "32px");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.statusBar, "32px");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.southPanel, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.confirmPanel, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.statusBar, "100%");
        LayoutUtils.addSclass("status-border", (HtmlBasedComponent)this.statusBar);
    }

    protected void layoutParameters() {
        this.noOfColumns = 6;
        if (ClientInfo.maxWidth(639)) {
            this.noOfColumns = 2;
        } else if (ClientInfo.maxWidth(999)) {
            this.noOfColumns = 4;
        }
        int childCnt = 0;
        Rows rows = this.parameterLayout.newRows();
        Row row = rows.newRow();
        row.appendCellChild(this.orgLabel.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.orgField.getComponent(), "true");
        row.appendCellChild((Component)this.orgField.getComponent());
        if ((childCnt += 2) % this.noOfColumns == 0) {
            row = rows.newRow();
        }
        row.appendCellChild(this.mtypeLabel.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.mtypeField.getComponent(), "true");
        row.appendCellChild((Component)this.mtypeField.getComponent());
        if ((childCnt += 2) % this.noOfColumns == 0) {
            row = rows.newRow();
        }
        if (this.noOfColumns == 6) {
            row.appendCellChild(this.dateFLabel.rightAlign());
            row.appendCellChild((Component)this.dateFField.getComponent());
            if ((childCnt += 2) % this.noOfColumns == 0) {
                row = rows.newRow();
            }
        }
        row.appendCellChild(this.locatorLabel.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.locatorField.getComponent(), "true");
        row.appendCellChild((Component)this.locatorField.getComponent());
        if ((childCnt += 2) % this.noOfColumns == 0) {
            row = rows.newRow();
        }
        row.appendCellChild(this.productLabel.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.productField.getComponent(), "true");
        row.appendCellChild((Component)this.productField.getComponent());
        if ((childCnt += 2) % this.noOfColumns == 0) {
            row = rows.newRow();
        }
        if (this.noOfColumns < 6) {
            row.appendCellChild(this.dateFLabel.rightAlign());
            row.appendCellChild((Component)this.dateFField.getComponent());
            if ((childCnt += 2) % this.noOfColumns == 0) {
                row = rows.newRow();
            }
        }
        row.appendCellChild(this.dateTLabel.rightAlign());
        row.appendCellChild((Component)this.dateTField.getComponent());
    }

    private void dynParameter() throws Exception {
        Properties ctx = Env.getCtx();
        MLookup orgLookup = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)0, (int)3660, (int)19);
        this.orgField = new WTableDirEditor("AD_Org_ID", false, false, true, (Lookup)orgLookup);
        MLocatorLookup locatorLookup = new MLocatorLookup(ctx, this.m_WindowNo, null);
        this.locatorField = new WLocatorEditor("M_Locator_ID", false, false, true, locatorLookup, this.m_WindowNo);
        MLookup productLookup = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)0, (int)3668, (int)30);
        this.productField = new WSearchEditor("M_Product_ID", false, false, true, (Lookup)productLookup);
        this.productField.addValueChangeListener(this);
        MLookup mtypeLookup = MLookupFactory.get((Properties)ctx, (int)this.m_WindowNo, (int)0, (int)3666, (int)17);
        this.mtypeField = new WTableDirEditor("MovementType", false, false, true, (Lookup)mtypeLookup);
        this.dateFField = new WDateEditor("DateFrom", false, false, true, Msg.getMsg((Properties)Env.getCtx(), (String)"DateFrom"));
        this.dateTField = new WDateEditor("DateTo", false, false, true, Msg.getMsg((Properties)Env.getCtx(), (String)"DateTo"));
        this.confirmPanel.addActionListener(this);
        this.statusBar.setStatusLine("");
    }

    private void dynInit() {
        super.dynInit((IStatusBar)this.statusBar);
        this.m_gridController = new ADTabpanel();
        this.m_gridController.init(null, this.m_mTab);
        if (!this.m_gridController.isGridView()) {
            this.m_gridController.switchRowPresentation();
        }
        Center center = new Center();
        this.mainLayout.appendChild((Component)center);
        center.appendChild((Component)this.m_gridController);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.m_gridController, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.m_gridController, "1");
    }

    public void dispose() {
        SessionManager.getAppDesktop().closeActiveWindow();
    }

    public void onEvent(Event e) {
        if (e.getTarget().getId().equals("Cancel")) {
            this.dispose();
        } else if (e.getTarget().getId().equals("Refresh") || e.getTarget().getId().equals("Ok")) {
            this.refresh();
        } else if (e.getTarget().getId().equals("Zoom")) {
            this.zoom();
        }
    }

    @Override
    public void valueChange(ValueChangeEvent e) {
        if (e.getPropertyName().equals("M_Product_ID")) {
            this.productField.setValue(e.getNewValue());
        }
    }

    private void refresh() {
        Object organization = this.orgField.getValue();
        Object locator = this.locatorField.getValue();
        Object product = this.productField.getValue();
        Object movementType = this.mtypeField.getValue();
        Timestamp movementDateFrom = this.dateFField.getValue();
        Timestamp movementDateTo = this.dateTField.getValue();
        this.refresh(organization, locator, product, movementType, movementDateFrom, movementDateTo, this.statusBar);
        if (ClientInfo.maxHeight(699)) {
            this.mainLayout.getNorth().setOpen(false);
        }
    }

    public void zoom() {
        super.zoom();
        AEnv.zoom(this.AD_Table_ID, this.Record_ID);
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }

    protected void onClientInfo() {
        if (this.noOfColumns > 0 && this.parameterLayout.getRows() != null) {
            int n = 6;
            if (ClientInfo.maxWidth(639)) {
                n = 2;
            } else if (ClientInfo.maxWidth(999)) {
                n = 4;
            }
            if (n != this.noOfColumns) {
                this.parameterLayout.getRows().detach();
                this.layoutParameters();
                this.form.invalidate();
            }
        }
    }
}

