/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MIssue;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;

@Form(name="org.compiere.apps.form.VSQLProcess")
public class WSQLProcess
extends ADForm
implements EventListener<Event> {
    private static final long serialVersionUID = -4661224754061326223L;
    private static final CLogger log = CLogger.getCLogger(WSQLProcess.class);
    private Grid m_grdMain = new Grid();
    private Label m_lblSql = new Label("SQL");
    private Textbox m_txbSqlField = new Textbox();
    private Button m_btnSql = WSQLProcess.createProcessButton();
    private Textbox m_txbResultField = new Textbox();
    private static final String REGEX_REMOVE_COMMENTS = "/\\*(?:.|[\\n\\r])*?\\*/";
    private static final String REGEX_REMOVE_QUOTED_STRINGS = "'(?:.|[\\n\\r])*?'";
    private static final String REGEX_REMOVE_LEADING_SPACES = "^\\s+";

    @Override
    protected void initForm() {
        Row rwTop = new Row();
        Row rwBottom = new Row();
        Rows rows = new Rows();
        int noColumns = 60;
        int maxStatementLength = 9000;
        int noStatementRows = 3;
        int noResultRows = 20;
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.m_grdMain, "80%");
        this.m_txbSqlField.setMultiline(true);
        this.m_txbSqlField.setMaxlength(9000);
        this.m_txbSqlField.setRows(3);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.m_txbSqlField, "1");
        this.m_txbSqlField.setCols(60);
        this.m_txbSqlField.setReadonly(false);
        this.m_btnSql.addEventListener("onClick", this);
        rwTop.appendChild((Component)this.m_lblSql);
        rwTop.appendChild((Component)this.m_txbSqlField);
        rwTop.appendChild((Component)this.m_btnSql);
        rows.appendChild((Component)rwTop);
        this.m_txbResultField.setCols(60);
        this.m_txbResultField.setRows(20);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.m_txbResultField, "1");
        this.m_txbResultField.setReadonly(true);
        rwBottom.appendCellChild((Component)this.m_txbResultField, 3);
        rwBottom.setAlign("center");
        rows.appendChild((Component)rwBottom);
        this.m_grdMain.appendChild((Component)rows);
        Borderlayout contentPane = new Borderlayout();
        this.appendChild((Component)contentPane);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)contentPane, "99%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)contentPane, "100%");
        Center center = new Center();
        center.setStyle("border: none");
        contentPane.appendChild((Component)center);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.m_grdMain, "true");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.m_grdMain, "true");
        center.appendChild((Component)this.m_grdMain);
    }

    public static final Button createProcessButton() {
        Button btnProcess = new Button();
        if (ThemeManager.isUseFontIconForImage()) {
            btnProcess.setIconSclass("z-icon-Process");
        } else {
            btnProcess.setImage(ThemeManager.getThemeResource("images/Process24.png"));
        }
        btnProcess.setName(Msg.getMsg((Properties)Env.getCtx(), (String)"Process"));
        return btnProcess;
    }

    public static String processStatements(String sqlStatements) {
        if (sqlStatements == null || sqlStatements.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringTokenizer st = new StringTokenizer(sqlStatements, ";", false);
        while (st.hasMoreTokens()) {
            result.append(WSQLProcess.processStatement(st.nextToken()));
            result.append(Env.NL);
        }
        return result.toString();
    }

    public static String processStatement(String sqlStatement) {
        StringBuilder result;
        block22: {
            if (sqlStatement == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            char[] chars = sqlStatement.toCharArray();
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (Character.isWhitespace(c)) {
                    sb.append(' ');
                } else {
                    sb.append(c);
                }
                ++i;
            }
            String sql = sb.toString();
            if (sql.trim().length() == 0) {
                return "";
            }
            if (!sql.contains(" ")) {
                sql = String.valueOf(sql) + " ";
            }
            result = new StringBuilder("SQL> ").append(sql).append(Env.NL);
            String SQL = sql.toUpperCase();
            String cleanSQL = SQL.replaceAll(REGEX_REMOVE_COMMENTS, "").replaceAll(REGEX_REMOVE_QUOTED_STRINGS, "").replaceFirst(REGEX_REMOVE_LEADING_SPACES, "");
            String[] allowedKeywords = MSysConfig.getValue((String)"FORM_SQL_PROCESS_ALLOWED_KEYWORDS", (String)"ALTER,ANALYZE,COMMENT,CREATE,DELETE,DROP,GRANT,INSERT,REINDEX,REVOKE,SET,UPDATE,TRUNCATE,VACUUM").split(",");
            boolean error = true;
            int i2 = 0;
            while (i2 < allowedKeywords.length) {
                if (cleanSQL.startsWith(String.valueOf(allowedKeywords[i2]) + " ")) {
                    error = false;
                    break;
                }
                ++i2;
            }
            if (error) {
                result.append("===> ERROR: Not Allowed Command").append(Env.NL);
                return result.toString();
            }
            Connection conn = DB.createConnection((boolean)true, (int)2);
            Statement stmt = null;
            try {
                try {
                    stmt = conn.createStatement();
                    long start = System.currentTimeMillis();
                    stmt.execute(sql);
                    long end = System.currentTimeMillis();
                    BigDecimal durationSeconds = BigDecimal.valueOf(end).subtract(BigDecimal.valueOf(start)).divide(BigDecimal.valueOf(1000.0));
                    int count = stmt.getUpdateCount();
                    if (count == -1) {
                        result.append("---> ResultSet");
                    } else {
                        result.append("---> Result=").append(count);
                    }
                    MIssue issue = new MIssue(Env.getCtx(), 0, null);
                    issue.setIssueSummary("SQL executed on SQL Process form");
                    issue.setStackTrace(sql);
                    issue.setResponseText(result.toString().replace("SQL> " + sql + Env.NL, ""));
                    issue.setIssueSource("X");
                    issue.setUserName(Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"));
                    issue.setAD_Form_ID(111);
                    issue.setProcessed(true);
                    issue.setComments("Duration : " + durationSeconds + " seconds");
                    issue.saveEx();
                }
                catch (SQLException e) {
                    String exception = e.toString();
                    log.log(Level.SEVERE, "process statement: " + sql + " - " + exception);
                    result.append("===> ").append(exception);
                    DB.close((Statement)stmt);
                    stmt = null;
                    try {
                        conn.close();
                    }
                    catch (SQLException e2) {
                        log.log(Level.SEVERE, "processStatement - close connection", (Throwable)e2);
                    }
                    conn = null;
                    break block22;
                }
            }
            catch (Throwable throwable) {
                DB.close((Statement)stmt);
                stmt = null;
                try {
                    conn.close();
                }
                catch (SQLException e2) {
                    log.log(Level.SEVERE, "processStatement - close connection", (Throwable)e2);
                }
                conn = null;
                throw throwable;
            }
            DB.close((Statement)stmt);
            stmt = null;
            try {
                conn.close();
            }
            catch (SQLException e2) {
                log.log(Level.SEVERE, "processStatement - close connection", (Throwable)e2);
            }
            conn = null;
        }
        result.append(Env.NL);
        return result.toString();
    }

    @Override
    public void onEvent(Event event) throws Exception {
        if (event.getTarget() == this.m_btnSql) {
            this.m_txbResultField.setText(WSQLProcess.processStatements(this.m_txbSqlField.getText()));
        }
        super.onEvent(event);
    }
}

