/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.adwindow.QuickGridView;
import org.adempiere.webui.apps.form.IQuickForm;
import org.adempiere.webui.component.Borderlayout;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.component.ZkCssHelper;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.CustomizeGridViewDialog;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MRole;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkforge.keylistener.Keylistener;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Column;
import org.zkoss.zul.Columns;
import org.zkoss.zul.Window;

public class WQuickForm
extends Window
implements IQuickForm {
    private static final long serialVersionUID = -5363771364595732977L;
    private Borderlayout mainLayout = new Borderlayout();
    private AbstractADWindowContent adWinContent = null;
    private QuickGridView quickGridView = null;
    private GridTab gridTab;
    private ConfirmPanel confirmPanel = new ConfirmPanel(true, true, false, false, false, false);
    private Button bDelete = this.confirmPanel.createButton("Delete");
    private Button bSave = this.confirmPanel.createButton("Save");
    private Button bIgnore = this.confirmPanel.createButton("Ignore");
    private Button bCustomize = this.confirmPanel.createButton("Customize");
    private Button bUnSort = this.confirmPanel.createButton("UnSort");
    private boolean onlyCurrentRows = false;
    private int onlyCurrentDays = 0;
    protected QuickGridView prevQGV = null;
    private int windowNo;
    private boolean stayInParent;

    public WQuickForm(AbstractADWindowContent winContent, boolean m_onlyCurrentRows, int m_onlyCurrentDays) {
        this.setMode(Window.Mode.POPUP);
        this.windowNo = SessionManager.getAppDesktop().registerWindow(this);
        this.adWinContent = winContent;
        this.onlyCurrentRows = m_onlyCurrentRows;
        this.onlyCurrentDays = m_onlyCurrentDays;
        this.gridTab = this.adWinContent.getADTab().getSelectedGridTab();
        this.quickGridView = new QuickGridView(this.adWinContent, this.gridTab, this);
        this.quickGridView.setVisible(true);
        this.initForm();
        this.gridTab.isQuickForm = true;
        this.gridTab.addDataStatusListener((DataStatusListener)this);
        this.prevQGV = this.adWinContent.getCurrQGV();
        this.adWinContent.setCurrQGV(this.quickGridView);
        this.addCallback("afterPageDetached", (Callback & Serializable)t -> {
            boolean bl = this.adWinContent.focusToLastFocusEditor();
        });
    }

    protected void initForm() {
        this.initZk();
        this.createNewRow();
        this.quickGridView.refresh(this.gridTab);
    }

    private void initZk() {
        Panel Center2 = new Panel();
        Center2.appendChild((Component)this.quickGridView);
        ZkCssHelper.appendStyle((HtmlBasedComponent)Center2, "border: none; width: 100%; height:99%; background: gainsboro;");
        Panel south = new Panel();
        south.appendChild((Component)this.adWinContent.getStatusBarQF());
        ZkCssHelper.appendStyle((HtmlBasedComponent)this.adWinContent.getStatusBarQF(), "height: 20px; padding-bottom: 3px background: white");
        south.appendChild((Component)this.confirmPanel);
        ZkCssHelper.appendStyle((HtmlBasedComponent)this.confirmPanel, "height: 50px; padding-top: 9px; background: #9c9c9c;");
        this.bSave.setEnabled(!this.gridTab.isReadOnly());
        this.bDelete.setEnabled(!this.gridTab.isReadOnly());
        this.bIgnore.setEnabled(!this.gridTab.isReadOnly());
        this.bUnSort.setEnabled(!this.gridTab.isReadOnly());
        this.bSave.addEventListener("onClick", this);
        this.bDelete.addEventListener("onClick", this);
        this.bIgnore.addEventListener("onClick", this);
        this.bCustomize.addEventListener("onClick", this);
        this.bUnSort.addEventListener("onClick", this);
        Button bRefresh = this.confirmPanel.getButton("Refresh");
        Button bCancel = this.confirmPanel.getButton("Cancel");
        Button bOk = this.confirmPanel.getButton("Ok");
        this.bSave.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"QuickFormSave"));
        this.bDelete.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"QuickFormDelete"));
        this.bIgnore.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"QuickFormIgnore"));
        this.bUnSort.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"QuickFormUnSort"));
        this.bCustomize.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"QuickFormCustomize"));
        bOk.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"QuickFormOk"));
        bCancel.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"QuickFormCancel"));
        bRefresh.setTooltiptext(Msg.translate((Properties)Env.getCtx(), (String)"QuickFormRefresh"));
        this.confirmPanel.addComponentsLeft(this.bSave);
        this.confirmPanel.addComponentsLeft(this.bDelete);
        this.confirmPanel.addComponentsLeft(this.bIgnore);
        this.confirmPanel.addComponentsLeft(this.bCustomize);
        this.confirmPanel.addComponentsLeft(this.bUnSort);
        this.confirmPanel.addActionListener(this);
        this.mainLayout.appendCenter((Component)Center2);
        this.mainLayout.appendSouth((Component)south);
        this.appendChild((Component)this.mainLayout);
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget() == this.confirmPanel.getButton("Cancel")) {
            this.onCancel();
        } else if (event.getTarget() == this.confirmPanel.getButton("Refresh")) {
            this.quickGridView.getRenderer().setCurrentCell(null);
            this.onRefresh();
        }
        if (event.getTarget() == this.confirmPanel.getButton("Ok")) {
            this.onSave();
            this.dispose();
        } else if (event.getTarget() == this.confirmPanel.getButton("Save")) {
            this.quickGridView.getRenderer().setCurrentCell(null);
            this.onSave();
        } else if (event.getTarget() == this.confirmPanel.getButton("Delete")) {
            this.quickGridView.getRenderer().setCurrentCell(null);
            this.onDelete();
        } else if (event.getTarget() == this.confirmPanel.getButton("Ignore")) {
            this.quickGridView.getRenderer().setCurrentCell(null);
            this.onIgnore();
        } else if (event.getTarget() == this.confirmPanel.getButton("Customize")) {
            this.onCustomize();
        } else if (event.getTarget() == this.confirmPanel.getButton("UnSort")) {
            this.onUnSort();
        }
        event.stopPropagation();
    }

    @Override
    public void onCancel() {
        if (this.gridTab.getTableModel().getRowChanged() > -1) {
            Dialog.ask(this.windowNo, "SaveChanges?", new org.adempiere.util.Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue()) {
                        WQuickForm.this.onSave();
                    }
                    WQuickForm.this.dispose();
                }
            });
        } else {
            this.dispose();
        }
    }

    @Override
    public void onUnSort() {
        this.adWinContent.getActiveGridTab().getTableModel().resetCacheSortState();
        Column sortColumn = this.quickGridView.findCurrentSortColumn();
        this.onRefresh();
        if (sortColumn != null) {
            sortColumn.setSortDirection("natural");
        }
        this.adWinContent.getStatusBarQF().setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"UnSort"), false);
    }

    @Override
    public void onCustomize() {
        this.onSave();
        Columns columns = this.quickGridView.getListbox().getColumns();
        List columnList = columns.getChildren();
        GridField[] fields = this.quickGridView.getGridField();
        HashMap<Integer, String> columnsWidth = new HashMap<Integer, String>();
        ArrayList<Integer> gridFieldIds = new ArrayList<Integer>();
        int i = 0;
        while (i < fields.length) {
            Column column = (Column)columnList.get(i + 1);
            String width = column.getWidth();
            columnsWidth.put(fields[i].getAD_Field_ID(), width);
            gridFieldIds.add(fields[i].getAD_Field_ID());
            ++i;
        }
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.quickGridView, this.getWidth());
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.quickGridView, this.getHeight());
        CustomizeGridViewDialog.showCustomize(0, this.gridTab.getAD_Tab_ID(), columnsWidth, gridFieldIds, null, this.quickGridView, true, null);
    }

    @Override
    public void onIgnore() {
        this.gridTab.dataIgnore();
        this.gridTab.dataRefreshAll();
        this.adWinContent.getStatusBarQF().setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"Ignored"), false);
        this.quickGridView.isNewLineSaved = true;
        if (this.gridTab.getRowCount() <= 0) {
            this.createNewRow();
        }
        this.quickGridView.updateListIndex();
        Events.echoEvent((String)"onSetFocusToFirstCell", (Component)this.quickGridView, null);
    }

    @Override
    public void onDelete() {
        int[] indices;
        if (this.gridTab == null || !this.quickGridView.isNewLineSaved) {
            return;
        }
        if (this.gridTab.getSelection().length == 0) {
            this.gridTab.addToSelection(this.quickGridView.getRenderer().getCurrentRowIndex());
        }
        if ((indices = this.gridTab.getSelection()).length > 0) {
            Dialog.ask(this.windowNo, "DeleteRecord?", new org.adempiere.util.Callback<Boolean>(){

                public void onCallback(Boolean result) {
                    if (result.booleanValue()) {
                        boolean isAllSelected = WQuickForm.this.quickGridView.isAllSelected();
                        WQuickForm.this.quickGridView.isNewLineSaved = true;
                        WQuickForm.this.gridTab.clearSelection();
                        WQuickForm.this.quickGridView.toggleSelectionForAll(false);
                        Arrays.sort(indices);
                        int count = 0;
                        int i = 0;
                        int offset = 0;
                        while (i < indices.length) {
                            WQuickForm.this.gridTab.navigate(indices[i] - offset);
                            if (!WQuickForm.this.gridTab.dataDelete()) break;
                            ++offset;
                            ++count;
                            ++i;
                        }
                        WQuickForm.this.adWinContent.getStatusBarQF().setStatusLine(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"Deleted")) + ": " + count + " / " + indices.length, false);
                        if (WQuickForm.this.gridTab.getRowCount() <= 0) {
                            WQuickForm.this.quickGridView.createNewLine();
                        }
                        WQuickForm.this.quickGridView.updateListIndex();
                        if (isAllSelected) {
                            Events.echoEvent((String)"onPageNavigate", (Component)WQuickForm.this.quickGridView, null);
                        } else {
                            Events.echoEvent((String)"onSetFocusToFirstCell", (Component)WQuickForm.this.quickGridView, null);
                        }
                    } else {
                        WQuickForm.this.gridTab.clearSelection();
                        WQuickForm.this.quickGridView.toggleSelectionForAll(false);
                    }
                }
            });
        }
    }

    @Override
    public void onSave() {
        if (this.gridTab.getTableModel().getRowChanged() == this.gridTab.getCurrentRow()) {
            if (this.quickGridView.dataSave(0)) {
                this.gridTab.dataRefreshAll();
                this.adWinContent.getStatusBarQF().setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"Saved"), false);
                Events.echoEvent((String)"onSetFocusToFirstCell", (Component)this.quickGridView, null);
            }
        } else {
            this.onIgnore();
        }
    }

    @Override
    public void onRefresh() {
        this.gridTab.dataRefreshAll();
        this.adWinContent.getStatusBarQF().setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh"), false);
        this.quickGridView.isNewLineSaved = true;
        this.quickGridView.updateListIndex();
        Events.echoEvent((String)"onSetFocusToFirstCell", (Component)this.quickGridView, null);
        if (this.gridTab.getRowCount() <= 0) {
            this.createNewRow();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.gridTab.setQuickForm(false);
        this.onIgnore();
        this.gridTab.removeDataStatusListener((DataStatusListener)this);
        this.adWinContent.closeQuickFormTab(this.gridTab.getAD_Tab_ID());
        this.quickGridView.getRenderer().clearMaps();
        int tabLevel = this.adWinContent.getToolbar().getQuickFormTabHrchyLevel();
        if (tabLevel > 0) {
            this.adWinContent.getToolbar().setQuickFormTabHrchyLevel(tabLevel - 1);
            Keylistener keyListener = SessionManager.getSessionApplication().getKeylistener();
            keyListener.setCtrlKeys(String.valueOf(keyListener.getCtrlKeys()) + "#left#right#up#down#home@k@r");
            if (this.prevQGV != null) {
                this.adWinContent.onParentRecord();
                SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this.prevQGV);
                Events.echoEvent((String)"onPageNavigate", (Component)this.prevQGV, null);
            }
            this.adWinContent.setCurrQGV(this.prevQGV);
        } else {
            this.adWinContent.setCurrQGV(null);
        }
        this.adWinContent.getADTab().getSelectedTabpanel().query(this.onlyCurrentRows, this.onlyCurrentDays, MRole.getDefault().getMaxQueryRecords());
        if (this.stayInParent) {
            this.adWinContent.onParentRecord();
        }
    }

    private void createNewRow() {
        int row = this.gridTab.getRowCount();
        if (row <= 0 || this.gridTab.isNew() && row == 1) {
            this.gridTab.dataIgnore();
            if (this.gridTab.isInsertRecord()) {
                this.quickGridView.createNewLine();
            } else {
                this.adWinContent.getStatusBarQF().setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"NewError"), true);
            }
        }
    }

    public void dataStatusChanged(DataStatusEvent e) {
        if (Executions.getCurrent() == null || e.isInitEdit()) {
            return;
        }
        int col = e.getChangedColumn();
        this.quickGridView.dynamicDisplay(col);
    }

    public void setStayInParent(boolean stayInParent) {
        this.stayInParent = stayInParent;
    }
}

