/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.WebUIActivator;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.minigrid.IDColumn;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.ui.zk.annotation.Form;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleRevision;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Vbox;

@Form
public class WPluginManager
extends ADForm
implements EventListener<Event> {
    private static final long serialVersionUID = -5661912464378243252L;
    private static final CLogger log = CLogger.getCLogger(WPluginManager.class);
    private WListbox pluginsTable;
    private Listbox pluginActions;
    private Button pluginProcess;
    private Vector<Vector<Object>> pluginData;
    private Vector<String> pluginColumnNames;
    private Textbox fFilter = new Textbox();
    private Button btnRefresh = null;
    private static final int PLUGIN_ACTION_NONE = 0;
    private static final int PLUGIN_ACTION_STOP = 1;
    private static final int PLUGIN_ACTION_START = 2;
    private static final int PLUGIN_ACTION_UPDATE = 3;
    private static final int PLUGIN_ACTION_UNINSTALL = 4;
    private static final int PLUGIN_ACTION_INSTALL = 5;

    @Override
    protected void initForm() {
        Properties ctx = Env.getCtx();
        Vbox vbox = new Vbox();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)vbox, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)vbox, "1");
        this.fFilter.setPlaceholder(Msg.getMsg((Properties)ctx, (String)"filter.by"));
        this.fFilter.addEventListener("onChange", this);
        this.btnRefresh = ButtonFactory.createNamedButton("Refresh");
        this.btnRefresh.addEventListener("onClick", this);
        Hlayout hl = new Hlayout();
        hl.setValign("middle");
        hl.appendChild((Component)this.fFilter);
        hl.appendChild((Component)this.btnRefresh);
        vbox.appendChild((Component)hl);
        this.pluginColumnNames = new Vector();
        this.pluginColumnNames.add("");
        this.pluginColumnNames.add(Msg.getMsg((Properties)ctx, (String)"Id"));
        this.pluginColumnNames.add(Msg.getMsg((Properties)ctx, (String)"State"));
        this.pluginColumnNames.add(Msg.getCleanMsg((Properties)ctx, (String)"Name"));
        this.pluginColumnNames.add(Msg.getMsg((Properties)ctx, (String)"Version"));
        this.pluginsTable = ListboxFactory.newDataTableAutoSize();
        this.pluginData = new Vector();
        int i = 0;
        this.pluginsTable.setColumnClass(i++, IDColumn.class, true);
        this.pluginsTable.setColumnClass(i++, Integer.class, true);
        this.pluginsTable.setColumnClass(i++, String.class, true);
        this.pluginsTable.setColumnClass(i++, String.class, true);
        this.pluginsTable.setColumnClass(i++, String.class, true);
        vbox.appendChild((Component)this.pluginsTable);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.pluginsTable, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.pluginsTable, "1");
        this.refreshPluginTable();
        this.pluginsTable.addEventListener("onSelect", this);
        this.pluginActions = new Listbox(new KeyNamePair[]{new KeyNamePair(0, ""), new KeyNamePair(1, Msg.getMsg((Properties)ctx, (String)"Stop")), new KeyNamePair(2, Msg.getMsg((Properties)ctx, (String)"Start")), new KeyNamePair(3, Msg.getMsg((Properties)ctx, (String)"Update")), new KeyNamePair(4, Msg.getMsg((Properties)ctx, (String)"Uninstall")), new KeyNamePair(5, Msg.getMsg((Properties)ctx, (String)"Install"))});
        this.pluginActions.setId("pluginActions");
        this.pluginActions.setRows(0);
        this.pluginActions.setMold("select");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.pluginActions, "200px");
        this.refreshActionList();
        this.pluginProcess = new Button(Msg.getMsg((Properties)ctx, (String)"Process"));
        this.pluginProcess.addEventListener("onClick", this);
        Div div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.pluginActions);
        div.appendChild((Component)this.pluginProcess);
        vbox.appendChild((Component)div);
        this.appendChild((Component)vbox);
    }

    private String state(int state) {
        switch (state) {
            case 32: {
                return "ACTIVE";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 1: {
                return "UNINSTALLED";
            }
        }
        return "UNKNOWN";
    }

    private void refreshActionList() {
        this.pluginActions.getItemAtIndex(3).setVisible(false);
        this.pluginActions.getItemAtIndex(4).setVisible(false);
        this.pluginActions.getItemAtIndex(5).setVisible(false);
        this.pluginActions.getItemAtIndex(1).setVisible(false);
        this.pluginActions.getItemAtIndex(2).setVisible(false);
        this.pluginActions.setSelectedItem(null);
        Bundle bundle = this.getSelectedBundle();
        if (bundle == null) {
            return;
        }
        int state = bundle.getState();
        boolean isFragment = false;
        BundleRevision rev = (BundleRevision)bundle.adapt(BundleRevision.class);
        if (rev != null) {
            boolean bl = isFragment = (rev.getTypes() & 1) != 0;
        }
        if (bundle.getBundleId() != 0L) {
            if (state == 32) {
                this.pluginActions.getItemAtIndex(1).setVisible(true);
            } else if (state == 4) {
                if (!isFragment) {
                    this.pluginActions.getItemAtIndex(2).setVisible(true);
                }
            } else if (state == 2) {
                if (!isFragment) {
                    this.pluginActions.getItemAtIndex(2).setVisible(true);
                }
            } else if (state == 8) {
                if (!isFragment) {
                    this.pluginActions.getItemAtIndex(2).setVisible(true);
                }
            } else if (state != 16) {
                // empty if block
            }
        }
    }

    private Bundle getSelectedBundle() {
        Bundle retValue = null;
        int idx = this.pluginsTable.getSelectedIndex();
        if (idx >= 0) {
            Vector<Object> pluginVector = this.pluginData.get(idx);
            int pluginId = ((IDColumn)pluginVector.get(0)).getRecord_ID();
            BundleContext bundleCtx = WebUIActivator.getBundleContext();
            retValue = bundleCtx.getBundle((long)pluginId);
        }
        return retValue;
    }

    private void processPlugin() {
        ListItem actionItem = this.pluginActions.getSelectedItem();
        if (actionItem != null && actionItem.getValue() instanceof Integer) {
            int action = (Integer)actionItem.getValue();
            Bundle bundle = this.getSelectedBundle();
            if (action == 1 && bundle != null) {
                try {
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Stopping plugin " + bundle.getSymbolicName());
                    }
                    bundle.stop();
                }
                catch (BundleException e) {
                    throw new AdempiereException((Throwable)e);
                }
            } else if (action == 2 && bundle != null) {
                try {
                    if (log.isLoggable(Level.INFO)) {
                        log.info("Starting plugin " + bundle.getSymbolicName());
                    }
                    bundle.start();
                }
                catch (BundleException e) {
                    throw new AdempiereException((Throwable)e);
                }
            } else if (action == 3 && bundle != null || action == 4 && bundle != null || action == 5) {
                // empty if block
            }
        }
        this.refreshAll();
    }

    private void refreshPluginTable() {
        int idx = this.pluginsTable.getSelectedIndex();
        this.pluginsTable.getModel().removeAll(this.pluginData);
        this.pluginData.removeAllElements();
        BundleContext bundleCtx = WebUIActivator.getBundleContext();
        Bundle[] bundleArray = bundleCtx.getBundles();
        int n = bundleArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (Util.isEmpty((String)this.fFilter.getValue()) || bundle.getSymbolicName().toUpperCase().contains(this.fFilter.getValue().toUpperCase())) {
                Vector<Object> line = new Vector<Object>();
                Integer bundl = Long.valueOf(bundle.getBundleId()).intValue();
                line.add(new IDColumn(bundl));
                line.add(bundl);
                line.add(this.state(bundle.getState()));
                line.add(bundle.getSymbolicName());
                line.add(bundle.getVersion());
                this.pluginData.add(line);
            }
            ++n2;
        }
        ListModelTable model = new ListModelTable(this.pluginData);
        this.pluginsTable.setData(model, this.pluginColumnNames);
        this.pluginsTable.setSelectedIndex(idx);
    }

    private void refreshAll() {
        this.refreshPluginTable();
        this.refreshActionList();
    }

    @Override
    public void onEvent(Event event) throws Exception {
        if ("onSelect".equals(event.getName()) && event.getTarget() == this.pluginsTable) {
            this.refreshActionList();
        } else if ("onClick".equals(event.getName()) && event.getTarget() == this.pluginProcess) {
            this.processPlugin();
        } else if ("onClick".equals(event.getName()) && event.getTarget() == this.btnRefresh) {
            this.refreshAll();
        } else if ("onChange".equals(event.getName()) && event.getTarget() == this.fFilter) {
            this.pluginsTable.setSelectedIndex(-1);
            this.refreshAll();
        }
    }
}

