/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.SimpleListModel;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WNumberEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.panel.StatusBarPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.apps.form.Match;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vlayout;

@Form(name="org.compiere.apps.form.VMatch")
public class WMatch
extends Match
implements IFormController,
EventListener<Event>,
WTableModelListener {
    private CustomForm form = new CustomForm();
    private int m_WindowNo = 0;
    private static final CLogger log = CLogger.getCLogger(WMatch.class);
    private int m_AD_Client_ID = Env.getAD_Client_ID((Properties)Env.getCtx());
    private int m_AD_Org_ID = Env.getAD_Org_ID((Properties)Env.getCtx());
    private int m_by = Env.getAD_User_ID((Properties)Env.getCtx());
    private String[] m_matchOptions = new String[]{Msg.getElement((Properties)Env.getCtx(), (String)"C_Invoice_ID", (boolean)false), Msg.getElement((Properties)Env.getCtx(), (String)"M_InOut_ID", (boolean)false), Msg.getElement((Properties)Env.getCtx(), (String)"C_Order_ID", (boolean)false)};
    private String[] m_matchMode = new String[]{Msg.translate((Properties)Env.getCtx(), (String)"NotMatched"), Msg.translate((Properties)Env.getCtx(), (String)"Matched")};
    private static final int MODE_NOTMATCHED = 0;
    private static final int MODE_MATCHED = 1;
    private BigDecimal m_xMatched = Env.ZERO;
    private BigDecimal m_xMatchedTo = Env.ZERO;
    private Panel mainPanel = new Panel();
    private StatusBarPanel statusBar = new StatusBarPanel();
    private Borderlayout mainLayout = new Borderlayout();
    private Panel northPanel = new Panel();
    private Grid northLayout = GridFactory.newGridLayout();
    private Label matchFromLabel = new Label();
    private Listbox matchFrom = ListboxFactory.newDropdownListbox(this.m_matchOptions);
    private Label matchToLabel = new Label();
    private Listbox matchTo = ListboxFactory.newDropdownListbox();
    private Label matchModeLabel = new Label();
    private Listbox matchMode = ListboxFactory.newDropdownListbox(this.m_matchMode);
    private WSearchEditor onlyVendor = null;
    private WSearchEditor onlyProduct = null;
    private Label onlyVendorLabel = new Label();
    private Label onlyProductLabel = new Label();
    private Label dateFromLabel = new Label();
    private Label dateToLabel = new Label();
    private WDateEditor dateFrom = new WDateEditor("DateFrom", false, false, true, "DateFrom");
    private WDateEditor dateTo = new WDateEditor("DateTo", false, false, true, "DateTo");
    private Button bSearch = new Button();
    private Panel southPanel = new Panel();
    private Grid southLayout = GridFactory.newGridLayout();
    private Label xMatchedLabel = new Label();
    private Label xMatchedToLabel = new Label();
    private Label differenceLabel = new Label();
    private WNumberEditor xMatched = new WNumberEditor("xMatched", false, true, false, 29, "xMatched");
    private WNumberEditor xMatchedTo = new WNumberEditor("xMatchedTo", false, true, false, 29, "xMatchedTo");
    private WNumberEditor difference = new WNumberEditor("Difference", false, true, false, 29, "Difference");
    private Button bProcess = new Button();
    private Panel centerPanel = new Panel();
    private Borderlayout centerLayout = new Borderlayout();
    private Label xMatchedBorder = new Label("xMatched");
    private WListbox xMatchedTable = ListboxFactory.newDataTable();
    private Label xMatchedToBorder = new Label("xMatchedTo");
    private WListbox xMatchedToTable = ListboxFactory.newDataTable();
    private Panel xPanel = new Panel();
    private Checkbox sameProduct = new Checkbox();
    private Checkbox sameBPartner = new Checkbox();
    private Checkbox sameQty = new Checkbox();
    private int noOfColumn;

    public WMatch() {
        this.m_WindowNo = this.form.getWindowNo();
        if (log.isLoggable(Level.INFO)) {
            log.info("WinNo=" + this.m_WindowNo + " - AD_Client_ID=" + this.m_AD_Client_ID + ", AD_Org_ID=" + this.m_AD_Org_ID + ", By=" + this.m_by);
        }
        Env.setContext((Properties)Env.getCtx(), (int)this.m_WindowNo, (String)"IsSOTrx", (String)"N");
        try {
            this.onlyVendor = WSearchEditor.createBPartner(this.m_WindowNo);
            this.onlyProduct = WSearchEditor.createProduct(this.m_WindowNo);
            this.zkInit();
            this.dynInit();
            this.southPanel.appendChild((Component)new Separator());
            this.southPanel.appendChild((Component)this.statusBar);
            LayoutUtils.addSclass("status-border", (HtmlBasedComponent)this.statusBar);
            this.cmd_matchTo();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        if (ClientInfo.isMobile()) {
            ClientInfo.onClientInfo((Component)this.form, this::onClientInfo);
        }
    }

    private void zkInit() throws Exception {
        this.form.appendChild((Component)this.mainPanel);
        this.mainPanel.setStyle("width: 100%; height: 100%; padding: 0; margin: 0; overflow: auto;");
        this.mainPanel.appendChild((Component)this.mainLayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.mainLayout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.mainLayout, "100%");
        this.mainLayout.setStyle("min-height: 750px");
        this.northPanel.appendChild((Component)this.northLayout);
        this.matchFromLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"MatchFrom"));
        this.matchToLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"MatchTo"));
        this.matchModeLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"MatchMode"));
        this.onlyVendorLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        this.onlyProductLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
        this.dateFromLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"DateFrom"));
        this.dateToLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"DateTo"));
        this.bSearch.setLabel(Msg.translate((Properties)Env.getCtx(), (String)"Search"));
        this.southPanel.appendChild((Component)this.southLayout);
        this.xMatchedLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"ToBeMatched"));
        this.xMatchedToLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"Matching"));
        this.differenceLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"Difference"));
        this.bProcess.setLabel(Msg.translate((Properties)Env.getCtx(), (String)"Process"));
        this.centerPanel.appendChild((Component)this.centerLayout);
        this.sameProduct.setSelected(true);
        this.sameProduct.setText(Msg.translate((Properties)Env.getCtx(), (String)"SameProduct"));
        this.sameBPartner.setSelected(true);
        this.sameBPartner.setText(Msg.translate((Properties)Env.getCtx(), (String)"SameBPartner"));
        this.sameQty.setSelected(false);
        this.sameQty.setText(Msg.translate((Properties)Env.getCtx(), (String)"SameQty"));
        North north = new North();
        this.mainLayout.appendChild((Component)north);
        north.appendChild((Component)this.northPanel);
        north.setCollapsible(true);
        north.setSplittable(true);
        this.layoutParameterAndSummary();
        Center center = new Center();
        center.setAutoscroll(true);
        this.mainLayout.appendChild((Component)center);
        center.appendChild((Component)this.centerPanel);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.centerPanel, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.centerPanel, "1");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.centerLayout, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.centerLayout, "100%");
        north = new North();
        this.centerLayout.appendChild((Component)north);
        north.setStyle("border: none");
        Panel p = new Panel();
        p.appendChild((Component)this.xMatchedBorder);
        p.appendChild((Component)this.xMatchedTable);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.xMatchedTable, "100%");
        p.setStyle("width: 100%; height: 100%; padding: 0; margin: 0");
        north.appendChild((Component)p);
        ZKUpdateUtil.setHeight((HtmlBasedComponent)north, "45%");
        north.setSplittable(true);
        north.setCollapsible(true);
        center = new Center();
        this.centerLayout.appendChild((Component)center);
        center.setBorder("none");
        Vlayout vlayout = new Vlayout();
        vlayout.setVflex("1");
        vlayout.setHflex("1");
        center.appendChild((Component)vlayout);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.xPanel, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.xPanel, "1");
        this.xPanel.appendChild((Component)this.sameBPartner);
        this.xPanel.appendChild((Component)new Space());
        this.xPanel.appendChild((Component)this.sameProduct);
        this.xPanel.appendChild((Component)new Space());
        this.xPanel.appendChild((Component)this.sameQty);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.xPanel, "min");
        this.xPanel.appendChild((Component)new Separator());
        vlayout.appendChild((Component)this.xPanel);
        vlayout.appendChild((Component)this.xMatchedToBorder);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.xMatchedToTable, "100%");
        vlayout.appendChild((Component)this.xMatchedToTable);
        ZKUpdateUtil.setVflex(this.xMatchedTable, true);
        this.centerPanel.setStyle("min-height: 300px;");
    }

    protected void layoutParameterAndSummary() {
        this.setupParameterColumns();
        Rows rows = this.northLayout.newRows();
        Row row = rows.newRow();
        row.appendChild(this.matchFromLabel.rightAlign());
        row.appendChild((Component)this.matchFrom);
        row.appendChild(this.matchToLabel.rightAlign());
        row.appendChild((Component)this.matchTo);
        row = rows.newRow();
        row.appendCellChild(this.matchModeLabel.rightAlign(), 1);
        row.appendCellChild((Component)this.matchMode, 1);
        row = rows.newRow();
        row.appendChild(this.onlyVendorLabel.rightAlign());
        row.appendChild((Component)this.onlyVendor.getComponent());
        row.appendChild(this.onlyProductLabel.rightAlign());
        row.appendChild((Component)this.onlyProduct.getComponent());
        row = rows.newRow();
        row.appendChild(this.dateFromLabel.rightAlign());
        row.appendChild((Component)this.dateFrom.getComponent());
        row.appendChild(this.dateToLabel.rightAlign());
        row.appendChild((Component)this.dateTo.getComponent());
        this.bSearch.setStyle("float: right");
        int r = row.getChildren().size() % this.noOfColumn;
        row.appendCellChild((Component)this.bSearch, this.noOfColumn - r);
        if (this.noOfColumn < 6) {
            LayoutUtils.compactTo(this.northLayout, this.noOfColumn);
        } else {
            LayoutUtils.expandTo(this.northLayout, this.noOfColumn, true);
        }
        South south = new South();
        this.mainLayout.appendChild((Component)south);
        south.appendChild((Component)this.southPanel);
        rows = this.southLayout.newRows();
        row = rows.newRow();
        row.appendChild(this.xMatchedLabel.rightAlign());
        row.appendChild((Component)this.xMatched.getComponent());
        row.appendChild(this.xMatchedToLabel.rightAlign());
        row.appendChild((Component)this.xMatchedTo.getComponent());
        row.appendChild(this.differenceLabel.rightAlign());
        row.appendChild((Component)this.difference.getComponent());
        row = rows.newRow();
        row.appendCellChild((Component)this.bProcess, this.noOfColumn);
        this.bProcess.setStyle("float: right");
        if (this.noOfColumn < 6) {
            LayoutUtils.compactTo(this.southLayout, this.noOfColumn);
        }
    }

    protected void setupParameterColumns() {
        this.noOfColumn = 6;
        if (ClientInfo.maxWidth(999)) {
            this.noOfColumn = ClientInfo.maxWidth(699) ? 2 : 4;
        }
        Columns columns = new Columns();
        Column column = new Column();
        column.setWidth(this.noOfColumn == 2 ? "35%" : (this.noOfColumn == 4 ? "15%" : "10%"));
        columns.appendChild((Component)column);
        column = new Column();
        column.setWidth(this.noOfColumn == 2 ? "65%" : "35%");
        columns.appendChild((Component)column);
        if (this.noOfColumn > 2) {
            column = new Column();
            column.setWidth(this.noOfColumn == 4 ? "15%" : "10%");
            columns.appendChild((Component)column);
            column = new Column();
            column.setWidth("35%");
            columns.appendChild((Component)column);
        }
        if (this.noOfColumn == 6) {
            column = new Column();
            column.setWidth("5%");
            columns.appendChild((Component)column);
            column = new Column();
            column.setWidth("5%");
            columns.appendChild((Component)column);
        }
        this.northLayout.appendChild((Component)columns);
    }

    private void dynInit() {
        ColumnInfo[] layout = this.getColumnLayout();
        this.xMatchedTable.prepareTable(layout, "", "", false, "");
        this.xMatchedToTable.prepareTable(layout, "", "", true, "");
        this.matchFrom.setSelectedIndex(0);
        this.matchFrom.addActionListener(this);
        this.matchTo.addActionListener(this);
        this.bSearch.addActionListener(this);
        this.xMatchedTable.addEventListener("onSelect", this);
        this.xMatchedToTable.getModel().addTableModelListener(this);
        this.bProcess.addActionListener(this);
        this.sameBPartner.addActionListener(this);
        this.sameProduct.addActionListener(this);
        this.sameQty.addActionListener(this);
        String selection = (String)this.matchFrom.getSelectedItem().getValue();
        SimpleListModel model = new SimpleListModel(this.cmd_matchFrom(this.matchFrom.getSelectedItem().getLabel()));
        this.matchTo.setItemRenderer(model);
        this.matchTo.setModel((ListModel)model);
        this.xMatchedBorder.setValue(selection);
        this.xMatchedTable.setRowCount(0);
        this.matchTo.setSelectedIndex(0);
        this.cmd_matchTo();
        this.statusBar.setStatusLine("");
        this.statusBar.setStatusDB("0");
    }

    public void dispose() {
        SessionManager.getAppDesktop().closeActiveWindow();
    }

    protected void onClientInfo() {
        if (ClientInfo.isMobile() && this.form.getPage() != null && this.noOfColumn > 0 && this.northLayout.getRows() != null) {
            int t = 6;
            if (ClientInfo.maxWidth(999)) {
                t = ClientInfo.maxWidth(699) ? 2 : 4;
            }
            if (t != this.noOfColumn) {
                this.northLayout.getRows().detach();
                if (this.northLayout.getColumns() != null) {
                    this.northLayout.getColumns().detach();
                }
                if (this.mainLayout.getSouth() != null) {
                    this.mainLayout.getSouth().detach();
                }
                if (this.southLayout.getRows() != null) {
                    this.southLayout.getRows().detach();
                }
                this.layoutParameterAndSummary();
                this.form.invalidate();
            }
        }
    }

    public void onEvent(Event e) {
        Timestamp to;
        Integer product = this.onlyProduct.getValue() != null ? (Integer)this.onlyProduct.getValue() : null;
        Integer vendor = this.onlyVendor.getValue() != null ? (Integer)this.onlyVendor.getValue() : null;
        Timestamp from = this.dateFrom.getValue() != null ? this.dateFrom.getValue() : null;
        Timestamp timestamp = to = this.dateTo.getValue() != null ? this.dateTo.getValue() : null;
        if (e.getTarget() == this.matchFrom) {
            String selection = (String)this.matchFrom.getSelectedItem().getValue();
            SimpleListModel model = new SimpleListModel(this.cmd_matchFrom(this.matchFrom.getSelectedItem().getLabel()));
            this.matchTo.setItemRenderer(model);
            this.matchTo.setModel((ListModel)model);
            this.xMatchedBorder.setValue(selection);
            this.xMatchedTable.setRowCount(0);
            this.matchTo.setSelectedIndex(0);
            this.cmd_matchTo();
        } else if (e.getTarget() == this.matchTo) {
            this.cmd_matchTo();
        } else if (e.getTarget() == this.bSearch) {
            this.xMatchedTable = (WListbox)this.cmd_search(this.xMatchedTable, this.matchFrom.getSelectedIndex(), this.matchTo.getSelectedItem().getLabel(), product, vendor, from, to, this.matchMode.getSelectedIndex() == 1);
            this.xMatched.setValue(Env.ZERO);
            this.statusBar.setStatusLine(String.valueOf(this.matchFrom.getSelectedItem().getLabel()) + "# = " + this.xMatchedTable.getRowCount(), this.xMatchedTable.getRowCount() == 0);
            this.statusBar.setStatusDB("0");
            this.cmd_searchTo();
        } else if (e.getTarget() == this.bProcess) {
            this.cmd_process(this.xMatchedTable, this.xMatchedToTable, this.matchMode.getSelectedIndex(), this.matchFrom.getSelectedIndex(), this.matchTo.getSelectedItem().getLabel(), this.m_xMatched);
            this.xMatchedTable = (WListbox)this.cmd_search(this.xMatchedTable, this.matchFrom.getSelectedIndex(), this.matchTo.getSelectedItem().getLabel(), product, vendor, from, to, this.matchMode.getSelectedIndex() == 1);
            this.xMatched.setValue(Env.ZERO);
            this.statusBar.setStatusLine(String.valueOf(this.matchFrom.getSelectedItem().getLabel()) + "# = " + this.xMatchedTable.getRowCount(), this.xMatchedTable.getRowCount() == 0);
            this.statusBar.setStatusDB("0");
            this.cmd_searchTo();
        } else if (e.getTarget() == this.sameBPartner || e.getTarget() == this.sameProduct || e.getTarget() == this.sameQty) {
            this.cmd_searchTo();
        } else if (AEnv.contains((Component)this.xMatchedTable, e.getTarget())) {
            this.cmd_searchTo();
        }
    }

    private void cmd_matchTo() {
        int index = this.matchTo.getSelectedIndex();
        String selection = (String)this.matchTo.getModel().getElementAt(index);
        this.xMatchedToBorder.setValue(selection);
        this.xMatchedToTable.setRowCount(0);
    }

    private void cmd_searchTo() {
        int row = this.xMatchedTable.getSelectedRow();
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Row=" + row);
        }
        double qty = 0.0;
        if (row < 0) {
            this.xMatchedToTable.setRowCount(0);
        } else {
            String displayString = this.matchTo.getSelectedItem().getLabel();
            int matchToType = this.matchFrom.getSelectedIndex();
            double docQty = (Double)this.xMatchedTable.getValueAt(row, 6);
            double matchedQty = (Double)this.xMatchedTable.getValueAt(row, 7);
            qty = docQty - matchedQty;
            this.xMatchedToTable = (WListbox)this.cmd_searchTo(this.xMatchedTable, this.xMatchedToTable, displayString, matchToType, this.sameBPartner.isSelected(), this.sameProduct.isSelected(), this.sameQty.isSelected(), this.matchMode.getSelectedIndex() == 1);
        }
        this.m_xMatched = BigDecimal.valueOf(qty);
        this.xMatched.setValue(this.m_xMatched);
        this.xMatchedTo.setValue(Env.ZERO);
        this.difference.setValue(this.m_xMatched);
        this.statusBar.setStatusLine(String.valueOf(this.matchFrom.getSelectedItem().getLabel()) + "# = " + this.xMatchedTable.getRowCount() + " - " + this.getMatchToLabel() + "# = " + this.xMatchedToTable.getRowCount(), this.xMatchedToTable.getRowCount() == 0);
        this.statusBar.setStatusDB("0");
    }

    private String getMatchToLabel() {
        int index = this.matchTo.getSelectedIndex();
        return this.matchTo.getModel().getElementAt(index).toString();
    }

    @Override
    public void tableChanged(WTableModelEvent e) {
        if (e.getColumn() != 0) {
            return;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Row=" + e.getFirstRow() + "-" + e.getLastRow() + ", Col=" + e.getColumn() + ", Type=" + e.getType());
        }
        int matchedRow = this.xMatchedTable.getSelectedRow();
        KeyNamePair Product = (KeyNamePair)this.xMatchedTable.getValueAt(matchedRow, 5);
        double qty = 0.0;
        int noRows = 0;
        int row = 0;
        while (row < this.xMatchedToTable.getRowCount()) {
            IDColumn id = (IDColumn)this.xMatchedToTable.getValueAt(row, 0);
            if (id != null && id.isSelected()) {
                KeyNamePair ProductCompare = (KeyNamePair)this.xMatchedToTable.getValueAt(row, 5);
                if (Product.getKey() != ProductCompare.getKey()) {
                    id.setSelected(false);
                } else {
                    if (this.matchMode.getSelectedIndex() == 0) {
                        qty += ((Double)this.xMatchedToTable.getValueAt(row, 6)).doubleValue();
                    }
                    qty -= ((Double)this.xMatchedToTable.getValueAt(row, 7)).doubleValue();
                    ++noRows;
                }
            }
            ++row;
        }
        this.m_xMatchedTo = BigDecimal.valueOf(qty);
        this.xMatchedTo.setValue(this.m_xMatchedTo);
        this.difference.setValue(this.m_xMatched.subtract(this.m_xMatchedTo));
        this.bProcess.setEnabled(noRows != 0);
        this.statusBar.setStatusDB(String.valueOf(noRows));
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }
}

