/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.form.WGenForm;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.apps.form.GenForm;
import org.compiere.apps.form.InOutGen;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.North;

@Form(name="org.compiere.apps.form.VInOutGen")
public class WInOutGen
extends InOutGen
implements IFormController,
EventListener<Event>,
ValueChangeListener {
    private WGenForm form;
    private static final CLogger log = CLogger.getCLogger(WInOutGen.class);
    private Label lWarehouse = new Label();
    private WTableDirEditor fWarehouse;
    private Label lBPartner = new Label();
    private WSearchEditor fBPartner;
    private Label lDocType = new Label();
    private Listbox cmbDocType = ListboxFactory.newDropdownListbox();
    private Label lDocAction = new Label();
    private WTableDirEditor docAction;
    private int noOfColumn;

    public WInOutGen() {
        log.info("");
        this.form = new WGenForm((GenForm)this);
        Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"IsSOTrx", (String)"Y");
        try {
            this.dynInit();
            this.zkInit();
            this.form.postQueryEvent();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "init", (Throwable)ex);
        }
        ClientInfo.onClientInfo((Component)this.form, this::onClientInfo);
    }

    void zkInit() throws Exception {
        this.setupColumns();
        this.lBPartner.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        Row row = this.form.getParameterPanel().newRows().newRow();
        row.appendCellChild(this.lWarehouse.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fWarehouse.getComponent(), "true");
        row.appendCellChild((Component)this.fWarehouse.getComponent());
        row.appendCellChild(this.lBPartner.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fBPartner.getComponent(), "true");
        row.appendCellChild((Component)this.fBPartner.getComponent());
        row = new Row();
        this.form.getParameterPanel().getRows().appendChild((Component)row);
        row.appendCellChild(this.lDocType.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.cmbDocType, "true");
        row.appendCellChild((Component)this.cmbDocType);
        row.appendCellChild(this.lDocAction.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.docAction.getComponent(), "true");
        row.appendCellChild((Component)this.docAction.getComponent());
        if (this.noOfColumn < 6) {
            LayoutUtils.compactTo(this.form.getParameterPanel(), this.noOfColumn);
        } else {
            LayoutUtils.expandTo(this.form.getParameterPanel(), this.noOfColumn, true);
        }
    }

    protected void setupColumns() {
        this.noOfColumn = 6;
        if (ClientInfo.maxWidth(999)) {
            this.noOfColumn = ClientInfo.maxWidth(699) ? 2 : 4;
        }
        if (this.noOfColumn == 2) {
            Columns columns = new Columns();
            Column column = new Column();
            column.setWidth("35%");
            columns.appendChild((Component)column);
            column = new Column();
            column.setWidth("65%");
            columns.appendChild((Component)column);
            this.form.getParameterPanel().appendChild((Component)columns);
        }
    }

    public void dynInit() throws Exception {
        MLookup orgL = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)11474, (int)19);
        this.fWarehouse = new WTableDirEditor("M_Warehouse_ID", true, false, true, (Lookup)orgL);
        this.lWarehouse.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_Warehouse_ID"));
        this.fWarehouse.addValueChangeListener(this);
        this.fWarehouse.setValue(Env.getContextAsInt((Properties)Env.getCtx(), (String)"#M_Warehouse_ID"));
        this.setM_Warehouse_ID(this.fWarehouse.getValue());
        this.lDocAction.setText(Msg.translate((Properties)Env.getCtx(), (String)"DocAction"));
        MLookup docActionL = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)4324, (int)17, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"DocAction", (int)135, (boolean)false, (String)"AD_Ref_List.Value IN ('CO','PR','--')");
        this.docAction = new WTableDirEditor("DocAction", true, false, true, (Lookup)docActionL);
        this.docAction.setValue("CO");
        MLookup bpL = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)2762, (int)30);
        this.fBPartner = new WSearchEditor("C_BPartner_ID", false, false, true, (Lookup)bpL);
        this.lBPartner.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        this.fBPartner.addValueChangeListener(this);
        this.lDocType.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_DocType_ID"));
        this.cmbDocType.addItem(new KeyNamePair(259, Msg.translate((Properties)Env.getCtx(), (String)"Order")));
        this.cmbDocType.addItem(new KeyNamePair(661, Msg.translate((Properties)Env.getCtx(), (String)"VendorRMA")));
        this.cmbDocType.addActionListener(this);
        this.cmbDocType.setSelectedIndex(0);
        this.form.getStatusBar().setStatusLine(Msg.getMsg((Properties)Env.getCtx(), (String)"InOutGenerateSel"));
    }

    public void executeQuery() {
        Component comp;
        KeyNamePair docTypeKNPair = this.cmbDocType.getSelectedItem().toKeyNamePair();
        this.executeQuery(docTypeKNPair, this.form.getMiniTable());
        if (ClientInfo.maxHeight(499) && (comp = this.form.getParameterPanel().getParent()) instanceof North) {
            ((North)comp).setOpen(false);
        }
        this.form.getMiniTable().repaint();
    }

    protected void onClientInfo() {
        if (ClientInfo.isMobile() && this.form.getPage() != null && this.noOfColumn > 0 && this.form.getParameterPanel().getRows() != null) {
            int t = 6;
            if (ClientInfo.maxWidth(999)) {
                t = ClientInfo.maxWidth(699) ? 2 : 4;
            }
            if (t != this.noOfColumn) {
                this.form.getParameterPanel().getRows().detach();
                if (this.form.getParameterPanel().getColumns() != null) {
                    this.form.getParameterPanel().getColumns().detach();
                }
                try {
                    this.zkInit();
                    this.form.invalidate();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void onEvent(Event e) {
        if (log.isLoggable(Level.INFO)) {
            log.info("Cmd=" + e.getTarget().getId());
        }
        if (((Object)((Object)this.cmbDocType)).equals(e.getTarget())) {
            this.form.postQueryEvent();
            return;
        }
        this.validate();
    }

    public void validate() {
        if (this.isSelectionActive() && this.getM_Warehouse_ID() <= 0) {
            throw new WrongValueException((Component)this.fWarehouse.getComponent(), Msg.translate((Properties)Env.getCtx(), (String)"FillMandatory"));
        }
        String docActionSelected = (String)this.docAction.getValue();
        if (docActionSelected == null || docActionSelected.isEmpty()) {
            throw new WrongValueException((Component)this.docAction.getComponent(), Msg.translate((Properties)Env.getCtx(), (String)"FillMandatory"));
        }
        this.form.saveSelection();
        ArrayList selection = this.getSelection();
        if (selection != null && selection.size() > 0 && this.isSelectionActive()) {
            this.form.generate();
        } else {
            this.form.dispose();
        }
    }

    @Override
    public void valueChange(ValueChangeEvent e) {
        if (log.isLoggable(Level.INFO)) {
            log.info(String.valueOf(e.getPropertyName()) + "=" + e.getNewValue());
        }
        if (e.getPropertyName().equals("M_Warehouse_ID")) {
            this.setM_Warehouse_ID(e.getNewValue());
        }
        if (e.getPropertyName().equals("C_BPartner_ID")) {
            this.m_C_BPartner_ID = e.getNewValue();
            this.fBPartner.setValue(this.m_C_BPartner_ID);
        }
        this.form.postQueryEvent();
    }

    public String generate() {
        KeyNamePair docTypeKNPair = this.cmbDocType.getSelectedItem().toKeyNamePair();
        String docActionSelected = (String)this.docAction.getValue();
        return this.generate(this.form.getStatusBar(), docTypeKNPair, docActionSelected);
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }
}

