/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.io.File;
import java.io.FileInputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.BusyDialog;
import org.adempiere.webui.apps.WProcessCtl;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.DesktopTabpanel;
import org.adempiere.webui.component.DocumentLink;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.StatusBarPanel;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.SimplePDFViewer;
import org.compiere.apps.form.GenForm;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MQuery;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoLog;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zhtml.Table;
import org.zkoss.zhtml.Td;
import org.zkoss.zhtml.Text;
import org.zkoss.zhtml.Tr;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Html;
import org.zkoss.zul.Label;
import org.zkoss.zul.LayoutRegion;
import org.zkoss.zul.North;
import org.zkoss.zul.South;

public class WGenForm
extends ADForm
implements EventListener<Event>,
WTableModelListener {
    private static final long serialVersionUID = 4240430312911412710L;
    private GenForm genForm;
    private static final CLogger log = CLogger.getCLogger(WGenForm.class);
    private Tabbox tabbedPane = new Tabbox();
    private Borderlayout selPanel = new Borderlayout();
    private Grid selNorthPanel = GridFactory.newGridLayout();
    private ConfirmPanel confirmPanelSel = new ConfirmPanel(true, true, false, false, false, false, false);
    private ConfirmPanel confirmPanelGen = new ConfirmPanel(false, false, false, false, false, false, false);
    private StatusBarPanel statusBar = new StatusBarPanel();
    private Borderlayout genPanel = new Borderlayout();
    private Html info = new Html();
    private WListbox miniTable = ListboxFactory.newDataTable();
    private BusyDialog progressWindow;
    private Div messageDiv;
    private Table logMessageTable;
    private int[] m_ids;

    public WGenForm(GenForm genForm) {
        if (log.isLoggable(Level.INFO)) {
            log.info("");
        }
        this.genForm = genForm;
    }

    @Override
    protected void initForm() {
        try {
            this.zkInit();
            this.dynInit();
            Borderlayout contentPane = new Borderlayout();
            this.appendChild((Component)contentPane);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)contentPane, "100%");
            ZKUpdateUtil.setHeight((HtmlBasedComponent)contentPane, "100%");
            Center center = new Center();
            center.setBorder("none");
            contentPane.appendChild((Component)center);
            center.appendChild((Component)this.tabbedPane);
            ZKUpdateUtil.setVflex((HtmlBasedComponent)this.tabbedPane, "1");
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.tabbedPane, "1");
            South south = new South();
            south.setBorder("none");
            contentPane.appendChild((Component)south);
            south.appendChild((Component)this.statusBar);
            LayoutUtils.addSclass("status-border", (HtmlBasedComponent)this.statusBar);
            ZKUpdateUtil.setVflex((HtmlBasedComponent)south, "min");
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "init", (Throwable)ex);
        }
    }

    void zkInit() throws Exception {
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.selPanel, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.selPanel, "100%");
        this.selPanel.setStyle("border: none; position: relative");
        DesktopTabpanel tabpanel = new DesktopTabpanel();
        tabpanel.appendChild((Component)this.selPanel);
        Tabpanels tabPanels = new Tabpanels();
        tabPanels.appendChild((Component)tabpanel);
        this.tabbedPane.appendChild((Component)tabPanels);
        Tabs tabs = new Tabs();
        this.tabbedPane.appendChild((Component)tabs);
        Tab tab = new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        tabs.appendChild((Component)tab);
        North north = new North();
        this.selPanel.appendChild((Component)north);
        north.appendChild((Component)this.selNorthPanel);
        north.setCollapsible(true);
        north.setSplittable(true);
        LayoutUtils.addSlideSclass((LayoutRegion)north);
        South south = new South();
        this.selPanel.appendChild((Component)south);
        south.appendChild((Component)this.confirmPanelSel);
        Center center = new Center();
        this.selPanel.appendChild((Component)center);
        center.appendChild((Component)this.miniTable);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.miniTable, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.miniTable, "1");
        this.confirmPanelSel.addActionListener(this);
        tabpanel = new DesktopTabpanel();
        tabPanels.appendChild((Component)tabpanel);
        tabpanel.appendChild((Component)this.genPanel);
        tab = new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"Generate"));
        tabs.appendChild((Component)tab);
        tab.setDisabled(true);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.genPanel, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.genPanel, "100%");
        this.genPanel.setStyle("border: none; position: relative");
        center = new Center();
        this.genPanel.appendChild((Component)center);
        this.messageDiv = new Div();
        this.messageDiv.appendChild((Component)this.info);
        center.appendChild((Component)this.messageDiv);
        south = new South();
        this.genPanel.appendChild((Component)south);
        south.appendChild((Component)this.confirmPanelGen);
        this.confirmPanelGen.addActionListener(this);
    }

    public void dynInit() {
        this.genForm.configureMiniTable((IMiniTable)this.miniTable);
        this.miniTable.getModel().addTableModelListener(this);
        this.statusBar.setStatusDB(" ");
        this.tabbedPane.addEventListener("onSelect", this);
        Button button = this.confirmPanelSel.getButton("Ok");
        button.setEnabled(false);
    }

    public void postQueryEvent() {
        Clients.showBusy((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing"));
        Events.echoEvent((String)"onExecuteQuery", (Component)this, null);
    }

    public void onExecuteQuery() {
        try {
            this.genForm.executeQuery();
        }
        finally {
            Clients.clearBusy();
        }
    }

    @Override
    public void onEvent(Event e) throws Exception {
        if (log.isLoggable(Level.INFO)) {
            log.info("Event Target Id=" + e.getTarget().getId());
        }
        if (e.getTarget().getId().equals("Cancel")) {
            this.dispose();
            return;
        }
        if (e.getTarget().getId().equals("Refresh")) {
            this.postQueryEvent();
        } else {
            if (e.getTarget() instanceof Tab) {
                int index = this.tabbedPane.getSelectedIndex();
                this.genForm.setSelectionActive(index == 0);
                if (index == 0) {
                    this.tabbedPane.getTabpanel(1).getLinkedTab().setDisabled(true);
                }
                if (index == 0 && this.miniTable.getSelectedCount() > 0) {
                    this.postQueryEvent();
                }
                return;
            }
            if (e.getTarget().getId().equals("Ok")) {
                this.genForm.validate();
            } else {
                super.onEvent(e);
            }
        }
    }

    @Override
    public void tableChanged(WTableModelEvent e) {
        int rowsSelected = 0;
        int rows = this.miniTable.getRowCount();
        int i = 0;
        while (i < rows) {
            IDColumn id = (IDColumn)this.miniTable.getValueAt(i, 0);
            if (id != null && id.isSelected()) {
                ++rowsSelected;
            }
            ++i;
        }
        this.statusBar.setStatusDB(" " + rowsSelected + " ");
        if (this.tabbedPane.getSelectedIndex() == 0) {
            Button button = this.confirmPanelSel.getButton("Ok");
            button.setEnabled(rowsSelected > 0);
        }
    }

    public void saveSelection() {
        this.genForm.saveSelection((IMiniTable)this.miniTable);
    }

    public void generate() {
        this.info.setContent(this.genForm.generate());
        this.lockUI();
        Clients.response((AuResponse)new AuEcho((Component)this, "runProcess", null));
    }

    public void runProcess() {
        WProcessCtl worker = new WProcessCtl(null, this.getWindowNo(), this.genForm.getProcessInfo(), this.genForm.getTrx());
        try {
            worker.run();
        }
        finally {
            this.unlockUI();
        }
    }

    private void generateComplete() {
        if (this.progressWindow != null) {
            this.progressWindow.dispose();
            this.progressWindow = null;
        }
        this.tabbedPane.getTabpanel(1).getLinkedTab().setDisabled(false);
        this.tabbedPane.setSelectedIndex(1);
        ProcessInfoUtil.setLogFromDB((ProcessInfo)this.genForm.getProcessInfo());
        StringBuilder iText = new StringBuilder();
        iText.append("<b>").append(this.genForm.getProcessInfo().getSummary()).append("</b><br>(").append(Msg.getMsg((Properties)Env.getCtx(), (String)this.genForm.getTitle())).append(")<br><br>");
        this.info.setContent(iText.toString());
        if (this.logMessageTable != null) {
            this.messageDiv.removeChild((Component)this.logMessageTable);
        }
        this.appendRecordLogInfo(this.genForm.getProcessInfo().getLogs());
        int[] ids = this.genForm.getProcessInfo().getIDs();
        if (ids == null || ids.length == 0) {
            return;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("PrintItems=" + ids.length);
        }
        this.m_ids = ids;
        if (!this.genForm.getProcessInfo().isError()) {
            Clients.response((AuResponse)new AuEcho((Component)this, "onAfterProcess", null));
        }
    }

    public void onAfterProcess() {
        Dialog.ask(this.getWindowNo(), this.genForm.getAskPrintMsg(), new Callback<Boolean>(){

            public void onCallback(Boolean result) {
                if (result.booleanValue()) {
                    Clients.showBusy((String)"Processing...");
                    Clients.response((AuResponse)new AuEcho((Component)WGenForm.this, "onPrint", null));
                }
            }
        });
    }

    public void onPrint() {
        ArrayList<File> pdfList = new ArrayList<File>();
        int i = 0;
        while (i < this.m_ids.length) {
            int RecordID = this.m_ids[i];
            ReportEngine re = null;
            if (this.genForm.getPrintFormat() != null) {
                MPrintFormat format = this.genForm.getPrintFormat();
                MTable table2 = MTable.get((Properties)Env.getCtx(), (int)format.getAD_Table_ID());
                MQuery query = new MQuery(table2.getTableName());
                query.addRestriction(String.valueOf(table2.getTableName()) + "_ID", "=", RecordID);
                PrintInfo info = new PrintInfo(table2.getTableName(), table2.get_Table_ID(), RecordID);
                re = new ReportEngine(Env.getCtx(), format, query, info, null, this.m_WindowNo);
            } else {
                re = ReportEngine.get((Properties)Env.getCtx(), (int)this.genForm.getReportEngineType(), (int)RecordID, (int)this.m_WindowNo);
            }
            pdfList.add(re.getPDF());
            ++i;
        }
        if (pdfList.size() > 1) {
            try {
                File outFile = File.createTempFile(this.genForm.getClass().getName(), ".pdf");
                AEnv.mergePdf(pdfList, outFile);
                Clients.clearBusy();
                SimplePDFViewer win = new SimplePDFViewer(this.getFormName(), new FileInputStream(outFile));
                SessionManager.getAppDesktop().showWindow(win, "center");
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            }
        } else if (pdfList.size() > 0) {
            Clients.clearBusy();
            try {
                SimplePDFViewer win = new SimplePDFViewer(this.getFormName(), new FileInputStream((File)pdfList.get(0)));
                SessionManager.getAppDesktop().showWindow(win, "center");
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void lockUI() {
        this.progressWindow = new BusyDialog();
        this.progressWindow.setPage(this.getPage());
        this.progressWindow.doHighlighted();
    }

    public void unlockUI() {
        this.generateComplete();
    }

    @Override
    public void dispose() {
        SessionManager.getAppDesktop().closeActiveWindow();
    }

    public Grid getParameterPanel() {
        return this.selNorthPanel;
    }

    public WListbox getMiniTable() {
        return this.miniTable;
    }

    public StatusBarPanel getStatusBar() {
        return this.statusBar;
    }

    private void appendRecordLogInfo(ProcessInfoLog[] m_logs) {
        if (m_logs == null) {
            return;
        }
        SimpleDateFormat dateFormat = DisplayType.getDateFormat((int)15);
        this.logMessageTable = new Table();
        this.logMessageTable.setId("logrecords");
        this.logMessageTable.setDynamicProperty("border", (Object)"1");
        this.logMessageTable.setDynamicProperty("cellpadding", (Object)"0");
        this.logMessageTable.setDynamicProperty("cellspacing", (Object)"0");
        this.logMessageTable.setDynamicProperty("width", (Object)"100%");
        boolean datePresents = false;
        boolean numberPresents = false;
        boolean msgPresents = false;
        ProcessInfoLog[] processInfoLogArray = m_logs;
        int n = m_logs.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoLog log = processInfoLogArray[n2];
            if (log.getP_Date() != null) {
                datePresents = true;
            }
            if (log.getP_Number() != null) {
                numberPresents = true;
            }
            if (log.getP_Msg() != null) {
                msgPresents = true;
            }
            ++n2;
        }
        int i = 0;
        while (i < m_logs.length) {
            Td td;
            Tr tr = new Tr();
            this.logMessageTable.appendChild((Component)tr);
            ProcessInfoLog log = m_logs[i];
            if (datePresents) {
                td = new Td();
                if (log.getP_Date() != null) {
                    Label label = new Label(dateFormat.format(log.getP_Date()));
                    td.appendChild((Component)label);
                }
                tr.appendChild((Component)td);
            }
            if (numberPresents) {
                td = new Td();
                if (log.getP_Number() != null) {
                    Label labelPno = new Label("" + log.getP_Number());
                    td.appendChild((Component)labelPno);
                }
                tr.appendChild((Component)td);
            }
            if (msgPresents && !this.genForm.getProcessInfo().isError()) {
                td = new Td();
                if (log.getP_Msg() != null) {
                    if (log.getAD_Table_ID() > 0 && log.getRecord_ID() > 0) {
                        DocumentLink recordLink = new DocumentLink(log.getP_Msg(), log.getAD_Table_ID(), log.getRecord_ID());
                        td.appendChild((Component)recordLink);
                    } else {
                        Text t = new Text();
                        t.setEncode(false);
                        t.setValue(log.getP_Msg());
                        td.appendChild((Component)t);
                    }
                }
                tr.appendChild((Component)td);
            }
            ++i;
        }
        this.messageDiv.appendChild((Component)this.logMessageTable);
    }
}

