/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.AdempiereWebUI;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ReaderInputStream;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.impexp.ImpFormat;
import org.compiere.impexp.ImpFormatRow;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.util.media.Media;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.UploadEvent;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;
import org.zkoss.zul.Vbox;

@Form(name="org.compiere.apps.form.VFileImport")
public class WFileImport
extends ADForm
implements EventListener<Event> {
    private static final long serialVersionUID = -7462842139127270429L;
    private static final int MAX_LOADED_LINES = 100;
    private static final int MAX_SHOWN_LINES = 10;
    private static final CLogger log = CLogger.getCLogger(WFileImport.class);
    private int m_record = -1;
    private ArrayList<String> m_data = new ArrayList();
    private static final String s_none = "----";
    private ImpFormat m_format;
    private Button bFile = new Button();
    private Listbox fCharset = new Listbox();
    private Label info = new Label();
    private Label labelFormat = new Label();
    private Listbox pickFormat = new Listbox();
    private Button bPrevious = new Button();
    private Label record = new Label();
    private Button bNext = new Button();
    private Textbox rawData = new Textbox();
    private InputStream m_file_istream;
    private Textbox[] m_fields;
    private Label[] m_labels;
    private Div previewPanel = new Div();
    private Vbox northPanel = new Vbox();
    private Div centerPanel = new Div();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);

    @Override
    protected void initForm() {
        if (log.isLoggable(Level.INFO)) {
            log.info("");
        }
        try {
            this.zkInit();
            this.dynInit();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "100%");
            this.setClosable(true);
            this.setTitle("Import File Loader");
            this.setBorder("normal");
            Borderlayout layout = new Borderlayout();
            ZKUpdateUtil.setHeight((HtmlBasedComponent)layout, "100%");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)layout, "100%");
            this.appendChild((Component)layout);
            North north = new North();
            layout.appendChild((Component)north);
            north.appendChild((Component)this.northPanel);
            Center center = new Center();
            layout.appendChild((Component)center);
            center.appendChild((Component)this.centerPanel);
            ZKUpdateUtil.setVflex((HtmlBasedComponent)this.centerPanel, "1");
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.centerPanel, "1");
            South south = new South();
            layout.appendChild((Component)south);
            south.appendChild((Component)this.confirmPanel);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "init", (Throwable)e);
        }
    }

    private void zkInit() throws Exception {
        Charset[] charsets = Ini.getAvailableCharsets();
        int i = 0;
        while (i < charsets.length) {
            this.fCharset.appendItem(charsets[i].displayName(), charsets[i]);
            ++i;
        }
        this.bFile.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImportFile"));
        this.bFile.setSclass("txt-btn");
        this.bFile.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImportFileInfo"));
        this.bFile.setUpload(AdempiereWebUI.getUploadSetting());
        this.bFile.addEventListener("onUpload", this);
        this.fCharset.setMold("select");
        this.fCharset.setRows(0);
        this.fCharset.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Charset", (boolean)false));
        this.info.setValue("   ");
        this.labelFormat.setValue(Msg.translate((Properties)Env.getCtx(), (String)"AD_ImpFormat_ID"));
        this.pickFormat.setMold("select");
        this.pickFormat.setRows(0);
        this.bNext.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Next"));
        this.bNext.setLabel(">");
        this.bNext.addEventListener("onClick", this);
        this.record.setValue("------");
        this.bPrevious.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"Previous"));
        this.bPrevious.setLabel("<");
        this.bPrevious.addEventListener("onClick", this);
        Hbox hbox = new Hbox();
        hbox.setAlign("center");
        hbox.appendChild((Component)this.bFile);
        hbox.appendChild((Component)this.fCharset);
        hbox.appendChild((Component)this.info);
        hbox.appendChild((Component)this.labelFormat);
        hbox.appendChild((Component)this.pickFormat);
        hbox.appendChild((Component)this.bPrevious);
        hbox.appendChild((Component)this.record);
        hbox.appendChild((Component)this.bNext);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.rawData, "1");
        this.rawData.setRows(10);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.northPanel, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.northPanel, "0");
        this.northPanel.appendChild((Component)hbox);
        this.northPanel.appendChild((Component)this.rawData);
        this.northPanel.appendChild((Component)new Separator());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.previewPanel, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.previewPanel, "1");
        this.previewPanel.setStyle("overflow: auto");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.centerPanel, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.centerPanel, "1");
        this.centerPanel.appendChild((Component)this.previewPanel);
        this.confirmPanel.addActionListener("onClick", this);
    }

    private void dynInit() {
        block8: {
            this.pickFormat.appendItem(s_none, s_none);
            String sql = MRole.getDefault().addAccessSQL("SELECT Name, AD_Impformat_ID FROM AD_ImpFormat WHERE IsActive='Y' ORDER BY Name", "AD_ImpFormat", true, false);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.pickFormat.appendItem(rs.getString(1), rs.getInt(2));
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        this.pickFormat.setSelectedIndex(0);
        this.pickFormat.addEventListener("onSelect", this);
        Charset charset = Ini.getCharset();
        int i = 0;
        while (i < this.fCharset.getItemCount()) {
            ListItem listitem = this.fCharset.getItemAtIndex(i);
            Charset compare = (Charset)listitem.getValue();
            if (charset == compare) {
                this.fCharset.setSelectedIndex(i);
                Executions.getCurrent().getDesktop().getWebApp().getConfiguration().setUploadCharset(compare.name());
                break;
            }
            ++i;
        }
        this.fCharset.addEventListener("onSelect", this);
        this.confirmPanel.setEnabled("Ok", false);
    }

    @Override
    public void onEvent(Event e) throws Exception {
        if (e instanceof UploadEvent) {
            UploadEvent ue = (UploadEvent)e;
            this.processUploadMedia(ue.getMedia());
            this.invalidate();
        } else if (e.getTarget() == this.fCharset) {
            if (this.m_file_istream != null) {
                this.m_file_istream.close();
                this.m_file_istream = null;
            }
            this.clearAll();
            ListItem listitem = this.fCharset.getSelectedItem();
            if (listitem == null) {
                return;
            }
            Charset charset = (Charset)listitem.getValue();
            Executions.getCurrent().getDesktop().getWebApp().getConfiguration().setUploadCharset(charset.name());
            this.bFile.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImportFile"));
        } else if (e.getTarget() == this.pickFormat) {
            this.cmd_loadFormat();
            this.invalidate();
        } else if (e.getTarget() == this.bNext) {
            this.cmd_applyFormat(true);
        } else if (e.getTarget() == this.bPrevious) {
            this.cmd_applyFormat(false);
        } else if (e.getTarget() == this.confirmPanel.getButton("Ok")) {
            this.confirmPanel.setEnabled("Ok", false);
            this.cmd_process();
        } else {
            if (e.getTarget() == this.confirmPanel.getButton("Cancel")) {
                SessionManager.getAppDesktop().closeActiveWindow();
                return;
            }
            super.onEvent(e);
        }
        if (this.m_data != null && this.m_data.size() > 0 && this.m_format != null && this.m_format.getRowCount() > 0) {
            this.confirmPanel.getButton("Ok").setEnabled(true);
        } else {
            this.confirmPanel.getButton("Ok").setEnabled(false);
        }
    }

    private void clearAll() {
        this.m_record = -1;
        this.record.setValue("------");
        this.info.setValue("   ");
        this.rawData.setText(null);
        this.m_data.clear();
        if (this.m_fields != null) {
            Textbox[] textboxArray = this.m_fields;
            int n = this.m_fields.length;
            int n2 = 0;
            while (n2 < n) {
                Textbox field = textboxArray[n2];
                field.setText(null);
                ++n2;
            }
        }
    }

    private void processUploadMedia(Media media) {
        if (media == null) {
            return;
        }
        if (media.isBinary()) {
            this.m_file_istream = media.getStreamData();
        } else {
            ListItem listitem = this.fCharset.getSelectedItem();
            if (listitem == null) {
                this.m_file_istream = new ReaderInputStream(media.getReaderData());
            } else {
                Charset charset = (Charset)listitem.getValue();
                this.m_file_istream = new ReaderInputStream(media.getReaderData(), charset.name());
            }
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(media.getName());
        }
        this.bFile.setLabel(media.getName());
        this.cmd_reloadFile();
    }

    private void cmd_reloadFile() {
        if (this.m_file_istream == null) {
            return;
        }
        this.m_data.clear();
        this.rawData.setText("");
        try {
            ListItem listitem = this.fCharset.getSelectedItem();
            Charset charset = null;
            if (listitem == null) {
                return;
            }
            charset = (Charset)listitem.getValue();
            BufferedReader in = new BufferedReader(new InputStreamReader(this.m_file_istream, charset), 10240);
            String s = null;
            StringBuilder concat = new StringBuilder();
            while ((s = in.readLine()) != null) {
                this.m_data.add(s);
                concat.append(s);
                concat.append("\n");
                if (this.m_data.size() >= 100) continue;
                this.rawData.setValue(concat.toString());
            }
            in.close();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
            this.bFile.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"FileImportFile"));
        }
        int index = 1;
        if (this.m_data.size() == 1) {
            index = 0;
        }
        int length = 0;
        if (this.m_data.size() > 0) {
            length = this.m_data.get(index).toString().length();
        }
        StringBuilder msginfo = new StringBuilder(Msg.getMsg((Properties)Env.getCtx(), (String)"Records")).append("=").append(this.m_data.size()).append(", ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"Length")).append("=").append(length).append("   ");
        this.info.setValue(msginfo.toString());
        StringBuilder msglog = new StringBuilder("Records=").append(this.m_data.size()).append(", Length=").append(length);
        if (log.isLoggable(Level.CONFIG)) {
            log.config(msglog.toString());
        }
    }

    private void cmd_loadFormat() {
        this.previewPanel.getChildren().clear();
        ListItem listitem = this.pickFormat.getSelectedItem();
        String formatName = listitem.getLabel();
        if (formatName.equals(s_none)) {
            this.confirmPanel.getButton("Ok").setEnabled(false);
            this.m_format = null;
            return;
        }
        int formatId = (Integer)listitem.getValue();
        this.m_format = ImpFormat.load((int)formatId);
        if (this.m_format == null) {
            Dialog.error(this.m_WindowNo, formatName);
            return;
        }
        int size = this.m_format.getRowCount();
        this.m_labels = new Label[size];
        this.m_fields = new Textbox[size];
        int i = 0;
        while (i < size) {
            ImpFormatRow row = this.m_format.getRow(i);
            this.m_labels[i] = new Label(row.getName());
            Hbox hbox = new Hbox();
            hbox.setAlign("center");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)hbox, "100%");
            hbox.setStyle("padding-bottom: 3px");
            Cell cell = new Cell();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)cell, "30%");
            cell.appendChild(this.m_labels[i].rightAlign());
            hbox.appendChild((Component)cell);
            cell = new Cell();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)cell, "70%");
            int length = row.getEndNo() - row.getStartNo();
            if (length <= 5) {
                length = 5;
            } else if (length > 20) {
                length = 20;
            }
            this.m_fields[i] = new Textbox();
            this.m_fields[i].setStyle("margin-left: 2px");
            ZKUpdateUtil.setWidth((HtmlBasedComponent)this.m_fields[i], "300px");
            cell.appendChild((Component)this.m_fields[i]);
            hbox.appendChild((Component)cell);
            this.previewPanel.appendChild((Component)hbox);
            ++i;
        }
        this.m_record = -1;
        this.record.setValue("------");
        this.previewPanel.invalidate();
    }

    private void cmd_applyFormat(boolean next) {
        if (this.m_format == null || this.m_data.size() == 0) {
            return;
        }
        this.m_record = next ? ++this.m_record : --this.m_record;
        if (this.m_record < 0) {
            this.m_record = 0;
        } else if (this.m_record >= this.m_data.size()) {
            this.m_record = this.m_data.size() - 1;
        }
        this.record.setValue(" " + String.valueOf(this.m_record + 1) + " ");
        String[] lInfo = this.m_format.parseLine(this.m_data.get(this.m_record).toString(), false, true, false);
        int size = this.m_format.getRowCount();
        if (lInfo.length != size) {
            log.log(Level.SEVERE, "FormatElements=" + size + " != Fields=" + lInfo.length);
        }
        int i = 0;
        while (i < size) {
            this.m_fields[i].setText(lInfo[i]);
            ++i;
        }
    }

    private void cmd_process() {
        if (this.m_format == null) {
            Dialog.error(this.m_WindowNo, "FileImportNoFormat");
            return;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config(this.m_format.getName());
        }
        int row = 0;
        int imported = 0;
        row = 0;
        while (row < this.m_data.size()) {
            if (this.m_format.updateDB(Env.getCtx(), this.m_data.get(row).toString(), null)) {
                ++imported;
            }
            ++row;
        }
        Dialog.info(this.m_WindowNo, "FileImportR/I", String.valueOf(row) + " / " + imported + "#");
        SessionManager.getAppDesktop().closeActiveWindow();
    }
}

