/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.ToolBarButton;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.apps.form.FactReconcile;
import org.compiere.model.Lookup;
import org.compiere.model.MClient;
import org.compiere.model.MColumn;
import org.compiere.model.MFactAcct;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.LayoutRegion;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.North;
import org.zkoss.zul.South;

@Form(name="org.compiere.apps.form.VFactReconcile")
public class WFactReconcile
extends FactReconcile
implements IFormController,
EventListener<Event>,
WTableModelListener,
ValueChangeListener {
    private CustomForm form = new CustomForm();
    private DecimalFormat m_format = DisplayType.getNumberFormat((int)12);
    private static final CLogger log = CLogger.getCLogger(WFactReconcile.class);
    private Borderlayout mainLayout = new Borderlayout();
    private Panel parameterPanel = new Panel();
    private Grid parameterLayout = GridFactory.newGridLayout();
    private Label labelAcctSchema = new Label();
    private WTableDirEditor fieldAcctSchema = null;
    private Label labelOrg = new Label();
    private WTableDirEditor fieldOrg = null;
    private Label labelReconciled = new Label();
    private Checkbox isReconciled = new Checkbox();
    private Label labelAccount = new Label();
    private WTableDirEditor fieldAccount = null;
    private Label labelBPartner = new Label();
    private WSearchEditor fieldBPartner = null;
    private Label labelDateAcct = new Label();
    private WDateEditor fieldDateAcct = new WDateEditor();
    private Label labelDateAcct2 = new Label();
    private WDateEditor fieldDateAcct2 = new WDateEditor();
    private Label labelProduct = new Label();
    private WSearchEditor fieldProduct = null;
    private Label dataStatus = new Label();
    private WListbox miniTable = ListboxFactory.newDataTable();
    private Panel commandPanel = new Panel();
    private Grid commandLayout = GridFactory.newGridLayout();
    protected ConfirmPanel cp = new ConfirmPanel();
    private Button bCancel = this.cp.createButton("Cancel");
    private Button bGenerate = this.cp.createButton("Process");
    private Button bReset = this.cp.createButton("Reset");
    private Button bZoom = this.cp.createButton("Zoom");
    private Button bZoomDoc = this.cp.createButton("Zoom");
    private Button bRefresh = this.cp.createButton("Refresh");
    private Label differenceLabel = new Label();
    private Textbox differenceField = new Textbox();
    private ToolBarButton bSelect = new ToolBarButton("SelectAll");
    private boolean checkAllSelected = true;
    private boolean loading = false;

    public WFactReconcile() {
        Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"IsSOTrx", (String)"Y");
        try {
            this.dynInit();
            this.zkInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getMessage(), (Throwable)e);
        }
    }

    private void zkInit() throws Exception {
        this.form.appendChild((Component)this.mainLayout);
        this.parameterPanel.appendChild((Component)this.parameterLayout);
        this.bRefresh.addActionListener(this);
        this.bReset.addActionListener(this);
        this.bZoom.addActionListener(this);
        this.bZoomDoc.addActionListener(this);
        this.bGenerate.setEnabled(false);
        this.bReset.setEnabled(false);
        this.bGenerate.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Process"));
        this.bReset.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Reset"));
        this.bZoom.setLabel(Msg.translate((Properties)Env.getCtx(), (String)"Fact_Acct_ID"));
        this.bZoomDoc.setId(String.valueOf(this.bZoomDoc.getId()) + "Doc");
        this.bZoomDoc.setLabel(Msg.translate((Properties)Env.getCtx(), (String)"ZoomDocument"));
        this.bSelect.setMode("toggle");
        if (ThemeManager.isUseFontIconForImage()) {
            this.bSelect.setIconSclass("z-icon-SelectAll");
        } else {
            this.bSelect.setImage(ThemeManager.getThemeResource("images/SelectAll24.png"));
        }
        this.bSelect.setTooltiptext(Msg.getCleanMsg((Properties)Env.getCtx(), (String)"SelectAll"));
        this.bSelect.addEventListener("onClick", this);
        this.labelAcctSchema.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_AcctSchema_ID"));
        this.labelAccount.setText(Msg.translate((Properties)Env.getCtx(), (String)"Account_ID"));
        this.labelBPartner.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        this.labelDateAcct.setText(Msg.translate((Properties)Env.getCtx(), (String)"DateAcct"));
        this.labelDateAcct2.setText("-");
        this.labelProduct.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
        this.labelOrg.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        this.labelReconciled.setText(" ");
        this.isReconciled.setText(Msg.translate((Properties)Env.getCtx(), (String)"IsReconciled"));
        this.dataStatus.setText(" ");
        this.differenceLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Difference"));
        this.differenceField.setText("0");
        this.bGenerate.addActionListener(this);
        this.bCancel.addActionListener(this);
        North north = new North();
        north.setStyle("border: none;");
        if (ClientInfo.isMobile()) {
            north.setStyle("max-height: 60%;");
        }
        this.mainLayout.appendChild((Component)north);
        north.appendChild((Component)this.parameterPanel);
        north.setCollapsible(true);
        north.setSplittable(true);
        north.setAutoscroll(true);
        LayoutUtils.addSlideSclass((LayoutRegion)north);
        Rows rows = null;
        Row row = null;
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.parameterLayout, "90%");
        rows = this.parameterLayout.newRows();
        row = rows.newRow();
        row.appendCellChild(this.labelAcctSchema.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldAcctSchema.getComponent(), "true");
        row.appendCellChild((Component)this.fieldAcctSchema.getComponent(), 2);
        row.appendCellChild(this.labelOrg.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldOrg.getComponent(), "true");
        row.appendCellChild((Component)this.fieldOrg.getComponent(), 2);
        row = rows.newRow();
        row.appendCellChild(this.labelAccount.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldAccount.getComponent(), "true");
        row.appendCellChild((Component)this.fieldAccount.getComponent(), 2);
        row.appendCellChild((Component)this.labelReconciled);
        row.appendCellChild((Component)this.isReconciled, 2);
        row = rows.newRow();
        row.appendCellChild(this.labelBPartner.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldBPartner.getComponent(), "true");
        row.appendCellChild((Component)this.fieldBPartner.getComponent(), 2);
        row.appendCellChild(this.labelProduct.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldProduct.getComponent(), "true");
        row.appendCellChild((Component)this.fieldProduct.getComponent(), 2);
        row = rows.newRow();
        row.appendCellChild(this.labelDateAcct.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldDateAcct.getComponent(), "true");
        row.appendCellChild((Component)this.fieldDateAcct.getComponent(), 2);
        row.appendCellChild(this.labelDateAcct2.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.fieldDateAcct2.getComponent(), "true");
        row.appendCellChild((Component)this.fieldDateAcct2.getComponent(), 2);
        row = rows.newRow();
        row.appendChild((Component)this.bRefresh);
        if (ClientInfo.maxWidth(499)) {
            LayoutUtils.compactTo(this.parameterLayout, 3);
            LayoutUtils.addSclass("btn-small small-img-btn", (HtmlBasedComponent)this.bRefresh);
        }
        Center center = new Center();
        this.mainLayout.appendChild((Component)center);
        center.appendChild((Component)this.miniTable);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.miniTable, "100%");
        center.setStyle("border: none");
        South south = new South();
        south.setStyle("border: none");
        this.mainLayout.appendChild((Component)south);
        south.appendChild((Component)this.commandPanel);
        this.commandPanel.appendChild((Component)this.commandLayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.commandLayout, "100%");
        rows = this.commandLayout.newRows();
        row = rows.newRow();
        row.appendCellChild((Component)this.bSelect, 1);
        row.appendCellChild((Component)this.bZoom, 1);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.bZoom, "true");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.bZoom, "100%");
        row.appendCellChild((Component)this.bZoomDoc, 1);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.bZoomDoc, "true");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.bZoomDoc, "100%");
        row.appendCellChild(this.differenceLabel.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.differenceLabel, "true");
        row.appendCellChild((Component)this.differenceField, 2);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.differenceField, "true");
        row.appendCellChild((Component)this.bGenerate, 1);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.bGenerate, "true");
        row.appendCellChild((Component)this.bReset, 1);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.bReset, "true");
        row.appendCellChild((Component)this.bCancel);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.bCancel, "true");
        if (ClientInfo.maxWidth(999)) {
            this.bZoom.setTooltiptext(this.bZoom.getLabel());
            this.bZoom.setLabel(null);
            this.bZoomDoc.setTooltiptext(this.bZoomDoc.getLabel());
            this.bZoomDoc.setLabel(null);
            this.bGenerate.setTooltiptext(this.bGenerate.getLabel());
            this.bGenerate.setLabel(null);
            this.bReset.setTooltiptext(this.bReset.getLabel());
            this.bReset.setLabel(null);
            if (ClientInfo.maxWidth(499)) {
                LayoutUtils.addSclass("btn-small small-img-btn", (HtmlBasedComponent)this.bZoom);
                LayoutUtils.addSclass("btn-small small-img-btn", (HtmlBasedComponent)this.bGenerate);
                LayoutUtils.addSclass("btn-small small-img-btn", (HtmlBasedComponent)this.bReset);
                LayoutUtils.addSclass("btn-small small-img-btn", (HtmlBasedComponent)this.bCancel);
            }
        }
    }

    public void dynInit() throws Exception {
        super.dynInit();
        int AD_Column_ID = FactReconcile.col_C_AcctSchema_ID;
        MLookup lookupAS = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)AD_Column_ID, (int)19);
        this.fieldAcctSchema = new WTableDirEditor("C_AcctSchema_ID", true, false, true, (Lookup)lookupAS);
        this.fieldAcctSchema.setValue(MClient.get((Properties)Env.getCtx()).getAcctSchema().getC_AcctSchema_ID());
        this.fieldAcctSchema.addValueChangeListener(this);
        this.m_C_AcctSchema_ID = (Integer)this.fieldAcctSchema.getValue();
        Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"C_AcctSchema_ID", (int)this.m_C_AcctSchema_ID);
        AD_Column_ID = FactReconcile.col_AD_Org_ID;
        MLookup lookupOrg = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)AD_Column_ID, (int)19);
        this.fieldOrg = new WTableDirEditor("AD_Org_ID", true, false, true, (Lookup)lookupOrg);
        if (lookupOrg.containsKey((Object)0)) {
            this.fieldOrg.setValue(0);
        } else {
            this.fieldOrg.setValue(Env.getAD_Org_ID((Properties)Env.getCtx()));
        }
        AD_Column_ID = FactReconcile.col_C_BPartner_ID;
        MLookup lookupBP = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)AD_Column_ID, (int)30);
        this.fieldBPartner = new WSearchEditor("C_BPartner_ID", false, false, true, (Lookup)lookupBP);
        AD_Column_ID = FactReconcile.col_M_Product_ID;
        MLookup lookupProduct = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)AD_Column_ID, (int)30);
        this.fieldProduct = new WSearchEditor("M_Product_ID", false, false, true, (Lookup)lookupProduct);
        AD_Column_ID = MColumn.getColumn_ID((String)"C_ElementValue", (String)"C_ElementValue_ID");
        MLookup lookupAccount = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)AD_Column_ID, (int)19, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"C_ElementValue_ID", (int)0, (boolean)true, (String)" C_ElementValue.IsActive='Y' AND C_ElementValue.IsSummary='N' AND EXISTS (SELECT 1 FROM C_AcctSchema_Element ase WHERE ase.C_Element_ID=C_ElementValue.C_Element_ID AND ase.ElementType='AC' AND ase.C_AcctSchema_ID=@C_AcctSchema_ID@ AND ase.AD_Client_ID=@AD_Client_ID@) ");
        this.fieldAccount = new WTableDirEditor("C_ElementValue_ID", true, false, true, (Lookup)lookupAccount);
    }

    private void loadData() {
        if (this.fieldAccount.isNullOrEmpty()) {
            throw new WrongValueException((Component)this.fieldAccount.getComponent(), Msg.getMsg((Properties)Env.getCtx(), (String)"FillMandatory"));
        }
        this.m_C_AcctSchema_ID = this.fieldAcctSchema.getValue() != null ? (Integer)this.fieldAcctSchema.getValue() : 0;
        this.m_Account_ID = this.fieldAccount.getValue() != null ? (Integer)this.fieldAccount.getValue() : 0;
        this.m_AD_Org_ID = this.fieldOrg.getValue() != null ? (Integer)this.fieldOrg.getValue() : 0;
        this.m_isReconciled = this.isReconciled.isChecked();
        this.m_C_BPartner_ID = this.fieldBPartner.getValue() != null ? (Integer)this.fieldBPartner.getValue() : 0;
        this.m_M_Product_ID = (Integer)this.fieldProduct.getValue() != null ? (Integer)this.fieldProduct.getValue() : 0;
        this.m_DateAcct = this.fieldDateAcct.getValue() != null ? this.fieldDateAcct.getValue() : null;
        this.m_DateAcct2 = this.fieldDateAcct2.getValue() != null ? this.fieldDateAcct2.getValue() : null;
        Vector data = this.getData();
        Vector columnNames = this.getColumnNames();
        this.miniTable.getModel().removeTableModelListener(this);
        ListModelTable modelI = new ListModelTable(data);
        modelI.addTableModelListener(this);
        this.miniTable.setData(modelI, columnNames);
        this.setColumnClass(this.miniTable);
        this.miniTable.setColorColumn(this.amtColIndex);
    }

    private void calculateSelection() {
        this.calculateSelection(this.miniTable);
        StringBuilder info = new StringBuilder();
        info.append(this.m_noSelected).append(" ").append(Msg.getMsg((Properties)Env.getCtx(), (String)"Selected")).append(" / ").append(this.miniTable.getRowCount());
        this.differenceField.setText(this.m_format.format(this.m_selectedAmt));
        this.dataStatus.setText(info.toString());
        this.bGenerate.setEnabled(this.m_noSelected != 0 && Env.ZERO.compareTo(this.m_selectedAmt) == 0 && !this.isReconciled.isSelected());
        this.bReset.setEnabled(this.m_noSelected > 0 && this.isReconciled.isSelected());
    }

    @Override
    public void valueChange(ValueChangeEvent evt) {
        String name = evt.getPropertyName();
        Object value = evt.getNewValue();
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(name) + "=" + value);
        }
        if (value == null) {
            return;
        }
        if (name.equals("C_AcctSchema_ID")) {
            this.m_C_AcctSchema_ID = (Integer)value;
            Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"C_AcctSchema_ID", (int)this.m_C_AcctSchema_ID);
            Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"AD_Client_ID", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            this.fieldAccount.actionRefresh();
        }
    }

    @Override
    public void tableChanged(WTableModelEvent event) {
        if (!this.loading) {
            this.calculateSelection();
        }
        if (event.getModel() == this.miniTable.getModel()) {
            int row = event.getFirstRow();
            int col = event.getColumn();
            if (row < 0) {
                return;
            }
            if (this.checkAllSelected && col == this.selectedColIndex) {
                ListModelTable model = this.miniTable.getModel();
                boolean rowUnSelected = false;
                int i = 0;
                while (i < model.getRowCount()) {
                    if (!((Boolean)model.getValueAt(i, this.selectedColIndex)).booleanValue()) {
                        rowUnSelected = true;
                        break;
                    }
                    ++i;
                }
                this.bSelect.setPressed(!rowUnSelected);
            }
        }
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget().equals((Object)this.bGenerate)) {
            this.generateReconciliation();
        } else if (event.getTarget().equals((Object)this.bReset)) {
            this.resetReconciliation();
        } else if (event.getTarget().equals((Object)this.bZoom)) {
            this.zoom(270);
        } else if (event.getTarget().equals((Object)this.bZoomDoc)) {
            this.zoom(-1);
        } else if (event.getTarget().equals((Object)this.bCancel)) {
            SessionManager.getAppDesktop().closeActiveWindow();
        } else if (event.getTarget().equals((Object)this.bRefresh)) {
            this.loadData();
        } else if (event.getTarget().equals((Object)this.bSelect)) {
            this.onbSelect();
        }
    }

    private void generateReconciliation() {
        if (this.miniTable.getRowCount() == 0) {
            return;
        }
        this.calculateSelection();
        if (this.m_noSelected == 0) {
            return;
        }
        ArrayList generated = new ArrayList();
        this.generate(this.miniTable, generated);
        if (generated.size() > 0) {
            Collections.reverse(generated);
            Iterator iterator = generated.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                this.miniTable.getModel().remove(i);
            }
        }
        this.bSelect.setPressed(false);
    }

    protected void zoom(int tableID) {
        int selected = this.miniTable.getSelectedRow();
        if (selected == -1) {
            return;
        }
        KeyNamePair pp = (KeyNamePair)this.miniTable.getModel().getValueAt(selected, this.idColIndex);
        int factId = pp.getKey();
        if (tableID == 270) {
            AEnv.zoom(tableID, factId);
        } else {
            MFactAcct fa = new MFactAcct(Env.getCtx(), factId, null);
            AEnv.zoom(fa.getAD_Table_ID(), fa.getRecord_ID());
        }
    }

    private void resetReconciliation() {
        if (this.miniTable.getRowCount() == 0) {
            return;
        }
        this.calculateSelection();
        if (this.m_noSelected == 0) {
            return;
        }
        ArrayList resets = new ArrayList();
        this.reset(this.miniTable, resets);
        if (resets.size() > 0) {
            Collections.reverse(resets);
            Iterator iterator = resets.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                this.miniTable.getModel().remove(i);
            }
        }
        this.bSelect.setPressed(false);
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }

    private void onbSelect() {
        ListModelTable model = this.miniTable.getModel();
        int rows = model.getSize();
        Boolean selectAll = this.bSelect.isPressed() ? Boolean.FALSE : Boolean.TRUE;
        this.bSelect.setPressed(!this.bSelect.isPressed());
        this.checkAllSelected = false;
        int i = 0;
        while (i < rows) {
            model.setValueAt(selectAll, i, this.selectedColIndex);
            ++i;
        }
        this.checkAllSelected = true;
        this.miniTable.setModel((ListModel<?>)model);
        this.calculateSelection();
    }
}

