/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.io.Serializable;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.WAppsAction;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.event.DialogEvents;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.panel.StatusBarPanel;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.apps.IStatusBar;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Callback;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.LayoutRegion;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.North;
import org.zkoss.zul.Separator;
import org.zkoss.zul.South;

public class WCreateFromWindow
extends Window
implements EventListener<Event>,
WTableModelListener,
DialogEvents {
    private static final long serialVersionUID = 6750121735083748182L;
    private CreateFrom createFrom;
    private int windowNo;
    private Panel parameterPanel = new Panel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private StatusBarPanel statusBar = new StatusBarPanel();
    private WListbox dataTable = ListboxFactory.newDataTable();
    private boolean isCancel;
    public static final String SELECT_DESELECT_ALL = "SelectAll";
    private boolean checkAllSelected = true;

    public WCreateFromWindow(CreateFrom createFrom, int windowNo) {
        this.createFrom = createFrom;
        this.windowNo = windowNo;
        try {
            this.zkInit();
            this.confirmPanel.addActionListener(this);
            this.statusBar.setStatusDB("");
            this.tableChanged(null);
            createFrom.setInitOK(true);
        }
        catch (Exception e) {
            createFrom.setInitOK(false);
        }
    }

    protected void zkInit() throws Exception {
        Borderlayout contentPane = new Borderlayout();
        this.appendChild((Component)contentPane);
        North north = new North();
        contentPane.appendChild((Component)north);
        north.appendChild((Component)this.parameterPanel);
        north.setAutoscroll(true);
        north.setSplittable(true);
        north.setCollapsible(true);
        LayoutUtils.addSlideSclass((LayoutRegion)north);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.parameterPanel, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.parameterPanel, "1");
        Center center = new Center();
        contentPane.appendChild((Component)center);
        center.appendChild((Component)this.dataTable);
        WAppsAction selectAllAction = new WAppsAction(SELECT_DESELECT_ALL, null, null);
        Button selectAllButton = selectAllAction.getButton();
        selectAllButton.setAttribute(SELECT_DESELECT_ALL, Boolean.FALSE);
        this.confirmPanel.addComponentsLeft(selectAllButton);
        South south = new South();
        contentPane.appendChild((Component)south);
        Panel southPanel = new Panel();
        south.appendChild((Component)southPanel);
        southPanel.appendChild((Component)new Separator());
        southPanel.appendChild((Component)this.confirmPanel);
        southPanel.appendChild((Component)new Separator());
        southPanel.appendChild((Component)this.statusBar);
        if (!ThemeManager.isUseCSSForWindowSize()) {
            ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)this, 750);
            ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this, 550);
        } else {
            this.addCallback("afterPageAttached", (Callback & Serializable)t -> {
                ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this);
                ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this);
            });
        }
        this.setSclass("create-from-window");
        this.setSizable(true);
        this.setBorder("normal");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)contentPane, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)contentPane, "100%");
    }

    public void onEvent(Event e) throws Exception {
        if (e.getTarget().getId().equals("Ok")) {
            this.isCancel = false;
            try {
                Trx.run((TrxRunnable)new TrxRunnable(){

                    public void run(String trxName) {
                        WCreateFromWindow.this.save(trxName);
                    }
                });
                this.dispose();
            }
            catch (Exception ex) {
                Dialog.error(this.windowNo, "Error", ex.getLocalizedMessage());
            }
        } else if (e.getTarget().getId().equals("Cancel")) {
            this.isCancel = true;
            this.dispose();
        } else if (e.getTarget().getId().equals(SELECT_DESELECT_ALL)) {
            ListModelTable model = this.dataTable.getModel();
            int rows = model.getSize();
            Button selectAllBtn = this.confirmPanel.getButton(SELECT_DESELECT_ALL);
            Boolean selectAll = (Boolean)selectAllBtn.getAttribute(SELECT_DESELECT_ALL);
            if (selectAll == null) {
                selectAll = Boolean.FALSE;
            }
            selectAll = selectAll == false;
            selectAllBtn.setAttribute(SELECT_DESELECT_ALL, selectAll);
            this.checkAllSelected = false;
            int i = 0;
            while (i < rows) {
                model.setValueAt(selectAll, i, 0);
                ++i;
            }
            this.checkAllSelected = true;
            this.dataTable.setModel((ListModel<?>)model);
            this.info();
        }
    }

    @Override
    public void tableChanged(WTableModelEvent e) {
        int type = -1;
        if (e != null) {
            type = e.getType();
            if (type != 0) {
                return;
            }
            if (this.checkAllSelected && e.getColumn() == 0) {
                ListModelTable model = this.dataTable.getModel();
                boolean rowUnSelected = false;
                int i = 0;
                while (i < model.getRowCount()) {
                    if (!((Boolean)model.getValueAt(i, 0)).booleanValue()) {
                        rowUnSelected = true;
                        break;
                    }
                    ++i;
                }
                Button selectAllBtn = this.confirmPanel.getButton(SELECT_DESELECT_ALL);
                selectAllBtn.setAttribute(SELECT_DESELECT_ALL, !rowUnSelected);
            }
        }
        this.info();
    }

    public boolean save(String trxName) {
        ListModelTable model = this.dataTable.getModel();
        int rows = model.getSize();
        if (rows == 0) {
            return false;
        }
        return this.createFrom.save((IMiniTable)this.dataTable, trxName);
    }

    public void info() {
        ListModelTable model = this.dataTable.getModel();
        int rows = model.getRowCount();
        int count = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)model.getValueAt(i, 0)).booleanValue()) {
                ++count;
            }
            ++i;
        }
        this.setStatusLine(count, null);
        this.createFrom.info((IMiniTable)this.dataTable, (IStatusBar)this.statusBar);
    }

    public void setStatusLine(int selectedRowCount, String text) {
        StringBuilder sb = new StringBuilder(String.valueOf(selectedRowCount));
        if (text != null && text.trim().length() > 0) {
            sb.append(" - ").append(text);
        }
        this.statusBar.setStatusLine(sb.toString());
        this.confirmPanel.getOKButton().setEnabled(selectedRowCount > 0);
    }

    public StatusBarPanel getStatusBar() {
        return this.statusBar;
    }

    @Deprecated(forRemoval=true, since="11")
    public void setStatusBar(StatusBarPanel statusBar) {
        this.statusBar = statusBar;
    }

    public WListbox getWListbox() {
        return this.dataTable;
    }

    public Panel getParameterPanel() {
        return this.parameterPanel;
    }

    public ConfirmPanel getConfirmPanel() {
        return this.confirmPanel;
    }

    public boolean isCancel() {
        return this.isCancel;
    }
}

