/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.form.WCreateFromWindow;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.grid.CreateFrom;
import org.compiere.grid.CreateFromInvoice;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MDocType;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Space;

public class WCreateFromInvoiceUI
extends CreateFromInvoice
implements EventListener<Event>,
ValueChangeListener {
    private WCreateFromWindow window;
    private int p_WindowNo;
    private static final CLogger log = CLogger.getCLogger(WCreateFromInvoiceUI.class);
    protected Label bPartnerLabel = new Label();
    protected WEditor bPartnerField;
    protected Label orderLabel = new Label();
    protected Listbox orderField = ListboxFactory.newDropdownListbox();
    protected Label shipmentLabel = new Label();
    protected Listbox shipmentField = ListboxFactory.newDropdownListbox();
    protected Label rmaLabel = new Label();
    protected Listbox rmaField = ListboxFactory.newDropdownListbox();
    private Grid parameterStdLayout;
    private boolean isCreditMemo = false;
    private boolean m_actionActive = false;
    private int noOfParameterColumn;

    public WCreateFromInvoiceUI(GridTab tab) {
        super(tab);
        if (log.isLoggable(Level.INFO)) {
            log.info(this.getGridTab().toString());
        }
        this.window = new WCreateFromWindow((CreateFrom)this, this.getGridTab().getWindowNo());
        this.p_WindowNo = this.getGridTab().getWindowNo();
        try {
            if (!this.dynInit()) {
                return;
            }
            this.zkInit();
            this.setInitOK(true);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
            this.setInitOK(false);
        }
        AEnv.showWindow(this.window);
    }

    public boolean dynInit() throws Exception {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("");
        }
        super.dynInit();
        this.window.setTitle(this.getTitle());
        Integer docTypeId = (Integer)this.getGridTab().getValue("C_DocTypeTarget_ID");
        MDocType docType = MDocType.get((Properties)Env.getCtx(), (int)docTypeId);
        if (!"APC".equals(docType.getDocBaseType())) {
            this.rmaLabel.setVisible(false);
            this.rmaField.setVisible(false);
        }
        this.isCreditMemo = "APC".equals(docType.getDocBaseType()) || "ARC".equals(docType.getDocBaseType());
        this.initBPartner(true);
        this.bPartnerField.addValueChangeListener(this);
        return true;
    }

    protected void zkInit() throws Exception {
        this.bPartnerLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        this.orderLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"C_Order_ID", (boolean)this.isSOTrx));
        this.shipmentLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"M_InOut_ID", (boolean)this.isSOTrx));
        this.rmaLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"M_RMA_ID"));
        Panel parameterPanel = this.window.getParameterPanel();
        this.parameterStdLayout = GridFactory.newGridLayout();
        Panel parameterStdPanel = new Panel();
        parameterStdPanel.appendChild((Component)this.parameterStdLayout);
        this.setupColumns(this.parameterStdLayout);
        parameterPanel.appendChild((Component)parameterStdPanel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.parameterStdLayout, "min");
        Rows rows = this.parameterStdLayout.newRows();
        Row row = rows.newRow();
        row.appendChild(this.bPartnerLabel.rightAlign());
        if (this.bPartnerField != null) {
            row.appendChild(this.bPartnerField.getComponent());
        }
        row.appendChild(this.orderLabel.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.orderField, "1");
        row.appendChild((Component)this.orderField);
        row = rows.newRow();
        row.appendChild((Component)new Space());
        row.appendChild((Component)new Space());
        row.appendChild(this.shipmentLabel.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.shipmentField, "1");
        row.appendChild((Component)this.shipmentField);
        row = rows.newRow();
        row.appendChild((Component)new Space());
        row.appendChild((Component)new Space());
        row.appendChild(this.rmaLabel.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.rmaField, "1");
        row.appendChild((Component)this.rmaField);
        if (ClientInfo.isMobile()) {
            if (this.noOfParameterColumn == 2) {
                LayoutUtils.compactTo(this.parameterStdLayout, 2);
            }
            ClientInfo.onClientInfo((Component)this.window, this::onClientInfo);
        }
        this.hideEmptyRow(rows);
    }

    private void hideEmptyRow(org.zkoss.zul.Rows rows) {
        for (Component a : rows.getChildren()) {
            Row row = (Row)a;
            boolean visible = false;
            block1: for (Component b : row.getChildren()) {
                if (b instanceof Space || !b.isVisible()) continue;
                if (!b.getChildren().isEmpty()) {
                    for (Component c : b.getChildren()) {
                        if (!c.isVisible()) continue;
                        visible = true;
                        continue block1;
                    }
                    continue;
                }
                visible = true;
                break;
            }
            row.setVisible(visible);
        }
    }

    public void onEvent(Event e) throws Exception {
        if (this.m_actionActive) {
            return;
        }
        this.m_actionActive = true;
        if (e.getTarget().equals((Object)this.orderField)) {
            ListItem li = this.orderField.getSelectedItem();
            int C_Order_ID = 0;
            if (li != null && li.getValue() != null) {
                C_Order_ID = (Integer)li.getValue();
            }
            this.rmaField.setSelectedIndex(-1);
            this.shipmentField.setSelectedIndex(-1);
            this.loadOrder(C_Order_ID, true);
        } else if (e.getTarget().equals((Object)this.shipmentField)) {
            ListItem li = this.shipmentField.getSelectedItem();
            int M_InOut_ID = 0;
            if (li != null && li.getValue() != null) {
                M_InOut_ID = (Integer)li.getValue();
            }
            this.orderField.setSelectedIndex(-1);
            this.rmaField.setSelectedIndex(-1);
            this.loadShipment(M_InOut_ID);
        } else if (e.getTarget().equals((Object)this.rmaField)) {
            ListItem li = this.rmaField.getSelectedItem();
            int M_RMA_ID = 0;
            if (li != null && li.getValue() != null) {
                M_RMA_ID = (Integer)li.getValue();
            }
            this.orderField.setSelectedIndex(-1);
            this.shipmentField.setSelectedIndex(-1);
            this.loadRMA(M_RMA_ID);
        }
        this.m_actionActive = false;
    }

    @Override
    public void valueChange(ValueChangeEvent e) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(e.getPropertyName()) + "=" + e.getNewValue());
        }
        if (e.getPropertyName().equals("C_BPartner_ID")) {
            Integer newBpValue = (Integer)e.getNewValue();
            int C_BPartner_ID = newBpValue == null ? 0 : newBpValue;
            this.initBPOrderDetails(C_BPartner_ID, true);
        }
        this.window.tableChanged(null);
    }

    protected void initBPartner(boolean forInvoice) throws Exception {
        int AD_Column_ID = 3499;
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.bPartnerField = new WSearchEditor("C_BPartner_ID", true, false, true, (Lookup)lookup);
        int C_BPartner_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_BPartner_ID");
        this.bPartnerField.setValue(C_BPartner_ID);
        this.initBPOrderDetails(C_BPartner_ID, forInvoice);
    }

    protected void initBPOrderDetails(int C_BPartner_ID, boolean forInvoice) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("C_BPartner_ID=" + C_BPartner_ID);
        }
        KeyNamePair pp = new KeyNamePair(0, "");
        this.orderField.removeActionListener(this);
        this.orderField.removeAllItems();
        this.orderField.addItem(pp);
        ArrayList list = this.loadOrderData(C_BPartner_ID, forInvoice, false, this.isCreditMemo);
        for (KeyNamePair knp : list) {
            this.orderField.addItem(knp);
        }
        this.orderField.setSelectedIndex(0);
        this.orderField.addActionListener(this);
        this.initBPDetails(C_BPartner_ID);
    }

    private void initBPDetails(int C_BPartner_ID) {
        this.initBPShipmentDetails(C_BPartner_ID);
        this.initBPRMADetails(C_BPartner_ID);
    }

    private void initBPShipmentDetails(int C_BPartner_ID) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("C_BPartner_ID" + C_BPartner_ID);
        }
        this.shipmentField.removeActionListener(this);
        this.shipmentField.removeAllItems();
        KeyNamePair pp = new KeyNamePair(0, "");
        this.shipmentField.addItem(pp);
        ArrayList list = this.loadShipmentData(C_BPartner_ID);
        for (KeyNamePair knp : list) {
            this.shipmentField.addItem(knp);
        }
        this.shipmentField.setSelectedIndex(0);
        this.shipmentField.addActionListener(this);
    }

    private void initBPRMADetails(int C_BPartner_ID) {
        this.rmaField.removeActionListener(this);
        this.rmaField.removeAllItems();
        KeyNamePair pp = new KeyNamePair(0, "");
        this.rmaField.addItem(pp);
        ArrayList list = this.loadRMAData(C_BPartner_ID);
        for (KeyNamePair knp : list) {
            this.rmaField.addItem(knp);
        }
        this.rmaField.setSelectedIndex(0);
        this.rmaField.addActionListener(this);
    }

    protected void loadOrder(int C_Order_ID, boolean forInvoice) {
        this.loadTableOIS(this.getOrderData(C_Order_ID, forInvoice, this.isCreditMemo));
    }

    protected void loadRMA(int M_RMA_ID) {
        this.loadTableOIS(this.getRMAData(M_RMA_ID));
    }

    protected void loadShipment(int M_InOut_ID) {
        this.loadTableOIS(this.getShipmentData(M_InOut_ID));
    }

    protected void loadTableOIS(Vector<?> data) {
        this.window.getWListbox().clear();
        this.window.getWListbox().getModel().removeTableModelListener(this.window);
        ListModelTable model = new ListModelTable(data);
        model.addTableModelListener(this.window);
        this.window.getWListbox().setData(model, this.getOISColumnNames());
        this.configureMiniTable(this.window.getWListbox());
    }

    public void showWindow() {
        this.window.setVisible(true);
    }

    public void closeWindow() {
        this.window.dispose();
    }

    public Object getWindow() {
        return this.window;
    }

    protected void setupColumns(Grid parameterGrid) {
        this.noOfParameterColumn = ClientInfo.maxWidth(600) ? 2 : 4;
        Columns columns = new Columns();
        parameterGrid.appendChild((Component)columns);
        if (ClientInfo.maxWidth(600)) {
            Column column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "35%");
            columns.appendChild((Component)column);
            column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "65%");
            columns.appendChild((Component)column);
        } else {
            Column column = new Column();
            columns.appendChild((Component)column);
            column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "15%");
            columns.appendChild((Component)column);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "35%");
            column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "15%");
            columns.appendChild((Component)column);
            column = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "35%");
            columns.appendChild((Component)column);
        }
    }

    protected void onClientInfo() {
        if (ClientInfo.isMobile() && this.parameterStdLayout != null && this.parameterStdLayout.getRows() != null) {
            int cc;
            int nc = ClientInfo.maxWidth(600) ? 2 : 4;
            if (nc == (cc = this.noOfParameterColumn)) {
                return;
            }
            this.parameterStdLayout.getColumns().detach();
            this.setupColumns(this.parameterStdLayout);
            if (cc > nc) {
                LayoutUtils.compactTo(this.parameterStdLayout, nc);
            } else {
                LayoutUtils.expandTo(this.parameterStdLayout, nc, false);
            }
            this.hideEmptyRow(this.parameterStdLayout.getRows());
            ZKUpdateUtil.setCSSHeight((HtmlBasedComponent)this.window);
            ZKUpdateUtil.setCSSWidth((HtmlBasedComponent)this.window);
            this.window.invalidate();
        }
    }
}

