/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListItem;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Tab;
import org.adempiere.webui.component.Tabbox;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.component.Tabpanels;
import org.adempiere.webui.component.Tabs;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MProduct;
import org.compiere.model.MProductPrice;
import org.compiere.model.MRole;
import org.compiere.model.MStorageReservation;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Div;
import org.zkoss.zul.Vbox;

@Form(name="org.compiere.apps.form.VAttributeGrid")
public class WAttributeGrid
extends ADForm
implements EventListener<Event> {
    private static final long serialVersionUID = 687630618195901592L;
    private MAttribute[] m_attributes = null;
    private boolean m_setting = false;
    private static final CLogger log = CLogger.getCLogger(WAttributeGrid.class);
    private static String[] MODES = new String[]{Msg.getMsg((Properties)Env.getCtx(), (String)"ModeView")};
    private static final int MODE_VIEW = 0;
    private static final int MODE_PO = 0;
    private static final int MODE_PRICE = 0;
    private int m_M_PriceList_Version_ID = 0;
    private DecimalFormat m_price = DisplayType.getNumberFormat((int)37);
    private int m_M_Warehouse_ID = 0;
    private DecimalFormat m_qty = DisplayType.getNumberFormat((int)29);
    private Tabbox tabbox = new Tabbox();
    private Tabs tabs = new Tabs();
    private Tabpanels tabpanels = new Tabpanels();
    private Label attributeLabel1 = new Label(String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"M_Attribute_ID")) + " 1");
    private Listbox attributeCombo1 = null;
    private Label attributeLabel2 = new Label(String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"M_Attribute_ID")) + " 2");
    private Listbox attributeCombo2 = null;
    private Label labelPriceList = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"M_PriceList_ID"));
    private Listbox pickPriceList = new Listbox();
    private Label labelWarehouse = new Label(Msg.getElement((Properties)Env.getCtx(), (String)"M_Warehouse_ID"));
    private Listbox pickWarehouse = new Listbox();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private Grid gridView = new Grid();
    private Label modeLabel = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Mode"));
    private Listbox modeCombo = new Listbox();

    @Override
    protected void initForm() {
        this.m_attributes = MAttribute.getOfClient((Properties)Env.getCtx(), (boolean)true, (boolean)true);
        KeyNamePair[] vector = new KeyNamePair[this.m_attributes.length + 1];
        vector[0] = new KeyNamePair(0, "");
        int i = 0;
        while (i < this.m_attributes.length) {
            vector[i + 1] = this.m_attributes[i].getKeyNamePair();
            ++i;
        }
        this.attributeCombo1 = new Listbox(vector);
        this.attributeCombo1.setMold("select");
        this.attributeCombo1.setSelectedIndex(0);
        this.attributeCombo2 = new Listbox(vector);
        this.attributeCombo2.setMold("select");
        this.attributeCombo2.setSelectedIndex(0);
        this.pickPriceList.setMold("select");
        this.pickWarehouse.setMold("select");
        this.fillPicks();
        i = 0;
        while (i < MODES.length) {
            this.modeCombo.appendItem(MODES[i], MODES[i]);
            ++i;
        }
        this.modeCombo.setMold("select");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.tabbox, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.tabbox, "85%");
        this.tabbox.appendChild((Component)this.tabs);
        this.tabbox.appendChild((Component)this.tabpanels);
        this.tabbox.addEventListener("onSelect", this);
        Grid gridSelection = new Grid();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)gridSelection, "500px");
        gridSelection.setStyle("margin:0; padding:0;");
        gridSelection.makeNoStrip();
        gridSelection.setOddRowSclass("even");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.gridView, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.gridView, "100%");
        this.gridView.setSizedByContent(false);
        Rows rows = new Rows();
        gridSelection.appendChild((Component)rows);
        Row row = new Row();
        rows.appendChild((Component)row);
        Div div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.attributeLabel1);
        row.appendCellChild((Component)div, 1);
        row.appendCellChild((Component)this.attributeCombo1, 2);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.attributeCombo1, "100%");
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.attributeLabel2);
        row.appendCellChild((Component)div, 1);
        row.appendCellChild((Component)this.attributeCombo2, 2);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.attributeCombo2, "100%");
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.labelPriceList);
        row.appendCellChild((Component)div, 1);
        row.appendCellChild((Component)this.pickPriceList, 2);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.pickPriceList, "100%");
        row = new Row();
        rows.appendChild((Component)row);
        div = new Div();
        div.setStyle("text-align: right;");
        div.appendChild((Component)this.labelWarehouse);
        row.appendCellChild((Component)div, 1);
        row.appendCellChild((Component)this.pickWarehouse, 2);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.pickWarehouse, "100%");
        div = new Div();
        div.setStyle("text-align: center;");
        div.appendChild((Component)gridSelection);
        Tabpanel tabSelectionPanel = new Tabpanel();
        tabSelectionPanel.appendChild((Component)div);
        Tab tabSelection = new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"Selection"));
        this.tabpanels.appendChild((Component)tabSelectionPanel);
        this.tabs.appendChild((Component)tabSelection);
        div = new Div();
        div.setStyle("text-align: center;");
        div.appendChild((Component)this.modeLabel);
        div.appendChild((Component)this.modeCombo);
        this.modeCombo.addEventListener("onChange", this);
        Vbox vbAttributeGrid = new Vbox();
        vbAttributeGrid.appendChild((Component)div);
        vbAttributeGrid.appendChild((Component)this.gridView);
        Tabpanel tabAttributeGridPanel = new Tabpanel();
        tabAttributeGridPanel.appendChild((Component)vbAttributeGrid);
        Tab tabAttributeGrid = new Tab(Msg.getMsg((Properties)Env.getCtx(), (String)"AttributeGrid"));
        this.tabpanels.appendChild((Component)tabAttributeGridPanel);
        this.tabs.appendChild((Component)tabAttributeGrid);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "100%");
        this.appendChild((Component)this.tabbox);
        this.tabbox.addEventListener("onSelect", this);
        this.appendChild((Component)this.confirmPanel);
        this.confirmPanel.addActionListener(this);
    }

    private void fillPicks() {
        block7: {
            String sql = "SELECT M_PriceList_Version.M_PriceList_Version_ID, M_PriceList_Version.Name || ' (' || c.Iso_Code || ')' AS ValueName FROM M_PriceList_Version, M_PriceList pl, C_Currency c WHERE M_PriceList_Version.M_PriceList_ID=pl.M_PriceList_ID AND pl.C_Currency_ID=c.C_Currency_ID AND M_PriceList_Version.IsActive='Y' AND pl.IsActive='Y'";
            sql = String.valueOf(MRole.getDefault().addAccessSQL(sql, "M_PriceList_Version", true, false)) + " ORDER BY M_PriceList_Version.Name";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    KeyNamePair kn;
                    this.pickPriceList.appendItem("", 0);
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        kn = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        this.pickPriceList.appendItem(kn.getName(), kn.getKey());
                    }
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    sql = "SELECT M_Warehouse_ID, Value || ' - ' || Name AS ValueName FROM M_Warehouse WHERE IsActive='Y'";
                    sql = String.valueOf(MRole.getDefault().addAccessSQL(sql, "M_Warehouse", false, false)) + " ORDER BY Value";
                    this.pickWarehouse.appendItem("", 0);
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        kn = new KeyNamePair(rs.getInt("M_Warehouse_ID"), rs.getString("ValueName"));
                        this.pickWarehouse.appendItem(kn.getName(), kn.getKey());
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    @Override
    public void onEvent(Event e) throws Exception {
        if (e.getTarget() instanceof Tab) {
            if (this.tabbox.getSelectedIndex() == 1) {
                this.createGrid();
            }
        } else if (e.getTarget() == this.modeCombo) {
            this.createGrid();
        } else if (e.getTarget().getId().equals("Ok")) {
            if (this.tabbox.getSelectedIndex() == 0) {
                this.createGrid();
            } else {
                this.gridOK();
            }
        } else if (e.getTarget().getId().equals("Cancel")) {
            this.onClose();
        } else {
            super.onEvent(e);
        }
    }

    private void gridOK() {
        int mode = this.modeCombo.getSelectedIndex();
        if (mode == 0) {
            this.createPO();
            this.modeCombo.setSelectedIndex(0);
            return;
        }
        if (mode == 0) {
            this.updatePrices();
            this.modeCombo.setSelectedIndex(0);
            return;
        }
        if (mode == 0) {
            // empty if block
        }
        this.onClose();
    }

    private void createPO() {
    }

    private void updatePrices() {
    }

    private void createGrid() {
        Object attr2;
        if (this.attributeCombo1 == null || this.m_setting) {
            return;
        }
        Object attr1 = this.attributeCombo1.getSelectedItem().getValue();
        if (attr1.equals(attr2 = this.attributeCombo2.getSelectedItem().getValue())) {
            Dialog.warn(this.m_WindowNo, "Same Attribute Selected", this.getTitle());
            log.warning("Same Attribute Selected");
            this.tabbox.setSelectedIndex(0);
            return;
        }
        this.m_setting = true;
        this.m_M_PriceList_Version_ID = 0;
        ListItem pl = this.pickPriceList.getSelectedItem();
        if (pl != null) {
            this.m_M_PriceList_Version_ID = Integer.valueOf(pl.getValue().toString());
        }
        this.m_M_Warehouse_ID = 0;
        ListItem wh = this.pickWarehouse.getSelectedItem();
        if (wh != null) {
            this.m_M_Warehouse_ID = Integer.valueOf(wh.getValue().toString());
        }
        int noOfCols = 2;
        int indexAttr1 = 0;
        MAttributeValue[] xValues = null;
        if (attr1 != null) {
            int value = Integer.parseInt(attr1.toString());
            int i = 0;
            while (i < this.m_attributes.length) {
                if (this.m_attributes[i].getKeyNamePair().getKey() == value) {
                    xValues = this.m_attributes[i].getMAttributeValues();
                    indexAttr1 = i;
                    break;
                }
                ++i;
            }
        }
        if (xValues != null) {
            noOfCols = xValues.length + 1;
        }
        int noOfRows = 2;
        int indexAttr2 = 0;
        MAttributeValue[] yValues = null;
        if (attr2 != null) {
            int value = Integer.parseInt(attr2.toString());
            int i = 0;
            while (i < this.m_attributes.length) {
                if (this.m_attributes[i].getKeyNamePair().getKey() == value) {
                    yValues = this.m_attributes[i].getMAttributeValues();
                    indexAttr2 = i;
                    break;
                }
                ++i;
            }
        }
        if (yValues != null) {
            noOfRows = yValues.length + 1;
        }
        this.gridView.getChildren().clear();
        Rows rows = new Rows();
        this.gridView.appendChild((Component)rows);
        log.info("Rows=" + noOfRows + " - Cols=" + noOfCols);
        int rowIndex = 0;
        while (rowIndex < noOfRows) {
            Row row = new Row();
            rows.appendChild((Component)row);
            int colIndex = 0;
            while (colIndex < noOfCols) {
                MAttributeValue xValue = null;
                if (xValues != null && colIndex > 0) {
                    xValue = xValues[colIndex - 1];
                }
                MAttributeValue yValue = null;
                if (yValues != null && rowIndex > 0) {
                    yValue = yValues[rowIndex - 1];
                }
                if (rowIndex == 0 && colIndex == 0) {
                    Vbox descr = new Vbox();
                    ZKUpdateUtil.setWidth((HtmlBasedComponent)descr, "100%");
                    if (xValues != null) {
                        Div div = new Div();
                        div.setStyle("text-align: right;");
                        div.appendChild((Component)new Label(this.m_attributes[indexAttr1].getName()));
                        descr.appendChild((Component)div);
                    }
                    if (yValues != null) {
                        descr.appendChild((Component)new Label(this.m_attributes[indexAttr2].getName()));
                    }
                    row.appendChild((Component)descr);
                } else if (rowIndex == 0) {
                    if (xValue != null) {
                        Div div = new Div();
                        div.setStyle("text-align: center;");
                        div.appendChild((Component)new Label(xValue.getName()));
                        row.appendChild((Component)div);
                    } else {
                        row.appendChild((Component)new Label());
                    }
                } else if (colIndex == 0) {
                    if (yValue != null) {
                        row.appendChild((Component)new Label(yValue.getName()));
                    } else {
                        row.appendChild((Component)new Label());
                    }
                } else {
                    row.appendChild((Component)this.getGridElement(xValue, yValue));
                }
                ++colIndex;
            }
            ++rowIndex;
        }
        this.tabbox.setSelectedIndex(1);
        this.m_setting = false;
    }

    private Panel getGridElement(MAttributeValue xValue, MAttributeValue yValue) {
        int noProducts;
        Panel element;
        block9: {
            element = new Panel();
            element.setStyle("border-width: thin; border-color: black;");
            String sql = "SELECT * FROM M_Product WHERE IsActive='Y'";
            if (xValue != null) {
                sql = String.valueOf(sql) + " AND M_AttributeSetInstance_ID IN (SELECT M_AttributeSetInstance_ID FROM M_AttributeInstance WHERE M_Attribute_ID=" + xValue.getM_Attribute_ID() + " AND M_AttributeValue_ID=" + xValue.getM_AttributeValue_ID() + ")";
            }
            if (yValue != null) {
                sql = String.valueOf(sql) + " AND M_AttributeSetInstance_ID IN (SELECT M_AttributeSetInstance_ID FROM M_AttributeInstance WHERE M_Attribute_ID=" + yValue.getM_Attribute_ID() + " AND M_AttributeValue_ID=" + yValue.getM_AttributeValue_ID() + ")";
            }
            sql = MRole.getDefault().addAccessSQL(sql, "M_Product", false, false);
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            noProducts = 0;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        MProduct product = new MProduct(Env.getCtx(), rs, null);
                        this.addProduct(element, product);
                        ++noProducts;
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        int mode = this.modeCombo.getSelectedIndex();
        if (noProducts == 0 && mode == 0 || mode != 0) {
            // empty if block
        }
        return element;
    }

    private void addProduct(Panel element, MProduct product) {
        int M_Product_ID = product.getM_Product_ID();
        Vbox pe = new Vbox();
        pe.setStyle("border-width: thin; border-color: blue;");
        pe.appendChild((Component)new Label(product.getValue()));
        String formatted = "";
        if (this.m_M_PriceList_Version_ID != 0) {
            MProductPrice pp = MProductPrice.get((Properties)Env.getCtx(), (int)this.m_M_PriceList_Version_ID, (int)M_Product_ID, null);
            if (pp != null) {
                BigDecimal price = pp.getPriceStd();
                formatted = this.m_price.format(price);
            } else {
                formatted = "-";
            }
        }
        pe.appendChild((Component)new Label(formatted));
        pe.appendChild((Component)new Label(product.getName()));
        formatted = "";
        if (this.m_M_Warehouse_ID != 0) {
            BigDecimal qty = MStorageReservation.getQtyAvailable((int)this.m_M_Warehouse_ID, (int)M_Product_ID, (int)0, null);
            formatted = qty == null ? "-" : this.m_qty.format(qty);
        }
        pe.appendChild((Component)new Label(formatted));
        element.appendChild((Component)pe);
    }
}

