/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps.form;

import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.DocumentLink;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.ListModelTable;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.Panel;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.component.WListbox;
import org.adempiere.webui.editor.WDateEditor;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.event.WTableModelEvent;
import org.adempiere.webui.event.WTableModelListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.apps.form.Allocation;
import org.compiere.model.Lookup;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;
import org.compiere.util.Util;
import org.idempiere.ui.zk.annotation.Form;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hbox;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.North;
import org.zkoss.zul.South;

@Form(name="org.compiere.apps.form.VAllocation")
public class WAllocation
extends Allocation
implements IFormController,
EventListener<Event>,
WTableModelListener,
ValueChangeListener {
    private CustomForm form = new CustomForm();
    private Borderlayout mainLayout = new Borderlayout();
    private Panel parameterPanel = new Panel();
    private Grid parameterLayout = GridFactory.newGridLayout();
    private Label bpartnerLabel = new Label();
    private WSearchEditor bpartnerSearch = null;
    private Label currencyLabel = new Label();
    private WTableDirEditor currencyPick = null;
    private Checkbox multiCurrency = new Checkbox();
    private Label chargeLabel = new Label();
    private Label dateLabel = new Label();
    private WDateEditor dateField = new WDateEditor();
    private Checkbox autoWriteOff = new Checkbox();
    private Label organizationLabel = new Label();
    private WTableDirEditor organizationPick;
    private int noOfColumn;
    private Borderlayout infoPanel = new Borderlayout();
    private Panel paymentPanel = new Panel();
    private Panel invoicePanel = new Panel();
    private Borderlayout invoiceLayout = new Borderlayout();
    private Label invoiceLabel = new Label();
    private WListbox invoiceTable = ListboxFactory.newDataTable();
    private Label invoiceInfo = new Label();
    private Borderlayout paymentLayout = new Borderlayout();
    private Label paymentLabel = new Label();
    private WListbox paymentTable = ListboxFactory.newDataTable();
    private Label paymentInfo = new Label();
    private Panel allocationPanel = new Panel();
    private Grid allocationLayout = GridFactory.newGridLayout();
    private Label differenceLabel = new Label();
    private Textbox differenceField = new Textbox();
    private Button allocateButton = new Button();
    private Button refreshButton = new Button();
    private WTableDirEditor chargePick = null;
    private Label DocTypeLabel = new Label();
    private WTableDirEditor DocTypePick = null;
    private Label allocCurrencyLabel = new Label();
    private Hlayout statusBar = new Hlayout();

    public WAllocation() {
        try {
            this.dynInit();
            this.zkInit();
            this.calculate();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", (Throwable)e);
        }
        if (ClientInfo.isMobile()) {
            ClientInfo.onClientInfo((Component)this.form, this::onClientInfo);
        }
    }

    private void zkInit() throws Exception {
        Div div = new Div();
        div.setStyle("height: 100%; width: 100%; overflow: auto;");
        div.appendChild((Component)this.mainLayout);
        this.form.appendChild((Component)div);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.mainLayout, "100%");
        this.mainLayout.setStyle("min-height: 600px");
        this.dateLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Date"));
        this.autoWriteOff.setSelected(false);
        this.autoWriteOff.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"AutoWriteOff", (boolean)true));
        this.autoWriteOff.setTooltiptext(Msg.getMsg((Properties)Env.getCtx(), (String)"AutoWriteOff", (boolean)false));
        this.parameterPanel.appendChild((Component)this.parameterLayout);
        this.allocationPanel.appendChild((Component)this.allocationLayout);
        this.bpartnerLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        this.paymentLabel.setText(" " + Msg.translate((Properties)Env.getCtx(), (String)"C_Payment_ID"));
        this.invoiceLabel.setText(" " + Msg.translate((Properties)Env.getCtx(), (String)"C_Invoice_ID"));
        this.paymentPanel.appendChild((Component)this.paymentLayout);
        this.invoicePanel.appendChild((Component)this.invoiceLayout);
        this.invoiceInfo.setText(".");
        this.paymentInfo.setText(".");
        this.chargeLabel.setText(" " + Msg.translate((Properties)Env.getCtx(), (String)"C_Charge_ID"));
        this.DocTypeLabel.setText(" " + Msg.translate((Properties)Env.getCtx(), (String)"C_DocType_ID"));
        this.differenceLabel.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"Difference"));
        this.differenceField.setText("0");
        this.differenceField.setReadonly(true);
        this.differenceField.setStyle("text-align: right");
        this.allocateButton.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Process")));
        this.allocateButton.addActionListener(this);
        this.refreshButton.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Refresh")));
        this.refreshButton.addActionListener(this);
        this.refreshButton.setAutodisable("self");
        this.currencyLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"C_Currency_ID"));
        this.multiCurrency.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"MultiCurrency"));
        this.multiCurrency.addActionListener(this);
        this.allocCurrencyLabel.setText(".");
        this.organizationLabel.setText(Msg.translate((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        North north = new North();
        north.setBorder("none");
        north.setSplittable(true);
        north.setCollapsible(true);
        this.mainLayout.appendChild((Component)north);
        north.appendChild((Component)this.parameterPanel);
        this.layoutParameterAndSummary();
        this.paymentPanel.appendChild((Component)this.paymentLayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.paymentPanel, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.paymentLayout, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.paymentPanel, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.paymentLayout, "1");
        this.invoicePanel.appendChild((Component)this.invoiceLayout);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.invoicePanel, "100%");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.invoiceLayout, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.invoicePanel, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.invoiceLayout, "1");
        north = new North();
        north.setBorder("none");
        this.paymentLayout.appendChild((Component)north);
        north.appendChild((Component)this.paymentLabel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.paymentLabel, "min");
        South south = new South();
        south.setBorder("none");
        this.paymentLayout.appendChild((Component)south);
        south.appendChild(this.paymentInfo.rightAlign());
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.paymentInfo, "min");
        Center center = new Center();
        this.paymentLayout.appendChild((Component)center);
        center.appendChild((Component)this.paymentTable);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.paymentTable, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.paymentTable, "1");
        center.setBorder("none");
        north = new North();
        north.setBorder("none");
        this.invoiceLayout.appendChild((Component)north);
        north.appendChild((Component)this.invoiceLabel);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.invoiceLabel, "min");
        south = new South();
        south.setBorder("none");
        this.invoiceLayout.appendChild((Component)south);
        south.appendChild(this.invoiceInfo.rightAlign());
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.invoiceInfo, "min");
        center = new Center();
        this.invoiceLayout.appendChild((Component)center);
        center.appendChild((Component)this.invoiceTable);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.invoiceTable, "100%");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.invoiceTable, "1");
        center.setStyle("border: none");
        center = new Center();
        this.mainLayout.appendChild((Component)center);
        center.appendChild((Component)this.infoPanel);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.infoPanel, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.infoPanel, "1");
        this.infoPanel.setStyle("border: none");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.infoPanel, "100%");
        north = new North();
        north.setBorder("none");
        this.infoPanel.appendChild((Component)north);
        north.appendChild((Component)this.paymentPanel);
        north.setAutoscroll(true);
        north.setSplittable(true);
        north.setSize("50%");
        north.setCollapsible(true);
        center = new Center();
        center.setBorder("none");
        this.infoPanel.appendChild((Component)center);
        center.appendChild((Component)this.invoicePanel);
        center.setAutoscroll(true);
        this.infoPanel.setStyle("min-height: 300px;");
    }

    protected void layoutParameterAndSummary() {
        Hbox box;
        Rows rows = null;
        Row row = null;
        this.setupParameterColumns();
        rows = this.parameterLayout.newRows();
        row = rows.newRow();
        row.appendCellChild(this.bpartnerLabel.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.bpartnerSearch.getComponent(), "true");
        row.appendCellChild((Component)this.bpartnerSearch.getComponent(), 1);
        this.bpartnerSearch.showMenu();
        row.appendChild(this.dateLabel.rightAlign());
        row.appendChild((Component)this.dateField.getComponent());
        row.appendCellChild(this.organizationLabel.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.organizationPick.getComponent(), "true");
        row.appendCellChild((Component)this.organizationPick.getComponent(), 1);
        this.organizationPick.showMenu();
        row = rows.newRow();
        row.appendCellChild(this.currencyLabel.rightAlign(), 1);
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.currencyPick.getComponent(), "true");
        row.appendCellChild((Component)this.currencyPick.getComponent(), 1);
        this.currencyPick.showMenu();
        Hbox cbox = new Hbox();
        cbox.setWidth("100%");
        if (this.noOfColumn == 6) {
            cbox.setPack("center");
        } else {
            cbox.setPack("end");
        }
        cbox.appendChild((Component)this.multiCurrency);
        cbox.appendChild((Component)this.autoWriteOff);
        row.appendCellChild((Component)cbox, 2);
        if (this.noOfColumn < 6) {
            LayoutUtils.compactTo(this.parameterLayout, this.noOfColumn);
        } else {
            LayoutUtils.expandTo(this.parameterLayout, this.noOfColumn, true);
        }
        South south = new South();
        south.setBorder("none");
        this.mainLayout.appendChild((Component)south);
        south.appendChild((Component)this.allocationPanel);
        this.allocationPanel.appendChild((Component)this.allocationLayout);
        this.allocationPanel.appendChild((Component)this.statusBar);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.allocationLayout, "100%");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.allocationPanel, "1");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.allocationPanel, "min");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.allocationLayout, "min");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.statusBar, "min");
        ZKUpdateUtil.setVflex((HtmlBasedComponent)south, "min");
        rows = this.allocationLayout.newRows();
        row = rows.newRow();
        if (ClientInfo.maxWidth(699)) {
            box = new Hbox();
            box.setWidth("100%");
            box.setPack("end");
            box.appendChild(this.differenceLabel.rightAlign());
            box.appendChild(this.allocCurrencyLabel.rightAlign());
            row.appendCellChild((Component)box);
        } else {
            box = new Hlayout();
            box.setStyle("float: right");
            box.appendChild(this.differenceLabel.rightAlign());
            box.appendChild(this.allocCurrencyLabel.rightAlign());
            row.appendCellChild((Component)box);
        }
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.differenceField, "true");
        row.appendCellChild((Component)this.differenceField);
        if (ClientInfo.maxWidth(699)) {
            row = rows.newRow();
        }
        row.appendCellChild(this.chargeLabel.rightAlign());
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.chargePick.getComponent(), "true");
        row.appendCellChild((Component)this.chargePick.getComponent());
        if (ClientInfo.maxWidth(699)) {
            row = rows.newRow();
        }
        row.appendCellChild(this.DocTypeLabel.rightAlign());
        this.chargePick.showMenu();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.DocTypePick.getComponent(), "true");
        row.appendCellChild((Component)this.DocTypePick.getComponent());
        this.DocTypePick.showMenu();
        if (ClientInfo.maxWidth(699)) {
            row = rows.newRow();
            box = new Hbox();
            box.setWidth("100%");
            box.setPack("end");
            box.appendChild((Component)this.allocateButton);
            box.appendChild((Component)this.refreshButton);
            row.appendCellChild((Component)box, 2);
        } else {
            box = new Hbox();
            box.setPack("end");
            box.appendChild((Component)this.allocateButton);
            box.appendChild((Component)this.refreshButton);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)box, "1");
            row.appendCellChild((Component)box, 2);
        }
    }

    protected void setupParameterColumns() {
        this.noOfColumn = 6;
        if (ClientInfo.maxWidth(999)) {
            this.noOfColumn = ClientInfo.maxWidth(699) ? 2 : 4;
        }
        if (this.noOfColumn == 2) {
            Columns columns = new Columns();
            Column column = new Column();
            column.setWidth("35%");
            columns.appendChild((Component)column);
            column = new Column();
            column.setWidth("65%");
            columns.appendChild((Component)column);
            this.parameterLayout.appendChild((Component)columns);
        }
    }

    public void dynInit() throws Exception {
        int AD_Column_ID = 3505;
        MLookup lookupCur = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)AD_Column_ID, (int)19);
        this.currencyPick = new WTableDirEditor("C_Currency_ID", true, false, true, (Lookup)lookupCur);
        this.currencyPick.setValue(this.getC_Currency_ID());
        this.currencyPick.addValueChangeListener(this);
        AD_Column_ID = 839;
        MLookup lookupOrg = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)AD_Column_ID, (int)19);
        this.organizationPick = new WTableDirEditor("AD_Org_ID", true, false, true, (Lookup)lookupOrg);
        this.organizationPick.setValue(Env.getAD_Org_ID((Properties)Env.getCtx()));
        this.organizationPick.addValueChangeListener(this);
        AD_Column_ID = 3499;
        MLookup lookupBP = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)AD_Column_ID, (int)30);
        this.bpartnerSearch = new WSearchEditor("C_BPartner_ID", true, false, true, (Lookup)lookupBP);
        this.bpartnerSearch.addValueChangeListener(this);
        this.statusBar.appendChild((Component)new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"AllocateStatus")));
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.statusBar, "min");
        Calendar cal = Calendar.getInstance();
        cal.setTime(Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date"));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        this.dateField.setValue(new Timestamp(cal.getTimeInMillis()));
        this.dateField.addValueChangeListener(this);
        AD_Column_ID = 61804;
        MLookup lookupCharge = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)AD_Column_ID, (int)19);
        this.chargePick = new WTableDirEditor("C_Charge_ID", false, false, true, (Lookup)lookupCharge);
        this.chargePick.setValue(this.getC_Charge_ID());
        this.chargePick.addValueChangeListener(this);
        AD_Column_ID = 212213;
        MLookup lookupDocType = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)AD_Column_ID, (int)19);
        this.DocTypePick = new WTableDirEditor("C_DocType_ID", false, false, true, (Lookup)lookupDocType);
        this.DocTypePick.setValue(this.getC_DocType_ID());
        this.DocTypePick.addValueChangeListener(this);
    }

    protected void onClientInfo() {
        if (ClientInfo.isMobile() && this.form.getPage() != null && this.noOfColumn > 0 && this.parameterLayout.getRows() != null) {
            int t = 6;
            if (ClientInfo.maxWidth(999)) {
                t = ClientInfo.maxWidth(699) ? 2 : 4;
            }
            if (t != this.noOfColumn) {
                this.parameterLayout.getRows().detach();
                if (this.parameterLayout.getColumns() != null) {
                    this.parameterLayout.getColumns().detach();
                }
                if (this.mainLayout.getSouth() != null) {
                    this.mainLayout.getSouth().detach();
                }
                if (this.allocationLayout.getRows() != null) {
                    this.allocationLayout.getRows().detach();
                }
                this.layoutParameterAndSummary();
                this.form.invalidate();
            }
        }
    }

    public void onEvent(Event e) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("");
        }
        if (e.getTarget().equals((Object)this.multiCurrency)) {
            this.loadBPartner();
        } else if (e.getTarget().equals((Object)this.allocateButton)) {
            this.allocateButton.setEnabled(false);
            MAllocationHdr allocation = this.saveData();
            this.loadBPartner();
            this.allocateButton.setEnabled(true);
            if (allocation != null) {
                DocumentLink link = new DocumentLink(String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_AllocationHdr_ID")) + ": " + allocation.getDocumentNo(), allocation.get_Table_ID(), allocation.get_ID());
                this.statusBar.appendChild((Component)link);
            }
        } else if (e.getTarget().equals((Object)this.refreshButton)) {
            this.loadBPartner();
        }
    }

    @Override
    public void tableChanged(WTableModelEvent e) {
        boolean isUpdate;
        boolean bl = isUpdate = e.getType() == 0;
        if (!isUpdate) {
            this.calculate();
            return;
        }
        int row = e.getFirstRow();
        int col = e.getColumn();
        if (row < 0) {
            return;
        }
        boolean isInvoice = e.getModel().equals((Object)this.invoiceTable.getModel());
        boolean isAutoWriteOff = this.autoWriteOff.isSelected();
        String msg = this.writeOff(row, col, isInvoice, this.paymentTable, this.invoiceTable, isAutoWriteOff);
        ListModelTable model = isInvoice ? this.invoiceTable.getModel() : this.paymentTable.getModel();
        model.updateComponent(row);
        if (msg != null && msg.length() > 0) {
            Dialog.warn(this.form.getWindowNo(), "AllocationWriteOffWarn");
        }
        this.calculate();
    }

    @Override
    public void valueChange(ValueChangeEvent e) {
        String name = e.getPropertyName();
        Object value = e.getNewValue();
        if (log.isLoggable(Level.CONFIG)) {
            log.config(String.valueOf(name) + "=" + value);
        }
        if (!(value != null || name.equals("C_Charge_ID") && name.equals("C_DocType_ID"))) {
            return;
        }
        if (name.equals("AD_Org_ID")) {
            this.setAD_Org_ID((Integer)value);
            this.loadBPartner();
        } else if (name.equals("C_Charge_ID")) {
            this.setC_Charge_ID(value != null ? (Integer)value : 0);
            this.setAllocateButton();
        } else if (name.equals("C_DocType_ID")) {
            this.setC_DocType_ID(value != null ? (Integer)value : 0);
        }
        if (name.equals("C_BPartner_ID")) {
            this.bpartnerSearch.setValue(value);
            this.setC_BPartner_ID((Integer)value);
            this.loadBPartner();
        } else if (name.equals("C_Currency_ID")) {
            this.setC_Currency_ID((Integer)value);
            this.loadBPartner();
        } else if (name.equals("Date") && this.multiCurrency.isSelected()) {
            this.loadBPartner();
        }
    }

    private void setAllocateButton() {
        if (this.isOkToAllocate()) {
            this.allocateButton.setEnabled(true);
        } else {
            this.allocateButton.setEnabled(false);
        }
        if (this.getTotalDifference().signum() == 0) {
            this.chargePick.setValue(null);
            this.setC_Charge_ID(0);
        }
    }

    private void loadBPartner() {
        this.checkBPartner();
        Vector data = this.getPaymentData(this.multiCurrency.isSelected(), this.dateField.getValue(), null);
        Vector columnNames = this.getPaymentColumnNames(this.multiCurrency.isSelected());
        this.paymentTable.clear();
        this.paymentTable.getModel().removeTableModelListener(this);
        ListModelTable modelP = new ListModelTable(data);
        modelP.addTableModelListener(this);
        this.paymentTable.setData(modelP, columnNames);
        this.setPaymentColumnClass(this.paymentTable, this.multiCurrency.isSelected());
        data = this.getInvoiceData(this.multiCurrency.isSelected(), this.dateField.getValue(), null);
        columnNames = this.getInvoiceColumnNames(this.multiCurrency.isSelected());
        this.invoiceTable.clear();
        this.invoiceTable.getModel().removeTableModelListener(this);
        ListModelTable modelI = new ListModelTable(data);
        modelI.addTableModelListener(this);
        this.invoiceTable.setData(modelI, columnNames);
        this.setInvoiceColumnClass(this.invoiceTable, this.multiCurrency.isSelected());
        this.calculate();
        this.statusBar.getChildren().clear();
    }

    public void calculate() {
        this.calculate(this.paymentTable, this.invoiceTable, this.multiCurrency.isSelected());
        this.paymentInfo.setText(this.getPaymentInfoText());
        this.invoiceInfo.setText(this.getInvoiceInfoText());
        this.differenceField.setText(this.format.format(this.getTotalDifference()));
        if (this.allocDate != null && !this.allocDate.equals(this.dateField.getValue())) {
            Clients.showNotification((String)Msg.getMsg((Properties)Env.getCtx(), (String)"AllocationDateUpdated"), (String)"info", (Component)this.dateField.getComponent(), (String)"start_before", (int)-1, (boolean)false);
            this.dateField.setValue(this.allocDate);
        }
        this.allocCurrencyLabel.setText(this.currencyPick.getDisplay());
        this.setAllocateButton();
    }

    private MAllocationHdr saveData() {
        if (this.getAD_Org_ID() > 0) {
            Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"AD_Org_ID", (int)this.getAD_Org_ID());
        } else {
            Env.setContext((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (String)"AD_Org_ID", (String)"");
        }
        try {
            final MAllocationHdr[] allocation = new MAllocationHdr[1];
            Trx.run((TrxRunnable)new TrxRunnable(){

                public void run(String trxName) {
                    WAllocation.this.statusBar.getChildren().clear();
                    allocation[0] = WAllocation.this.saveData(WAllocation.this.form.getWindowNo(), WAllocation.this.dateField.getValue(), WAllocation.this.paymentTable, WAllocation.this.invoiceTable, trxName);
                }
            });
            return allocation[0];
        }
        catch (Exception e) {
            Dialog.error(this.form.getWindowNo(), "Error", e.getLocalizedMessage());
            return null;
        }
    }

    @Override
    public ADForm getForm() {
        return this.form;
    }
}

