/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.apps.WProcessCtl;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MTable;
import org.compiere.model.PrintInfo;
import org.compiere.print.MPrintFormat;
import org.compiere.print.ReportCtl;
import org.compiere.print.ReportEngine;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;

public class WReport
implements EventListener<Event> {
    private MQuery m_query;
    private Menupopup m_popup;
    private List<KeyNamePair> m_list = new ArrayList<KeyNamePair>();
    private static final CLogger log = CLogger.getCLogger(WReport.class);
    protected Component parent;
    protected int WindowNo;
    private String whereExtended;

    public WReport(int AD_Table_ID, MQuery query) {
        new WReport(AD_Table_ID, query, null, 0);
    }

    public WReport(int AD_Table_ID, MQuery query, Component parent, int WindowNo) {
        this(AD_Table_ID, query, parent, WindowNo, null);
    }

    public WReport(int AD_Table_ID, MQuery query, Component parent, int WindowNo, String whereExtended) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("AD_Table_ID=" + AD_Table_ID + " " + query);
        }
        if (!MRole.getDefault().isCanReport(AD_Table_ID)) {
            Dialog.error(0, "AccessCannotReport", query.getTableName());
            return;
        }
        this.m_query = query;
        this.parent = parent;
        this.WindowNo = WindowNo;
        this.whereExtended = whereExtended;
        int AD_Window_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)WindowNo, (String)"_WinInfo_AD_Window_ID", (boolean)true);
        if (AD_Window_ID == 0) {
            AD_Window_ID = Env.getZoomWindowID((MQuery)query);
        }
        this.getPrintFormats(AD_Table_ID, AD_Window_ID);
    }

    private void getPrintFormats(int AD_Table_ID, int AD_Window_ID) {
        this.m_list = MPrintFormat.getAccessiblePrintFormats((int)AD_Table_ID, (int)AD_Window_ID, null, (boolean)true);
        if (this.m_list.size() == 1) {
            this.launchReport(this.m_list.get(0));
        } else {
            this.showPopup();
        }
    }

    private void showPopup() {
        this.m_popup = new Menupopup();
        int i = 0;
        while (i < this.m_list.size()) {
            KeyNamePair pp = this.m_list.get(i);
            Menuitem menuitem = new Menuitem(pp.getName());
            menuitem.setValue(String.valueOf(i));
            menuitem.addEventListener("onClick", (EventListener)this);
            this.m_popup.appendChild((Component)menuitem);
            ++i;
        }
        this.m_popup.setPage(this.parent.getPage());
        this.m_popup.open(this.parent);
    }

    private void launchReport(KeyNamePair pp) {
        MPrintFormat pf = MPrintFormat.get((Properties)Env.getCtx(), (int)pp.getKey(), (boolean)false);
        this.launchReport(pf);
    }

    private void launchReport(MPrintFormat pf) {
        int Record_ID = 0;
        if (this.m_query.getRestrictionCount() == 1 && this.m_query.getColumnName(0).equals(String.valueOf(this.m_query.getTableName()) + "_ID")) {
            Object vrec = this.m_query.getCode(0);
            if (vrec instanceof Integer) {
                Record_ID = (Integer)this.m_query.getCode(0);
            } else {
                try {
                    Record_ID = Integer.parseInt(this.m_query.getCode(0).toString());
                }
                catch (NumberFormatException e) {
                    log.info(e.getMessage());
                }
            }
        }
        PrintInfo info = new PrintInfo(pf.getName(), pf.getAD_Table_ID(), Record_ID);
        info.setDescription(this.m_query.getInfo());
        if (pf != null && pf.getJasperProcess_ID() > 0) {
            ProcessInfo pi = new ProcessInfo("", pf.getJasperProcess_ID(), pf.getAD_Table_ID(), Record_ID);
            WProcessCtl.process(this.WindowNo, pi, null);
        } else {
            ReportEngine re = new ReportEngine(Env.getCtx(), pf, this.m_query, info, null, this.WindowNo);
            re.setWhereExtended(this.whereExtended);
            ReportCtl.preview((ReportEngine)re);
        }
    }

    public static int getAD_Table_ID(String tableName) {
        return MTable.getTable_ID((String)tableName);
    }

    public void onEvent(Event event) {
        if (event.getTarget() instanceof Menuitem) {
            Menuitem mi = (Menuitem)event.getTarget();
            this.launchReport(this.m_list.get(Integer.parseInt(mi.getValue().toString())));
        }
    }
}

