/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.adempiere.util.Callback;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ServerContext;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.apps.BusyDialog;
import org.adempiere.webui.apps.DesktopRunnable;
import org.adempiere.webui.apps.ProcessParameterPanel;
import org.adempiere.webui.apps.WProcessCtl;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.ComboItem;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.editor.WTableDirEditor;
import org.adempiere.webui.factory.ButtonFactory;
import org.adempiere.webui.info.InfoWindow;
import org.adempiere.webui.process.WProcessInfo;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.util.ZkContextRunnable;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.MultiFileDownloadDialog;
import org.adempiere.webui.window.SimplePDFViewer;
import org.compiere.Adempiere;
import org.compiere.model.Lookup;
import org.compiere.model.MAttachment;
import org.compiere.model.MClient;
import org.compiere.model.MLanguage;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MLookupInfo;
import org.compiere.model.MNote;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstanceLog;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.model.MReportView;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.model.MUserDefProc;
import org.compiere.model.Query;
import org.compiere.print.MPrintFormat;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.process.ServerProcessCtl;
import org.compiere.util.AdempiereSystemError;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.Util;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuEcho;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.WrongValueException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Comboitem;
import org.zkoss.zul.Div;
import org.zkoss.zul.Hlayout;
import org.zkoss.zul.Html;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vlayout;

public abstract class AbstractProcessDialog
extends Window
implements IProcessUI,
EventListener<Event> {
    private static final long serialVersionUID = 484056046177205235L;
    private static final String ON_COMPLETE_EVENT = "onComplete";
    private static final String ON_STATUS_UPDATE_EVENT = "onStatusUpdate";
    private static final CLogger log = CLogger.getCLogger(AbstractProcessDialog.class);
    protected int m_WindowNo;
    protected int m_TabNo;
    private Properties m_ctx;
    private int m_AD_Process_ID;
    private ProcessInfo m_pi = null;
    private boolean m_disposeOnComplete;
    private ProcessParameterPanel parameterPanel = null;
    private Checkbox runAsJobField = null;
    private Label notificationTypeLabel = null;
    private WTableDirEditor notificationTypeField = null;
    private BusyDialog progressWindow;
    private String m_Name = null;
    private String m_Description = null;
    private String m_Help = null;
    private String m_ShowHelp = null;
    private String initialMessage;
    private boolean m_valid = true;
    private boolean m_cancel = false;
    private Future<?> future;
    private List<File> downloadFiles;
    private boolean m_locked = false;
    private String m_AD_Process_UU = "";
    protected HtmlBasedComponent topParameterLayout;
    protected HtmlBasedComponent bottomParameterLayout;
    protected HtmlBasedComponent mainParameterLayout;
    protected WTableDirEditor fPrintFormat;
    private WEditor fLanguageType;
    protected Listbox freportType;
    private Checkbox chbIsSummary;
    protected Button bOK;
    protected Button bCancel;
    protected Combobox fSavedName = new Combobox();
    private Button bSave = ButtonFactory.createNamedButton("Save");
    private Button bDelete = ButtonFactory.createNamedButton("Delete");
    private List<MPInstance> savedParams;
    private Label lSaved;

    protected AbstractProcessDialog() {
    }

    protected boolean init(Properties ctx, int WindowNo, int AD_Process_ID, ProcessInfo pi, boolean autoStart, boolean isDisposeOnComplete) {
        return this.init(ctx, WindowNo, 0, AD_Process_ID, pi, autoStart, isDisposeOnComplete);
    }

    protected boolean init(Properties ctx, int WindowNo, int TabNo, int AD_Process_ID, ProcessInfo pi, boolean autoStart, boolean isDisposeOnComplete) {
        this.m_ctx = ctx;
        this.m_WindowNo = WindowNo;
        this.m_TabNo = TabNo;
        this.m_AD_Process_ID = AD_Process_ID;
        this.setProcessInfo(pi);
        this.m_disposeOnComplete = isDisposeOnComplete;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("");
        }
        StringBuilder buildMsg = new StringBuilder();
        boolean trl = !Env.isBaseLanguage((Properties)this.m_ctx, (String)"AD_Process");
        MProcess process = MProcess.get((int)AD_Process_ID);
        this.m_Name = trl ? process.get_Translation("Name") : process.getName();
        this.m_Description = trl ? process.get_Translation("Description") : process.getDescription();
        this.m_Help = trl ? process.get_Translation("Help") : process.getHelp();
        this.m_ShowHelp = pi != null && !Util.isEmpty((String)pi.getShowHelp()) ? pi.getShowHelp() : process.getShowHelp();
        MUserDefProc userDef = MUserDefProc.getBestMatch((Properties)ctx, (int)AD_Process_ID);
        if (userDef != null) {
            if (userDef.getName() != null) {
                this.m_Name = userDef.getName();
            }
            if (userDef.getDescription() != null) {
                this.m_Description = userDef.getDescription();
            }
            if (userDef.getHelp() != null) {
                this.m_Help = userDef.getHelp();
            }
        }
        buildMsg.append("<b>");
        buildMsg.append(Util.isEmpty((String)this.m_Description) ? Msg.getMsg((Properties)this.m_ctx, (String)"StartProcess?") : this.m_Description);
        buildMsg.append("</b>");
        if (!Util.isEmpty((String)this.m_Help)) {
            buildMsg.append("<p>").append(this.m_Help).append("</p>");
        }
        this.m_AD_Process_UU = process.getAD_Process_UU();
        this.initialMessage = buildMsg.toString();
        if (this.m_Name == null) {
            return false;
        }
        this.setTitle(this.m_Name);
        if (this.m_pi == null) {
            this.m_pi = new WProcessInfo(this.m_Name, AD_Process_ID);
            this.m_pi.setReplaceTabContent();
        }
        this.m_pi.setAD_User_ID(Env.getAD_User_ID((Properties)Env.getCtx()));
        this.m_pi.setAD_Client_ID(Env.getAD_Client_ID((Properties)Env.getCtx()));
        this.m_pi.setTitle(this.m_Name);
        this.m_pi.setAD_Process_UU(this.m_AD_Process_UU);
        this.parameterPanel = new ProcessParameterPanel(this.m_WindowNo, this.m_TabNo, this.m_pi);
        if (!this.parameterPanel.init()) {
            if (this.m_ShowHelp != null && "N".equals(this.m_ShowHelp)) {
                autoStart = true;
            }
            if (autoStart) {
                this.layout();
                this.bOK.setDisabled(true);
                this.bCancel.setDisabled(true);
                this.autoStart();
                return true;
            }
        }
        if (this.isValid() && this.m_ShowHelp != null && "S".equals(this.m_ShowHelp)) {
            this.layout();
            this.bOK.setDisabled(true);
            this.bCancel.setDisabled(true);
            this.autoStart();
            return true;
        }
        this.layout();
        return true;
    }

    protected void layout() {
        this.overalLayout();
        this.topLayout(this.topParameterLayout);
        this.bottomLayout(this.bottomParameterLayout);
    }

    protected void overalLayout() {
        this.mainParameterLayout = new Div();
        this.mainParameterLayout.setSclass("main-parameter-layout");
        this.appendChild((Component)this.mainParameterLayout);
        this.topParameterLayout = new Vlayout();
        this.topParameterLayout.setSclass("top-parameter-layout");
        this.mainParameterLayout.appendChild((Component)this.topParameterLayout);
        ZKUpdateUtil.setVflex(this.topParameterLayout, "true");
        this.bottomParameterLayout = new Vlayout();
        this.bottomParameterLayout.setSclass("bottom-parameter-layout");
        this.mainParameterLayout.appendChild((Component)this.bottomParameterLayout);
    }

    protected void topLayout(HtmlBasedComponent topParameterLayout) {
        this.setHeadMessage(topParameterLayout, this.initialMessage);
        Div inputParameterLayout = new Div();
        inputParameterLayout.setSclass("input-paramenter-layout");
        topParameterLayout.appendChild((Component)inputParameterLayout);
        this.inputParameterLayout((HtmlBasedComponent)inputParameterLayout);
    }

    protected HtmlBasedComponent setHeadMessage(HtmlBasedComponent parent, String contentMsg) {
        Vlayout messageParameterLayout = new Vlayout();
        parent.appendChild((Component)messageParameterLayout);
        messageParameterLayout.setSclass("message-parameter-layout");
        Div messageDiv = new Div();
        Html content = new Html();
        if (contentMsg != null) {
            content.setContent(contentMsg);
        }
        messageDiv.appendChild((Component)content);
        messageDiv.setSclass("message-paramenter");
        messageParameterLayout.appendChild((Component)messageDiv);
        return content;
    }

    protected void inputParameterLayout(HtmlBasedComponent parent) {
        parent.appendChild((Component)this.parameterPanel);
        if (MSysConfig.getBooleanValue((String)"BACKGROUND_JOB_ALLOWED", (boolean)false)) {
            Grid grid = GridFactory.newGridLayout();
            parent.appendChild((Component)grid);
            Columns columns = new Columns();
            grid.appendChild((Component)columns);
            Column col = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)col, "30%");
            columns.appendChild((Component)col);
            col = new Column();
            ZKUpdateUtil.setWidth((HtmlBasedComponent)col, "70%");
            columns.appendChild((Component)col);
            Rows rows = new Rows();
            grid.appendChild((Component)rows);
            Row row = new Row();
            rows.appendChild((Component)row);
            row.appendChild((Component)new Space());
            this.runAsJobField = new Checkbox();
            this.runAsJobField.setLabel(Msg.getElement((Properties)this.m_ctx, (String)"IsRunAsJob"));
            row.appendChild((Component)this.runAsJobField);
            this.runAsJobField.addEventListener("onCheck", this);
            row = new Row();
            rows.appendChild((Component)row);
            Div div = new Div();
            div.setStyle("text-align: right;");
            this.notificationTypeLabel = new Label(Msg.getElement((Properties)this.m_ctx, (String)"NotificationType"));
            div.appendChild((Component)this.notificationTypeLabel);
            row.appendChild((Component)div);
            MLookupInfo info = MLookupFactory.getLookup_List((Language)Env.getLanguage((Properties)this.m_ctx), (int)344);
            this.notificationTypeField = new WTableDirEditor("NotificationType", true, false, true, (Lookup)new MLookup(info, 0));
            Combobox combobox = this.notificationTypeField.getComponent();
            List items = combobox.getItems();
            int i = 0;
            while (i < items.size()) {
                ComboItem item = (ComboItem)((Object)items.get(i));
                if ("X".equals(item.getValue())) {
                    combobox.removeItemAt(i);
                }
                ++i;
            }
            MUser user = MUser.get((Properties)this.m_ctx);
            String notificationType = user.getNotificationType();
            if (!"X".equals(notificationType)) {
                this.notificationTypeField.setValue(notificationType);
            }
            row.appendChild((Component)this.notificationTypeField.getComponent());
            this.runAsJobField.setChecked(MSysConfig.getBooleanValue((String)"BACKGROUND_JOB_BY_DEFAULT", (boolean)false));
            MProcess process = MProcess.get((Properties)Env.getCtx(), (int)this.m_AD_Process_ID);
            if (process.isForceBackground()) {
                this.runAsJobField.setChecked(true);
                this.runAsJobField.setEnabled(false);
            } else if (process.isForceForeground()) {
                this.runAsJobField.setChecked(false);
                this.runAsJobField.setEnabled(false);
                this.runAsJobField.setVisible(false);
            }
            this.notificationTypeField.getComponent().getParent().setVisible(this.runAsJobField.isChecked());
            this.notificationTypeField.fillHorizontal();
        }
    }

    protected void bottomLayout(HtmlBasedComponent bottomParameterLayout) {
        this.reportOptionLayout(bottomParameterLayout);
        Div bottomContainer = new Div();
        bottomContainer.setSclass("bottom-container");
        bottomParameterLayout.appendChild((Component)bottomContainer);
        MProcess process = MProcess.get((Properties)Env.getCtx(), (int)this.m_AD_Process_ID);
        int count = process.getParameters().length;
        if (count > 0) {
            this.savePrameterLayout((HtmlBasedComponent)bottomContainer);
        }
        this.buttonLayout((HtmlBasedComponent)bottomContainer);
    }

    protected void reportOptionLayout(HtmlBasedComponent bottomParameterLayout) {
        if (!this.isReport() && !this.isJasperReport()) {
            return;
        }
        Hlayout reportOptionLayout = new Hlayout();
        reportOptionLayout.setSclass("report-option-container");
        reportOptionLayout.setValign("middle");
        bottomParameterLayout.appendChild((Component)reportOptionLayout);
        Label lreportType = new Label(Msg.translate((Properties)Env.getCtx(), (String)"view.report"));
        lreportType.setSclass("option-input-parameter view-report-label");
        this.freportType = new Listbox();
        this.freportType.setSclass("option-input-parameter view-report-list");
        reportOptionLayout.appendChild((Component)lreportType);
        reportOptionLayout.appendChild((Component)this.freportType);
        if (this.isJasperReport()) {
            this.listReportTypeJasper();
        }
        if (!this.isReport()) {
            return;
        }
        this.chbIsSummary = new Checkbox();
        this.chbIsSummary.setSclass("option-input-parameter");
        Label lPrintFormat = new Label(Msg.translate((Properties)Env.getCtx(), (String)"AD_PrintFormat_ID"));
        lPrintFormat.setSclass("option-input-parameter print-format-label");
        Label lIsSummary = new Label(Msg.translate((Properties)Env.getCtx(), (String)"Summary"));
        lIsSummary.setSclass("option-input-parameter");
        MClient client = MClient.get((Properties)this.m_ctx);
        this.listPrintFormat(client);
        reportOptionLayout.appendChild((Component)lPrintFormat);
        reportOptionLayout.appendChild((Component)this.fPrintFormat.getComponent());
        if (client.isMultiLingualDocument()) {
            Label lLanguageType = new Label(Msg.translate((Properties)Env.getCtx(), (String)"AD_Language_ID"));
            reportOptionLayout.appendChild((Component)lLanguageType);
            reportOptionLayout.appendChild(this.fLanguageType.getComponent());
            ((Combobox)this.fLanguageType.getComponent()).setSclass("option-input-parameter");
        }
        this.fPrintFormat.getComponent().setSclass("option-input-parameter print-format-list");
        this.fPrintFormat.getComponent().setPlaceholder(lPrintFormat.getValue());
        reportOptionLayout.appendChild((Component)lIsSummary);
        reportOptionLayout.appendChild((Component)this.chbIsSummary);
    }

    protected boolean isReport() {
        MProcess pr = MProcess.get((Properties)this.m_ctx, (int)this.m_AD_Process_ID);
        return pr.isReport() && pr.getJasperReport() == null;
    }

    protected boolean isJasperReport() {
        MProcess pr = MProcess.get((Properties)this.m_ctx, (int)this.m_AD_Process_ID);
        return pr.isReport() && pr.getJasperReport() != null;
    }

    protected void savePrameterLayout(HtmlBasedComponent bottomParameterLayout) {
        Hlayout savePrameterLayout = new Hlayout();
        savePrameterLayout.setSclass("save-parameter-container");
        bottomParameterLayout.appendChild((Component)savePrameterLayout);
        savePrameterLayout.setValign("middle");
        this.lSaved = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"SavedParameter"));
        this.lSaved.setClass("saved-parameter-label");
        savePrameterLayout.appendChild((Component)this.lSaved);
        this.fSavedName = new Combobox();
        this.fSavedName.addEventListener("onChange", this);
        savePrameterLayout.appendChild((Component)this.fSavedName);
        this.fSavedName.setPlaceholder(this.lSaved.getValue());
        this.fSavedName.setSclass("saved-parameter-list");
        this.bSave.setEnabled(false);
        this.bSave.addActionListener(this);
        savePrameterLayout.appendChild((Component)this.bSave);
        this.bDelete.setEnabled(false);
        this.bDelete.addActionListener(this);
        savePrameterLayout.appendChild((Component)this.bDelete);
        LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)this.bSave);
        LayoutUtils.addSclass("btn-small", (HtmlBasedComponent)this.bDelete);
        this.querySaved();
    }

    protected void querySaved() {
        this.savedParams = MPInstance.get((Properties)Env.getCtx(), (int)this.getAD_Process_ID(), (int)Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_User_ID"));
        this.fSavedName.removeAllItems();
        for (MPInstance instance : this.savedParams) {
            String queries = instance.get_ValueAsString("Name");
            this.fSavedName.appendItem(queries);
        }
        this.fSavedName.setValue("");
    }

    protected void buttonLayout(HtmlBasedComponent bottomParameterLayout) {
        Div confParaPanel = new Div();
        confParaPanel.setSclass("button-container");
        bottomParameterLayout.appendChild((Component)confParaPanel);
        this.bOK = ButtonFactory.createNamedButton("Ok", true, true);
        this.bOK.setId("Ok");
        this.bOK.addEventListener("onClick", this);
        confParaPanel.appendChild((Component)this.bOK);
        confParaPanel.appendChild((Component)new Space());
        this.bCancel = ButtonFactory.createNamedButton("Cancel", true, true);
        this.bCancel.setId("Cancel");
        this.bCancel.addEventListener("onClick", this);
        confParaPanel.appendChild((Component)this.bCancel);
    }

    private void listPrintFormat(MClient client) {
        int AD_Column_ID = 0;
        boolean m_isCanExport = false;
        MProcess pr = MProcess.get((Properties)this.m_ctx, (int)this.m_AD_Process_ID);
        int table_ID = 0;
        try {
            if (pr.getAD_ReportView_ID() > 0) {
                MReportView m_Reportview = MReportView.get((Properties)this.m_ctx, (int)pr.getAD_ReportView_ID());
                table_ID = m_Reportview.getAD_Table_ID();
            } else if (pr.getAD_PrintFormat_ID() > 0) {
                MPrintFormat format = new MPrintFormat(this.m_ctx, pr.getAD_PrintFormat_ID(), null);
                table_ID = format.getAD_Table_ID();
            }
            StringBuilder valCode = new StringBuilder();
            if (table_ID > 0) {
                valCode.append("AD_PrintFormat.AD_Table_ID=").append(table_ID);
                m_isCanExport = MRole.getDefault().isCanExport(table_ID);
            }
            if (pr.getAD_ReportView_ID() > 0 && MSysConfig.getBooleanValue((String)"ZK_REPORT_ONLY_PRINTFORMAT_LINKEDTO_REPORTVIEW", (boolean)false, (int)client.getAD_Client_ID())) {
                if (valCode.length() > 0) {
                    valCode.append(" AND ");
                }
                valCode.append("AD_PrintFormat.AD_ReportView_ID=").append(pr.getAD_ReportView_ID());
            }
            MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.m_WindowNo, (int)AD_Column_ID, (int)19, (Language)Env.getLanguage((Properties)Env.getCtx()), (String)"AD_PrintFormat_ID", (int)0, (boolean)false, (String)valCode.toString());
            this.fPrintFormat = new WTableDirEditor("AD_PrintFormat_ID", false, false, true, (Lookup)lookup);
            if (client.isMultiLingualDocument()) {
                this.fLanguageType = AEnv.getListDocumentLanguage(client);
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getLocalizedMessage());
        }
        this.fillReportType(m_isCanExport);
        this.setReportTypeAndPrintFormat(this.getLastRun());
    }

    private void listReportTypeJasper() {
        boolean m_isCanExport = MRole.getDefault().isCanExport();
        this.fillReportType(m_isCanExport);
        this.setReportTypeAndPrintFormat(this.getLastRun());
    }

    protected MPInstance getLastRun() {
        String where = "AD_Process_ID = ? AND AD_User_ID = ? AND Name IS NULL ";
        return (MPInstance)new Query(Env.getCtx(), "AD_PInstance", "AD_Process_ID = ? AND AD_User_ID = ? AND Name IS NULL ", null).setOnlyActiveRecords(true).setClient_ID().setParameters(new Object[]{this.m_AD_Process_ID, Env.getContextAsInt((Properties)Env.getCtx(), (String)"#AD_User_ID")}).setOrderBy("Created DESC").first();
    }

    private void fillReportType(boolean m_isCanExport) {
        this.freportType.removeAllItems();
        this.freportType.setMold("select");
        this.freportType.appendItem("", "");
        this.freportType.appendItem("PDF", "PDF");
        this.freportType.appendItem("HTML", "HTML");
        if (m_isCanExport) {
            this.freportType.appendItem("XLS", "XLS");
            this.freportType.appendItem("CSV", "CSV");
            this.freportType.appendItem("XLSX", "XLSX");
        }
        this.freportType.setSelectedIndex(-1);
    }

    private void setReportTypeAndPrintFormat(MPInstance instance) {
        if (this.fPrintFormat != null && instance != null && instance.getAD_Process_ID() != 202) {
            this.fPrintFormat.setValue(instance.getAD_PrintFormat_ID());
        }
        if (this.fLanguageType != null && instance != null) {
            this.fLanguageType.setValue(instance.getAD_Language_ID());
        }
        if (this.freportType != null && instance != null) {
            if (instance.getReportType() == null) {
                this.freportType.setSelectedIndex(-1);
            } else {
                this.freportType.setValue(instance.getReportType());
            }
        }
        if (instance != null && this.chbIsSummary != null) {
            this.chbIsSummary.setSelected(instance.isSummary());
        }
    }

    protected void saveReportOption() {
        MPrintFormat format;
        if (!this.isReport() && !this.isJasperReport()) {
            return;
        }
        if (this.freportType.getSelectedItem() != null) {
            this.getProcessInfo().setReportType(this.freportType.getSelectedItem().getValue().toString());
        }
        if (!this.isReport()) {
            return;
        }
        if (this.fPrintFormat != null && this.fPrintFormat.getValue() != null && (format = new MPrintFormat(this.m_ctx, ((Integer)this.fPrintFormat.getValue()).intValue(), null)) != null) {
            this.getProcessInfo().setSerializableObject((Serializable)format);
        }
        this.getProcessInfo().setIsSummary(this.chbIsSummary.isChecked());
        if (this.fLanguageType != null && this.fLanguageType.getValue() != null) {
            this.getProcessInfo().setLanguageID(this.fLanguageType.getValue() == null ? 0 : (Integer)this.fLanguageType.getValue());
        } else {
            this.getProcessInfo().setLanguageID(MLanguage.get((Properties)this.getCtx(), (Language)Env.getLanguage((Properties)this.getCtx())).getAD_Language_ID());
        }
    }

    protected void autoStart() {
        this.startProcess0();
    }

    public void onEvent(Event event) {
        Component component = event.getTarget();
        if (component == this.runAsJobField && event.getName().equals("onCheck")) {
            this.notificationTypeField.getComponent().getParent().setVisible(this.runAsJobField.isChecked());
            this.mainParameterLayout.invalidate();
        } else if (event.getName().equals(ON_COMPLETE_EVENT)) {
            this.onComplete();
        } else if (event.getName().equals(ON_STATUS_UPDATE_EVENT)) {
            this.onStatusUpdate(event);
        } else if (event.getTarget().equals((Object)this.bSave) || event.getTarget().equals((Object)this.bDelete) || event.getTarget().equals((Object)this.fSavedName)) {
            String saveName = null;
            boolean lastRun = false;
            if (this.fSavedName.getRawText() != null) {
                saveName = this.fSavedName.getRawText();
                lastRun = ("** " + Msg.getMsg((Properties)Env.getCtx(), (String)"LastRun") + " **").equals(saveName);
            }
            if (((Object)((Object)this.bSave)).equals(event.getTarget())) {
                this.updateSaveParameter(saveName);
            } else if (((Object)((Object)this.bDelete)).equals(event.getTarget())) {
                this.deleteSaveParameter(saveName);
            } else {
                this.chooseSaveParameter(saveName, lastRun);
            }
        } else if (event.getTarget().equals((Object)this.bOK)) {
            if (this.isBackgroundJob() && this.getNotificationType() == null) {
                throw new WrongValueException((Component)this.notificationTypeField.getComponent(), String.valueOf(Msg.getMsg((Properties)this.m_ctx, (String)"FillMandatory")) + this.notificationTypeLabel.getValue());
            }
            this.saveReportOption();
        }
    }

    protected void updateSaveParameter(String saveName) {
        if (this.fSavedName.getSelectedIndex() > -1 && this.savedParams != null) {
            int i = 0;
            while (i < this.savedParams.size()) {
                if (this.savedParams.get(i).getName().equals(saveName)) {
                    this.getProcessInfo().setAD_PInstance_ID(this.savedParams.get(i).getAD_PInstance_ID());
                    MPInstancePara[] mPInstanceParaArray = this.savedParams.get(i).getParameters();
                    int n = mPInstanceParaArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MPInstancePara para = mPInstanceParaArray[n2];
                        para.deleteEx(true);
                        ++n2;
                    }
                    this.getParameterPanel().saveParameters();
                    this.saveReportOptionToInstance(this.savedParams.get(i));
                    this.savedParams.get(i).saveEx();
                    this.getProcessInfo().setAD_PInstance_ID(0);
                }
                ++i;
            }
        } else {
            MPInstance instance = null;
            try {
                instance = new MPInstance(Env.getCtx(), this.getProcessInfo().getAD_Process_ID(), this.getProcessInfo().getRecord_ID());
                instance.setName(saveName);
                this.saveReportOptionToInstance(instance);
                instance.saveEx();
                this.getProcessInfo().setAD_PInstance_ID(instance.getAD_PInstance_ID());
                if (this.getParameterPanel() != null && !this.getParameterPanel().saveParameters()) {
                    throw new AdempiereSystemError(Msg.getMsg((Properties)Env.getCtx(), (String)"SaveParameterError"));
                }
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        this.querySaved();
        this.fSavedName.setSelectedItem(this.getComboItem(saveName));
    }

    protected void saveReportOptionToInstance(MPInstance instance) {
        if (!this.isReport() && !this.isJasperReport()) {
            return;
        }
        if (this.freportType.getSelectedItem() != null) {
            instance.setReportType(this.freportType.getSelectedItem().getValue().toString());
        }
        if (!this.isReport()) {
            return;
        }
        Object value = this.fPrintFormat.getValue();
        if (value == null) {
            instance.setAD_PrintFormat_ID(0);
        } else {
            instance.setAD_PrintFormat_ID(((Integer)value).intValue());
        }
        if (this.fLanguageType != null) {
            value = this.fLanguageType.getValue();
            if (value == null) {
                instance.setAD_Language_ID(0);
            } else {
                instance.setAD_Language_ID(((Integer)value).intValue());
            }
        }
        instance.setIsSummary(this.chbIsSummary.isSelected());
    }

    public Comboitem getComboItem(String value) {
        Comboitem item = null;
        int i = 0;
        while (i < this.fSavedName.getItems().size()) {
            if (this.fSavedName.getItems().get(i) != null && value.equals((item = (Comboitem)this.fSavedName.getItems().get(i)).getLabel().toString())) break;
            ++i;
        }
        return item;
    }

    protected void deleteSaveParameter(String saveName) {
        Comboitem o = this.fSavedName.getSelectedItem();
        if (this.savedParams != null && o != null) {
            String selected = this.fSavedName.getSelectedItem().getLabel();
            int i = 0;
            while (i < this.savedParams.size()) {
                if (this.savedParams.get(i).getName().equals(selected)) {
                    this.savedParams.get(i).deleteEx(true);
                }
                ++i;
            }
        }
        this.querySaved();
    }

    protected void chooseSaveParameter(String saveName, boolean lastRun) {
        if (this.savedParams != null && saveName != null) {
            int i = 0;
            while (i < this.savedParams.size()) {
                if (this.savedParams.get(i).getName().equals(saveName)) {
                    this.loadSavedParams(this.savedParams.get(i));
                }
                ++i;
            }
        }
        boolean enabled = !Util.isEmpty((String)saveName);
        this.bSave.setEnabled(enabled && !lastRun);
        this.bDelete.setEnabled(enabled && this.fSavedName.getSelectedIndex() > -1 && !lastRun);
    }

    protected void loadSavedParams(MPInstance instance) {
        this.getParameterPanel().loadParameters(instance);
        this.setReportTypeAndPrintFormat(instance);
    }

    protected void startProcess() {
        if (!this.parameterPanel.validateParameters()) {
            return;
        }
        if (this.m_pi.isProcessRunning(this.parameterPanel.getParameters())) {
            Dialog.error(this.getWindowNo(), "ProcessAlreadyRunning");
            log.log(Level.WARNING, "Abort process " + this.m_AD_Process_ID + " because it is already running");
            return;
        }
        this.startProcess0();
    }

    protected void cancelProcess() {
        this.m_cancel = true;
        this.dispose();
    }

    protected BusyDialog createBusyDialog() {
        this.progressWindow = new BusyDialog();
        this.appendChild((Component)this.progressWindow);
        return this.progressWindow;
    }

    protected void closeBusyDialog() {
        if (this.progressWindow != null) {
            this.progressWindow.dispose();
            this.progressWindow = null;
        }
    }

    @Override
    public void dispose() {
        this.m_valid = false;
    }

    private void startProcess0() {
        if (!this.isBackgroundJob()) {
            this.getProcessInfo().setPrintPreview(true);
        }
        this.lockUI(this.getProcessInfo());
        this.downloadFiles = new ArrayList<File>();
        Clients.response((AuResponse)new AuEcho((Component)this, this.isBackgroundJob() ? "runBackgroundJob" : "runProcess", (Object)this));
    }

    public void runProcess() {
        Events.sendEvent((String)"onBeforeRunProcess", (Component)this, null);
        this.future = Adempiere.getThreadPoolExecutor().submit(new DesktopRunnable((Runnable)((Object)new ProcessDialogRunnable(null)), this.getDesktop()));
    }

    public void runBackgroundJob() {
        Properties m_ctx = this.getCtx();
        ProcessInfo m_pi = this.getProcessInfo();
        MPInstance instance = null;
        try {
            try {
                int AD_Client_ID = Env.getAD_Client_ID((Properties)m_ctx);
                int AD_User_ID = Env.getAD_User_ID((Properties)m_ctx);
                int count = new Query(m_ctx, "AD_PInstance", "Coalesce(AD_User_ID,0)=? AND IsProcessing='Y' AND IsRunAsJob='Y' ", null).setOnlyActiveRecords(true).setClient_ID().setParameters(new Object[]{AD_User_ID}).count();
                if (count >= MSysConfig.getIntValue((String)"BACKGROUND_JOB_MAX_PER_USER", (int)5, (int)AD_Client_ID)) {
                    throw new IllegalStateException(Msg.getMsg((Properties)m_ctx, (String)"BackgroundJobExceedMaxPerUser"));
                }
                count = new Query(m_ctx, "AD_PInstance", "IsProcessing='Y' AND IsRunAsJob='Y' ", null).setOnlyActiveRecords(true).setClient_ID().count();
                if (count >= MSysConfig.getIntValue((String)"BACKGROUND_JOB_MAX_PER_CLIENT", (int)10, (int)AD_Client_ID)) {
                    throw new IllegalStateException(Msg.getMsg((Properties)m_ctx, (String)"BackgroundJobExceedMaxPerClient"));
                }
                count = new Query(m_ctx, "AD_PInstance", "IsProcessing='Y' AND IsRunAsJob='Y' ", null).setOnlyActiveRecords(true).count();
                if (count >= MSysConfig.getIntValue((String)"BACKGROUND_JOB_MAX_IN_SYSTEM", (int)20)) {
                    throw new IllegalStateException(Msg.getMsg((Properties)m_ctx, (String)"BackgroundJobExceedMaxInSystem"));
                }
                instance = new MPInstance(m_ctx, m_pi.getAD_Process_ID(), m_pi.getRecord_ID());
                instance.setIsRunAsJob(true);
                instance.setIsProcessing(true);
                instance.setNotificationType(this.getNotificationType());
                if (instance.getNotificationType() == null) {
                    instance.setNotificationType("N");
                }
                instance.setReportType(m_pi.getReportType());
                instance.setIsSummary(m_pi.isSummary());
                instance.setAD_Language_ID(m_pi.getLanguageID());
                if (m_pi.getSerializableObject() != null && m_pi.getSerializableObject() instanceof MPrintFormat) {
                    instance.setAD_PrintFormat_ID(((MPrintFormat)m_pi.getSerializableObject()).getAD_PrintFormat_ID());
                }
                instance.saveEx();
                m_pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
                this.getParameterPanel().saveParameters();
                MPInstance.publishChangedEvent((int)AD_User_ID);
                Adempiere.getThreadPoolExecutor().schedule(new BackgroundJobRunnable(this.getCtx()), 1000L, TimeUnit.MILLISECONDS);
                m_pi.setSummary(Msg.getMsg((Properties)m_ctx, (String)"BackgroundJobScheduled"));
            }
            catch (Exception e) {
                m_pi.setSummary(e.getLocalizedMessage());
                m_pi.setError(true);
                if (instance != null) {
                    instance.setIsProcessing(false);
                    instance.saveEx();
                }
                this.unlockUI(m_pi);
                if (this.m_disposeOnComplete) {
                    this.dispose();
                }
            }
        }
        finally {
            this.unlockUI(m_pi);
            if (this.m_disposeOnComplete) {
                this.dispose();
            }
        }
    }

    private void onComplete() {
        ProcessInfo m_pi;
        block5: {
            m_pi = this.getProcessInfo();
            if (this.future != null) {
                try {
                    this.future.get();
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                    if (m_pi.isError()) break block5;
                    m_pi.setSummary(e.getLocalizedMessage(), true);
                }
            }
        }
        this.future = null;
        this.unlockUI(m_pi);
        if (this.downloadFiles.size() > 0) {
            MultiFileDownloadDialog downloadDialog = new MultiFileDownloadDialog(this.downloadFiles.toArray(new File[0]));
            downloadDialog.setPage(this.getPage());
            downloadDialog.setTitle(m_pi.getTitle());
            Events.postEvent((Component)downloadDialog, (Event)new Event("onShow"));
        }
        if (this.m_disposeOnComplete) {
            this.dispose();
        }
    }

    private void onStatusUpdate(Event event) {
        String message = (String)event.getData();
        if (this.progressWindow != null) {
            this.progressWindow.statusUpdate(message);
        }
    }

    public void lockUI(ProcessInfo pi) {
        if (this.m_locked || Executions.getCurrent() == null) {
            return;
        }
        this.m_locked = true;
        this.showBusyDialog();
    }

    public abstract void showBusyDialog();

    public void unlockUI(ProcessInfo pi) {
        if (!this.m_locked) {
            return;
        }
        this.m_locked = false;
        if (Executions.getCurrent() == null) {
            if (this.getDesktop() != null) {
                Executions.schedule((Desktop)this.getDesktop(), (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        AbstractProcessDialog.this.doUnlockUI();
                    }
                }, (Event)new Event("onUnLockUI"));
            }
        } else {
            this.doUnlockUI();
        }
    }

    private void doUnlockUI() {
        this.hideBusyDialog();
        this.updateUI();
    }

    public abstract void hideBusyDialog();

    public abstract void updateUI();

    public boolean isUILocked() {
        return this.m_locked;
    }

    public void statusUpdate(String message) {
        Desktop desktop = this.getDesktop();
        if (desktop != null && desktop.isAlive()) {
            Executions.schedule((Desktop)desktop, (EventListener)this, (Event)new Event(ON_STATUS_UPDATE_EVENT, (Component)this, (Object)message));
        }
    }

    public void ask(final String message, final Callback<Boolean> callback) {
        Executions.schedule((Desktop)this.getDesktop(), (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Dialog.ask(AbstractProcessDialog.this.getWindowNo(), message, (Callback<Boolean>)callback);
            }
        }, (Event)new Event("onAsk"));
    }

    public void download(File file) {
        this.downloadFiles.add(file);
    }

    public ProcessInfo getProcessInfo() {
        return this.m_pi;
    }

    public void setProcessInfo(ProcessInfo pi) {
        this.m_pi = pi;
    }

    public boolean isValid() {
        return this.m_valid;
    }

    public boolean isCancel() {
        return this.m_cancel;
    }

    public Properties getCtx() {
        return this.m_ctx;
    }

    public int getWindowNo() {
        return this.m_WindowNo;
    }

    public int getAD_Process_ID() {
        return this.m_AD_Process_ID;
    }

    public ProcessParameterPanel getParameterPanel() {
        return this.parameterPanel;
    }

    public String getName() {
        return this.m_Name;
    }

    public String getShowHelp() {
        return this.m_ShowHelp;
    }

    public String getInitialMessage() {
        return this.initialMessage;
    }

    public boolean isBackgroundJob() {
        return this.runAsJobField != null && this.runAsJobField.isChecked();
    }

    public String getNotificationType() {
        return (String)this.notificationTypeField.getValue();
    }

    public List<File> getDownloadFiles() {
        return this.downloadFiles;
    }

    public void askForSecretInput(final String message, final Callback<String> callback) {
        Executions.schedule((Desktop)this.getDesktop(), (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Dialog.askForSecretInput(AbstractProcessDialog.this.m_WindowNo, message, (Callback<String>)callback);
            }
        }, (Event)new Event("onAskForInput"));
    }

    public void askForInput(final String message, final Callback<String> callback) {
        Executions.schedule((Desktop)this.getDesktop(), (EventListener)new EventListener<Event>(){

            public void onEvent(Event event) throws Exception {
                Dialog.askForInput(AbstractProcessDialog.this.m_WindowNo, message, (Callback<String>)callback);
            }
        }, (Event)new Event("onAskForInput"));
    }

    public void askForInput(String message, MLookup lookup, int editorType, Callback<Object> callback) {
        Dialog.askForInput(message, lookup, editorType, callback, this.getDesktop(), this.m_WindowNo);
    }

    public void showReports(final List<File> pdfList) {
        if (pdfList == null || pdfList.isEmpty()) {
            return;
        }
        AEnv.executeAsyncDesktopTask(new Runnable(){

            @Override
            public void run() {
                if (pdfList.size() > 1) {
                    try {
                        File outFile = File.createTempFile(AbstractProcessDialog.this.m_Name, ".pdf");
                        AEnv.mergePdf(pdfList, outFile);
                        SimplePDFViewer win = new SimplePDFViewer(AbstractProcessDialog.this.m_Name, new FileInputStream(outFile));
                        win.setAttribute("mode", "highlighted");
                        SessionManager.getAppDesktop().showWindow(win, "center");
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                    }
                } else if (pdfList.size() > 0) {
                    try {
                        SimplePDFViewer win = new SimplePDFViewer(AbstractProcessDialog.this.m_Name, new FileInputStream((File)pdfList.get(0)));
                        win.setAttribute("mode", "highlighted");
                        SessionManager.getAppDesktop().showWindow(win, "center");
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        });
    }

    public void showInfoWindow(final int WindowNo, final String tableName, final String keyColumn, final String queryValue, final boolean multipleSelection, final String whereClause, final Integer AD_InfoWindow_ID, final boolean lookup) {
        if (AD_InfoWindow_ID <= 0) {
            return;
        }
        AEnv.executeAsyncDesktopTask(new Runnable(){

            @Override
            public void run() {
                try {
                    InfoWindow win = new InfoWindow(WindowNo, tableName, keyColumn, queryValue, multipleSelection, whereClause, (int)AD_InfoWindow_ID, lookup);
                    SessionManager.getAppDesktop().showWindow(win, "center");
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                }
            }
        });
    }

    public void focus() {
        super.focus();
        if (this.getParameterPanel() != null && this.getParameterPanel().focusToFirstEditor()) {
            return;
        }
        if (this.bOK != null) {
            this.bOK.focus();
        }
    }

    private class BackgroundJobRunnable
    implements Runnable {
        private Properties m_ctx = new Properties();

        private BackgroundJobRunnable(Properties ctx) {
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Client_ID", (String)ctx.getProperty("#AD_Client_ID"));
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Org_ID", (String)ctx.getProperty("#AD_Org_ID"));
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Role_ID", (String)ctx.getProperty("#AD_Role_ID"));
            Env.setContext((Properties)this.m_ctx, (String)"#M_Warehouse_ID", (String)ctx.getProperty("#M_Warehouse_ID"));
            Env.setContext((Properties)this.m_ctx, (String)"#AD_Language", (String)ctx.getProperty("#AD_Language"));
            Env.setContext((Properties)this.m_ctx, (String)"#AD_User_ID", (String)ctx.getProperty("#AD_User_ID"));
            Env.setContext((Properties)this.m_ctx, (String)"#Date", (String)ctx.getProperty("#Date"));
        }

        @Override
        public void run() {
            try {
                ServerContext.setCurrentInstance((Properties)this.m_ctx);
                this.doRun();
            }
            finally {
                ServerContext.dispose();
            }
        }

        private void doRun() {
            ProcessInfo m_pi = AbstractProcessDialog.this.getProcessInfo();
            m_pi.setIsBatch(true);
            m_pi.setPrintPreview(true);
            MPInstance instance = new MPInstance(this.m_ctx, m_pi.getAD_PInstance_ID(), null);
            String notificationType = instance.getNotificationType();
            if (notificationType == null) {
                notificationType = "N";
            }
            boolean sendEmail = notificationType.equals("E") || notificationType.equals("B");
            boolean createNotice = notificationType.equals("N") || notificationType.equals("B");
            int AD_Client_ID = Env.getAD_Client_ID((Properties)this.m_ctx);
            int AD_User_ID = Env.getAD_User_ID((Properties)this.m_ctx);
            try {
                try {
                    MProcess process = new MProcess(this.m_ctx, m_pi.getAD_Process_ID(), null);
                    if (process.isReport() && process.getJasperReport() != null && !Util.isEmpty((String)process.getJasperReport())) {
                        m_pi.setExport(true);
                        if ("HTML".equals(m_pi.getReportType())) {
                            m_pi.setExportFileExtension("html");
                        } else if ("CSV".equals(m_pi.getReportType())) {
                            m_pi.setExportFileExtension("csv");
                        } else if ("XLS".equals(m_pi.getReportType())) {
                            m_pi.setExportFileExtension("xls");
                        } else if ("XLSX".equals(m_pi.getReportType())) {
                            m_pi.setExportFileExtension("xlsx");
                        } else {
                            m_pi.setExportFileExtension("pdf");
                        }
                    }
                    ServerProcessCtl.process((ProcessInfo)m_pi, null);
                    ProcessInfoUtil.setLogFromDB((ProcessInfo)m_pi);
                    if (!m_pi.isError()) {
                        boolean isReport;
                        boolean bl = isReport = process.isReport() || process.getAD_ReportView_ID() > 0 || process.getJasperReport() != null || process.getAD_PrintFormat_ID() > 0;
                        if (isReport && m_pi.getPDFReport() != null) {
                            AbstractProcessDialog.this.download(m_pi.getPDFReport());
                        }
                        if (m_pi.isExport() && m_pi.getExportFile() != null) {
                            AbstractProcessDialog.this.download(m_pi.getExportFile());
                        }
                    }
                    if (sendEmail) {
                        MClient client = MClient.get((Properties)this.m_ctx, (int)AD_Client_ID);
                        client.sendEMailAttachments(AD_User_ID, process.get_Translation("Name", Env.getAD_Language((Properties)Env.getCtx())), String.valueOf(m_pi.getSummary()) + " " + m_pi.getLogInfo(), AbstractProcessDialog.this.getDownloadFiles());
                    }
                    if (createNotice) {
                        String log;
                        MNote note = new MNote(this.m_ctx, "BackgroundJob", AD_User_ID, null);
                        note.setTextMsg(String.valueOf(process.get_Translation("Name", Env.getAD_Language((Properties)Env.getCtx()))) + "\n" + m_pi.getSummary());
                        note.setRecord(282, m_pi.getAD_PInstance_ID());
                        note.saveEx();
                        MAttachment attachment = null;
                        if (AbstractProcessDialog.this.getDownloadFiles().size() > 0) {
                            attachment = note.createAttachment();
                            for (File downloadFile : AbstractProcessDialog.this.getDownloadFiles()) {
                                attachment.addEntry(downloadFile);
                            }
                        }
                        if ((log = m_pi.getLogInfo(true)) != null && log.trim().length() > 0) {
                            if (attachment == null) {
                                attachment = note.createAttachment();
                            }
                            attachment.addEntry("ProcessLog.html", log.getBytes("UTF-8"));
                        }
                        if (attachment != null) {
                            attachment.saveEx();
                        }
                        MPInstanceLog il = instance.addLog(null, 0, null, Msg.parseTranslation((Properties)this.m_ctx, (String)("@Created@ @AD_Note_ID@ " + note.getAD_Note_ID())), 389, note.getAD_Note_ID());
                        il.saveEx();
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, e.getLocalizedMessage());
                    instance.setIsProcessing(false);
                    instance.saveEx();
                    MPInstance.publishChangedEvent((int)AD_User_ID);
                }
            }
            finally {
                instance.setIsProcessing(false);
                instance.saveEx();
                MPInstance.publishChangedEvent((int)AD_User_ID);
            }
        }
    }

    private class ProcessDialogRunnable
    extends ZkContextRunnable {
        private Trx m_trx;

        private ProcessDialogRunnable(Trx trx) {
            this.m_trx = trx;
        }

        protected void doRun() {
            ProcessInfo m_pi = AbstractProcessDialog.this.getProcessInfo();
            try {
                try {
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, "Process Info=" + m_pi + " AD_Client_ID=" + Env.getAD_Client_ID((Properties)Env.getCtx()));
                    }
                    WProcessCtl.process(AbstractProcessDialog.this, AbstractProcessDialog.this.getWindowNo(), AbstractProcessDialog.this.getParameterPanel(), m_pi, this.m_trx);
                }
                catch (Exception ex) {
                    m_pi.setError(true);
                    m_pi.setSummary(ex.getLocalizedMessage());
                    log.log(Level.SEVERE, ex.getLocalizedMessage(), (Throwable)ex);
                    Executions.schedule((Desktop)AbstractProcessDialog.this.getDesktop(), (EventListener)AbstractProcessDialog.this, (Event)new Event(AbstractProcessDialog.ON_COMPLETE_EVENT, (Component)AbstractProcessDialog.this, null));
                }
            }
            finally {
                Executions.schedule((Desktop)AbstractProcessDialog.this.getDesktop(), (EventListener)AbstractProcessDialog.this, (Event)new Event(AbstractProcessDialog.ON_COMPLETE_EVENT, (Component)AbstractProcessDialog.this, null));
            }
        }
    }
}

