/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.adempiere.base.Core;
import org.adempiere.model.MTabCustomization;
import org.adempiere.util.Callback;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.adwindow.GridTableListModel;
import org.adempiere.webui.adwindow.IFieldEditorContainer;
import org.adempiere.webui.adwindow.QuickGridTabRowRenderer;
import org.adempiere.webui.apps.form.IQuickForm;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Columns;
import org.adempiere.webui.component.Combobox;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Searchbox;
import org.adempiere.webui.editor.WEditor;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.SortComparator;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.MSysConfig;
import org.compiere.model.StateChangeEvent;
import org.compiere.model.StateChangeListener;
import org.compiere.util.CLogger;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkforge.keylistener.Keylistener;
import org.zkoss.lang.Library;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.IdSpace;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Cell;
import org.zkoss.zul.Column;
import org.zkoss.zul.Div;
import org.zkoss.zul.Frozen;
import org.zkoss.zul.ListModel;
import org.zkoss.zul.Paging;
import org.zkoss.zul.Row;
import org.zkoss.zul.Vbox;

public class QuickGridView
extends Vbox
implements EventListener<Event>,
IdSpace,
IFieldEditorContainer,
StateChangeListener {
    private static final long serialVersionUID = 228387400133234920L;
    static CLogger log = CLogger.getCLogger(QuickGridView.class);
    private static final String HEADER_GRID_STYLE = "border: none; margin:0; padding: 0;";
    private static final int DEFAULT_PAGE_SIZE = 20;
    private static final int DEFAULT_MOBILE_PAGE_SIZE = 20;
    private static final int MIN_COLUMN_WIDTH = 100;
    private static final int MAX_COLUMN_WIDTH = 300;
    private static final int MIN_COMBOBOX_WIDTH = 160;
    private static final int MIN_NUMERIC_COL_WIDTH = 120;
    public static final int SALES_ORDER_LINE_TAB_ID = 187;
    private static final String ATTR_ON_POST_SELECTED_ROW_CHANGED = "org.adempiere.webui.adwindow.GridView.onPostSelectedRowChanged";
    public static final String CNTRL_KEYS = "#left#right#up#down#home@k@r";
    private static final int KEYBOARD_KEY_ENTER = 13;
    public static final String EVENT_ON_SELECT_ROW = "onSelectRow";
    public static final String EVENT_ON_CUSTOMIZE_GRID = "onCustomizeGrid";
    public static final String EVENT_ON_PAGE_NAVIGATE = "onPageNavigate";
    public static final String EVENT_ON_CLICK_TO_NAVIGATE = "onClickToNavigate";
    public static final String EVENT_ON_SET_FOCUS_TO_FIRST_CELL = "onSetFocusToFirstCell";
    public static final String EVENT_ON_AFTER_SAVE = "onAfterSave";
    public static final String EVENT_ONFOCUS_AFTER_SAVE = "onFocusAfterSave";
    public static final int NAVIGATE_CODE = 1;
    public static final int FOCUS_CODE = 0;
    private Grid listbox = null;
    private int pageSize = 20;
    private GridField[] gridFields;
    private AbstractTableModel tableModel;
    private int numColumns = 5;
    private int windowNo;
    private GridTab gridTab;
    private boolean init;
    public GridTableListModel listModel;
    public Paging paging;
    private QuickGridTabRowRenderer renderer;
    private Div gridFooter;
    private boolean modeless = true;
    private AbstractADWindowContent windowPanel;
    private boolean refreshing;
    private Map<Integer, String> columnWidthMap;
    protected Checkbox selectAll;
    protected boolean isHasCustomizeData = false;
    protected Keylistener keyListener;
    public boolean isNewLineSaved = true;
    private boolean isOnFocusAfterSave = false;
    private Component preEventComponent;
    public IQuickForm quickForm;

    public GridField[] getGridField() {
        return this.gridFields;
    }

    public void setGridField(GridField[] gridField) {
        this.gridFields = gridField;
    }

    public QuickGridTabRowRenderer getRenderer() {
        return this.renderer;
    }

    public QuickGridView(int windowNo) {
        this.windowNo = windowNo;
        this.setId("quickGridView");
        this.createListbox();
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this, "1");
        this.gridFooter = new Div();
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.gridFooter, "0");
        if (ClientInfo.isMobile()) {
            this.pageSize = MSysConfig.getIntValue((String)"ZK_MOBILE_PAGING_SIZE", (int)20, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            String limit = Library.getProperty((String)"org.zkoss.zul.grid.DataLoader.limit");
            if (limit == null || !limit.equals(Integer.toString(this.pageSize))) {
                Library.setProperty((String)"org.zkoss.zul.grid.DataLoader.limit", (String)Integer.toString(this.pageSize));
            }
        } else {
            this.pageSize = MSysConfig.getIntValue((String)"QUICKFORM_PAGE_SIZE", (int)20, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
            String limit = Library.getProperty((String)"org.zkoss.zul.grid.DataLoader.limit");
            if (limit == null || !limit.equals(Integer.toString(this.pageSize))) {
                Library.setProperty((String)"org.zkoss.zul.grid.DataLoader.limit", (String)Integer.toString(this.pageSize));
            }
        }
        this.modeless = ClientInfo.isMobile() ? MSysConfig.getBooleanValue((String)"ZK_GRID_MOBILE_EDIT_MODELESS", (boolean)false) && MSysConfig.getBooleanValue((String)"ZK_GRID_MOBILE_EDITABLE", (boolean)false) : MSysConfig.getBooleanValue((String)"ZK_GRID_EDIT_MODELESS", (boolean)true);
        this.appendChild((Component)this.listbox);
        this.appendChild((Component)this.gridFooter);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this, "true");
        this.setStyle(HEADER_GRID_STYLE);
        this.gridFooter.setStyle(HEADER_GRID_STYLE);
        this.addEventListener(EVENT_ON_SELECT_ROW, this);
        this.addEventListener(EVENT_ON_CUSTOMIZE_GRID, this);
        this.addEventListener(EVENT_ON_PAGE_NAVIGATE, this);
        this.addEventListener(EVENT_ON_CLICK_TO_NAVIGATE, this);
        this.addEventListener(EVENT_ON_SET_FOCUS_TO_FIRST_CELL, this);
        this.addEventListener(EVENT_ON_AFTER_SAVE, this);
        this.addEventListener(EVENT_ONFOCUS_AFTER_SAVE, this);
    }

    public QuickGridView(AbstractADWindowContent abstractADWindowContent, GridTab gridTab, IQuickForm wQuickForm) {
        this(abstractADWindowContent.getWindowNo());
        this.setADWindowPanel(abstractADWindowContent);
        this.quickForm = wQuickForm;
        this.init(gridTab);
    }

    protected void createListbox() {
        this.listbox = new Grid();
        this.listbox.setSizedByContent(false);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.listbox, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.listbox, "1");
        this.listbox.setSclass("adtab-grid");
        this.listbox.setEmptyMessage(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing")));
    }

    public void init(GridTab gridTab) {
        if (this.init) {
            return;
        }
        if (this.gridTab != null) {
            this.gridTab.removeStateChangeListener((StateChangeListener)this);
        }
        this.setupFields(gridTab);
        this.setupColumns();
        this.render();
        this.updateListIndex();
        this.init = true;
    }

    private void setupFields(GridTab gridTab) {
        this.gridTab = gridTab;
        gridTab.addStateChangeListener((StateChangeListener)this);
        this.tableModel = gridTab.getTableModel();
        this.columnWidthMap = new HashMap<Integer, String>();
        GridField[] modelFields = ((GridTable)this.tableModel).getFields();
        MTabCustomization tabCustomization = MTabCustomization.get((Properties)Env.getCtx(), (int)Env.getAD_User_ID((Properties)Env.getCtx()), (int)gridTab.getAD_Tab_ID(), null, (boolean)true);
        boolean bl = this.isHasCustomizeData = tabCustomization != null && tabCustomization.getAD_Tab_Customization_ID() > 0 && tabCustomization.getCustom() != null && tabCustomization.getCustom().trim().length() > 0;
        if (this.isHasCustomizeData) {
            int n;
            int n2;
            GridField[] gridFieldArray;
            String custom = tabCustomization.getCustom().trim();
            String[] customComponent = custom.split(";");
            String[] fieldIds = customComponent[0].split("[,]");
            ArrayList<Object> gridFieldsList = new ArrayList<Object>();
            String[] stringArray = fieldIds;
            int n3 = fieldIds.length;
            int n4 = 0;
            while (n4 < n3) {
                block17: {
                    String fieldId = stringArray[n4];
                    fieldId = fieldId.trim();
                    int AD_Field_ID = 0;
                    if (fieldId.length() != 0) {
                        try {
                            AD_Field_ID = Integer.parseInt(fieldId);
                        }
                        catch (NumberFormatException e) {
                            log.log(Level.SEVERE, "", (Throwable)e);
                            break block17;
                        }
                        gridFieldArray = modelFields;
                        n2 = modelFields.length;
                        n = 0;
                        while (n < n2) {
                            GridField gridField = gridFieldArray[n];
                            if (gridField.getAD_Field_ID() == AD_Field_ID) {
                                if (!gridField.isQuickForm()) break;
                                gridFieldsList.add(gridField);
                                break;
                            }
                            ++n;
                        }
                    }
                }
                ++n4;
            }
            this.gridFields = gridFieldsList.toArray(new GridField[0]);
            stringArray = modelFields;
            n3 = modelFields.length;
            n4 = 0;
            while (n4 < n3) {
                String field = stringArray[n4];
                if (field.isQuickForm()) {
                    boolean isFieldAvailable = false;
                    gridFieldArray = this.gridFields;
                    n2 = this.gridFields.length;
                    n = 0;
                    while (n < n2) {
                        GridField gField = gridFieldArray[n];
                        if (gField.getAD_Field_ID() == field.getAD_Field_ID()) {
                            isFieldAvailable = true;
                            break;
                        }
                        ++n;
                    }
                    if (!isFieldAvailable) {
                        gridFieldsList.add(field);
                    }
                }
                ++n4;
            }
            this.gridFields = gridFieldsList.toArray(new GridField[0]);
            if (customComponent.length == 2) {
                String[] widths = customComponent[1].split("[,]");
                int i = 0;
                while (i < this.gridFields.length && i < widths.length) {
                    this.columnWidthMap.put(this.gridFields[i].getAD_Field_ID(), widths[i]);
                    ++i;
                }
            }
        } else {
            ArrayList<GridField> gridFieldsList = new ArrayList<GridField>();
            GridField[] gridFieldArray = modelFields;
            int n = modelFields.length;
            int n5 = 0;
            while (n5 < n) {
                GridField field = gridFieldArray[n5];
                if (field.isQuickForm()) {
                    gridFieldsList.add(field);
                }
                ++n5;
            }
            Collections.sort(gridFieldsList, new Comparator<GridField>(){

                @Override
                public int compare(GridField o1, GridField o2) {
                    return o1.getSeqNoGrid() - o2.getSeqNoGrid();
                }
            });
            this.gridFields = new GridField[gridFieldsList.size()];
            gridFieldsList.toArray(this.gridFields);
        }
        this.numColumns = this.gridFields.length;
    }

    public boolean isInit() {
        return this.init;
    }

    public void refresh(GridTab gridTab) {
        if (this.gridTab != gridTab || !this.isInit()) {
            this.init = false;
            this.init(gridTab);
        } else {
            this.refreshing = true;
            this.listbox.setModel((ListModel)this.listModel);
            this.updateListIndex();
            this.refreshing = false;
            if (gridTab.getRowCount() == 0 && this.selectAll.isChecked()) {
                this.selectAll.setChecked(false);
            }
        }
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    public void updateListIndex() {
        if (this.gridTab == null || !this.gridTab.isOpen()) {
            return;
        }
        this.updateEmptyMessage();
        int rowIndex = this.gridTab.getCurrentRow();
        if (this.pageSize > 0) {
            int pgNo;
            if (this.paging.getTotalSize() != this.gridTab.getRowCount()) {
                this.paging.setTotalSize(this.gridTab.getRowCount());
            }
            if (this.paging.getPageCount() > 1 && !this.gridFooter.isVisible()) {
                this.showPagingControl();
            }
            int pgIndex = rowIndex >= 0 ? rowIndex % this.pageSize : 0;
            int n = pgNo = rowIndex >= 0 ? (rowIndex - pgIndex) / this.pageSize : 0;
            if (this.listModel.getPage() != pgNo) {
                this.listModel.setPage(pgNo);
            } else {
                int editingPgIndex;
                int editingPgNo;
                int editingRow;
                if (rowIndex == this.renderer.getCurrentRowIndex()) {
                    if (this.modeless && !this.renderer.isEditing()) {
                        this.echoOnPostSelectedRowChanged();
                    }
                    return;
                }
                if (this.renderer.isEditing() && (editingRow = this.renderer.getCurrentRowIndex()) >= 0 && (editingPgNo = (editingRow - (editingPgIndex = editingRow % this.pageSize)) / this.pageSize) == pgNo) {
                    this.listModel.updateComponent(this.renderer.getCurrentRowIndex() % this.pageSize);
                }
            }
            if (this.paging.getActivePage() != pgNo) {
                this.paging.setActivePage(pgNo);
            }
            if (rowIndex >= 0 && pgIndex >= 0 && this.isNewLineSaved || rowIndex == 0 && pgIndex == 0 && !this.isNewLineSaved) {
                this.echoOnPostSelectedRowChanged();
            }
        } else if (rowIndex >= 0 && this.isNewLineSaved) {
            this.echoOnPostSelectedRowChanged();
        }
    }

    private void hidePagingControl() {
        if (this.gridFooter.isVisible()) {
            this.gridFooter.setVisible(false);
        }
    }

    private void showPagingControl() {
        if (!this.gridFooter.isVisible()) {
            this.gridFooter.setVisible(true);
        }
    }

    protected void echoOnPostSelectedRowChanged() {
        if (this.getAttribute(ATTR_ON_POST_SELECTED_ROW_CHANGED) == null) {
            this.setAttribute(ATTR_ON_POST_SELECTED_ROW_CHANGED, Boolean.TRUE);
            Events.echoEvent((String)"onPostSelectedRowChanged", (Component)this, null);
        }
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void clear() {
        this.getChildren().clear();
    }

    private void setupColumns() {
        if (this.init) {
            return;
        }
        Columns columns = new Columns();
        if (!ClientInfo.isMobile()) {
            Frozen frozen = new Frozen();
            frozen.setColumns(1);
            this.listbox.appendChild((Component)frozen);
        }
        Column selection = new Column();
        ZKUpdateUtil.setWidth((HtmlBasedComponent)selection, "22px");
        try {
            selection.setSort("none");
        }
        catch (Exception exception) {
            // empty catch block
        }
        selection.setStyle("border-right: none");
        this.selectAll = new Checkbox();
        selection.appendChild((Component)this.selectAll);
        this.selectAll.setId("selectAll");
        this.selectAll.addEventListener("onCheck", this);
        columns.appendChild((Component)selection);
        this.listbox.appendChild((Component)columns);
        columns.setSizable(true);
        columns.setMenupopup("none");
        columns.setColumnsgroup(false);
        HashMap<Integer, String> colnames = new HashMap<Integer, String>();
        int index = 0;
        int i = 0;
        while (i < this.numColumns) {
            if (this.gridFields[i].isQuickForm()) {
                int headerWidth;
                int estimatedWidth;
                colnames.put(index, this.gridFields[i].getHeader());
                ++index;
                Column column = new Column();
                int colindex = this.tableModel.findColumn(this.gridFields[i].getColumnName());
                column.setSortAscending((Comparator)new SortComparator(colindex, true, Env.getLanguage((Properties)Env.getCtx())));
                column.setSortDescending((Comparator)new SortComparator(colindex, false, Env.getLanguage((Properties)Env.getCtx())));
                column.addEventListener("onSort", (EventListener)this);
                if (this.gridFields[i].isFieldOnly()) {
                    column.setLabel("");
                } else {
                    column.setLabel(this.gridFields[i].getHeader());
                    column.setTooltiptext(this.gridFields[i].getDescription());
                }
                if (this.columnWidthMap != null && this.columnWidthMap.get(this.gridFields[i].getAD_Field_ID()) != null && !this.columnWidthMap.get(this.gridFields[i].getAD_Field_ID()).equals("")) {
                    ZKUpdateUtil.setWidth((HtmlBasedComponent)column, this.columnWidthMap.get(this.gridFields[i].getAD_Field_ID()));
                } else if (this.gridFields[i].getDisplayType() == 20) {
                    if (i > 0) {
                        ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "min");
                    } else {
                        estimatedWidth = 60;
                        headerWidth = (this.gridFields[i].getHeader().length() + 2) * 8;
                        if (headerWidth > estimatedWidth) {
                            estimatedWidth = headerWidth;
                        }
                        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, String.valueOf(estimatedWidth) + "px");
                    }
                } else if (DisplayType.isNumeric((int)this.gridFields[i].getDisplayType()) && "Line".equals(this.gridFields[i].getColumnName())) {
                    if (i > 0) {
                        ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "min");
                    } else {
                        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, "60px");
                    }
                } else {
                    estimatedWidth = 0;
                    estimatedWidth = DisplayType.isNumeric((int)this.gridFields[i].getDisplayType()) ? 120 : (DisplayType.isLookup((int)this.gridFields[i].getDisplayType()) ? 160 : (DisplayType.isText((int)this.gridFields[i].getDisplayType()) ? this.gridFields[i].getDisplayLength() * 8 : 100));
                    headerWidth = (this.gridFields[i].getHeader().length() + 2) * 8;
                    if (headerWidth > estimatedWidth) {
                        estimatedWidth = headerWidth;
                    }
                    if (i > 0) {
                        if (DisplayType.isLookup((int)this.gridFields[i].getDisplayType())) {
                            if (headerWidth > 160) {
                                ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "min");
                            }
                        } else if (DisplayType.isNumeric((int)this.gridFields[i].getDisplayType())) {
                            if (headerWidth > 120) {
                                ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "min");
                            }
                        } else if (!DisplayType.isText((int)this.gridFields[i].getDisplayType()) && headerWidth > 100) {
                            ZKUpdateUtil.setHflex((HtmlBasedComponent)column, "min");
                        }
                    }
                    if (!"min".equals(column.getHflex())) {
                        if (estimatedWidth > 300) {
                            estimatedWidth = 300;
                        } else if (estimatedWidth < 100) {
                            estimatedWidth = 100;
                        }
                        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, String.valueOf(Integer.toString(estimatedWidth)) + "px");
                    }
                }
                columns.appendChild((Component)column);
            }
            ++i;
        }
    }

    private void render() {
        this.updateEmptyMessage();
        this.listbox.addEventListener("onClick", this);
        this.updateModel();
        if (this.pageSize > 0) {
            this.paging = new Paging();
            this.paging.setPageSize(this.pageSize);
            this.paging.setTotalSize(this.tableModel.getRowCount());
            this.paging.setDetailed(true);
            this.paging.setId("paging");
            this.gridFooter.appendChild((Component)this.paging);
            this.paging.addEventListener("onPaging", (EventListener)this);
            this.renderer.setPaging(this.paging);
            this.showPagingControl();
            this.positionPagingControl();
        } else {
            this.hidePagingControl();
        }
    }

    private void updateEmptyMessage() {
        if (this.gridTab.getRowCount() == 0) {
            this.listbox.setEmptyMessage(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"FindZeroRecords")));
        } else {
            this.listbox.setEmptyMessage(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Processing")));
        }
    }

    private void updateModel() {
        if (this.listModel != null) {
            ((GridTable)this.tableModel).removeTableModelListener((TableModelListener)this.listModel);
        }
        this.listModel = new GridTableListModel((GridTable)this.tableModel, this.windowNo);
        this.listModel.setPageSize(this.pageSize);
        this.renderer = new QuickGridTabRowRenderer(this.gridTab, this.windowNo);
        this.renderer.setGridPanel(this);
        this.renderer.setADWindowPanel(this.windowPanel);
        if (this.pageSize > 0 && this.paging != null) {
            this.renderer.setPaging(this.paging);
        }
        this.listbox.setModel((ListModel)this.listModel);
        if (this.listbox.getRows() == null) {
            this.listbox.appendChild((Component)new Rows());
        }
        this.listbox.setRowRenderer(this.renderer);
    }

    public void onEvent(Event event) throws Exception {
        if (event == null) {
            return;
        }
        if (event.getTarget() == this.listbox && "onClick".equals(event.getName())) {
            int index;
            Object data = event.getData();
            Row row = null;
            if (data != null && data instanceof Component) {
                if (data instanceof Row) {
                    row = (Row)data;
                } else {
                    AbstractComponent cmp = (AbstractComponent)data;
                    if (cmp.getParent() instanceof Row) {
                        row = (Row)cmp.getParent();
                    }
                }
            }
            if (row != null && row != this.renderer.getCurrentRow() && (index = this.listbox.getRows().getChildren().indexOf(row)) >= 0 && !this.isOnFocusAfterSave) {
                this.onSelectedRowChange(index);
            }
        } else if (event.getTarget() == this.paging) {
            this.isNewLineSaved = true;
            int pgNo = this.paging.getActivePage();
            if (pgNo != this.listModel.getPage()) {
                this.listModel.setPage(pgNo);
                this.onSelectedRowChange(0);
                this.gridTab.clearSelection();
                this.renderer.clearMaps();
                Clients.resize((Component)this.listbox);
                Events.postEvent((Event)new Event(EVENT_ON_PAGE_NAVIGATE, (Component)this, null));
            }
        } else if (event.getTarget() == this.selectAll) {
            this.toggleSelectionForAll(this.selectAll.isChecked());
        } else if (event.getName().equals(EVENT_ON_SELECT_ROW)) {
            Checkbox checkbox = (Checkbox)((Object)event.getData());
            int rowIndex = (Integer)checkbox.getAttribute("grid.row.index");
            if (this.gridTab.getRowCount() - 1 == rowIndex && !this.isNewLineSaved) {
                checkbox.setChecked(false);
                return;
            }
            if (checkbox.isChecked()) {
                this.gridTab.addToSelection(rowIndex);
                if (!this.selectAll.isChecked() && this.isAllSelected()) {
                    this.selectAll.setChecked(true);
                }
            } else {
                this.gridTab.removeFromSelection(rowIndex);
                if (this.selectAll.isChecked()) {
                    this.selectAll.setChecked(false);
                }
            }
            this.onSelectedRowChange(rowIndex % this.paging.getPageSize());
            this.isNewLineSaved = true;
        } else if (event.getName().equals(EVENT_ON_CUSTOMIZE_GRID)) {
            this.reInit();
        } else if (event.getName().equals("onCtrlKey") || event.getName().equals(EVENT_ON_AFTER_SAVE)) {
            KeyEvent keyEvent;
            ArrayList dataEvent = null;
            if (event.getName().equals(EVENT_ON_AFTER_SAVE)) {
                dataEvent = (ArrayList)event.getData();
                keyEvent = (KeyEvent)dataEvent.get(0);
            } else {
                keyEvent = (KeyEvent)event;
            }
            int code = keyEvent.getKeyCode();
            boolean isAlt = keyEvent.isAltKey();
            boolean isCtrl = keyEvent.isCtrlKey();
            boolean isShift = keyEvent.isShiftKey();
            int row = this.renderer.getCurrentRowIndex() % this.paging.getPageSize();
            int col = 0;
            if (this.renderer.getCurrentCell() != null) {
                col = this.renderer.getCurrentRow().getChildren().indexOf(this.renderer.getCurrentCell());
            }
            int totalRow = this.gridTab.getRowCount();
            if (event.getName().equals(EVENT_ON_AFTER_SAVE) && col == -1) {
                col = (Integer)dataEvent.get(1);
            }
            if (col == -1 && (code == 37 || code == 39)) {
                int n = col = code == 37 ? 3 : 0;
            }
            if ((code == 40 || code == 38) && this.renderer.getCurrentCell() != null && this.renderer.getCurrentCell().getChildren().get(0) instanceof Combobox) {
                return;
            }
            if (!(code != 13 || isCtrl || isAlt || isShift)) {
                Cell cell = this.renderer.getCurrentCell();
                if (cell != null && cell.getChildren().get(0) instanceof Searchbox && !((Searchbox)((Object)cell.getChildren().get(0))).getText().isEmpty() && ((Boolean)((Searchbox)((Object)cell.getChildren().get(0))).getAttribute("ATTRIBUTE_IS_INFO_PANEL_OPEN")).booleanValue()) {
                    event.stopPropagation();
                    return;
                }
                code = 40;
            }
            int currentRow = row % this.paging.getPageSize() + this.paging.getActivePage() * this.paging.getPageSize();
            if (code == 40 || code == 38 || code == 36 || code == 35) {
                int rowChangedIndex = this.gridTab.getTableModel().getRowChanged();
                if (this.paging.getTotalSize() != this.gridTab.getRowCount()) {
                    this.updateListIndex();
                    this.isNewLineSaved = true;
                }
                if (rowChangedIndex == currentRow) {
                    if (!this.save(code, row, col)) {
                        event.stopPropagation();
                        return;
                    }
                    if (totalRow != this.gridTab.getRowCount() && code == 40) {
                        totalRow = this.gridTab.getRowCount();
                        this.gridTab.setCurrentRow((--row >= 0 ? row % this.paging.getPageSize() : 0) + this.paging.getActivePage() * this.paging.getPageSize());
                        this.renderer.currentRowIndex = this.gridTab.getCurrentRow();
                    }
                    ArrayList<Object> eData = new ArrayList<Object>();
                    eData.add(keyEvent);
                    eData.add(col);
                    Events.echoEvent((String)EVENT_ON_AFTER_SAVE, (Component)this, eData);
                    return;
                }
            }
            if (!(code != 40 || isCtrl || isAlt || isShift)) {
                if (((currentRow = ++row % this.paging.getPageSize() + this.paging.getActivePage() * this.paging.getPageSize()) == totalRow || row % this.paging.getPageSize() == 0 && this.paging.getActivePage() == this.paging.getPageCount() - 1) && this.isNewLineSaved) {
                    this.createNewLine();
                    this.updateListIndex();
                    this.toggleSelectionForAll(false);
                    if (row % this.paging.getPageSize() != 0) {
                        Events.echoEvent((String)EVENT_ON_SET_FOCUS_TO_FIRST_CELL, (Component)this, null);
                        event.stopPropagation();
                    }
                } else if (currentRow == totalRow || row % this.paging.getPageSize() == 0 && this.paging.getActivePage() == this.paging.getPageCount() - 1) {
                    event.stopPropagation();
                    return;
                }
                if (row % this.paging.getPageSize() == 0) {
                    this.renderer.clearMaps();
                    this.updateListIndex();
                    this.paging.setActivePage(this.paging.getActivePage() + (this.paging.getActivePage() == this.paging.getPageCount() - 1 ? 0 : 1));
                    this.listModel.setPage(this.paging.getActivePage());
                    this.updateModelIndex(0);
                    Events.echoEvent((String)EVENT_ON_SET_FOCUS_TO_FIRST_CELL, (Component)this, null);
                    row = 0;
                }
            } else if (!(code != 37 || isCtrl || isAlt || isShift)) {
                --col;
            } else if (!(code != 39 || isCtrl || isAlt || isShift)) {
                ++col;
            } else if (!(code != 38 || isCtrl || isAlt || isShift)) {
                currentRow = this.gridTab.getCurrentRow();
                if (totalRow > 1 && totalRow - 1 == currentRow && !this.isNewLineSaved) {
                    this.gridTab.dataIgnore();
                    if (this.gridTab.getRowCount() <= 0) {
                        this.createNewLine();
                    }
                    this.gridTab.setCurrentRow(currentRow);
                }
                if (this.paging.getActivePage() > 0 && (--row + 1) % this.paging.getPageSize() == 0) {
                    this.renderer.clearMaps();
                    this.paging.setActivePage(this.paging.getActivePage() - 1);
                    this.listModel.setPage(this.paging.getActivePage());
                    this.updateModelIndex(this.paging.getPageSize() - 1);
                    Events.echoEvent((String)EVENT_ON_SET_FOCUS_TO_FIRST_CELL, (Component)this, null);
                    return;
                }
                if (currentRow != this.gridTab.getCurrentRow() && !this.isNewLineSaved) {
                    this.updateListIndex();
                    this.isNewLineSaved = true;
                }
                if (row < 0) {
                    row = 0;
                }
            } else if (code == 36) {
                row = 0;
            } else {
                if (!isCtrl && isAlt && !isShift) {
                    if (code == 75) {
                        this.quickForm.onSave();
                        this.quickForm.dispose();
                    } else if (code == 83) {
                        this.quickForm.onSave();
                    } else if (code == 68) {
                        this.quickForm.onDelete();
                    } else if (code == 90) {
                        this.quickForm.onIgnore();
                    } else if (code == 69) {
                        this.quickForm.onRefresh();
                    } else if (code == 88) {
                        this.quickForm.onCancel();
                    } else if (code == 76) {
                        this.quickForm.onCustomize();
                    } else if (code == 82) {
                        this.quickForm.onUnSort();
                    }
                    event.stopPropagation();
                    return;
                }
                this.renderer.setCurrentCell(row, col, code);
                event.stopPropagation();
                return;
            }
            if (row < 0 || row >= this.gridTab.getTableModel().getRowCount() || col < 0 || col >= this.gridTab.getTableModel().getColumnCount()) {
                this.renderer.setFocusOnCurrentCell();
                event.stopPropagation();
                return;
            }
            Component source = this.listbox.getCell(row, col);
            if (source == null) {
                this.listbox.renderAll();
                source = this.listbox.getCell(row, col);
            }
            while (source != null && source.getClass() != Cell.class) {
                source = source.getParent();
            }
            this.renderer.setCurrentCell(row, col, code);
        } else if (event.getName().equals("onFocus") || event.getName().equals(EVENT_ONFOCUS_AFTER_SAVE)) {
            int currentRow;
            int totalRow;
            this.isOnFocusAfterSave = event.getName().equals(EVENT_ONFOCUS_AFTER_SAVE);
            Component eventComponent = this.isOnFocusAfterSave ? (Component)event.getData() : event.getTarget();
            if (this.paging.getTotalSize() != this.gridTab.getRowCount()) {
                this.updateListIndex();
            }
            if ((totalRow = this.gridTab.getRowCount()) - 1 != (currentRow = this.gridTab.getCurrentRow()) && !this.isNewLineSaved) {
                this.updateListIndex();
                this.isNewLineSaved = true;
                this.gridTab.dataIgnore();
                this.gridTab.setCurrentRow(currentRow);
            }
            if (!this.isOnFocusAfterSave) {
                if (eventComponent == this.preEventComponent) {
                    return;
                }
                this.preEventComponent = eventComponent;
            }
            Component source = event.getTarget();
            if (this.isOnFocusAfterSave) {
                source = (Component)event.getData();
            }
            while (source != null && source.getClass() != Cell.class) {
                source = source.getParent();
            }
            if (this.renderer.getCurrentCell() != null && !this.renderer.getCurrentCell().equals(source)) {
                int row = this.renderer.getCurrentRowIndex();
                int col = this.renderer.getCurrentRow().getChildren().indexOf(this.renderer.getCurrentCell());
                int focusedRowIndex = this.getFocusedRowIndex(source);
                if (focusedRowIndex != row % this.pageSize) {
                    String script = "$('.z-combobox-open').remove()";
                    Clients.response((AuResponse)new AuScript(script));
                    int rowChangedIndex = this.gridTab.getTableModel().getRowChanged();
                    if (rowChangedIndex == row) {
                        if (this.save(39, row, col)) {
                            this.isOnFocusAfterSave = true;
                            Events.echoEvent((String)EVENT_ONFOCUS_AFTER_SAVE, (Component)this, (Object)event.getTarget());
                        } else {
                            event.stopPropagation();
                        }
                        return;
                    }
                }
                this.setFocusOnDiv(source);
            }
        } else if (event.getName().equals(EVENT_ON_PAGE_NAVIGATE)) {
            this.renderer.setCurrentCell(null);
            this.renderer.setCurrentCell(0, 1, 1);
            this.renderer.getCurrentRow().setStyle("border-top: 2px solid #6f97d2; border-bottom: 2px solid #6f97d2");
        } else if (event.getName().equals(EVENT_ON_CLICK_TO_NAVIGATE)) {
            int row = this.renderer.getCurrentRowIndex();
            int col = (Integer)event.getData();
            this.renderer.setCurrentCell(row, col, 1);
            Row currntRow = this.renderer.getCurrentRow();
            currntRow.setStyle("border-top: 2px solid #6f97d2; border-bottom: 2px solid #6f97d2");
        } else if (event.getName().equals(EVENT_ON_SET_FOCUS_TO_FIRST_CELL)) {
            int row = this.renderer.getCurrentRowIndex() % this.paging.getPageSize();
            row = row < 0 ? 0 : row;
            this.renderer.setCurrentCell(row, 1, 1);
            this.renderer.addRemovePropertyChangeListener(false, 1);
            this.renderer.setRowTo(row);
            this.renderer.addRemovePropertyChangeListener(true, 1);
        } else if ("onSort".equals(event.getName())) {
            int row = this.renderer.getCurrentRowIndex();
            int col = this.renderer.getCurrentRow().getChildren().indexOf(this.renderer.getCurrentCell());
            int rowChangedIndex = this.gridTab.getTableModel().getRowChanged();
            if (rowChangedIndex == row) {
                if (!this.save(39, row, col)) {
                    event.stopPropagation();
                    return;
                }
            } else if (this.gridTab.getRowCount() <= 1 && !this.isNewLineSaved) {
                event.stopPropagation();
                this.setStatusLine("NO record to Sort", false);
                return;
            }
            this.renderer.clearMaps();
            Events.echoEvent((String)EVENT_ON_PAGE_NAVIGATE, (Component)this, null);
            return;
        }
        event.stopPropagation();
    }

    private void setFocusOnDiv(Component source) {
        int rowCount = this.gridTab.getTableModel().getRowCount();
        int colCount = this.renderer.getCurrentRow().getChildren().size();
        int i = 0;
        while (i < rowCount) {
            int j = 0;
            while (j < colCount) {
                if (this.listbox.getCell(i, j) != null && this.listbox.getCell(i, j).equals(source)) {
                    this.renderer.setCurrentCell(i, j, 0);
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    public boolean isAllSelected() {
        org.zkoss.zul.Rows rows = this.listbox.getRows();
        List childs = rows.getChildren();
        boolean all = false;
        for (Component comp : childs) {
            Row row = (Row)comp;
            Component firstChild = row.getFirstChild();
            if (firstChild instanceof Cell) {
                firstChild = firstChild.getFirstChild();
            }
            if (!(firstChild instanceof Checkbox)) continue;
            Checkbox checkbox = (Checkbox)firstChild;
            if (!checkbox.isChecked()) {
                return false;
            }
            all = true;
        }
        return all;
    }

    public void toggleSelectionForAll(boolean b) {
        org.zkoss.zul.Rows rows = this.listbox.getRows();
        List childs = rows.getChildren();
        for (Component comp : childs) {
            Row row = (Row)comp;
            Component firstChild = row.getFirstChild();
            if (firstChild instanceof Cell) {
                firstChild = firstChild.getFirstChild();
            }
            if (!(firstChild instanceof Checkbox)) continue;
            Checkbox checkbox = (Checkbox)firstChild;
            checkbox.setChecked(b);
            int rowIndex = (Integer)checkbox.getAttribute("grid.row.index");
            if (this.gridTab.getRowCount() - 1 == rowIndex && !this.isNewLineSaved) {
                checkbox.setChecked(false);
                continue;
            }
            if (b) {
                this.gridTab.addToSelection(rowIndex);
                continue;
            }
            this.gridTab.removeFromSelection(rowIndex);
        }
    }

    private void onSelectedRowChange(int index) {
        if (this.updateModelIndex(index)) {
            this.updateListIndex();
        }
    }

    private boolean save(int code, int row, int col) {
        boolean isSave = this.dataSave(code);
        if (isSave) {
            this.listModel.updateComponent(row % this.pageSize);
        } else {
            this.renderer.setCurrentCell(row, col, code);
        }
        return isSave;
    }

    public void onPostSelectedRowChanged() {
        int rowIndex;
        this.removeAttribute(ATTR_ON_POST_SELECTED_ROW_CHANGED);
        if (this.listbox.getRows() == null || this.listbox.getRows().getChildren().isEmpty()) {
            return;
        }
        int n = rowIndex = this.gridTab.isOpen() ? this.gridTab.getCurrentRow() : -1;
        if (rowIndex >= 0 && this.pageSize > 0) {
            int pgIndex = rowIndex >= 0 ? rowIndex % this.pageSize : 0;
            Row row = (Row)this.listbox.getRows().getChildren().get(pgIndex);
            if (!this.isRowRendered(row, pgIndex)) {
                this.listbox.renderRow(row);
            } else {
                this.renderer.setCurrentRow(row);
                this.renderer.setCurrentCell(rowIndex, 1, 1);
            }
        } else if (rowIndex >= 0) {
            Row row = (Row)this.listbox.getRows().getChildren().get(rowIndex);
            if (!this.isRowRendered(row, rowIndex)) {
                this.listbox.renderRow(row);
            } else {
                this.renderer.setCurrentRow(row);
                this.renderer.setCurrentCell(rowIndex, 1, 1);
            }
        }
    }

    public void scrollToCurrentRow() {
        this.onPostSelectedRowChanged();
    }

    private boolean isRowRendered(Row row, int index) {
        if (row.getChildren().size() == 0) {
            return false;
        }
        return row.getChildren().size() != 1 || row.getChildren().get(0) instanceof Cell;
    }

    public boolean updateModelIndex(int rowIndex) {
        if (this.pageSize > 0) {
            int start = this.listModel.getPage() * this.listModel.getPageSize();
            rowIndex = start + rowIndex;
        }
        if (this.gridTab.getCurrentRow() != rowIndex) {
            this.gridTab.navigate(rowIndex);
            return true;
        }
        return false;
    }

    public Grid getListbox() {
        return this.listbox;
    }

    public void dynamicDisplay(int col) {
        GridField changedField;
        String columnName;
        ArrayList dependants;
        if (this.gridTab == null || !this.gridTab.isOpen()) {
            return;
        }
        if (col > 0 && (dependants = this.gridTab.getDependantFields(columnName = (changedField = this.gridTab.getField(col)).getColumnName())).size() <= 0 && changedField.getCallout().length() <= 0 && Core.findCallout((String)this.gridTab.getTableName(), (String)columnName).size() <= 0) {
            return;
        }
        boolean noData = this.gridTab.getRowCount() == 0;
        List list = this.renderer.editorsListMap.get(this.renderer.getCurrentRow());
        if (list != null) {
            this.dynamicDisplayEditors(noData, list);
        }
        if (this.gridTab.getRowCount() == 0 && this.selectAll.isChecked()) {
            this.selectAll.setChecked(false);
        }
    }

    private void dynamicDisplayEditors(boolean noData, List<WEditor> list) {
        ArrayList<WEditor> readOnlyEditorsList = this.renderer.readOnlyEditorsListMap.get(this.renderer.getCurrentRow());
        for (WEditor comp : list) {
            GridField mField = comp.getGridField();
            if (mField == null) continue;
            if (noData) {
                comp.setReadWrite(false);
            } else {
                boolean rw;
                if (readOnlyEditorsList != null && readOnlyEditorsList.contains(comp)) {
                    this.renderer.isDisableReadonlyComponent(comp.getComponent(), false);
                    readOnlyEditorsList.remove(comp);
                }
                if ((rw = mField.isEditable(true)) && !comp.isReadWrite()) {
                    mField.refreshLookup();
                }
                comp.setReadWrite(rw);
                comp.setMandatory(mField.isMandatory(true));
                comp.dynamicDisplay();
                if (readOnlyEditorsList != null && this.renderer.isDisableReadonlyComponent(comp.getComponent(), true)) {
                    readOnlyEditorsList.add(comp);
                }
            }
            comp.setVisible((this.isHasCustomizeData || mField.isDisplayedGrid()) && mField.isDisplayed(mField.getVO().ctx, true));
        }
        this.renderer.readOnlyEditorsListMap.put(this.renderer.getCurrentRow(), readOnlyEditorsList);
    }

    public void setWindowNo(int windowNo) {
        this.windowNo = windowNo;
    }

    public void setADWindowPanel(AbstractADWindowContent winPanel) {
        this.windowPanel = winPanel;
        if (this.renderer != null) {
            this.renderer.setADWindowPanel(this.windowPanel);
        }
    }

    public void reInit() {
        this.listbox.getChildren().clear();
        this.listbox.detach();
        if (this.paging != null) {
            this.paging.detach();
            this.paging = null;
        }
        this.renderer = null;
        this.init = false;
        Grid tmp = this.listbox;
        this.createListbox();
        tmp.copyEventListeners(this.listbox);
        this.insertBefore((Component)this.listbox, (Component)this.gridFooter);
        this.refresh(this.gridTab);
        this.scrollToCurrentRow();
        Clients.resize((Component)this.listbox);
    }

    public GridField[] getFields() {
        return this.gridFields;
    }

    @Override
    public void focusToFirstEditor() {
    }

    @Override
    public void focusToNextEditor(WEditor ref) {
    }

    public void stateChange(StateChangeEvent event) {
        switch (event.getEventType()) {
            case 0: 
            case 2: 
            case 6: {
                if (!this.selectAll.isChecked()) break;
                this.selectAll.setChecked(false);
                break;
            }
            case 3: 
            case 5: {
                if (this.selectAll.isChecked() || !this.isAllSelected()) break;
                this.selectAll.setChecked(true);
            }
        }
    }

    protected void onADTabPanelParentChanged() {
        this.positionPagingControl();
    }

    private void positionPagingControl() {
        if (this.gridFooter.getParent() != this) {
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.gridFooter, "1");
            this.gridFooter.setSclass("adtab-grid-south");
            this.appendChild((Component)this.gridFooter);
        }
        if (this.paging != null) {
            this.paging.setDetailed(true);
        }
    }

    public void setStatusLine(String text, boolean error) {
        this.windowPanel.getStatusBarQF().setStatusLine(text, error);
    }

    public void createNewLine() {
        this.isNewLineSaved = false;
        this.gridTab.dataNew(false);
    }

    public boolean dataSave(int code) {
        boolean isSave = false;
        isSave = this.gridTab.dataSave(false);
        if (isSave) {
            this.isNewLineSaved = true;
        }
        int row = this.renderer.getCurrentRowIndex();
        int col = this.renderer.getCurrentRow().getChildren().indexOf(this.renderer.getCurrentCell());
        if (code != 40 && code != 38) {
            this.renderer.setCurrentCell(row, col, code);
        }
        return isSave;
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        if (newpage != null) {
            this.keyListener = SessionManager.getSessionApplication().getKeylistener();
            this.keyListener.setCtrlKeys(String.valueOf(this.keyListener.getCtrlKeys()) + CNTRL_KEYS);
            this.keyListener.addEventListener("onCtrlKey", this);
        }
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        this.keyListener.setCtrlKeys(this.keyListener.getCtrlKeys().replaceAll(CNTRL_KEYS, ""));
        this.keyListener.removeEventListener("onCtrlKey", this);
    }

    @Override
    public void editorTraverse(Callback<WEditor> editorTaverseCallback) {
    }

    private int getFocusedRowIndex(Component source) {
        int rowCount = this.gridTab.getTableModel().getRowCount();
        int colCount = this.renderer.getCurrentRow().getChildren().size();
        int i = 0;
        while (i < rowCount) {
            int j = 0;
            while (j < colCount) {
                if (this.listbox.getCell(i, j) != null && this.listbox.getCell(i, j).equals(source)) {
                    return i;
                }
                ++j;
            }
            ++i;
        }
        return 0;
    }

    public Column findCurrentSortColumn() {
        if (this.listbox.getColumns() != null) {
            List list = this.listbox.getColumns().getChildren();
            int i = 0;
            while (i < list.size()) {
                Column column;
                Component comp = (Component)list.get(i);
                if (comp instanceof Column && !(column = (Column)comp).getSortDirection().equals("natural")) {
                    return column;
                }
                ++i;
            }
        }
        return null;
    }
}

