/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.adwindow;

import java.util.Properties;
import org.adempiere.util.Callback;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.AbstractADWindowContent;
import org.adempiere.webui.adwindow.BreadCrumb;
import org.adempiere.webui.adwindow.CompositeADTabbox;
import org.adempiere.webui.adwindow.IADTabbox;
import org.adempiere.webui.adwindow.IADTabpanel;
import org.adempiere.webui.component.Tabpanel;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.panel.ITabOnCloseHandler;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.util.CLogger;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zul.Div;
import org.zkoss.zul.Tab;
import org.zkoss.zul.Vlayout;

public class ADWindowContent
extends AbstractADWindowContent {
    private static final CLogger logger = CLogger.getCLogger(ADWindowContent.class);
    private Vlayout layout;
    private Div contentArea;

    public ADWindowContent(Properties ctx, int windowNo, int adWindowId) {
        super(ctx, windowNo, adWindowId);
    }

    @Override
    protected Component doCreatePart(Component parent) {
        this.layout = new ADWindowVlayout(this);
        if (parent != null) {
            this.layout.setParent(parent);
            this.layout.setSclass("adwindow-layout");
        } else {
            this.layout.setPage(this.page);
        }
        this.layout.setSpacing("0px");
        Div north = new Div();
        north.setParent((Component)this.layout);
        north.setSclass("adwindow-north");
        Div div = new Div();
        div.setStyle("height: 100%; width: 100%");
        north.appendChild((Component)div);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)north, "0");
        this.toolbar.setParent((Component)div);
        this.toolbar.setWindowNo(this.getWindowNo());
        this.breadCrumb = new BreadCrumb(this, this.getWindowNo());
        this.breadCrumb.setToolbarListener(this);
        this.breadCrumb.setId("breadCrumb");
        div.appendChild((Component)this.breadCrumb);
        div.appendChild((Component)this.statusBar);
        LayoutUtils.addSclass("adwindow-status", (HtmlBasedComponent)this.statusBar);
        this.contentArea = new Div();
        this.contentArea.setParent((Component)this.layout);
        ZKUpdateUtil.setVflex((HtmlBasedComponent)this.contentArea, "1");
        ZKUpdateUtil.setHflex((HtmlBasedComponent)this.contentArea, "1");
        this.contentArea.setStyle("overflow: auto;");
        this.adTabbox.createPart(this.contentArea);
        if (parent instanceof Tabpanel) {
            TabOnCloseHanlder handler = new TabOnCloseHanlder();
            ((Tabpanel)parent).setOnCloseHandler(handler);
        }
        SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this);
        this.layout.addEventListener("onWindowContainerSelectionChanged", (EventListener)this);
        return this.layout;
    }

    @Override
    protected IADTabbox createADTab() {
        CompositeADTabbox composite = new CompositeADTabbox();
        return composite;
    }

    public Vlayout getComponent() {
        return this.layout;
    }

    @Override
    public void onEvent(Event event) {
        if ("onCtrlKey".equals(event.getName())) {
            IADTabpanel panel;
            KeyEvent keyEvent = (KeyEvent)event;
            if (keyEvent.getKeyCode() == 13 && this.getComponent().getParent().isVisible() && (panel = this.adTabbox.getSelectedTabpanel()) != null && panel.onEnterKey()) {
                keyEvent.stopPropagation();
            }
        } else if (event.getName().equals("onWindowContainerSelectionChanged")) {
            SessionManager.getAppDesktop().updateHelpContext("T", this.adTabbox.getSelectedGridTab().getAD_Tab_ID());
        } else {
            super.onEvent(event);
        }
    }

    protected void closeTab(Tabpanel tabPanel) {
        Tab tab = tabPanel.getLinkedTab();
        tab.close();
        if (this.getWindowNo() > 0) {
            SessionManager.getAppDesktop().unregisterWindow(this.getWindowNo());
        }
    }

    @Override
    protected void switchEditStatus(boolean editStatus) {
        this.layout.setWidgetOverride("isEditting", "'" + String.valueOf(editStatus) + "'");
    }

    public static class ADWindowVlayout
    extends Vlayout
    implements IHelpContext {
        private static final long serialVersionUID = 6104341168705201721L;
        private ADWindowContent content;

        protected ADWindowVlayout(ADWindowContent content) {
            this.content = content;
        }

        public void onPageDetached(Page page) {
            super.onPageDetached(page);
            try {
                SessionManager.getSessionApplication().getKeylistener().removeEventListener("onCtrlKey", this.content);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.content.layout.removeEventListener("onWindowContainerSelectionChanged", (EventListener)this.content);
        }
    }

    class TabOnCloseHanlder
    implements ITabOnCloseHandler,
    Callback<Boolean> {
        private Tabpanel tabPanel;

        TabOnCloseHanlder() {
        }

        @Override
        public void onClose(Tabpanel tabPanel) {
            this.tabPanel = tabPanel;
            ADWindowContent.this.onExit(this);
        }

        public void onCallback(Boolean result) {
            if (result.booleanValue()) {
                ADWindowContent.this.closeTab(this.tabPanel);
            }
            this.tabPanel = null;
        }
    }
}

