/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.acct;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.component.Listbox;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MJournal;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MRefList;
import org.compiere.report.core.RColumn;
import org.compiere.report.core.RModel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

public class WAcctViewerData {
    public int WindowNo;
    public int AD_Client_ID;
    public MAcctSchema[] ASchemas = null;
    public MAcctSchema ASchema = null;
    public boolean documentQuery = false;
    public int C_AcctSchema_ID = 0;
    public String PostingType = "";
    public int AD_Org_ID = 0;
    public Timestamp DateFrom = null;
    public Timestamp DateTo = null;
    public int AD_Table_ID;
    public int Record_ID;
    public HashMap<String, String> whereInfo = new HashMap();
    public HashMap<String, Integer> tableInfo = new HashMap();
    protected boolean displayQty = false;
    protected boolean displaySourceAmt = false;
    protected boolean displayDocumentInfo = false;
    protected String sortBy1 = "";
    protected String sortBy2 = "";
    protected String sortBy3 = "";
    protected String sortBy4 = "";
    protected boolean group1 = false;
    protected boolean group2 = false;
    protected boolean group3 = false;
    protected boolean group4 = false;
    private int m_leadingColumns = 0;
    private String m_ref1 = null;
    private String m_ref2 = null;
    private static final CLogger log = CLogger.getCLogger(WAcctViewerData.class);

    public WAcctViewerData(Properties ctx, int windowNo, int ad_Client_ID, int ad_Table_ID) {
        this.WindowNo = windowNo;
        this.AD_Client_ID = ad_Client_ID;
        if (this.AD_Client_ID == 0) {
            this.AD_Client_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.WindowNo, (String)"AD_Client_ID");
        }
        if (this.AD_Client_ID == 0) {
            this.AD_Client_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"AD_Client_ID");
        }
        this.AD_Table_ID = ad_Table_ID;
        this.ASchemas = MAcctSchema.getClientAcctSchema((Properties)ctx, (int)this.AD_Client_ID);
        this.ASchema = this.ASchemas[0];
    }

    public void dispose() {
        this.ASchemas = null;
        this.ASchema = null;
        this.whereInfo.clear();
        this.whereInfo = null;
        Env.clearWinContext((int)this.WindowNo);
    }

    protected void validateAcctSchemas(int Record_ID) {
        MJournal journal;
        if (Record_ID > 0 && this.AD_Table_ID == 224 && (journal = new MJournal(Env.getCtx(), Record_ID, null)).getGL_Journal_ID() == Record_ID) {
            this.ASchemas = new MAcctSchema[1];
            this.ASchemas[0] = MAcctSchema.get((Properties)Env.getCtx(), (int)journal.getC_AcctSchema_ID());
            this.ASchema = this.ASchemas[0];
        }
    }

    protected void fillAcctSchema(Listbox cb) {
        int i = 0;
        while (i < this.ASchemas.length) {
            KeyNamePair key = new KeyNamePair(this.ASchemas[i].getC_AcctSchema_ID(), this.ASchemas[i].getName());
            cb.appendItem(key.getName(), key);
            ++i;
        }
    }

    protected void fillPostingType(Listbox cb) {
        int AD_Reference_ID = 125;
        ValueNamePair[] pt = MRefList.getList((Properties)Env.getCtx(), (int)AD_Reference_ID, (boolean)true);
        int i = 0;
        while (i < pt.length) {
            cb.appendItem(pt[i].getName(), pt[i]);
            ++i;
        }
    }

    protected void fillTable(Listbox cb) {
        block6: {
            String sql = "SELECT AD_Table_ID, TableName FROM AD_Table t WHERE EXISTS (SELECT * FROM AD_Column c WHERE t.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='Posted') AND IsView='N'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        int id = rs.getInt(1);
                        String tableName = rs.getString(2);
                        String name = Msg.translate((Properties)Env.getCtx(), (String)(String.valueOf(tableName) + "_ID"));
                        ValueNamePair pp = new ValueNamePair(tableName, name);
                        cb.appendItem(pp.getName(), pp);
                        this.tableInfo.put(tableName, id);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    protected void fillOrg(Listbox cb) {
        block6: {
            KeyNamePair pp = new KeyNamePair(0, "");
            cb.appendItem(pp.getName(), pp);
            String sql = "SELECT AD_Org_ID, Name FROM AD_Org WHERE AD_Client_ID=? ORDER BY Value";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, this.AD_Client_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        KeyNamePair key = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        cb.appendItem(key.getName(), key);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    protected String getButtonText(String tableName, String columnName, String selectSQL) {
        String retValue;
        block6: {
            StringBuilder sql = new StringBuilder("SELECT (");
            Language language = Env.getLanguage((Properties)Env.getCtx());
            sql.append(MLookupFactory.getLookup_TableDirEmbed((Language)language, (String)columnName, (String)"avd")).append(") FROM ").append(tableName).append(" avd WHERE avd.").append(selectSQL);
            retValue = "<" + selectSQL + ">";
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = DB.createStatement();
                    rs = stmt.executeQuery(sql.toString());
                    if (rs.next()) {
                        retValue = rs.getString(1);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)stmt);
                    rs = null;
                    stmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)stmt);
            rs = null;
            stmt = null;
        }
        return retValue;
    }

    protected RModel query() {
        StringBuilder whereClause = new StringBuilder();
        if (this.C_AcctSchema_ID != 0) {
            whereClause.append("zz").append(".C_AcctSchema_ID=").append(this.C_AcctSchema_ID);
        }
        if (this.PostingType != null && this.PostingType.length() > 0) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("zz").append(".PostingType='").append(this.PostingType).append("'");
        }
        if (this.documentQuery) {
            if (whereClause.length() > 0) {
                whereClause.append(" AND ");
            }
            whereClause.append("zz").append(".AD_Table_ID=").append(this.AD_Table_ID).append(" AND ").append("zz").append(".Record_ID=").append(this.Record_ID);
        } else {
            for (String where : this.whereInfo.values()) {
                if (where == null || where.length() <= 0) continue;
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                whereClause.append("zz").append(".").append(where);
            }
            if (this.DateFrom != null || this.DateTo != null) {
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                if (this.DateFrom != null && this.DateTo != null) {
                    whereClause.append("TRUNC(").append("zz").append(".DateAcct) BETWEEN ").append(DB.TO_DATE((Timestamp)this.DateFrom)).append(" AND ").append(DB.TO_DATE((Timestamp)this.DateTo));
                } else if (this.DateFrom != null) {
                    whereClause.append("TRUNC(").append("zz").append(".DateAcct) >= ").append(DB.TO_DATE((Timestamp)this.DateFrom));
                } else {
                    whereClause.append("TRUNC(").append("zz").append(".DateAcct) <= ").append(DB.TO_DATE((Timestamp)this.DateTo));
                }
            }
            if (this.AD_Org_ID != 0) {
                if (whereClause.length() > 0) {
                    whereClause.append(" AND ");
                }
                whereClause.append("zz").append(".AD_Org_ID=").append(this.AD_Org_ID);
            }
        }
        StringBuilder orderClause = new StringBuilder();
        if (this.sortBy1.length() > 0) {
            orderClause.append("zz").append(".").append(this.sortBy1);
        }
        if (this.sortBy2.length() > 0) {
            if (orderClause.length() > 0) {
                orderClause.append(",");
            }
            orderClause.append("zz").append(".").append(this.sortBy2);
        }
        if (this.sortBy3.length() > 0) {
            if (orderClause.length() > 0) {
                orderClause.append(",");
            }
            orderClause.append("zz").append(".").append(this.sortBy3);
        }
        if (this.sortBy4.length() > 0) {
            if (orderClause.length() > 0) {
                orderClause.append(",");
            }
            orderClause.append("zz").append(".").append(this.sortBy4);
        }
        if (orderClause.length() == 0) {
            orderClause.append("zz").append(".Fact_Acct_ID");
        }
        RModel rm = this.getRModel();
        if ((this.group1 || this.group2 || this.group3 || this.group4) && this.sortBy1.length() > 0) {
            rm.setGroup(this.sortBy1);
        }
        if ((this.group2 || this.group3 || this.group4) && this.sortBy2.length() > 0) {
            rm.setGroup(this.sortBy2);
        }
        if ((this.group3 || this.group4) && this.sortBy3.length() > 0) {
            rm.setGroup(this.sortBy3);
        }
        if (this.group4 && this.sortBy4.length() > 0) {
            rm.setGroup(this.sortBy4);
        }
        rm.setFunction("AmtAcctDr", "Sum");
        rm.setFunction("AmtAcctCr", "Sum");
        rm.query(Env.getCtx(), whereClause.toString(), orderClause.toString());
        return rm;
    }

    private RModel getRModel() {
        String column;
        Properties ctx = Env.getCtx();
        RModel rm = new RModel("Fact_Acct");
        ArrayList<String> keys = this.createKeyColumns();
        int max = this.m_leadingColumns;
        if (max == 0) {
            max = keys.size();
        }
        int i = 0;
        while (i < max) {
            column = keys.get(i);
            if (column != null && column.startsWith("Date")) {
                rm.addColumn(new RColumn(ctx, column, 15));
            } else if (column != null && column.endsWith("_ID")) {
                rm.addColumn(new RColumn(ctx, column, 19));
            }
            ++i;
        }
        rm.addColumn(new RColumn(ctx, "AmtAcctDr", 12));
        rm.addColumn(new RColumn(ctx, "AmtAcctCr", 12));
        if (this.displaySourceAmt) {
            if (!keys.contains("DateTrx")) {
                rm.addColumn(new RColumn(ctx, "DateTrx", 15));
            }
            rm.addColumn(new RColumn(ctx, "C_Currency_ID", 19));
            rm.addColumn(new RColumn(ctx, "AmtSourceDr", 12));
            rm.addColumn(new RColumn(ctx, "AmtSourceCr", 12));
            rm.addColumn(new RColumn(ctx, "Rate", 12, "CASE WHEN (AmtSourceDr + AmtSourceCr) = 0 THEN 0 ELSE (AmtAcctDr + AmtAcctCr) / (AmtSourceDr + AmtSourceCr) END"));
        }
        i = max;
        while (i < keys.size()) {
            column = keys.get(i);
            if (column != null && column.startsWith("Date")) {
                rm.addColumn(new RColumn(ctx, column, 15));
            } else if (column != null && column.startsWith("UserElement")) {
                if (column.indexOf(49) != -1) {
                    rm.addColumn(new RColumn(ctx, column, 19, null, 0, this.m_ref1));
                } else {
                    rm.addColumn(new RColumn(ctx, column, 19, null, 0, this.m_ref2));
                }
            } else if (column != null && column.endsWith("_ID")) {
                rm.addColumn(new RColumn(ctx, column, 19));
            }
            ++i;
        }
        if (!keys.contains("DateAcct")) {
            rm.addColumn(new RColumn(ctx, "DateAcct", 15));
        }
        if (!keys.contains("C_Period_ID")) {
            rm.addColumn(new RColumn(ctx, "C_Period_ID", 19));
        }
        if (this.displayQty) {
            rm.addColumn(new RColumn(ctx, "C_UOM_ID", 19));
            rm.addColumn(new RColumn(ctx, "Qty", 29));
        }
        rm.addColumn(new RColumn(ctx, "AD_Table_ID", 19));
        rm.addColumn(new RColumn(ctx, "Record_ID", 13));
        rm.addColumn(new RColumn(ctx, "Fact_Acct_ID", 13));
        if (this.displayDocumentInfo) {
            rm.addColumn(new RColumn(ctx, "Description", 10));
        }
        if (this.PostingType == null || this.PostingType.length() == 0) {
            rm.addColumn(new RColumn(ctx, "PostingType", 17, "zz.PostingType", 125, null));
        }
        return rm;
    }

    private ArrayList<String> createKeyColumns() {
        ArrayList<String> columns = new ArrayList<String>();
        this.m_leadingColumns = 0;
        columns.add(this.sortBy1);
        if (!columns.contains(this.sortBy2)) {
            columns.add(this.sortBy2);
        }
        if (!columns.contains(this.sortBy3)) {
            columns.add(this.sortBy3);
        }
        if (!columns.contains(this.sortBy4)) {
            columns.add(this.sortBy4);
        }
        MAcctSchemaElement[] elements = this.ASchema.getAcctSchemaElements();
        int i = 0;
        while (i < elements.length) {
            MAcctSchemaElement ase;
            String columnName;
            if (this.m_leadingColumns == 0 && columns.contains("AD_Org_ID") && columns.contains("Account_ID")) {
                this.m_leadingColumns = columns.size();
            }
            if ((columnName = (ase = elements[i]).getColumnName()).startsWith("UserElement")) {
                if (columnName.indexOf(49) != -1) {
                    this.m_ref1 = ase.getDisplayColumnName();
                } else {
                    this.m_ref2 = ase.getDisplayColumnName();
                }
            }
            if (!columns.contains(columnName)) {
                columns.add(columnName);
            }
            ++i;
        }
        if (this.m_leadingColumns == 0 && columns.contains("AD_Org_ID") && columns.contains("Account_ID")) {
            this.m_leadingColumns = columns.size();
        }
        return columns;
    }
}

