/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.apps.form.WArchiveViewer;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.session.SessionManager;
import org.compiere.model.MArchive;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Menupopup;
import org.zkoss.zul.Popup;

public class WArchive
implements EventListener<Event> {
    private int m_AD_Table_ID;
    private int m_Record_ID;
    private Menupopup m_popup = new Menupopup();
    private Menuitem m_reports = null;
    private Menuitem m_reportsAll = null;
    private Menuitem m_documents = null;
    protected StringBuffer m_where = null;
    private static final CLogger log = CLogger.getCLogger(WArchive.class);

    public WArchive(Component invoker, int AD_Table_ID, int Record_ID) {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("AD_Table_ID=" + AD_Table_ID + ", Record_ID=" + Record_ID);
        }
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_Record_ID = Record_ID;
        this.getArchives(invoker);
    }

    private void getArchives(Component invoker) {
        Popup popup;
        int allReports;
        this.m_where = new StringBuffer();
        this.m_where.append("(AD_Table_ID=").append(this.m_AD_Table_ID).append(" AND Record_ID=").append(this.m_Record_ID).append(")");
        if (this.m_AD_Table_ID == 291) {
            this.m_where.append(" OR C_BPartner_ID=").append(this.m_Record_ID);
        }
        int[] counts = MArchive.getReportAndDocumentCountByRecordId((int)this.m_AD_Table_ID, (int)this.m_Record_ID, null);
        int reportCount = counts[0];
        int documentCount = counts[1];
        if (documentCount > 0) {
            this.m_documents = new Menuitem(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"ArchivedDocuments")) + " (" + documentCount + ")");
            this.m_documents.addEventListener("onClick", (EventListener)this);
            this.m_popup.appendChild((Component)this.m_documents);
        }
        if (reportCount > 0) {
            this.m_reports = new Menuitem(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"ArchivedReports")) + " (" + reportCount + ")");
            this.m_reports.addEventListener("onClick", (EventListener)this);
            this.m_popup.appendChild((Component)this.m_reports);
        }
        if ((allReports = MArchive.getReportCountByTableId((int)this.m_AD_Table_ID, null)) > 0) {
            this.m_reportsAll = new Menuitem(String.valueOf(Msg.getMsg((Properties)Env.getCtx(), (String)"ArchivedReportsAll")) + " (" + allReports + ")");
            this.m_reportsAll.addEventListener("onClick", (EventListener)this);
            this.m_popup.appendChild((Component)this.m_reportsAll);
        }
        if (documentCount == 0 && reportCount == 0 && allReports == 0) {
            this.m_popup.appendChild((Component)new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"ArchivedNone")));
        }
        if ((popup = LayoutUtils.findPopup(invoker)) != null) {
            popup.appendChild((Component)this.m_popup);
        } else {
            this.m_popup.setPage(invoker.getPage());
            LayoutUtils.autoDetachOnClose((Popup)this.m_popup);
        }
        this.m_popup.open(invoker, "after_start");
    }

    public void onEvent(Event e) throws Exception {
        if (e.getTarget() instanceof Menuitem) {
            int AD_Form_ID = 118;
            ADForm form = ADForm.openForm(AD_Form_ID);
            WArchiveViewer av = (WArchiveViewer)form.getICustomForm();
            av.setShowQuery(false);
            if (e.getTarget() == this.m_documents) {
                av.query(false, this.m_AD_Table_ID, this.m_Record_ID);
            } else if (e.getTarget() == this.m_reports) {
                av.query(true, this.m_AD_Table_ID, this.m_Record_ID);
            } else {
                av.query(true, this.m_AD_Table_ID, 0);
            }
            if (this.m_popup.getParent() instanceof Popup) {
                ((Popup)this.m_popup.getParent()).close();
            }
            form.setAttribute("mode", form.getWindowMode());
            SessionManager.getAppDesktop().showWindow(form);
        }
    }
}

