/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui;

import java.util.List;
import java.util.logging.Level;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Listbox;
import org.adempiere.webui.component.ListboxFactory;
import org.adempiere.webui.component.VerticalBox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.MAttachmentEntry;
import org.compiere.util.CLogger;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Iframe;
import org.zkoss.zul.Separator;

public class FedexLabelWindow
extends Window
implements EventListener<Event> {
    private static final long serialVersionUID = 8850485069628076246L;
    private List<MAttachmentEntry> images;
    private Listbox lbx;
    private Iframe content;
    private static final CLogger log = CLogger.getCLogger(FedexLabelWindow.class);

    public FedexLabelWindow(List<MAttachmentEntry> images) {
        this.images = images;
        this.init();
    }

    private void init() {
        this.setBorder("normal");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "730px");
        VerticalBox box = new VerticalBox();
        this.appendChild((Component)box);
        this.lbx = ListboxFactory.newDropdownListbox();
        for (MAttachmentEntry entry : this.images) {
            this.lbx.appendItem(entry.getName(), entry);
        }
        this.lbx.setSelectedIndex(0);
        this.lbx.addEventListener("onSelect", this);
        box.appendChild((Component)this.lbx);
        box.appendChild((Component)new Separator());
        this.content = new Iframe();
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this.content, "500px");
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.content, "700px");
        this.content.setId("content");
        this.content.setName(this.content.getUuid());
        box.appendChild((Component)this.content);
        ConfirmPanel panel = new ConfirmPanel(false);
        panel.addActionListener(this);
        Button btn = panel.createButton("Print");
        panel.addButton(btn);
        btn.addEventListener("onClick", this);
        box.appendChild((Component)new Separator());
        box.appendChild((Component)panel);
        try {
            this.loadContent();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void loadContent() throws Exception {
        MAttachmentEntry entry = (MAttachmentEntry)this.lbx.getSelectedItem().getValue();
        String name = entry.getName();
        name = name.substring(0, name.length() - 4);
        String imageName = String.valueOf(name) + ".png";
        MAttachmentEntry imageEntry = null;
        for (MAttachmentEntry i : this.images) {
            if (!i.getName().equals(imageName)) continue;
            imageEntry = i;
            break;
        }
        AMedia media = new AMedia(entry.getName(), null, imageEntry.getContentType(), imageEntry.getData());
        this.content.setContent((Media)media);
    }

    public void onEvent(Event event) throws Exception {
        if (event.getTarget().getId().equals("Ok")) {
            this.detach();
        } else if (event.getTarget() == this.lbx) {
            this.loadContent();
        } else if (event.getTarget().getId().equals("Print")) {
            this.content.focus();
            String script = "frames['" + this.content.getUuid() + "'].contentWindow.print()";
            if (Executions.getCurrent() != null) {
                Clients.response((AuResponse)new AuScript(script));
            }
        }
    }
}

