/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui;

import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.adempiere.util.Callback;
import org.adempiere.util.ServerContext;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.IWebClient;
import org.adempiere.webui.WLogin;
import org.adempiere.webui.apps.AEnv;
import org.adempiere.webui.component.DrillCommand;
import org.adempiere.webui.component.TokenCommand;
import org.adempiere.webui.component.ZoomCommand;
import org.adempiere.webui.desktop.DefaultDesktop;
import org.adempiere.webui.desktop.FavouriteController;
import org.adempiere.webui.desktop.IDesktop;
import org.adempiere.webui.session.SessionContextListener;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.BrowserToken;
import org.adempiere.webui.util.DesktopWatchDog;
import org.adempiere.webui.util.UserPreference;
import org.compiere.Adempiere;
import org.compiere.model.MRole;
import org.compiere.model.MSession;
import org.compiere.model.MSysConfig;
import org.compiere.model.MSystem;
import org.compiere.model.MTable;
import org.compiere.model.MUser;
import org.compiere.model.MUserPreference;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkforge.keylistener.Keylistener;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuScript;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.Session;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.ClientInfoEvent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.sys.DesktopCache;
import org.zkoss.zk.ui.sys.SessionCtrl;
import org.zkoss.zk.ui.sys.WebAppCtrl;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Style;
import org.zkoss.zul.Window;

public class AdempiereWebUI
extends Window
implements EventListener<Event>,
IWebClient {
    public static final String CHECK_AD_USER_ID_ATTR = "Check_AD_User_ID";
    public static final String DESKTOP_SESSION_INVALIDATED_ATTR = "DesktopSessionInvalidated";
    private static final long serialVersionUID = -6725805283410008847L;
    public static final String APPLICATION_DESKTOP_KEY = "application.desktop";
    public static String APP_NAME = null;
    public static final String UID = "1.0.0";
    public static final String WIDGET_INSTANCE_NAME = "instanceName";
    private WLogin loginDesktop;
    private ClientInfo clientInfo = new ClientInfo();
    private String langSession;
    private UserPreference userPreference;
    private MUserPreference userPreferences;
    private Keylistener keyListener;
    private static final CLogger logger = CLogger.getCLogger(AdempiereWebUI.class);
    @Deprecated(forRemoval=true, since="11")
    public static final String EXECUTION_CARRYOVER_SESSION_KEY = "execution.carryover";
    private static final String CLIENT_INFO = "client.info";
    private static boolean eventThreadEnabled = false;
    private ConcurrentMap<String, String[]> m_URLParameters;
    private static final String ON_LOGIN_COMPLETED = "onLoginCompleted";

    public AdempiereWebUI() {
        this.setVisible(false);
        this.userPreference = new UserPreference();
        this.m_URLParameters = new ConcurrentHashMap<String, String[]>(Executions.getCurrent().getParameterMap());
        this.addEventListener(ON_LOGIN_COMPLETED, this);
    }

    public void onCreate() {
        String ping = Executions.getCurrent().getHeader("X-PING");
        if (!Util.isEmpty((String)ping, (boolean)true)) {
            this.cleanupForPing();
            return;
        }
        this.getPage().setTitle(ThemeManager.getBrowserTitle());
        Executions.getCurrent().getDesktop().enableServerPush(true);
        SessionManager.setSessionApplication(this);
        Session session = Executions.getCurrent().getDesktop().getSession();
        Properties ctx = Env.getCtx();
        this.langSession = Env.getContext((Properties)ctx, (String)"#AD_Language");
        if (session.getAttribute("WebUISessionContext") == null || !SessionManager.isUserLoggedIn(ctx)) {
            this.loginDesktop = new WLogin(this);
            this.loginDesktop.createPart(this.getPage());
            this.loginDesktop.getComponent().getRoot().addEventListener("onClientInfo", (EventListener)this);
        } else {
            Clients.showBusy(null);
            if (session.getAttribute(CLIENT_INFO) != null) {
                this.clientInfo = (ClientInfo)session.getAttribute(CLIENT_INFO);
            }
            this.getRoot().addEventListener("onClientInfo", (EventListener)this);
            Events.echoEvent((String)ON_LOGIN_COMPLETED, (Component)this, null);
        }
        Executions.getCurrent().getDesktop().addListener((Object)new DrillCommand());
        Executions.getCurrent().getDesktop().addListener((Object)new TokenCommand());
        Executions.getCurrent().getDesktop().addListener((Object)new ZoomCommand());
        eventThreadEnabled = Executions.getCurrent().getDesktop().getWebApp().getConfiguration().isEventThreadEnabled();
    }

    private void cleanupForPing() {
        Desktop desktop = Executions.getCurrent().getDesktop();
        WebApp wapp = desktop.getWebApp();
        DesktopCache desktopCache = ((WebAppCtrl)wapp).getDesktopCache(desktop.getSession());
        Session session = desktop.getSession();
        Env.getCtx().clear();
        Adempiere.getThreadPoolExecutor().schedule(() -> {
            try {
                ((SessionCtrl)session).invalidateNow();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                if (desktopCache.getDesktopIfAny(desktop.getId()) != null) {
                    desktop.setAttribute(DESKTOP_SESSION_INVALIDATED_ATTR, (Object)Boolean.TRUE);
                    desktopCache.removeDesktop(desktop);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }, 1L, TimeUnit.SECONDS);
    }

    public void onOk() {
    }

    public void onCancel() {
    }

    @Override
    public void loginCompleted() {
        Properties ctx;
        String langLogin;
        if (this.loginDesktop != null) {
            this.loginDesktop.getComponent().getRoot().removeEventListener("onClientInfo", (EventListener)this);
            this.loginDesktop.detach();
            this.loginDesktop = null;
        }
        if ((langLogin = Env.getContext((Properties)(ctx = Env.getCtx()), (String)"#AD_Language")) == null || langLogin.length() <= 0) {
            langLogin = this.langSession;
            Env.setContext((Properties)ctx, (String)"#AD_Language", (String)this.langSession);
        }
        MSystem system = MSystem.get((Properties)Env.getCtx());
        Env.setContext((Properties)ctx, (String)"#System_Name", (String)system.getName());
        Language language = Language.getLanguage((String)langLogin);
        String locale = Env.getContext((Properties)ctx, (String)"#Locale");
        if (locale != null && locale.length() > 0 && !language.getLocale().toString().equals(locale)) {
            String adLanguage = language.getAD_Language();
            Language tmp = Language.getLanguage((String)locale);
            language = new Language(tmp.getName(), adLanguage, tmp.getLocale(), Boolean.valueOf(tmp.isDecimalPoint()), tmp.getDateFormat().toPattern(), tmp.getMediaSize());
        } else {
            Language tmp = language;
            language = new Language(tmp.getName(), tmp.getAD_Language(), tmp.getLocale(), Boolean.valueOf(tmp.isDecimalPoint()), tmp.getDateFormat().toPattern(), tmp.getMediaSize());
        }
        Env.verifyLanguage((Properties)ctx, (Language)language);
        Env.setContext((Properties)ctx, (String)"#AD_Language", (String)language.getAD_Language());
        StringBuilder calendarMsgScript = new StringBuilder();
        String monthMore = Msg.getMsg((Properties)ctx, (String)"more");
        String dayMore = Msg.getMsg((Properties)ctx, (String)"more");
        calendarMsgScript.append("function _overrideMsgCal() { msgcal.monthMORE = '+{0} ").append(monthMore).append("';");
        calendarMsgScript.append("msgcal.dayMORE = '+{0} ").append(dayMore).append("'; }");
        AuScript auscript = new AuScript(calendarMsgScript.toString());
        Clients.response((AuResponse)auscript);
        Session currSess = Executions.getCurrent().getDesktop().getSession();
        HttpSession httpSess = (HttpSession)currSess.getNativeSession();
        String x_Forward_IP = Executions.getCurrent().getHeader("X-Forwarded-For");
        MSession mSession = MSession.get((Properties)ctx, (String)(x_Forward_IP != null ? x_Forward_IP : Executions.getCurrent().getRemoteAddr()), (String)Executions.getCurrent().getRemoteHost(), (String)httpSess.getId());
        if (this.clientInfo.userAgent != null) {
            mSession.setDescription(String.valueOf(mSession.getDescription()) + "\n" + this.clientInfo.toString());
            mSession.saveEx();
        }
        currSess.setAttribute(CHECK_AD_USER_ID_ATTR, (Object)Env.getAD_User_ID((Properties)ctx));
        Env.setContext((Properties)ctx, (String)"#ShowTrl", (boolean)true);
        Env.setContext((Properties)ctx, (String)"#ShowAcct", (boolean)MRole.getDefault().isShowAcct());
        this.userPreference = this.loadUserPreference(Env.getAD_User_ID((Properties)ctx));
        this.userPreferences = MUserPreference.getUserPreference((int)Env.getAD_User_ID((Properties)ctx), (int)Env.getAD_Client_ID((Properties)ctx));
        this.userPreferences.fillPreferences();
        this.keyListener = new Keylistener();
        this.keyListener.setPage(this.getPage());
        this.keyListener.setCtrlKeys("@a@c@d@e@f@h@l@m@n@o@p@q@r@s@t@w@x@z@#left@#right@#up@#down@#home@#end#enter^u@u@#pgdn@#pgup$#f2^#f2");
        this.keyListener.setAutoBlur(false);
        IDesktop appDesktop = this.createDesktop();
        appDesktop.setClientInfo(this.clientInfo);
        appDesktop.createPart(this.getPage());
        this.getPage().getDesktop().setAttribute(APPLICATION_DESKTOP_KEY, new WeakReference<IDesktop>(appDesktop));
        appDesktop.getComponent().getRoot().addEventListener("onClientInfo", (EventListener)this);
        SessionContextListener.addDesktopId(mSession.getAD_Session_ID(), this.getPage().getDesktop().getId());
        if (!this.getPage().getDesktop().isServerPushEnabled()) {
            this.getPage().getDesktop().enableServerPush(true);
        }
        currSess.setAttribute("WebUISessionContext", (Object)ServerContext.getCurrentInstance());
        MUser user = MUser.get((Properties)ctx);
        BrowserToken.save(mSession, user);
        Env.setContext((Properties)ctx, (String)"#UIClient", (String)"zk");
        Env.setContext((Properties)ctx, (String)"#DBType", (String)DB.getDatabase().getName());
        StringBuilder localHttpAddr = new StringBuilder(Executions.getCurrent().getScheme());
        localHttpAddr.append("://").append(Executions.getCurrent().getLocalAddr());
        int port = Executions.getCurrent().getLocalPort();
        if (port > 0 && port != 80) {
            localHttpAddr.append(":").append(port);
        }
        Env.setContext((Properties)ctx, (String)"#LocalHttpAddr", (String)localHttpAddr.toString());
        Env.setContext((Properties)ctx, (String)"#IsCanApproveOwnDoc", (boolean)MRole.getDefault().isCanApproveOwnDoc());
        Clients.response((AuResponse)new AuScript("zAu.cmd0.clearBusy()"));
        StringBuilder cssContent = new StringBuilder();
        cssContent.append(".adtab-form-borderlayout .z-south-collapsed:before { ");
        cssContent.append("content: \"");
        cssContent.append(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Detail")));
        cssContent.append("\"; ");
        cssContent.append("} ");
        Style style = new Style();
        style.setContent(cssContent.toString());
        this.appendChild((Component)style);
        FavouriteController.getInstance(currSess);
        this.processParameters();
    }

    private void processParameters() {
        String action = this.getPrmString("Action");
        if ("Zoom".equalsIgnoreCase(action)) {
            MTable table;
            String tableName;
            int tableID = this.getPrmInt("AD_Table_ID");
            if (tableID == 0 && !Util.isEmpty((String)(tableName = this.getPrmString("TableName"))) && (table = MTable.get((Properties)Env.getCtx(), (String)tableName)) != null) {
                tableID = table.getAD_Table_ID();
            }
            int recordID = this.getPrmInt("Record_ID");
            if (tableID > 0) {
                AEnv.zoom(tableID, recordID);
            }
        }
        this.m_URLParameters = null;
    }

    private String getPrmString(String prm) {
        String[] strs;
        String retValue = "";
        if (this.m_URLParameters != null && (strs = (String[])this.m_URLParameters.get(prm)) != null && strs.length == 1 && strs[0] != null) {
            retValue = strs[0];
        }
        return retValue;
    }

    private int getPrmInt(String prm) {
        int retValue = 0;
        String str = this.getPrmString(prm);
        try {
            if (!Util.isEmpty((String)str)) {
                retValue = Integer.parseInt(str);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return retValue;
    }

    @Override
    public Keylistener getKeylistener() {
        return this.keyListener;
    }

    private IDesktop createDesktop() {
        IDesktop appDesktop = null;
        String className = MSysConfig.getValue((String)"ZK_DESKTOP_CLASS");
        if (className != null && className.trim().length() > 0) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
                appDesktop = (IDesktop)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable t) {
                logger.warning("Failed to instantiate desktop. Class=" + className);
            }
        }
        if (appDesktop == null) {
            appDesktop = new DefaultDesktop();
        }
        return appDesktop;
    }

    @Override
    public void logout() {
        Desktop desktop = Executions.getCurrent().getDesktop();
        WebApp wapp = desktop.getWebApp();
        DesktopCache desktopCache = ((WebAppCtrl)wapp).getDesktopCache(desktop.getSession());
        Session session = this.logout0();
        Env.getCtx().clear();
        this.afterLogout(session);
        desktop.setAttribute(DESKTOP_SESSION_INVALIDATED_ATTR, (Object)Boolean.TRUE);
        Executions.sendRedirect((String)"index.zul");
        try {
            desktopCache.removeDesktop(desktop);
            DesktopWatchDog.removeDesktop(desktop);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void afterLogout(Session session) {
        try {
            ((SessionCtrl)session).onDestroyed();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        ((SessionCtrl)session).invalidateNow();
    }

    @Override
    public void logoutAfterTabDestroyed() {
        Desktop desktop = Executions.getCurrent().getDesktop();
        DesktopWatchDog.removeDesktop(desktop);
        Session session = this.logout0();
        Env.getCtx().clear();
        SessionCtrl ctrl = (SessionCtrl)session;
        if (!ctrl.isInvalidated() && session.getNativeSession() != null) {
            this.afterLogout(session);
        }
    }

    protected Session logout0() {
        IDesktop appDesktop;
        Session session;
        Session session2 = session = Executions.getCurrent() != null ? Executions.getCurrent().getDesktop().getSession() : null;
        if (this.keyListener != null) {
            this.keyListener.detach();
            this.keyListener = null;
        }
        if ((appDesktop = this.getAppDeskop()) != null) {
            appDesktop.logout();
        }
        this.getChildren().clear();
        this.getPage().removeComponents();
        if (session != null) {
            session.getAttributes().clear();
        }
        AEnv.logout();
        return session;
    }

    @Override
    public IDesktop getAppDeskop() {
        WeakReference ref;
        Desktop desktop = Executions.getCurrent() != null ? Executions.getCurrent().getDesktop() : null;
        IDesktop appDesktop = null;
        if (desktop != null && (ref = (WeakReference)desktop.getAttribute(APPLICATION_DESKTOP_KEY)) != null) {
            appDesktop = (IDesktop)ref.get();
        }
        return appDesktop;
    }

    public void onEvent(Event event) {
        if (event instanceof ClientInfoEvent) {
            IDesktop appDesktop;
            String ua;
            ClientInfoEvent c = (ClientInfoEvent)event;
            this.clientInfo = new ClientInfo();
            this.clientInfo.colorDepth = c.getColorDepth();
            this.clientInfo.screenHeight = c.getScreenHeight();
            this.clientInfo.screenWidth = c.getScreenWidth();
            this.clientInfo.devicePixelRatio = c.getDevicePixelRatio();
            this.clientInfo.desktopHeight = c.getDesktopHeight();
            this.clientInfo.desktopWidth = c.getDesktopWidth();
            this.clientInfo.desktopXOffset = c.getDesktopXOffset();
            this.clientInfo.desktopYOffset = c.getDesktopYOffset();
            this.clientInfo.orientation = c.getOrientation();
            this.clientInfo.timeZone = TimeZone.getTimeZone(c.getZoneId());
            this.clientInfo.userAgent = ua = Servlets.getUserAgent((ServletRequest)((ServletRequest)Executions.getCurrent().getNativeRequest()));
            ua = ua.toLowerCase();
            this.clientInfo.tablet = false;
            if (Executions.getCurrent().getBrowser("mobile") != null) {
                this.clientInfo.tablet = true;
            } else if (ua.contains("ipad") || ua.contains("iphone") || ua.contains("android")) {
                this.clientInfo.tablet = true;
            }
            if (this.getDesktop() != null && this.getDesktop().getSession() != null) {
                this.getDesktop().getSession().setAttribute(CLIENT_INFO, (Object)this.clientInfo);
            } else if (Executions.getCurrent() != null) {
                Executions.getCurrent().getSession().setAttribute(CLIENT_INFO, (Object)this.clientInfo);
            }
            Env.setContext((Properties)Env.getCtx(), (String)"#clientInfo_desktopWidth", (int)this.clientInfo.desktopWidth);
            Env.setContext((Properties)Env.getCtx(), (String)"#clientInfo_desktopHeight", (int)this.clientInfo.desktopHeight);
            Env.setContext((Properties)Env.getCtx(), (String)"#clientInfo_orientation", (String)this.clientInfo.orientation);
            Env.setContext((Properties)Env.getCtx(), (String)"#clientInfo_mobile", (boolean)this.clientInfo.tablet);
            if (this.clientInfo.timeZone != null) {
                Env.setContext((Properties)Env.getCtx(), (String)"#clientInfo_timeZone", (String)this.clientInfo.timeZone.getID());
            }
            if ((appDesktop = this.getAppDeskop()) != null) {
                appDesktop.setClientInfo(this.clientInfo);
            }
        } else if (event.getName().equals(ON_LOGIN_COMPLETED)) {
            this.loginCompleted();
        }
    }

    private void onChangeRole(Locale locale, Properties context) {
        SessionManager.setSessionApplication(this);
        this.loginDesktop = new WLogin(this);
        this.loginDesktop.createPart(this.getPage());
        this.loginDesktop.changeRole(locale, context);
        this.loginDesktop.getComponent().getRoot().addEventListener("onClientInfo", (EventListener)this);
    }

    @Override
    public UserPreference loadUserPreference(int userId) {
        this.userPreference.loadPreference(userId);
        return this.userPreference;
    }

    @Override
    public UserPreference getUserPreference() {
        return this.userPreference;
    }

    public static boolean isEventThreadEnabled() {
        return eventThreadEnabled;
    }

    @Override
    public void changeRole(MUser user) {
        Properties properties = new Properties();
        Env.setContext((Properties)properties, (String)"#AD_Client_ID", (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
        Env.setContext((Properties)properties, (String)"#AD_Client_Name", (String)Env.getContext((Properties)Env.getCtx(), (String)"#AD_Client_Name"));
        Env.setContext((Properties)properties, (String)"#AD_Org_ID", (int)Env.getAD_Org_ID((Properties)Env.getCtx()));
        Env.setContext((Properties)properties, (String)"#AD_User_ID", (int)user.getAD_User_ID());
        Env.setContext((Properties)properties, (String)"#SalesRep_ID", (int)user.getAD_User_ID());
        Env.setContext((Properties)properties, (String)"#AD_User_Name", (String)Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"));
        Env.setContext((Properties)properties, (String)"#AD_Role_ID", (int)Env.getAD_Role_ID((Properties)Env.getCtx()));
        Env.setContext((Properties)properties, (String)"#AD_Role_Name", (String)Env.getContext((Properties)Env.getCtx(), (String)"#AD_Role_Name"));
        Env.setContext((Properties)properties, (String)"#AD_Role_Type", (String)Env.getContext((Properties)Env.getCtx(), (String)"#AD_Role_Type"));
        Env.setContext((Properties)properties, (String)"#IsClientAdmin", (String)Env.getContext((Properties)Env.getCtx(), (String)"#IsClientAdmin"));
        Env.setContext((Properties)properties, (String)"#User_Level", (String)Env.getContext((Properties)Env.getCtx(), (String)"#User_Level"));
        Env.setContext((Properties)properties, (String)"#AD_Org_Name", (String)Env.getContext((Properties)Env.getCtx(), (String)"#AD_Org_Name"));
        Env.setContext((Properties)properties, (String)"#M_Warehouse_ID", (String)Env.getContext((Properties)Env.getCtx(), (String)"#M_Warehouse_ID"));
        Env.setContext((Properties)properties, (String)"#LanguageName", (String)Env.getContext((Properties)Env.getCtx(), (String)"#LanguageName"));
        Env.setContext((Properties)properties, (String)"#AD_Language", (String)Env.getContext((Properties)Env.getCtx(), (String)"#AD_Language"));
        Env.setContext((Properties)properties, (String)"#Locale", (String)Env.getContext((Properties)Env.getCtx(), (String)"#Locale"));
        Env.setContext((Properties)properties, (String)"#ZK_Toolbar_Button_Size", (String)Env.getContext((Properties)Env.getCtx(), (String)"#ZK_Toolbar_Button_Size"));
        Env.setContext((Properties)properties, (String)"#THEME_USE_CSS_FOR_WINDOW_SIZE", (String)Env.getContext((Properties)Env.getCtx(), (String)"#THEME_USE_CSS_FOR_WINDOW_SIZE"));
        Env.setContext((Properties)properties, (String)"#THEME_USE_FONT_ICON_FOR_IMAGE", (String)Env.getContext((Properties)Env.getCtx(), (String)"#THEME_USE_FONT_ICON_FOR_IMAGE"));
        Env.setContext((Properties)properties, (String)"#clientInfo_desktopWidth", (int)this.clientInfo.desktopWidth);
        Env.setContext((Properties)properties, (String)"#clientInfo_desktopHeight", (int)this.clientInfo.desktopHeight);
        Env.setContext((Properties)properties, (String)"#clientInfo_orientation", (String)this.clientInfo.orientation);
        Env.setContext((Properties)properties, (String)"#clientInfo_mobile", (boolean)this.clientInfo.tablet);
        Env.setContext((Properties)properties, (String)"#clientInfo_timeZone", (String)this.clientInfo.timeZone.getID());
        Desktop desktop = Executions.getCurrent().getDesktop();
        Locale locale = (Locale)desktop.getSession().getAttribute("org.zkoss.web.preferred.locale");
        HttpServletRequest httpRequest = (HttpServletRequest)Executions.getCurrent().getNativeRequest();
        Env.setContext((Properties)properties, (String)"servlet.sessionId", (String)httpRequest.getSession().getId());
        if (Env.getCtx().get("SERVER_CONTEXT_URL_HANDLER") != null) {
            properties.put("SERVER_CONTEXT_URL_HANDLER", Env.getCtx().get("SERVER_CONTEXT_URL_HANDLER"));
        }
        IDesktop appDesktop = this.getAppDeskop();
        HttpSession session = httpRequest.getSession();
        if (appDesktop != null) {
            appDesktop.logout((Callback<Boolean>)((Callback)T -> {
                if (T.booleanValue()) {
                    this.asyncChangeRole(session, locale, properties);
                }
            }));
        }
    }

    private void asyncChangeRole(HttpSession httpSession, Locale locale, Properties properties) {
        if (this.keyListener != null) {
            this.keyListener.detach();
            this.keyListener = null;
        }
        this.getChildren().clear();
        Page page = this.getPage();
        page.removeComponents();
        this.setPage(page);
        Enumeration attributes = httpSession.getAttributeNames();
        while (attributes.hasMoreElements()) {
            String attribute = (String)attributes.nextElement();
            if (attribute.contains("zkoss.")) continue;
            httpSession.removeAttribute(attribute);
        }
        AEnv.logout();
        this.onChangeRole(locale, properties);
    }

    @Override
    public ClientInfo getClientInfo() {
        return this.clientInfo;
    }

    public static String getUploadSetting() {
        StringBuilder uploadSetting = new StringBuilder("true,native");
        int size = MSysConfig.getIntValue((String)"ZK_MAX_UPLOAD_SIZE", (int)0);
        if (size > 0) {
            uploadSetting.append(",maxsize=").append(size);
        }
        return uploadSetting.toString();
    }
}

