/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.passay.dictionary.Dictionary;

public class JDBCDictionary
implements Dictionary {
    protected DataSource dataSource;
    protected String searchStatement;
    protected String sizeStatement;

    public JDBCDictionary(DataSource source, String searchSql, String sizeSql) {
        this.dataSource = source;
        this.searchStatement = searchSql;
        this.sizeStatement = sizeSql;
    }

    @Override
    public boolean search(String word) {
        try {
            return this.executeStatement(this.searchStatement, String.class, word) != null;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error executing SQL", e);
        }
    }

    @Override
    public long size() {
        try {
            return this.executeStatement(this.sizeStatement, Long.class, null);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error executing SQL", e);
        }
    }

    protected <T> T executeStatement(String statement, Class<T> type, Object ... params) throws SQLException {
        block22: {
            try (Connection c = this.getConnection();){
                PreparedStatement stmt = c.prepareStatement(statement);
                if (params != null && params.length > 0) {
                    for (int i = 0; i < params.length; ++i) {
                        stmt.setObject(i + 1, params[i]);
                    }
                }
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) break block22;
                T t = rs.getObject(1, type);
                return t;
                {
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
            }
        }
        return null;
    }

    protected Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }
}

