/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.webui.apps.form;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.webui.component.Checkbox;
import org.adempiere.webui.component.Column;
import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Grid;
import org.adempiere.webui.component.GridFactory;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Row;
import org.adempiere.webui.component.Rows;
import org.adempiere.webui.component.Textbox;
import org.adempiere.webui.editor.WSearchEditor;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.panel.ADForm;
import org.adempiere.webui.panel.CustomForm;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.Dialog;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MSysConfig;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Borderlayout;
import org.zkoss.zul.Center;
import org.zkoss.zul.Columns;
import org.zkoss.zul.South;

public class JPiereResetPassword
implements IFormController,
EventListener<Event>,
ValueChangeListener {
    private static CLogger log = CLogger.getCLogger(JPiereResetPassword.class);
    private CustomForm form = new CustomForm();
    private Grid gridPanel;
    private ConfirmPanel confirmPanel;
    private Label lblUser;
    private Label lblOldPassword;
    private Label lblNewPassword;
    private Label lblRetypeNewPassword;
    private Label lblNewEMail;
    private Label lblNewEMailUser;
    private Label lblNewEMailUserPW;
    private Label lblRetypeNewEMailPW;
    private WSearchEditor fUser;
    private Textbox txtOldPassword;
    private Textbox txtNewPassword;
    private Textbox txtRetypeNewPassword;
    private Checkbox cbForceChangeNextLogin;
    private Textbox txtNewEMail;
    private Textbox txtNewEMailUser;
    private Textbox txtNewEMailUserPW;
    private Textbox txtRetypeNewEMailPW;

    public JPiereResetPassword() {
        try {
            this.dynInit();
            this.zkInit();
            Borderlayout contentPane = new Borderlayout();
            this.form.appendChild((Component)contentPane);
            ZKUpdateUtil.setWidth((HtmlBasedComponent)contentPane, (String)"99%");
            ZKUpdateUtil.setHeight((HtmlBasedComponent)contentPane, (String)"100%");
            Center center = new Center();
            center.setStyle("border: none");
            contentPane.appendChild((Component)center);
            ZKUpdateUtil.setHflex((HtmlBasedComponent)this.gridPanel, (String)"true");
            ZKUpdateUtil.setVflex((HtmlBasedComponent)this.gridPanel, (String)"true");
            center.appendChild((Component)this.gridPanel);
            South south = new South();
            south.setStyle("border: none");
            contentPane.appendChild((Component)south);
            south.appendChild((Component)this.confirmPanel);
            this.confirmPanel.addActionListener((EventListener)this);
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "init", (Throwable)ex);
        }
    }

    private void dynInit() throws Exception {
        this.lblUser = new Label(Msg.translate((Properties)Env.getCtx(), (String)"AD_User_ID"));
        this.lblOldPassword = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"Old Password"));
        this.lblNewPassword = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"New Password"));
        this.lblRetypeNewPassword = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"New Password Confirm"));
        this.lblNewEMail = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"New EMail"));
        this.lblNewEMailUser = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"New EMail User"));
        this.lblNewEMailUserPW = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"New EMail User Password"));
        this.lblRetypeNewEMailPW = new Label(Msg.getMsg((Properties)Env.getCtx(), (String)"New EMail PW Confirm"));
        MLookup userLkp = MLookupFactory.get((Properties)Env.getCtx(), (int)this.form.getWindowNo(), (int)0, (int)212, (int)30);
        this.fUser = new WSearchEditor("AD_User_ID", false, false, true, (Lookup)userLkp);
        this.fUser.setReadWrite(false);
        this.fUser.setValue((Object)Env.getAD_User_ID((Properties)Env.getCtx()));
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.fUser.getComponent(), (String)"220px");
        this.txtOldPassword = new Textbox();
        this.txtOldPassword.setId("txtOldPassword");
        this.txtOldPassword.setType("password");
        this.txtOldPassword.setCols(25);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtOldPassword, (String)"220px");
        this.txtNewPassword = new Textbox();
        this.txtNewPassword.setId("txtNewPassword");
        this.txtNewPassword.setType("password");
        this.txtNewPassword.setCols(25);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtNewPassword, (String)"220px");
        this.txtRetypeNewPassword = new Textbox();
        this.txtRetypeNewPassword.setId("txtRetypeNewPassword");
        this.txtRetypeNewPassword.setType("password");
        this.txtRetypeNewPassword.setCols(25);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtRetypeNewPassword, (String)"220px");
        this.cbForceChangeNextLogin = new Checkbox();
        this.cbForceChangeNextLogin.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"ForceChangeOnNextLogin"));
        this.cbForceChangeNextLogin.setChecked(false);
        this.txtNewEMail = new Textbox();
        this.txtNewEMail.setId("txtNewEMail");
        this.txtNewEMail.setCols(25);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtNewEMail, (String)"220px");
        this.txtNewEMailUser = new Textbox();
        this.txtNewEMailUser.setId("txtNewEMailUser");
        this.txtNewEMailUser.setCols(25);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtNewEMailUser, (String)"220px");
        this.txtNewEMailUserPW = new Textbox();
        this.txtNewEMailUserPW.setId("txtNewEMailUserPW");
        this.txtNewEMailUserPW.setType("password");
        this.txtNewEMailUserPW.setCols(25);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtNewEMailUserPW, (String)"220px");
        this.txtRetypeNewEMailPW = new Textbox();
        this.txtRetypeNewEMailPW.setId("txtRetypeNewEMail");
        this.txtRetypeNewEMailPW.setType("password");
        this.txtRetypeNewEMailPW.setCols(25);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.txtRetypeNewEMailPW, (String)"220px");
        this.confirmPanel = new ConfirmPanel(true);
    }

    private void zkInit() throws Exception {
        this.gridPanel = GridFactory.newGridLayout();
        Columns columns = new Columns();
        this.gridPanel.appendChild((Component)columns);
        Column column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, (String)"40%");
        column = new Column();
        columns.appendChild((Component)column);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)column, (String)"60%");
        Rows rows = new Rows();
        this.gridPanel.appendChild((Component)rows);
        Row row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(this.lblUser.rightAlign());
        row.appendChild((Component)this.fUser.getComponent());
        this.fUser.addValueChangeListener((ValueChangeListener)this);
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(this.lblOldPassword.rightAlign());
        row.appendChild((Component)this.txtOldPassword);
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(this.lblNewPassword.rightAlign());
        row.appendChild((Component)this.txtNewPassword);
        row = new Row();
        rows.appendChild((Component)row);
        row.appendChild(this.lblRetypeNewPassword.rightAlign());
        row.appendChild((Component)this.txtRetypeNewPassword);
    }

    public void valueChange(ValueChangeEvent e) {
        log.info(String.valueOf(e.getPropertyName()) + "=" + e.getNewValue());
        if (e.getPropertyName().equals("AD_User_ID")) {
            this.fUser.setValue(e.getNewValue());
        }
    }

    public void onEvent(Event e) throws Exception {
        if (e.getTarget().getId().equals("Cancel")) {
            SessionManager.getAppDesktop().closeActiveWindow();
            return;
        }
        if (e.getTarget().getId().equals("Ok")) {
            this.validateChangePassword();
        }
    }

    private void validateChangePassword() {
        int p_AD_User_ID = -1;
        if (this.fUser.getValue() != null) {
            p_AD_User_ID = Integer.parseInt(this.fUser.getValue().toString());
        }
        if (p_AD_User_ID < 0) {
            throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"UserMandatory"));
        }
        String p_OldPassword = this.txtOldPassword.getValue();
        String p_NewPassword = this.txtNewPassword.getValue();
        String p_NewPasswordConfirm = this.txtRetypeNewPassword.getValue();
        String p_NewEMail = this.txtNewEMail.getValue();
        String p_NewEMailConfirm = this.txtRetypeNewEMailPW.getValue();
        String p_NewEMailUser = this.txtNewEMailUser.getValue();
        String p_NewEMailUserPW = this.txtNewEMailUserPW.getValue();
        MUser user = new MUser(Env.getCtx(), p_AD_User_ID, null);
        if (log.isLoggable(Level.FINE)) {
            log.fine("User=" + user);
        }
        if (Util.isEmpty((String)p_OldPassword)) {
            MUser operator = MUser.get((Properties)Env.getCtx(), (int)Env.getAD_User_ID((Properties)Env.getCtx()));
            if (log.isLoggable(Level.FINE)) {
                log.fine("Operator=" + operator);
            }
            if (p_AD_User_ID == 0 || p_AD_User_ID == 100 || !operator.isAdministrator()) {
                throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"OldPasswordMandatory"));
            }
        } else {
            boolean hash_password = MSysConfig.getBooleanValue((String)"USER_PASSWORD_HASH", (boolean)false);
            if (hash_password ? !user.authenticateHash(p_OldPassword) : !p_OldPassword.equals(user.getPassword())) {
                throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"OldPasswordNoMatch"));
            }
            if (MSysConfig.getBooleanValue((String)"CHANGE_PASSWORD_MUST_DIFFER", (boolean)true) && p_OldPassword.equals(p_NewPassword)) {
                throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"NewPasswordMustDiffer"));
            }
        }
        if (!Util.isEmpty((String)p_NewPassword)) {
            if (Util.isEmpty((String)p_NewPasswordConfirm)) {
                throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"NewPasswordConfirmMandatory"));
            }
            if (!p_NewPassword.equals(p_NewPasswordConfirm)) {
                throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"PasswordNotMatch"));
            }
        }
        if (!Util.isEmpty((String)p_NewEMailUserPW)) {
            if (Util.isEmpty((String)p_NewEMailConfirm)) {
                throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"NewEmailConfirmMandatory"));
            }
            if (!p_NewEMailUserPW.equals(p_NewEMailConfirm)) {
                throw new IllegalArgumentException(Msg.getMsg((Properties)Env.getCtx(), (String)"NewEmailNotMatch"));
            }
        }
        if (!Util.isEmpty((String)p_NewPassword)) {
            user.set_ValueOfColumn("Password", (Object)p_NewPassword);
        }
        if (!Util.isEmpty((String)p_NewEMail)) {
            user.setEMail(p_NewEMail);
        }
        if (!Util.isEmpty((String)p_NewEMailUser)) {
            user.setEMailUser(p_NewEMailUser);
        }
        if (!Util.isEmpty((String)p_NewEMailUserPW)) {
            user.setEMailUserPW(p_NewEMailUserPW);
        }
        if (this.cbForceChangeNextLogin.isChecked()) {
            user.setIsExpired(true);
        }
        try {
            user.saveEx();
        }
        catch (AdempiereException e) {
            user.load(user.get_TrxName(), new String[0]);
            throw e;
        }
        this.clearForm();
        Dialog.info((int)this.form.getWindowNo(), (String)"RecordSaved");
    }

    private void clearForm() {
        this.txtOldPassword.setValue(null);
        this.txtNewPassword.setValue(null);
        this.txtRetypeNewPassword.setValue(null);
        this.txtNewEMail.setValue(null);
        this.txtRetypeNewEMailPW.setValue(null);
        this.txtNewEMailUser.setValue(null);
        this.txtNewEMailUserPW.setValue(null);
    }

    public ADForm getForm() {
        return this.form;
    }
}

