/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.webui.apps.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.apps.IStatusBar;
import org.compiere.grid.CreateFrom;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MCurrency;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrderPaySchedule;
import org.compiere.model.MProduct;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MUOMConversion;
import org.compiere.model.PO;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public abstract class JPiereCreateFromInvoice
extends CreateFrom {
    public JPiereCreateFromInvoice(GridTab mTab) {
        super(mTab);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(mTab.toString());
        }
    }

    public boolean dynInit() throws Exception {
        this.log.config("");
        this.setTitle(String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"C_Invoice_ID", (boolean)this.isSOTrx)) + " .. " + Msg.translate((Properties)Env.getCtx(), (String)"CreateFrom"));
        return true;
    }

    protected ArrayList<KeyNamePair> loadShipmentData(int C_BPartner_ID) {
        ArrayList<KeyNamePair> list;
        block8: {
            String isSOTrxParam = this.isSOTrx ? "Y" : "N";
            list = new ArrayList<KeyNamePair>();
            StringBuffer display = new StringBuffer("s.DocumentNo||' - '||").append(DB.TO_CHAR((String)"s.MovementDate", (int)15, (String)Env.getAD_Language((Properties)Env.getCtx())));
            StringBuffer sql = new StringBuffer("SELECT s.M_InOut_ID,").append(display).append(" FROM M_InOut s WHERE s.C_BPartner_ID=? AND s.IsSOTrx=? AND s.DocStatus IN ('CL','CO') AND s.M_InOut_ID IN (SELECT sl.M_InOut_ID FROM M_InOutLine sl");
            if (!this.isSOTrx) {
                sql.append(" LEFT OUTER JOIN M_MatchInv mi ON (sl.M_InOutLine_ID=mi.M_InOutLine_ID)  JOIN M_InOut s2 ON (sl.M_InOut_ID=s2.M_InOut_ID)  WHERE s2.C_BPartner_ID=? AND s2.IsSOTrx=? AND s2.DocStatus IN ('CL','CO')  GROUP BY sl.M_InOut_ID,sl.MovementQty,mi.M_InOutLine_ID HAVING (sl.MovementQty<>SUM(mi.Qty) AND mi.M_InOutLine_ID IS NOT NULL) OR mi.M_InOutLine_ID IS NULL ");
            } else {
                sql.append(" INNER JOIN M_InOut s2 ON (sl.M_InOut_ID=s2.M_InOut_ID) LEFT JOIN C_InvoiceLine il ON sl.M_InOutLine_ID = il.M_InOutLine_ID WHERE s2.C_BPartner_ID=? AND s2.IsSOTrx=? AND s2.DocStatus IN ('CL','CO') GROUP BY sl.M_InOutLine_ID HAVING sl.MovementQty - sum(COALESCE(il.QtyInvoiced,0)) <> 0");
            }
            sql.append(") ORDER BY s.MovementDate");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setInt(1, C_BPartner_ID);
                    pstmt.setString(2, isSOTrxParam);
                    pstmt.setInt(3, C_BPartner_ID);
                    pstmt.setString(4, isSOTrxParam);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    protected ArrayList<KeyNamePair> loadRMAData(int C_BPartner_ID) {
        ArrayList<KeyNamePair> list;
        block6: {
            list = new ArrayList<KeyNamePair>();
            String sqlStmt = "SELECT r.M_RMA_ID, r.DocumentNo || '-' || r.Amt from M_RMA r WHERE ISSOTRX='N' AND r.DocStatus in ('CO', 'CL') AND r.C_BPartner_ID=? AND NOT EXISTS (SELECT * FROM C_Invoice inv WHERE inv.M_RMA_ID=r.M_RMA_ID AND inv.DocStatus IN ('CO', 'CL'))";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sqlStmt, null);
                    pstmt.setInt(1, C_BPartner_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return list;
    }

    protected Vector<Vector<Object>> getShipmentData(int M_InOut_ID) {
        Vector<Vector<Object>> data;
        block19: {
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("M_InOut_ID=" + M_InOut_ID);
            }
            MInOut inout = new MInOut(Env.getCtx(), M_InOut_ID, null);
            this.p_order = null;
            if (inout.getC_Order_ID() != 0) {
                this.p_order = new MOrder(Env.getCtx(), inout.getC_Order_ID(), null);
            }
            this.m_rma = null;
            if (inout.getM_RMA_ID() != 0) {
                this.m_rma = new MRMA(Env.getCtx(), inout.getM_RMA_ID(), null);
            }
            data = new Vector<Vector<Object>>();
            StringBuilder sql = new StringBuilder("SELECT ");
            if (!this.isSOTrx) {
                sql.append("l.MovementQty-SUM(COALESCE(mi.Qty, 0)),");
            } else {
                sql.append("l.MovementQty-SUM(COALESCE(il.QtyInvoiced,0)),");
            }
            sql.append(" l.QtyEntered/l.MovementQty, l.C_UOM_ID, COALESCE(uom.UOMSymbol, uom.Name), l.M_Product_ID, p.Name, p.Value, po.VendorProductNo, l.M_InOutLine_ID, l.Line, l.C_OrderLine_ID  FROM M_InOutLine l ");
            if (Env.isBaseLanguage((Properties)Env.getCtx(), (String)"C_UOM")) {
                sql.append(" LEFT OUTER JOIN C_UOM uom ON (l.C_UOM_ID=uom.C_UOM_ID)");
            } else {
                sql.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language((Properties)Env.getCtx())).append("')");
            }
            sql.append(" LEFT OUTER JOIN M_Product p ON (l.M_Product_ID=p.M_Product_ID)").append(" INNER JOIN M_InOut io ON (l.M_InOut_ID=io.M_InOut_ID)");
            if (!this.isSOTrx) {
                sql.append(" LEFT OUTER JOIN M_MatchInv mi ON (l.M_InOutLine_ID=mi.M_InOutLine_ID)");
            } else {
                sql.append(" LEFT JOIN C_InvoiceLine il ON l.M_InOutLine_ID = il.M_InOutLine_ID");
            }
            sql.append(" LEFT OUTER JOIN M_Product_PO po ON (l.M_Product_ID = po.M_Product_ID AND io.C_BPartner_ID = po.C_BPartner_ID)").append(" WHERE l.M_InOut_ID=? AND l.MovementQty<>0 ").append("GROUP BY l.MovementQty, l.QtyEntered/l.MovementQty, l.C_UOM_ID, COALESCE(uom.UOMSymbol, uom.Name), l.M_Product_ID, p.Name, p.Value, po.VendorProductNo, l.M_InOutLine_ID, l.Line, l.C_OrderLine_ID ");
            if (!this.isSOTrx) {
                sql.append(" HAVING l.MovementQty-SUM(COALESCE(mi.Qty, 0)) <>0");
            } else {
                sql.append(" HAVING l.MovementQty-SUM(COALESCE(il.QtyInvoiced,0)) <>0");
            }
            sql.append("ORDER BY l.Line");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setInt(1, M_InOut_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(7);
                        line.add(false);
                        BigDecimal qtyMovement = rs.getBigDecimal(1);
                        BigDecimal multiplier = rs.getBigDecimal(2);
                        BigDecimal qtyEntered = qtyMovement.multiply(multiplier);
                        line.add(qtyEntered);
                        KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                        line.add(pp);
                        line.add(rs.getString(7));
                        pp = new KeyNamePair(rs.getInt(5), rs.getString(6));
                        line.add(pp);
                        int C_OrderLine_ID = rs.getInt(11);
                        if (rs.wasNull()) {
                            line.add(null);
                        } else {
                            line.add(new KeyNamePair(C_OrderLine_ID, "."));
                        }
                        pp = new KeyNamePair(rs.getInt(9), rs.getString(10));
                        line.add(pp);
                        line.add(null);
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block19;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    protected Vector<Vector<Object>> getRMAData(int M_RMA_ID) {
        Vector<Vector<Object>> data;
        block10: {
            this.p_order = null;
            data = new Vector<Vector<Object>>();
            StringBuilder sqlStmt = new StringBuilder();
            sqlStmt.append("SELECT rl.M_RMALine_ID, rl.line, rl.Qty - COALESCE(rl.QtyInvoiced, 0), iol.M_Product_ID, p.Name, p.Value, uom.C_UOM_ID, COALESCE(uom.UOMSymbol,uom.Name) ");
            sqlStmt.append("FROM M_RMALine rl INNER JOIN M_InOutLine iol ON rl.M_InOutLine_ID=iol.M_InOutLine_ID ");
            if (Env.isBaseLanguage((Properties)Env.getCtx(), (String)"C_UOM")) {
                sqlStmt.append("LEFT OUTER JOIN C_UOM uom ON (uom.C_UOM_ID=iol.C_UOM_ID) ");
            } else {
                sqlStmt.append("LEFT OUTER JOIN C_UOM_Trl uom ON (uom.C_UOM_ID=iol.C_UOM_ID AND uom.AD_Language='");
                sqlStmt.append(Env.getAD_Language((Properties)Env.getCtx())).append("') ");
            }
            sqlStmt.append("LEFT OUTER JOIN M_Product p ON p.M_Product_ID=iol.M_Product_ID ");
            sqlStmt.append("WHERE rl.M_RMA_ID=? ");
            sqlStmt.append("AND rl.M_INOUTLINE_ID IS NOT NULL");
            sqlStmt.append(" UNION ");
            sqlStmt.append("SELECT rl.M_RMALine_ID, rl.line, rl.Qty - rl.QtyDelivered, 0, c.Name, uom.C_UOM_ID, COALESCE(uom.UOMSymbol,uom.Name) ");
            sqlStmt.append("FROM M_RMALine rl INNER JOIN C_Charge c ON c.C_Charge_ID = rl.C_Charge_ID ");
            if (Env.isBaseLanguage((Properties)Env.getCtx(), (String)"C_UOM")) {
                sqlStmt.append("LEFT OUTER JOIN C_UOM uom ON (uom.C_UOM_ID=100) ");
            } else {
                sqlStmt.append("LEFT OUTER JOIN C_UOM_Trl uom ON (uom.C_UOM_ID=100 AND uom.AD_Language='");
                sqlStmt.append(Env.getAD_Language((Properties)Env.getCtx())).append("') ");
            }
            sqlStmt.append("WHERE rl.M_RMA_ID=? ");
            sqlStmt.append("AND rl.C_Charge_ID IS NOT NULL");
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sqlStmt.toString(), null);
                    pstmt.setInt(1, M_RMA_ID);
                    pstmt.setInt(2, M_RMA_ID);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>(7);
                        line.add(false);
                        line.add(rs.getBigDecimal(3));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(7), rs.getString(8));
                        line.add(pp);
                        line.add(null);
                        pp = new KeyNamePair(rs.getInt(4), rs.getString(5));
                        line.add(rs.getString(6));
                        line.add(null);
                        line.add(null);
                        pp = new KeyNamePair(rs.getInt(1), rs.getString(2));
                        line.add(pp);
                        data.add(line);
                    }
                }
                catch (Exception ex) {
                    this.log.log(Level.SEVERE, sqlStmt.toString(), (Throwable)ex);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    public void info(IMiniTable miniTable, IStatusBar statusBar) {
    }

    protected void configureMiniTable(IMiniTable miniTable) {
        miniTable.setColumnClass(0, Boolean.class, false);
        miniTable.setColumnClass(1, BigDecimal.class, true);
        miniTable.setColumnClass(2, String.class, true);
        miniTable.setColumnClass(3, String.class, true);
        miniTable.setColumnClass(4, String.class, true);
        miniTable.setColumnClass(5, String.class, true);
        miniTable.setColumnClass(6, String.class, true);
        miniTable.setColumnClass(7, String.class, true);
        miniTable.autoSize();
    }

    protected Vector<String> getOISColumnNames() {
        Vector<String> columnNames = new Vector<String>(7);
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Quantity"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"C_UOM_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"ProductValue", (boolean)this.isSOTrx));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"M_Product_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"C_OrderLine_ID", (boolean)this.isSOTrx));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"M_InOutLine_ID", (boolean)this.isSOTrx));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"M_RMALine_ID", (boolean)this.isSOTrx));
        return columnNames;
    }

    public boolean save(IMiniTable miniTable, String trxName) {
        int C_Invoice_ID = (Integer)this.getGridTab().getValue("C_Invoice_ID");
        MInvoice invoice = new MInvoice(Env.getCtx(), C_Invoice_ID, trxName);
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(invoice.toString());
        }
        int i = 0;
        while (i < miniTable.getRowCount()) {
            if (((Boolean)miniTable.getValueAt(i, 0)).booleanValue()) {
                MInOutLine line;
                int j;
                MInOutLine[] lines;
                String whereClause;
                MProduct product = null;
                BigDecimal QtyEntered = (BigDecimal)miniTable.getValueAt(i, 1);
                KeyNamePair pp = (KeyNamePair)miniTable.getValueAt(i, 2);
                int C_UOM_ID = pp.getKey();
                pp = (KeyNamePair)miniTable.getValueAt(i, 4);
                int M_Product_ID = 0;
                if (pp != null) {
                    M_Product_ID = pp.getKey();
                }
                int C_OrderLine_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i, 5);
                if (pp != null) {
                    C_OrderLine_ID = pp.getKey();
                }
                int M_InOutLine_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i, 6);
                if (pp != null) {
                    M_InOutLine_ID = pp.getKey();
                }
                int M_RMALine_ID = 0;
                pp = (KeyNamePair)miniTable.getValueAt(i, 7);
                if (pp != null) {
                    M_RMALine_ID = pp.getKey();
                }
                int precision = 2;
                if (M_Product_ID != 0) {
                    product = MProduct.get((Properties)Env.getCtx(), (int)M_Product_ID);
                    precision = product.getUOMPrecision();
                }
                QtyEntered = QtyEntered.setScale(precision, RoundingMode.HALF_UP);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Line QtyEntered=" + QtyEntered + ", Product_ID=" + M_Product_ID + ", OrderLine_ID=" + C_OrderLine_ID + ", InOutLine_ID=" + M_InOutLine_ID);
                }
                MInvoiceLine invoiceLine = new MInvoiceLine(invoice);
                invoiceLine.setM_Product_ID(M_Product_ID, C_UOM_ID);
                invoiceLine.setQty(QtyEntered);
                BigDecimal QtyInvoiced = null;
                if (M_Product_ID > 0 && product.getC_UOM_ID() != C_UOM_ID) {
                    QtyInvoiced = MUOMConversion.convertProductFrom((Properties)Env.getCtx(), (int)M_Product_ID, (int)C_UOM_ID, (BigDecimal)QtyEntered);
                }
                if (QtyInvoiced == null) {
                    QtyInvoiced = QtyEntered;
                }
                invoiceLine.setQtyInvoiced(QtyInvoiced);
                MOrderLine orderLine = null;
                if (C_OrderLine_ID != 0) {
                    orderLine = new MOrderLine(Env.getCtx(), C_OrderLine_ID, trxName);
                }
                MRMALine rmaLine = null;
                if (M_RMALine_ID > 0) {
                    rmaLine = new MRMALine(Env.getCtx(), M_RMALine_ID, null);
                }
                MInOutLine inoutLine = null;
                if (M_InOutLine_ID != 0) {
                    inoutLine = new MInOutLine(Env.getCtx(), M_InOutLine_ID, trxName);
                    if (orderLine == null && inoutLine.getC_OrderLine_ID() != 0) {
                        C_OrderLine_ID = inoutLine.getC_OrderLine_ID();
                        orderLine = new MOrderLine(Env.getCtx(), C_OrderLine_ID, trxName);
                    }
                } else if (C_OrderLine_ID > 0) {
                    whereClause = "EXISTS (SELECT 1 FROM M_InOut io WHERE io.M_InOut_ID=M_InOutLine.M_InOut_ID AND io.DocStatus IN ('CO','CL'))";
                    lines = MInOutLine.getOfOrderLine((Properties)Env.getCtx(), (int)C_OrderLine_ID, (String)whereClause, (String)trxName);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Receipt Lines with OrderLine = #" + lines.length);
                    }
                    if (lines.length > 0) {
                        j = 0;
                        while (j < lines.length) {
                            line = lines[j];
                            if (line.getQtyEntered().compareTo(QtyEntered) == 0) {
                                inoutLine = line;
                                M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                                break;
                            }
                            ++j;
                        }
                    }
                } else if (M_RMALine_ID != 0) {
                    whereClause = "EXISTS (SELECT 1 FROM M_InOut io WHERE io.M_InOut_ID=M_InOutLine.M_InOut_ID AND io.DocStatus IN ('CO','CL'))";
                    lines = MInOutLine.getOfRMALine((Properties)Env.getCtx(), (int)M_RMALine_ID, (String)whereClause, null);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Receipt Lines with RMALine = #" + lines.length);
                    }
                    if (lines.length > 0) {
                        j = 0;
                        while (j < lines.length) {
                            line = lines[j];
                            if (rmaLine.getQty().compareTo(QtyEntered) == 0) {
                                inoutLine = line;
                                M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                                break;
                            }
                            ++j;
                        }
                        if (rmaLine == null) {
                            inoutLine = lines[0];
                            M_InOutLine_ID = inoutLine.getM_InOutLine_ID();
                        }
                    }
                }
                if (inoutLine != null) {
                    invoiceLine.setShipLine(inoutLine);
                    invoiceLine.set_ValueNoCheck("JP_ProductExplodeBOM_ID", inoutLine.get_Value("JP_ProductExplodeBOM_ID"));
                } else {
                    this.log.fine("No Receipt Line");
                    if (orderLine != null) {
                        invoiceLine.setOrderLine(orderLine);
                        invoiceLine.set_ValueNoCheck("JP_ProductExplodeBOM_ID", orderLine.get_Value("JP_ProductExplodeBOM_ID"));
                    } else {
                        this.log.fine("No Order Line");
                        invoiceLine.setPrice();
                        invoiceLine.setTax();
                    }
                    if (rmaLine != null) {
                        invoiceLine.setRMALine(rmaLine);
                    } else {
                        this.log.fine("No RMA Line");
                    }
                }
                invoiceLine.saveEx();
            }
            ++i;
        }
        if (this.p_order != null && this.p_order.getC_Order_ID() != 0 && invoice.getC_Order_ID() == 0) {
            invoice.setOrder(this.p_order);
            invoice.saveEx();
            invoice.load(invoice.get_TrxName(), new String[0]);
            MOrderPaySchedule[] opss = MOrderPaySchedule.getOrderPaySchedule((Properties)invoice.getCtx(), (int)this.p_order.getC_Order_ID(), (int)0, (String)invoice.get_TrxName());
            MInvoicePaySchedule[] ipss = MInvoicePaySchedule.getInvoicePaySchedule((Properties)invoice.getCtx(), (int)invoice.getC_Invoice_ID(), (int)0, (String)invoice.get_TrxName());
            if (ipss.length == 0 && opss.length > 0) {
                BigDecimal ogt = this.p_order.getGrandTotal();
                BigDecimal igt = invoice.getGrandTotal();
                BigDecimal percent = Env.ONE;
                if (ogt.compareTo(igt) != 0) {
                    percent = igt.divide(ogt, 10, RoundingMode.HALF_UP);
                }
                MCurrency cur = MCurrency.get((Properties)this.p_order.getCtx(), (int)this.p_order.getC_Currency_ID());
                int scale = cur.getStdPrecision();
                MOrderPaySchedule[] mOrderPayScheduleArray = opss;
                int n = opss.length;
                int n2 = 0;
                while (n2 < n) {
                    MOrderPaySchedule ops = mOrderPayScheduleArray[n2];
                    MInvoicePaySchedule ips = new MInvoicePaySchedule(invoice.getCtx(), 0, invoice.get_TrxName());
                    PO.copyValues((PO)ops, (PO)ips);
                    if (percent != Env.ONE) {
                        BigDecimal propDueAmt = ops.getDueAmt().multiply(percent);
                        if (propDueAmt.scale() > scale) {
                            propDueAmt = propDueAmt.setScale(scale, RoundingMode.HALF_UP);
                        }
                        ips.setDueAmt(propDueAmt);
                    }
                    ips.setC_Invoice_ID(invoice.getC_Invoice_ID());
                    ips.setAD_Org_ID(ops.getAD_Org_ID());
                    ips.setProcessing(ops.isProcessing());
                    ips.setIsActive(ops.isActive());
                    ips.saveEx();
                    ++n2;
                }
                invoice.validatePaySchedule();
                invoice.saveEx();
            }
        } else if (this.m_rma != null && this.m_rma.getM_RMA_ID() != 0 && invoice.getM_RMA_ID() == 0) {
            invoice.setM_RMA_ID(this.m_rma.getM_RMA_ID());
            invoice.saveEx();
        }
        return true;
    }

    protected Vector<Vector<Object>> getOrderData(int C_Order_ID, boolean forInvoice) {
        Vector<Vector<Object>> data;
        block18: {
            ArrayList<ILineOrderLineSummary> ILineOrderLineSummary_list;
            block16: {
                StringBuilder preSQL = new StringBuilder("SELECT il.C_OrderLine_ID, SUM(il.QtyEntered), il.C_UOM_ID FROM C_InvoiceLine il INNER JOIN C_Invoice i ON(i.C_Invoice_ID = il.C_Invoice_ID)  WHERE il.C_Invoice_ID=? GROUP BY C_OrderLine_ID, C_UOM_ID");
                CPreparedStatement prePSTMT = null;
                ResultSet preRS = null;
                ILineOrderLineSummary_list = new ArrayList<ILineOrderLineSummary>();
                int C_Invoice_ID = (Integer)this.getGridTab().getValue("C_Invoice_ID");
                try {
                    try {
                        prePSTMT = DB.prepareStatement((String)preSQL.toString(), null);
                        prePSTMT.setInt(1, C_Invoice_ID);
                        preRS = prePSTMT.executeQuery();
                        while (preRS.next()) {
                            ILineOrderLineSummary_list.add(new ILineOrderLineSummary(preRS.getInt(1), preRS.getBigDecimal(2), preRS.getInt(3)));
                        }
                    }
                    catch (SQLException e) {
                        this.log.log(Level.SEVERE, preSQL.toString(), (Throwable)e);
                        DB.close((ResultSet)preRS, (Statement)prePSTMT);
                        preRS = null;
                        prePSTMT = null;
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(preRS, prePSTMT);
                    preRS = null;
                    prePSTMT = null;
                    throw throwable;
                }
                DB.close((ResultSet)preRS, (Statement)prePSTMT);
                preRS = null;
                prePSTMT = null;
            }
            if (this.log.isLoggable(Level.CONFIG)) {
                this.log.config("C_Order_ID=" + C_Order_ID);
            }
            this.p_order = new MOrder(Env.getCtx(), C_Order_ID, null);
            data = new Vector<Vector<Object>>();
            StringBuilder sql = new StringBuilder("SELECT l.QtyOrdered - l.QtyInvoiced ,CASE WHEN l.QtyOrdered=0 THEN 0 ELSE l.QtyEntered/l.QtyOrdered END  ,l.C_UOM_ID,COALESCE(uom.UOMSymbol,uom.Name) ,COALESCE(l.M_Product_ID,0),COALESCE(p.Name,c.Name)  ,p.Value AS ProductValue  ,l.C_OrderLine_ID,l.Line FROM C_OrderLine l");
            sql.append(" LEFT OUTER JOIN M_Product p ON (l.M_Product_ID=p.M_Product_ID) LEFT OUTER JOIN C_Charge c ON (l.C_Charge_ID=c.C_Charge_ID)");
            if (Env.isBaseLanguage((Properties)Env.getCtx(), (String)"C_UOM")) {
                sql.append(" LEFT OUTER JOIN C_UOM uom ON (l.C_UOM_ID=uom.C_UOM_ID)");
            } else {
                sql.append(" LEFT OUTER JOIN C_UOM_Trl uom ON (l.C_UOM_ID=uom.C_UOM_ID AND uom.AD_Language='").append(Env.getAD_Language((Properties)Env.getCtx())).append("')");
            }
            sql.append(" WHERE l.C_Order_ID=? ");
            sql.append(" ORDER BY l.Line ");
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer(sql.toString());
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setInt(1, C_Order_ID);
                    rs = pstmt.executeQuery();
                    boolean isContain = false;
                    while (rs.next()) {
                        isContain = false;
                        for (ILineOrderLineSummary olSum : ILineOrderLineSummary_list) {
                            BigDecimal multiplier;
                            if (olSum.C_OrderLine_ID != rs.getInt(8) || olSum.C_UOM_ID != rs.getInt(3)) continue;
                            isContain = true;
                            BigDecimal qtyOrdered = rs.getBigDecimal(1);
                            BigDecimal qtyEntered = qtyOrdered.multiply(multiplier = rs.getBigDecimal(2)).subtract(olSum.QtyEntered);
                            if (qtyEntered.compareTo(Env.ZERO) == 0) break;
                            Vector<Object> line = new Vector<Object>();
                            line.add(false);
                            line.add(qtyEntered);
                            KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                            line.add(pp);
                            line.add(rs.getString(7));
                            pp = new KeyNamePair(rs.getInt(5), rs.getString(6));
                            line.add(pp);
                            pp = new KeyNamePair(rs.getInt(8), rs.getString(9));
                            line.add(pp);
                            data.add(line);
                            break;
                        }
                        if (isContain) continue;
                        Vector<Object> line = new Vector<Object>();
                        line.add(false);
                        BigDecimal qtyOrdered = rs.getBigDecimal(1);
                        BigDecimal multiplier = rs.getBigDecimal(2);
                        BigDecimal qtyEntered = qtyOrdered.multiply(multiplier);
                        line.add(qtyEntered);
                        KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(4).trim());
                        line.add(pp);
                        line.add(rs.getString(7));
                        pp = new KeyNamePair(rs.getInt(5), rs.getString(6));
                        line.add(pp);
                        pp = new KeyNamePair(rs.getInt(8), rs.getString(9));
                        line.add(pp);
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block18;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return data;
    }

    private class ILineOrderLineSummary {
        int C_OrderLine_ID = 0;
        BigDecimal QtyEntered = Env.ZERO;
        int C_UOM_ID = 0;

        public ILineOrderLineSummary(int C_OrderLine_ID, BigDecimal QtyEntered, int C_UOM_ID) {
            this.C_OrderLine_ID = C_OrderLine_ID;
            this.QtyEntered = QtyEntered;
            this.C_UOM_ID = C_UOM_ID;
        }
    }
}

