/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.webui.apps.form;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class Allocation {
    public DecimalFormat format = DisplayType.getNumberFormat((int)12);
    public static final CLogger log = CLogger.getCLogger(Allocation.class);
    private boolean m_calculating = false;
    public int m_C_Currency_ID = 0;
    public int m_C_Charge_ID = 0;
    public int m_C_DocType_ID = 0;
    public int m_C_BPartner_ID = 0;
    public int m_C_BPartner2_ID = 0;
    private int m_noInvoices = 0;
    private int m_noPayments = 0;
    public BigDecimal totalInv = Env.ZERO;
    public BigDecimal totalPay = Env.ZERO;
    public BigDecimal totalDiff = Env.ZERO;
    public Timestamp allocDate = null;
    private int i_payment = 7;
    private int i_open = 6;
    private int i_discount = 7;
    private int i_writeOff = 8;
    private int i_applied = 9;
    private int i_overUnder = 10;
    private int i_Payment_OrgInfoCorp = 0;
    private int i_Invoice_OrgInfoCorp = 0;
    public int m_AD_Org_ID = 0;
    public int m_AD_Org2_ID = 0;
    public int m_Doc_AD_Org_ID = 0;
    public int m_JP_OrgInfo_Corporation_ID = 0;
    public int m_JP_Corporation_ID = 0;
    private ArrayList<Integer> m_bpartnerCheck = new ArrayList();

    public void dynInit() throws Exception {
        this.m_C_Currency_ID = Env.getContextAsInt((Properties)Env.getCtx(), (String)"$C_Currency_ID");
        if (log.isLoggable(Level.INFO)) {
            log.info("Currency=" + this.m_C_Currency_ID);
        }
        this.m_AD_Org_ID = Env.getAD_Org_ID((Properties)Env.getCtx());
        this.m_C_DocType_ID = MDocType.getDocType((String)"CMA");
    }

    public void checkBPartner() {
        if (log.isLoggable(Level.CONFIG)) {
            log.config("BPartner=" + this.m_C_BPartner_ID + ", Cur=" + this.m_C_Currency_ID);
        }
        if (this.m_C_BPartner_ID == 0 || this.m_C_Currency_ID == 0) {
            return;
        }
        Integer key = this.m_C_BPartner_ID;
        if (!this.m_bpartnerCheck.contains(key)) {
            new Thread(){

                @Override
                public void run() {
                    MPayment.setIsAllocated((Properties)Env.getCtx(), (int)Allocation.this.m_C_BPartner_ID, null);
                    MInvoice.setIsPaid((Properties)Env.getCtx(), (int)Allocation.this.m_C_BPartner_ID, null);
                }
            }.start();
            this.m_bpartnerCheck.add(key);
        }
    }

    public Vector<Vector<Object>> getPaymentData(boolean isMultiCurrency, Object date, IMiniTable paymentTable) {
        Vector<Vector<Object>> data;
        block19: {
            data = new Vector<Vector<Object>>();
            if (this.m_C_BPartner_ID == 0 && this.m_C_BPartner2_ID == 0 && this.m_JP_Corporation_ID == 0) {
                return data;
            }
            StringBuilder sql = new StringBuilder("SELECT p.DateTrx,p.DocumentNo,p.C_Payment_ID,c.ISO_Code,p.PayAmt,currencyConvertPayment(p.C_Payment_ID,?,null,?),currencyConvertPayment(p.C_Payment_ID,?,paymentAvailable(p.C_Payment_ID),?),p.MultiplierAP, bp.Name, bc.Name, o.Name, cp.Name FROM C_Payment_v p INNER JOIN C_Currency c ON (p.C_Currency_ID=c.C_Currency_ID)  INNER JOIN C_BPartner bp ON (p.C_BPartner_ID=bp.C_BPartner_ID)  INNER JOIN AD_Org o ON (p.AD_Org_ID=o.AD_Org_ID)  LEFT OUTER JOIN JP_Corporation bc ON (bp.JP_Corporation_ID = bc.JP_Corporation_ID)  LEFT OUTER JOIN AD_OrgInfo oi ON (p.AD_Org_ID=oi.AD_Org_ID)  LEFT OUTER JOIN JP_Corporation cp ON (oi.JP_Corporation_ID=cp.JP_Corporation_ID) WHERE p.IsAllocated='N' AND p.Processed='Y' AND p.C_Charge_ID IS NULL");
            if (this.m_C_BPartner_ID != 0 || this.m_C_BPartner2_ID != 0) {
                sql.append(" AND p.C_BPartner_ID in (?,?)");
            }
            if (this.m_JP_Corporation_ID != 0) {
                sql.append(" AND bp.JP_Corporation_ID=?");
            }
            if (!isMultiCurrency) {
                sql.append(" AND p.C_Currency_ID=?");
            }
            if (this.m_AD_Org_ID != 0 || this.m_AD_Org2_ID != 0) {
                sql.append(" AND p.AD_Org_ID in (?,?) ");
            }
            if (this.m_JP_OrgInfo_Corporation_ID != 0) {
                sql.append(" AND oi.JP_Corporation_ID=?");
            }
            sql.append(" ORDER BY p.DateTrx,p.DocumentNo");
            sql = new StringBuilder(MRole.getDefault((Properties)Env.getCtx(), (boolean)false).addAccessSQL(sql.toString(), "p", true, false));
            if (log.isLoggable(Level.FINE)) {
                log.fine("PaySQL=" + sql.toString());
            }
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    int i = 0;
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setInt(++i, this.m_C_Currency_ID);
                    pstmt.setTimestamp(++i, (Timestamp)date);
                    pstmt.setInt(++i, this.m_C_Currency_ID);
                    pstmt.setTimestamp(++i, (Timestamp)date);
                    if (this.m_C_BPartner_ID != 0 || this.m_C_BPartner2_ID != 0) {
                        pstmt.setInt(++i, this.m_C_BPartner_ID);
                        pstmt.setInt(++i, this.m_C_BPartner2_ID);
                    }
                    if (this.m_JP_Corporation_ID != 0) {
                        pstmt.setInt(++i, this.m_JP_Corporation_ID);
                    }
                    if (!isMultiCurrency) {
                        pstmt.setInt(++i, this.m_C_Currency_ID);
                    }
                    if (this.m_AD_Org_ID != 0 || this.m_AD_Org2_ID != 0) {
                        pstmt.setInt(++i, this.m_AD_Org_ID);
                        pstmt.setInt(++i, this.m_AD_Org2_ID);
                    }
                    if (this.m_JP_OrgInfo_Corporation_ID != 0) {
                        pstmt.setInt(++i, this.m_JP_OrgInfo_Corporation_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>();
                        line.add(Boolean.FALSE);
                        line.add(rs.getTimestamp(1));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(2));
                        line.add(pp);
                        if (isMultiCurrency) {
                            line.add(rs.getString(4));
                            line.add(rs.getBigDecimal(5));
                        }
                        line.add(rs.getBigDecimal(6));
                        BigDecimal available = rs.getBigDecimal(7);
                        if (available == null || available.signum() == 0) continue;
                        line.add(available);
                        line.add(Env.ZERO);
                        line.add(rs.getString(9));
                        line.add(rs.getString(10));
                        line.add(rs.getString(11));
                        line.add(rs.getString(12));
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    break block19;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        return data;
    }

    public Vector<String> getPaymentColumnNames(boolean isMultiCurrency) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo")));
        if (isMultiCurrency) {
            columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"TrxCurrency"));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Amount"));
        }
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"ConvertedAmount"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"OpenAmt"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"AppliedAmt"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"JP_Corporation_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"JP_OrgInfo_Corporation_ID"));
        return columnNames;
    }

    public void setPaymentColumnClass(IMiniTable paymentTable, boolean isMultiCurrency) {
        int i = 0;
        paymentTable.setColumnClass(i++, Boolean.class, false);
        paymentTable.setColumnClass(i++, Timestamp.class, true);
        paymentTable.setColumnClass(i++, String.class, true);
        if (isMultiCurrency) {
            paymentTable.setColumnClass(i++, String.class, true);
            paymentTable.setColumnClass(i++, BigDecimal.class, true);
        }
        paymentTable.setColumnClass(i++, BigDecimal.class, true);
        paymentTable.setColumnClass(i++, BigDecimal.class, true);
        paymentTable.setColumnClass(i++, BigDecimal.class, false);
        paymentTable.setColumnClass(i++, String.class, true);
        paymentTable.setColumnClass(i++, String.class, true);
        paymentTable.setColumnClass(i++, String.class, true);
        paymentTable.setColumnClass(i++, String.class, true);
        this.i_payment = isMultiCurrency ? 7 : 5;
        this.i_Payment_OrgInfoCorp = isMultiCurrency ? 11 : 9;
        paymentTable.autoSize();
    }

    public Vector<Vector<Object>> getInvoiceData(boolean isMultiCurrency, Object date, IMiniTable invoiceTable) {
        Vector<Vector<Object>> data;
        block21: {
            data = new Vector<Vector<Object>>();
            if (this.m_C_BPartner_ID == 0 && this.m_C_BPartner2_ID == 0 && this.m_JP_Corporation_ID == 0) {
                return data;
            }
            StringBuilder sql = new StringBuilder("SELECT i.DateInvoiced,i.DocumentNo,i.C_Invoice_ID,c.ISO_Code,i.GrandTotal*i.MultiplierAP, currencyConvertInvoice(i.C_Invoice_ID,?,i.GrandTotal*i.MultiplierAP,?), currencyConvertInvoice(i.C_Invoice_ID,?,invoiceOpen(C_Invoice_ID,C_InvoicePaySchedule_ID),?)*i.MultiplierAP, currencyConvertInvoice(i.C_Invoice_ID,?,invoiceDiscount(i.C_Invoice_ID,?,C_InvoicePaySchedule_ID),i.DateInvoiced)*i.Multiplier*i.MultiplierAP,i.MultiplierAP, bp.Name, bc.Name, o.Name, cp.Name FROM C_Invoice_v i INNER JOIN C_Currency c ON (i.C_Currency_ID=c.C_Currency_ID)  INNER JOIN C_BPartner bp ON (i.C_BPartner_ID=bp.C_BPartner_ID)  LEFT OUTER JOIN JP_Corporation bc ON (bp.JP_Corporation_ID = bc.JP_Corporation_ID)  INNER JOIN AD_Org o ON (i.AD_Org_ID=o.AD_Org_ID)  LEFT OUTER JOIN AD_OrgInfo oi ON (i.AD_Org_ID=oi.AD_Org_ID)  LEFT OUTER JOIN JP_Corporation cp ON (oi.JP_Corporation_ID=cp.JP_Corporation_ID) WHERE i.IsPaid='N' AND i.Processed='Y'");
            if (this.m_C_BPartner_ID != 0 || this.m_C_BPartner2_ID != 0) {
                sql.append(" AND i.C_BPartner_ID in (?,?)");
            }
            if (this.m_JP_Corporation_ID != 0) {
                sql.append(" AND bp.JP_Corporation_ID=?");
            }
            if (!isMultiCurrency) {
                sql.append(" AND i.C_Currency_ID=?");
            }
            if (this.m_AD_Org_ID != 0 || this.m_AD_Org2_ID != 0) {
                sql.append(" AND i.AD_Org_ID in (?,?)");
            }
            if (this.m_JP_OrgInfo_Corporation_ID != 0) {
                sql.append(" AND oi.JP_Corporation_ID=?");
            }
            sql.append(" ORDER BY i.DateInvoiced, i.DocumentNo");
            if (log.isLoggable(Level.FINE)) {
                log.fine("InvSQL=" + sql.toString());
            }
            sql = new StringBuilder(MRole.getDefault((Properties)Env.getCtx(), (boolean)false).addAccessSQL(sql.toString(), "i", true, false));
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    int i = 0;
                    pstmt = DB.prepareStatement((String)sql.toString(), null);
                    pstmt.setInt(++i, this.m_C_Currency_ID);
                    pstmt.setTimestamp(++i, (Timestamp)date);
                    pstmt.setInt(++i, this.m_C_Currency_ID);
                    pstmt.setTimestamp(++i, (Timestamp)date);
                    pstmt.setInt(++i, this.m_C_Currency_ID);
                    pstmt.setTimestamp(++i, (Timestamp)date);
                    if (this.m_C_BPartner_ID != 0 || this.m_C_BPartner2_ID != 0) {
                        pstmt.setInt(++i, this.m_C_BPartner_ID);
                        pstmt.setInt(++i, this.m_C_BPartner2_ID);
                    }
                    if (this.m_JP_Corporation_ID != 0) {
                        pstmt.setInt(++i, this.m_JP_Corporation_ID);
                    }
                    if (!isMultiCurrency) {
                        pstmt.setInt(++i, this.m_C_Currency_ID);
                    }
                    if (this.m_AD_Org_ID != 0 || this.m_AD_Org2_ID != 0) {
                        pstmt.setInt(++i, this.m_AD_Org_ID);
                        pstmt.setInt(++i, this.m_AD_Org2_ID);
                    }
                    if (this.m_JP_OrgInfo_Corporation_ID != 0) {
                        pstmt.setInt(++i, this.m_JP_OrgInfo_Corporation_ID);
                    }
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        Vector<Object> line = new Vector<Object>();
                        line.add(Boolean.FALSE);
                        line.add(rs.getTimestamp(1));
                        KeyNamePair pp = new KeyNamePair(rs.getInt(3), rs.getString(2));
                        line.add(pp);
                        if (isMultiCurrency) {
                            line.add(rs.getString(4));
                            line.add(rs.getBigDecimal(5));
                        }
                        line.add(rs.getBigDecimal(6));
                        BigDecimal open = rs.getBigDecimal(7);
                        if (open == null) {
                            open = Env.ZERO;
                        }
                        line.add(open);
                        BigDecimal discount = rs.getBigDecimal(8);
                        if (discount == null) {
                            discount = Env.ZERO;
                        }
                        line.add(discount);
                        line.add(Env.ZERO);
                        line.add(Env.ZERO);
                        line.add(open);
                        line.add(rs.getString(10));
                        line.add(rs.getString(11));
                        line.add(rs.getString(12));
                        line.add(rs.getString(13));
                        if (Env.ZERO.compareTo(open) == 0) continue;
                        data.add(line);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, sql.toString(), (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    break block21;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
        }
        return data;
    }

    public Vector<String> getInvoiceColumnNames(boolean isMultiCurrency) {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Select"));
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Date"));
        columnNames.add(Util.cleanAmp((String)Msg.translate((Properties)Env.getCtx(), (String)"DocumentNo")));
        if (isMultiCurrency) {
            columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"TrxCurrency"));
            columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"Amount"));
        }
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"ConvertedAmount"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"OpenAmt"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"Discount"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"WriteOff"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"AppliedAmt"));
        columnNames.add(Msg.getMsg((Properties)Env.getCtx(), (String)"OverUnderAmt"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"JP_Corporation_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"AD_Org_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"JP_OrgInfo_Corporation_ID"));
        return columnNames;
    }

    public void setInvoiceColumnClass(IMiniTable invoiceTable, boolean isMultiCurrency) {
        int i = 0;
        invoiceTable.setColumnClass(i++, Boolean.class, false);
        invoiceTable.setColumnClass(i++, Timestamp.class, true);
        invoiceTable.setColumnClass(i++, String.class, true);
        if (isMultiCurrency) {
            invoiceTable.setColumnClass(i++, String.class, true);
            invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        }
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, false);
        invoiceTable.setColumnClass(i++, BigDecimal.class, true);
        invoiceTable.setColumnClass(i++, String.class, true);
        invoiceTable.setColumnClass(i++, String.class, true);
        invoiceTable.setColumnClass(i++, String.class, true);
        invoiceTable.setColumnClass(i++, String.class, true);
        invoiceTable.autoSize();
        this.i_Invoice_OrgInfoCorp = isMultiCurrency ? 14 : 12;
    }

    public void calculate(boolean isMultiCurrency) {
        this.i_open = isMultiCurrency ? 6 : 4;
        this.i_discount = isMultiCurrency ? 7 : 5;
        this.i_writeOff = isMultiCurrency ? 8 : 6;
        this.i_applied = isMultiCurrency ? 9 : 7;
        this.i_overUnder = isMultiCurrency ? 10 : 8;
    }

    public String writeOff(int row, int col, boolean isInvoice, IMiniTable payment, IMiniTable invoice, boolean isAutoWriteOff) {
        String msg = "";
        if (this.m_calculating) {
            return msg;
        }
        this.m_calculating = true;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Row=" + row + ", Col=" + col + ", InvoiceTable=" + isInvoice);
        }
        if (!isInvoice) {
            BigDecimal open = (BigDecimal)payment.getValueAt(row, this.i_open);
            BigDecimal applied = (BigDecimal)payment.getValueAt(row, this.i_payment);
            if (col == 0) {
                if (((Boolean)payment.getValueAt(row, 0)).booleanValue()) {
                    applied = open;
                    if (this.totalDiff.abs().compareTo(applied.abs()) < 0 && this.totalDiff.signum() == -applied.signum()) {
                        applied = this.totalDiff.negate();
                    }
                } else {
                    applied = Env.ZERO;
                }
            }
            if (col == this.i_payment) {
                if (!MSysConfig.getBooleanValue((String)"ALLOW_APPLY_PAYMENT_TO_CREDITMEMO", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx())) && open.signum() > 0 && applied.signum() == -open.signum()) {
                    applied = applied.negate();
                }
                if (!MSysConfig.getBooleanValue((String)"ALLOW_OVER_APPLIED_PAYMENT", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx())) && open.abs().compareTo(applied.abs()) < 0) {
                    applied = open;
                }
            }
            payment.setValueAt((Object)applied, row, this.i_payment);
        } else {
            boolean selected = (Boolean)invoice.getValueAt(row, 0);
            BigDecimal open = (BigDecimal)invoice.getValueAt(row, this.i_open);
            BigDecimal discount = (BigDecimal)invoice.getValueAt(row, this.i_discount);
            BigDecimal applied = (BigDecimal)invoice.getValueAt(row, this.i_applied);
            BigDecimal writeOff = (BigDecimal)invoice.getValueAt(row, this.i_writeOff);
            BigDecimal overUnder = (BigDecimal)invoice.getValueAt(row, this.i_overUnder);
            int openSign = open.signum();
            if (col == 0) {
                if (selected) {
                    applied = open;
                    applied = applied.subtract(discount);
                    writeOff = Env.ZERO;
                    overUnder = Env.ZERO;
                    this.totalDiff = Env.ZERO;
                    if (this.totalDiff.abs().compareTo(applied.abs()) < 0 && this.totalDiff.signum() == applied.signum()) {
                        applied = this.totalDiff;
                    }
                    if (isAutoWriteOff) {
                        writeOff = open.subtract(applied.add(discount));
                    } else {
                        overUnder = open.subtract(applied.add(discount));
                    }
                } else {
                    writeOff = Env.ZERO;
                    applied = Env.ZERO;
                    overUnder = Env.ZERO;
                }
            }
            if (selected && col != 0) {
                if (discount.signum() == -openSign) {
                    discount = discount.negate();
                }
                if (writeOff.signum() == -openSign) {
                    writeOff = writeOff.negate();
                }
                if (applied.signum() == -openSign) {
                    applied = applied.negate();
                }
                if (discount.abs().compareTo(open.abs()) > 0) {
                    discount = open;
                }
                if (writeOff.abs().compareTo(open.abs()) > 0) {
                    writeOff = open;
                }
                BigDecimal newTotal = discount.add(writeOff).add(applied).add(overUnder);
                BigDecimal difference = newTotal.subtract(open);
                BigDecimal diffWOD = writeOff.add(discount).subtract(open);
                if (diffWOD.signum() == open.signum()) {
                    if (col == this.i_discount) {
                        writeOff = writeOff.subtract(diffWOD);
                    } else {
                        discount = discount.subtract(diffWOD);
                    }
                    difference = difference.subtract(diffWOD);
                }
                if (col == this.i_applied) {
                    overUnder = overUnder.subtract(difference);
                } else {
                    applied = applied.subtract(difference);
                }
            }
            if (isAutoWriteOff && writeOff.doubleValue() / open.doubleValue() > 0.3) {
                msg = "AllocationWriteOffWarn";
            }
            invoice.setValueAt((Object)discount, row, this.i_discount);
            invoice.setValueAt((Object)applied, row, this.i_applied);
            invoice.setValueAt((Object)writeOff, row, this.i_writeOff);
            invoice.setValueAt((Object)overUnder, row, this.i_overUnder);
        }
        this.m_calculating = false;
        return msg;
    }

    public String calculatePayment(IMiniTable payment, boolean isMultiCurrency) {
        log.config("");
        this.totalPay = Env.ZERO;
        int rows = payment.getRowCount();
        this.m_noPayments = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)payment.getValueAt(i, 0)).booleanValue()) {
                Timestamp ts = (Timestamp)payment.getValueAt(i, 1);
                if (!isMultiCurrency) {
                    this.allocDate = TimeUtil.max((Timestamp)this.allocDate, (Timestamp)ts);
                }
                BigDecimal bd = (BigDecimal)payment.getValueAt(i, this.i_payment);
                this.totalPay = this.totalPay.add(bd);
                ++this.m_noPayments;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Payment_" + i + " = " + bd + " - Total=" + this.totalPay);
                }
            }
            ++i;
        }
        return String.valueOf(String.valueOf(this.m_noPayments)) + " - " + Msg.getMsg((Properties)Env.getCtx(), (String)"Sum") + "  " + this.format.format(this.totalPay) + " ";
    }

    public String calculateInvoice(IMiniTable invoice, boolean isMultiCurrency) {
        this.totalInv = Env.ZERO;
        int rows = invoice.getRowCount();
        this.m_noInvoices = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)invoice.getValueAt(i, 0)).booleanValue()) {
                Timestamp ts = (Timestamp)invoice.getValueAt(i, 1);
                if (!isMultiCurrency) {
                    this.allocDate = TimeUtil.max((Timestamp)this.allocDate, (Timestamp)ts);
                }
                BigDecimal bd = (BigDecimal)invoice.getValueAt(i, this.i_applied);
                this.totalInv = this.totalInv.add(bd);
                ++this.m_noInvoices;
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Invoice_" + i + " = " + bd + " - Total=" + this.totalPay);
                }
            }
            ++i;
        }
        return String.valueOf(String.valueOf(this.m_noInvoices)) + " - " + Msg.getMsg((Properties)Env.getCtx(), (String)"Sum") + "  " + this.format.format(this.totalInv) + " ";
    }

    public MAllocationHdr saveData(int m_WindowNo, Object date, IMiniTable payment, IMiniTable invoice, String trxName) {
        int C_Invoice_ID;
        KeyNamePair pp;
        if (this.m_noInvoices + this.m_noPayments == 0) {
            return null;
        }
        int AD_Client_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)m_WindowNo, (String)"AD_Client_ID");
        int AD_Org_ID = this.m_Doc_AD_Org_ID;
        String orgInfoCorporation = null;
        int i_CheckOrgInfoCorporationDiff = 0;
        boolean isPaymentSelected = false;
        int C_BPartner_ID = this.m_C_BPartner_ID;
        int C_Order_ID = 0;
        int C_CashLine_ID = 0;
        Timestamp DateTrx = (Timestamp)date;
        if (DateTrx == null) {
            DateTrx = Env.getContextAsDate((Properties)Env.getCtx(), (String)"#Date");
        }
        int C_Currency_ID = this.m_C_Currency_ID;
        if (AD_Org_ID == 0) {
            String msg = String.valueOf(Msg.getElement((Properties)Env.getCtx(), (String)"AD_OrgDoc_ID")) + " : " + Msg.getMsg((Properties)Env.getCtx(), (String)"Org0NotAllowed");
            throw new AdempiereException(msg);
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Client=" + AD_Client_ID + ", Org=" + AD_Org_ID + ", BPartner=" + C_BPartner_ID + ", Date=" + DateTrx);
        }
        int pRows = payment.getRowCount();
        ArrayList<Integer> paymentList = new ArrayList<Integer>(pRows);
        ArrayList<BigDecimal> amountList = new ArrayList<BigDecimal>(pRows);
        BigDecimal paymentAppliedAmt = Env.ZERO;
        int i = 0;
        while (i < pRows) {
            if (((Boolean)payment.getValueAt(i, 0)).booleanValue()) {
                KeyNamePair pp2 = (KeyNamePair)payment.getValueAt(i, 2);
                int C_Payment_ID = pp2.getKey();
                paymentList.add(C_Payment_ID);
                BigDecimal PaymentAmt = (BigDecimal)payment.getValueAt(i, this.i_payment);
                amountList.add(PaymentAmt);
                paymentAppliedAmt = paymentAppliedAmt.add(PaymentAmt);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("C_Payment_ID=" + C_Payment_ID + " - PaymentAmt=" + PaymentAmt);
                }
                String corporation = (String)payment.getValueAt(i, this.i_Payment_OrgInfoCorp);
                if (i_CheckOrgInfoCorporationDiff == 0) {
                    orgInfoCorporation = corporation;
                } else {
                    if (Util.isEmpty((String)orgInfoCorporation) != Util.isEmpty((String)corporation)) {
                        String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Allocation_DiffCorp");
                        throw new AdempiereException(msg);
                    }
                    if (!Util.isEmpty((String)orgInfoCorporation) && !orgInfoCorporation.equals(corporation)) {
                        String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Allocation_DiffCorp");
                        throw new AdempiereException(msg);
                    }
                }
                ++i_CheckOrgInfoCorporationDiff;
                isPaymentSelected = true;
            }
            ++i;
        }
        if (log.isLoggable(Level.CONFIG)) {
            log.config("Number of Payments=" + paymentList.size() + " - Total=" + paymentAppliedAmt);
        }
        int iRows = invoice.getRowCount();
        i_CheckOrgInfoCorporationDiff = 0;
        MAllocationHdr alloc = new MAllocationHdr(Env.getCtx(), true, DateTrx, C_Currency_ID, Env.getContext((Properties)Env.getCtx(), (String)"#AD_User_Name"), trxName);
        alloc.setAD_Org_ID(AD_Org_ID);
        alloc.setC_DocType_ID(this.m_C_DocType_ID);
        alloc.setDescription(alloc.getDescriptionForManualAllocation(this.m_C_BPartner_ID, trxName));
        alloc.saveEx();
        BigDecimal unmatchedApplied = Env.ZERO;
        int i2 = 0;
        while (i2 < iRows) {
            if (((Boolean)invoice.getValueAt(i2, 0)).booleanValue()) {
                int C_Payment_ID;
                pp = (KeyNamePair)invoice.getValueAt(i2, 2);
                C_Invoice_ID = pp.getKey();
                BigDecimal AppliedAmt = (BigDecimal)invoice.getValueAt(i2, this.i_applied);
                BigDecimal DiscountAmt = (BigDecimal)invoice.getValueAt(i2, this.i_discount);
                BigDecimal WriteOffAmt = (BigDecimal)invoice.getValueAt(i2, this.i_writeOff);
                BigDecimal OverUnderAmt = ((BigDecimal)invoice.getValueAt(i2, this.i_open)).subtract(AppliedAmt).subtract(DiscountAmt).subtract(WriteOffAmt);
                if (log.isLoggable(Level.CONFIG)) {
                    log.config("Invoice #" + i2 + " - AppliedAmt=" + AppliedAmt);
                }
                int j = 0;
                while (j < paymentList.size() && AppliedAmt.signum() != 0) {
                    C_Payment_ID = (Integer)paymentList.get(j);
                    BigDecimal PaymentAmt = (BigDecimal)amountList.get(j);
                    if (PaymentAmt.signum() == AppliedAmt.signum()) {
                        BigDecimal amount;
                        if (log.isLoggable(Level.CONFIG)) {
                            log.config(".. with payment #" + j + ", Amt=" + PaymentAmt);
                        }
                        if ((amount = AppliedAmt).abs().compareTo(PaymentAmt.abs()) > 0) {
                            amount = PaymentAmt;
                        }
                        MAllocationLine aLine = new MAllocationLine(alloc, amount, DiscountAmt, WriteOffAmt, OverUnderAmt);
                        aLine.setDocInfo(this.getC_BPartner_ID(C_Invoice_ID, C_Payment_ID), C_Order_ID, C_Invoice_ID);
                        aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                        aLine.saveEx();
                        DiscountAmt = Env.ZERO;
                        WriteOffAmt = Env.ZERO;
                        AppliedAmt = AppliedAmt.subtract(amount);
                        PaymentAmt = PaymentAmt.subtract(amount);
                        if (log.isLoggable(Level.FINE)) {
                            log.fine("Allocation Amount=" + amount + " - Remaining  Applied=" + AppliedAmt + ", Payment=" + PaymentAmt);
                        }
                        amountList.set(j, PaymentAmt);
                    }
                    ++j;
                }
                String corporation = (String)invoice.getValueAt(i2, this.i_Invoice_OrgInfoCorp);
                if (i_CheckOrgInfoCorporationDiff == 0 && !isPaymentSelected) {
                    orgInfoCorporation = corporation;
                } else {
                    if (Util.isEmpty((String)orgInfoCorporation) != Util.isEmpty((String)corporation)) {
                        String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Allocation_DiffCorp");
                        throw new AdempiereException(msg);
                    }
                    if (!Util.isEmpty((String)orgInfoCorporation) && !orgInfoCorporation.equals(corporation)) {
                        String msg = Msg.getMsg((Properties)Env.getCtx(), (String)"JP_Allocation_DiffCorp");
                        throw new AdempiereException(msg);
                    }
                }
                ++i_CheckOrgInfoCorporationDiff;
                if (AppliedAmt.signum() != 0 || DiscountAmt.signum() != 0 || WriteOffAmt.signum() != 0) {
                    C_Payment_ID = 0;
                    MAllocationLine aLine = new MAllocationLine(alloc, AppliedAmt, DiscountAmt, WriteOffAmt, OverUnderAmt);
                    aLine.setDocInfo(this.getC_BPartner_ID(C_Invoice_ID, C_Payment_ID), C_Order_ID, C_Invoice_ID);
                    aLine.setPaymentInfo(C_Payment_ID, C_CashLine_ID);
                    aLine.saveEx();
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Allocation Amount=" + AppliedAmt);
                    }
                    unmatchedApplied = unmatchedApplied.add(AppliedAmt);
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < paymentList.size()) {
            BigDecimal payAmt = (BigDecimal)amountList.get(i2);
            if (payAmt.signum() != 0) {
                int C_Payment_ID = (Integer)paymentList.get(i2);
                if (log.isLoggable(Level.FINE)) {
                    log.fine("Payment=" + C_Payment_ID + ", Amount=" + payAmt);
                }
                MAllocationLine aLine = new MAllocationLine(alloc, payAmt, Env.ZERO, Env.ZERO, Env.ZERO);
                aLine.setDocInfo(this.getC_BPartner_ID(0, C_Payment_ID), 0, 0);
                aLine.setPaymentInfo(C_Payment_ID, 0);
                aLine.saveEx();
                unmatchedApplied = unmatchedApplied.subtract(payAmt);
            }
            ++i2;
        }
        if (this.m_C_Charge_ID > 0 && unmatchedApplied.compareTo(Env.ZERO) != 0) {
            BigDecimal chargeAmt = this.totalDiff;
            MAllocationLine aLine = new MAllocationLine(alloc, chargeAmt.negate(), Env.ZERO, Env.ZERO, Env.ZERO);
            aLine.setC_Charge_ID(this.m_C_Charge_ID);
            aLine.setC_BPartner_ID(this.m_C_BPartner_ID);
            if (!aLine.save(trxName)) {
                StringBuilder msg = new StringBuilder("Allocation Line not saved - Charge=").append(this.m_C_Charge_ID);
                throw new AdempiereException(msg.toString());
            }
            unmatchedApplied = unmatchedApplied.add(chargeAmt);
        }
        if (unmatchedApplied.signum() != 0) {
            throw new AdempiereException("Allocation not balanced -- out by " + unmatchedApplied);
        }
        if (alloc.get_ID() != 0) {
            if (!alloc.processIt("CO")) {
                throw new AdempiereException("Cannot complete allocation: " + alloc.getProcessMsg());
            }
            alloc.saveEx();
        }
        i = 0;
        while (i < iRows) {
            if (((Boolean)invoice.getValueAt(i, 0)).booleanValue()) {
                String sql = "SELECT invoiceOpen(C_Invoice_ID, 0) FROM C_Invoice WHERE C_Invoice_ID=?";
                pp = (KeyNamePair)invoice.getValueAt(i, 2);
                C_Invoice_ID = pp.getKey();
                BigDecimal open = DB.getSQLValueBD((String)trxName, (String)sql, (int)C_Invoice_ID);
                if (open != null && open.signum() == 0) {
                    sql = "UPDATE C_Invoice SET IsPaid='Y' WHERE C_Invoice_ID=" + C_Invoice_ID;
                    int no = DB.executeUpdate((String)sql, (String)trxName);
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config("Invoice #" + i + " is paid - updated=" + no);
                    }
                } else if (log.isLoggable(Level.CONFIG)) {
                    log.config("Invoice #" + i + " is not paid - " + open);
                }
            }
            ++i;
        }
        i = 0;
        while (i < paymentList.size()) {
            int C_Payment_ID = (Integer)paymentList.get(i);
            MPayment pay = new MPayment(Env.getCtx(), C_Payment_ID, trxName);
            if (pay.testAllocation()) {
                pay.saveEx();
            }
            if (log.isLoggable(Level.CONFIG)) {
                log.config("Payment #" + i + (pay.isAllocated() ? " not" : " is") + " fully allocated");
            }
            ++i;
        }
        paymentList.clear();
        amountList.clear();
        return alloc;
    }

    private int getC_BPartner_ID(int C_Invoice_ID, int C_Payment_ID) {
        int C_BPartner_ID = 0;
        C_BPartner_ID = C_Payment_ID != 0 ? new MPayment(Env.getCtx(), C_Payment_ID, null).getC_BPartner_ID() : (C_Invoice_ID != 0 ? new MInvoice(Env.getCtx(), C_Invoice_ID, null).getC_BPartner_ID() : (this.m_C_BPartner_ID == 0 ? this.m_C_BPartner2_ID : this.m_C_BPartner_ID));
        return C_BPartner_ID;
    }
}

