/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MPayment;
import org.compiere.util.Env;

public class JPierePaymentUtil {
    public static BigDecimal getOpenAmtNow(Properties ctx, MPayment payment, String trxName) {
        BigDecimal allocatedNow = payment.getAllocatedAmt();
        BigDecimal m_openAmt = Env.ZERO;
        if (allocatedNow == null) {
            allocatedNow = Env.ZERO;
        }
        if (payment.isReceipt()) {
            m_openAmt = payment.getPayAmt().subtract(allocatedNow);
        } else {
            allocatedNow = allocatedNow.negate();
            m_openAmt = payment.getPayAmt().subtract(allocatedNow);
            m_openAmt = m_openAmt.negate();
        }
        return m_openAmt;
    }

    public static BigDecimal getOpenAmtPointOfTime(Properties ctx, MPayment payment, Timestamp pointOfTime, String trxName) {
        if (pointOfTime == null) {
            return JPierePaymentUtil.getOpenAmtNow(ctx, payment, trxName);
        }
        BigDecimal allocatedAmtPointOfTime = Env.ZERO;
        BigDecimal m_openAmt = Env.ZERO;
        MAllocationHdr[] allocationHdr = MAllocationHdr.getOfPayment((Properties)ctx, (int)payment.getC_Payment_ID(), (String)trxName);
        Timestamp allocatedDate = null;
        int i = 0;
        while (i < allocationHdr.length) {
            allocatedDate = allocationHdr[i].getDateAcct();
            if (!allocatedDate.after(pointOfTime)) {
                MAllocationLine[] allocationLine = allocationHdr[i].getLines(false);
                int j = 0;
                while (j < allocationLine.length) {
                    if (allocationLine[j].getC_Payment_ID() == payment.getC_Payment_ID()) {
                        allocatedAmtPointOfTime = allocatedAmtPointOfTime.add(allocationLine[j].getAmount());
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (payment.isReceipt()) {
            m_openAmt = payment.getPayAmt().subtract(allocatedAmtPointOfTime);
        } else {
            allocatedAmtPointOfTime = allocatedAmtPointOfTime.negate();
            m_openAmt = payment.getPayAmt().subtract(allocatedAmtPointOfTime);
            m_openAmt = m_openAmt.negate();
        }
        return m_openAmt;
    }
}

