/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MDocType;
import org.compiere.model.MInvoice;
import org.compiere.util.Env;

public class JPiereInvoiceUtil {
    public static BigDecimal getOpenAmtNow(Properties ctx, MInvoice invoice, boolean creditMemoAdjusted, String trxName) {
        BigDecimal allocatedNow = invoice.getAllocatedAmt();
        if (allocatedNow == null) {
            allocatedNow = Env.ZERO;
        }
        if (invoice.isSOTrx()) {
            if (!MDocType.get((Properties)ctx, (int)invoice.getC_DocType_ID()).getDocBaseType().equals("ARI") && MDocType.get((Properties)ctx, (int)invoice.getC_DocType_ID()).getDocBaseType().equals("ARC")) {
                allocatedNow = allocatedNow.negate();
            }
        } else if (MDocType.get((Properties)ctx, (int)invoice.getC_DocType_ID()).getDocBaseType().equals("API")) {
            allocatedNow = allocatedNow.negate();
        } else if (MDocType.get((Properties)ctx, (int)invoice.getC_DocType_ID()).getDocBaseType().equals("APC")) {
            // empty if block
        }
        BigDecimal m_openAmt = invoice.getGrandTotal().subtract(allocatedNow);
        if (!creditMemoAdjusted) {
            return m_openAmt;
        }
        if (invoice.isCreditMemo()) {
            return m_openAmt.negate();
        }
        return m_openAmt;
    }

    public static BigDecimal getOpenAmtPointOfTime(Properties ctx, MInvoice invoice, Timestamp pointOfTime, boolean creditMemoAdjusted, String trxName) {
        if (pointOfTime == null) {
            return invoice.getOpenAmt(creditMemoAdjusted, null);
        }
        BigDecimal allocatedAmtPointOfTime = Env.ZERO;
        MAllocationHdr[] allocationHdr = MAllocationHdr.getOfInvoice((Properties)ctx, (int)invoice.getC_Invoice_ID(), (String)trxName);
        Timestamp allocatedDate = null;
        int i = 0;
        while (i < allocationHdr.length) {
            allocatedDate = allocationHdr[i].getDateAcct();
            if (!allocatedDate.after(pointOfTime)) {
                MAllocationLine[] allocationLine = allocationHdr[i].getLines(false);
                int j = 0;
                while (j < allocationLine.length) {
                    if (allocationLine[j].getC_Invoice_ID() == invoice.getC_Invoice_ID()) {
                        allocatedAmtPointOfTime = allocatedAmtPointOfTime.add(allocationLine[j].getAmount()).add(allocationLine[j].getDiscountAmt()).add(allocationLine[j].getWriteOffAmt());
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (invoice.isSOTrx()) {
            if (!MDocType.get((Properties)ctx, (int)invoice.getC_DocType_ID()).getDocBaseType().equals("ARI") && MDocType.get((Properties)ctx, (int)invoice.getC_DocType_ID()).getDocBaseType().equals("ARC")) {
                allocatedAmtPointOfTime = allocatedAmtPointOfTime.negate();
            }
        } else if (MDocType.get((Properties)ctx, (int)invoice.getC_DocType_ID()).getDocBaseType().equals("API")) {
            allocatedAmtPointOfTime = allocatedAmtPointOfTime.negate();
        } else if (MDocType.get((Properties)ctx, (int)invoice.getC_DocType_ID()).getDocBaseType().equals("APC")) {
            // empty if block
        }
        BigDecimal m_openAmt = invoice.getGrandTotal().subtract(allocatedAmtPointOfTime);
        if (!creditMemoAdjusted) {
            return m_openAmt;
        }
        if (invoice.isCreditMemo()) {
            return m_openAmt.negate();
        }
        return m_openAmt;
    }
}

