/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.compiere.acct;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MContractAcct;
import jpiere.base.plugin.org.adempiere.model.MContractChargeAcct;
import jpiere.base.plugin.org.adempiere.model.MContractContent;
import jpiere.base.plugin.org.adempiere.model.MContractProductAcct;
import org.adempiere.exceptions.AverageCostingZeroQtyException;
import org.compiere.acct.Doc;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.I_C_Order;
import org.compiere.model.I_C_OrderLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MAcctSchemaElement;
import org.compiere.model.MCharge;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCostDetail;
import org.compiere.model.MFactAcct;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoice;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MMatchInv;
import org.compiere.model.MOrderLandedCostAllocation;
import org.compiere.model.MUOM;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trx;

public class Doc_MatchInvJP
extends Doc {
    private static final BigDecimal TOLERANCE = BigDecimal.valueOf(0.02);
    private MInvoiceLine m_invoiceLine = null;
    private MInOutLine m_receiptLine = null;
    private ProductCost m_pc = null;
    private MMatchInv m_matchInv;
    private MContractAcct m_contractAcct = null;

    public Doc_MatchInvJP(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MMatchInv.class, rs, "MXI", trxName);
    }

    protected String loadDocumentDetails() {
        MContractContent content;
        int JP_Contract_Acct_ID;
        this.setC_Currency_ID(-2);
        this.m_matchInv = (MMatchInv)this.getPO();
        this.setDateDoc(this.m_matchInv.getDateTrx());
        this.setQty(this.m_matchInv.getQty());
        int C_InvoiceLine_ID = this.m_matchInv.getC_InvoiceLine_ID();
        this.m_invoiceLine = new MInvoiceLine(this.getCtx(), C_InvoiceLine_ID, this.getTrxName());
        int C_BPartner_ID = this.m_invoiceLine.getParent().getC_BPartner_ID();
        this.setC_BPartner_ID(C_BPartner_ID);
        int M_InOutLine_ID = this.m_matchInv.getM_InOutLine_ID();
        this.m_receiptLine = new MInOutLine(this.getCtx(), M_InOutLine_ID, this.getTrxName());
        this.m_pc = new ProductCost(Env.getCtx(), this.getM_Product_ID(), this.m_matchInv.getM_AttributeSetInstance_ID(), this.getTrxName());
        this.m_pc.setQty(this.getQty());
        int JP_ContractContent_ID = this.m_invoiceLine.getParent().get_ValueAsInt("JP_ContractContent_ID");
        if (JP_ContractContent_ID > 0 && (JP_Contract_Acct_ID = (content = MContractContent.get(this.getCtx(), JP_ContractContent_ID)).getJP_Contract_Acct_ID()) > 0) {
            this.m_contractAcct = MContractAcct.get(this.getCtx(), JP_Contract_Acct_ID);
        }
        return null;
    }

    public BigDecimal getBalance() {
        return Env.ZERO;
    }

    public ArrayList<Fact> createFacts(MAcctSchema as) {
        BigDecimal credit;
        BigDecimal debit;
        MInvoice invoice;
        ArrayList<Fact> facts = new ArrayList<Fact>();
        ArrayList<FactLine> invGainLossFactLines = new ArrayList<FactLine>();
        ArrayList<MInvoice> invList = new ArrayList<MInvoice>();
        ArrayList<MInvoiceLine> invLineList = new ArrayList<MInvoiceLine>();
        HashMap<Integer, ArrayList<FactLine>> htFactLineInv = new HashMap<Integer, ArrayList<FactLine>>();
        ArrayList<FactLine> mrGainLossFactLines = new ArrayList<FactLine>();
        ArrayList<FactLine> mrFactLines = new ArrayList<FactLine>();
        if (this.getM_Product_ID() == 0 || this.getQty().signum() == 0 || this.m_receiptLine.get_ID() > 0 && this.m_receiptLine.getMovementQty().signum() == 0) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("No Product/Qty - M_Product_ID=" + this.getM_Product_ID() + ",Qty=" + this.getQty() + ",InOutQty=" + this.m_receiptLine.getMovementQty());
            }
            return facts;
        }
        if (this.m_receiptLine.getM_InOutLine_ID() == 0) {
            MInvoice m_invoice = new MInvoice(this.getCtx(), this.m_invoiceLine.getC_Invoice_ID(), this.getTrxName());
            boolean isCreditMemo = m_invoice.isCreditMemo();
            if (!isCreditMemo) {
                return facts;
            }
            return this.createCreditMemoFacts(as);
        }
        if (this.m_receiptLine.getParent().getC_DocType().getDocBaseType().equals("MMS")) {
            return this.createMatShipmentFacts(as);
        }
        Fact fact = new Fact((Doc)this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        boolean isInterOrg = this.isInterOrg(as);
        BigDecimal multiplier = this.getQty().divide(this.m_receiptLine.getMovementQty(), 12, RoundingMode.HALF_UP);
        FactLine dr = fact.createLine(null, this.getAccount(51, as), as.getC_Currency_ID(), Env.ONE, null);
        if (dr == null) {
            this.p_Error = "No Product Costs";
            return null;
        }
        dr.setQty(this.getQty());
        BigDecimal temp = dr.getAcctBalance();
        if (this.m_matchInv.isReversal()) {
            if (!dr.updateReverseLine(472, this.m_matchInv.getReversal_ID(), 0, BigDecimal.ONE)) {
                this.p_Error = "Failed to create reversal entry";
                return null;
            }
        } else if (!dr.updateReverseLine(319, this.m_receiptLine.getM_InOut_ID(), this.m_receiptLine.getM_InOutLine_ID(), multiplier)) {
            this.p_Error = "Mat.Receipt not posted yet";
            return null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("CR - Amt(" + temp + "->" + dr.getAcctBalance() + ") - " + dr.toString());
        }
        MAccount expense = this.m_pc.getAccount(10, as);
        if (this.m_pc.isService()) {
            expense = this.m_pc.getAccount(2, as);
        }
        BigDecimal LineNetAmt = this.m_invoiceLine.getLineNetAmt();
        multiplier = this.getQty().divide(this.m_invoiceLine.getQtyInvoiced(), 12, RoundingMode.HALF_UP);
        if (multiplier.compareTo(Env.ONE) != 0) {
            LineNetAmt = LineNetAmt.multiply(multiplier);
        }
        if (this.m_pc.isService()) {
            LineNetAmt = dr.getAcctBalance();
        }
        FactLine cr = null;
        if (as.isAccrual()) {
            cr = fact.createLine(null, expense, as.getC_Currency_ID(), null, LineNetAmt);
            if (cr == null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Line Net Amt=0 - M_Product_ID=" + this.getM_Product_ID() + ",Qty=" + this.getQty() + ",InOutQty=" + this.m_receiptLine.getMovementQty());
                }
                cr = fact.createLine(null, expense, as.getC_Currency_ID(), null, Env.ONE);
                cr.setAmtAcctCr(BigDecimal.ZERO);
                cr.setAmtSourceCr(BigDecimal.ZERO);
            }
            temp = cr.getAcctBalance();
            if (this.m_matchInv.isReversal()) {
                if (!cr.updateReverseLine(472, this.m_matchInv.getReversal_ID(), 0, BigDecimal.ONE)) {
                    this.p_Error = "Failed to create reversal entry";
                    return null;
                }
            } else {
                cr.setQty(this.getQty().negate());
                if (this.m_pc.isService() && this.m_contractAcct != null) {
                    cr.setAccount(as, this.getInvoiceExpenseAccount(as));
                }
                if (!cr.updateReverseLine(318, this.m_invoiceLine.getC_Invoice_ID(), this.m_invoiceLine.getC_InvoiceLine_ID(), multiplier)) {
                    this.p_Error = "Invoice not posted yet";
                    return null;
                }
                if (this.m_pc.isService() && this.m_contractAcct != null) {
                    cr.setAccount(as, expense);
                }
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("DR - Amt(" + temp + "->" + cr.getAcctBalance() + ") - " + cr.toString());
            }
        } else {
            invoice = this.m_invoiceLine.getParent();
            if (as.getC_Currency_ID() != invoice.getC_Currency_ID()) {
                LineNetAmt = MConversionRate.convert((Properties)this.getCtx(), (BigDecimal)LineNetAmt, (int)invoice.getC_Currency_ID(), (int)as.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
            }
            cr = fact.createLine(null, expense, as.getC_Currency_ID(), null, LineNetAmt);
            if (this.m_matchInv.isReversal()) {
                if (!cr.updateReverseLine(472, this.m_matchInv.getReversal_ID(), 0, BigDecimal.ONE)) {
                    this.p_Error = "Failed to create reversal entry";
                    return null;
                }
            } else {
                int precision = MUOM.getPrecision((Properties)this.getCtx(), (int)this.m_invoiceLine.getC_UOM_ID());
                cr.setQty(this.getQty().multiply(multiplier).negate().setScale(precision, RoundingMode.HALF_UP));
            }
        }
        if (this.m_receiptLine != null && this.m_invoiceLine.getParent().getC_Currency_ID() != as.getC_Currency_ID()) {
            mrFactLines.add(dr);
            this.p_Error = this.createReceiptGainLoss(as, fact, this.getAccount(51, as), this.m_receiptLine.getParent(), dr.getAmtSourceDr(), dr.getAmtAcctDr(), mrGainLossFactLines, mrFactLines);
            if (this.p_Error != null) {
                return null;
            }
        }
        if (!mrFactLines.isEmpty()) {
            this.p_Error = this.createReceiptRoundingCorrection(as, fact, this.getAccount(51, as), mrGainLossFactLines, mrFactLines);
            if (this.p_Error != null) {
                return null;
            }
        }
        if (this.m_invoiceLine != null && this.m_invoiceLine.getParent().getC_Currency_ID() != as.getC_Currency_ID()) {
            ArrayList<Object> factLineList;
            invoice = this.m_invoiceLine.getParent();
            if (!invList.contains(invoice)) {
                invList.add(invoice);
            }
            if (!invLineList.contains(this.m_invoiceLine)) {
                invLineList.add(this.m_invoiceLine);
            }
            if ((factLineList = htFactLineInv.get(invoice.get_ID())) == null) {
                factLineList = new ArrayList();
            }
            factLineList.add(cr);
            htFactLineInv.put(invoice.get_ID(), factLineList);
            this.p_Error = this.createInvoiceGainLoss(as, fact, expense, invoice, cr.getAmtSourceCr(), cr.getAmtAcctCr(), invGainLossFactLines, htFactLineInv);
            if (this.p_Error != null) {
                return null;
            }
        }
        if (!htFactLineInv.isEmpty()) {
            this.p_Error = this.createInvoiceRoundingCorrection(as, fact, expense, invGainLossFactLines, invList, invLineList, htFactLineInv);
            if (this.p_Error != null) {
                return null;
            }
        }
        cr.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
        cr.setC_Campaign_ID(this.m_invoiceLine.getC_Campaign_ID());
        cr.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
        cr.setC_ProjectPhase_ID(this.m_invoiceLine.getC_ProjectPhase_ID());
        cr.setC_ProjectTask_ID(this.m_invoiceLine.getC_ProjectTask_ID());
        cr.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
        cr.setUser1_ID(this.m_invoiceLine.getUser1_ID());
        cr.setUser2_ID(this.m_invoiceLine.getUser2_ID());
        if (this.m_matchInv.isReversal()) {
            cr.setQty(this.getQty().negate());
        }
        if (dr.getC_Currency_ID() != cr.getC_Currency_ID()) {
            this.setIsMultiCurrency(true);
        }
        MAccount acct_db = dr.getAccount();
        MAccount acct_cr = cr.getAccount();
        if (!as.isPostIfClearingEqual() && acct_db.equals((Object)acct_cr) && !isInterOrg && (debit = dr.getAmtSourceDr()).compareTo(credit = cr.getAmtSourceCr()) == 0) {
            fact.remove(dr);
            fact.remove(cr);
        }
        BigDecimal ipv = cr.getAcctBalance().add(dr.getAcctBalance()).negate();
        this.processInvoicePriceVariance(as, fact, ipv);
        String error = this.createMatchInvCostDetail(as);
        if (error != null && error.trim().length() > 0) {
            this.p_Error = error;
            return null;
        }
        facts.add(fact);
        return facts;
    }

    protected void processInvoicePriceVariance(MAcctSchema as, Fact fact, BigDecimal ipv) {
        boolean zeroQty;
        block24: {
            if (ipv.signum() == 0) {
                return;
            }
            FactLine pv = null;
            pv = this.m_pc.isService() ? fact.createLine(null, this.m_pc.getAccount(2, as), as.getC_Currency_ID(), ipv) : fact.createLine(null, this.m_pc.getAccount(6, as), as.getC_Currency_ID(), ipv);
            this.updateFactLineByReceiptLine(pv);
            MMatchInv matchInv = (MMatchInv)this.getPO();
            Trx trx = Trx.get((String)this.getTrxName(), (boolean)false);
            Savepoint savepoint = null;
            zeroQty = false;
            try {
                try {
                    savepoint = trx.setSavepoint(null);
                    if (!MCostDetail.createMatchInvoice((MAcctSchema)as, (int)this.m_invoiceLine.getAD_Org_ID(), (int)this.m_invoiceLine.getM_Product_ID(), (int)this.m_invoiceLine.getM_AttributeSetInstance_ID(), (int)matchInv.getM_MatchInv_ID(), (int)0, (BigDecimal)ipv, (BigDecimal)BigDecimal.ZERO, (String)"Invoice Price Variance", (String)this.getTrxName())) {
                        throw new RuntimeException("Failed to create cost detail record.");
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e.getLocalizedMessage(), e);
                }
                catch (AverageCostingZeroQtyException e) {
                    zeroQty = true;
                    try {
                        trx.rollback(savepoint);
                        savepoint = null;
                    }
                    catch (SQLException e1) {
                        throw new RuntimeException(e1.getLocalizedMessage(), e1);
                    }
                    if (savepoint != null) {
                        try {
                            trx.releaseSavepoint(savepoint);
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block24;
                }
            }
            catch (Throwable throwable) {
                if (savepoint != null) {
                    try {
                        trx.releaseSavepoint(savepoint);
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            if (savepoint != null) {
                try {
                    trx.releaseSavepoint(savepoint);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        String costingMethod = this.m_pc.getProduct().getCostingMethod(as);
        MAccount account = this.m_pc.getAccount(3, as);
        if (this.m_pc.isService()) {
            account = this.m_pc.getAccount(2, as);
        }
        if ("A".equals(costingMethod)) {
            if (zeroQty) {
                account = this.m_pc.getAccount(23, as);
            }
            FactLine line = fact.createLine(null, this.m_pc.getAccount(6, as), as.getC_Currency_ID(), ipv.negate());
            this.updateFactLineByReceiptLine(line);
            line.setQty(this.getQty().negate());
            line = fact.createLine(null, account, as.getC_Currency_ID(), ipv);
            this.updateFactLineByReceiptLine(line);
        } else if ("I".equals(costingMethod) && !zeroQty) {
            FactLine line = fact.createLine(null, this.m_pc.getAccount(6, as), as.getC_Currency_ID(), ipv.negate());
            this.updateFactLineByReceiptLine(line);
            line.setQty(this.getQty().negate());
            line = fact.createLine(null, account, as.getC_Currency_ID(), ipv);
            this.updateFactLineByReceiptLine(line);
        }
    }

    private boolean isInterOrg(MAcctSchema as) {
        MAcctSchemaElement elementorg = as.getAcctSchemaElement("OO");
        if (elementorg == null || !elementorg.isBalanced()) {
            return false;
        }
        return this.m_receiptLine != null && this.m_invoiceLine != null && this.m_receiptLine.getAD_Org_ID() != this.m_invoiceLine.getAD_Org_ID();
    }

    private String createMatchInvCostDetail(MAcctSchema as) {
        if (this.m_invoiceLine != null && this.m_invoiceLine.get_ID() > 0 && this.m_receiptLine != null && this.m_receiptLine.get_ID() > 0) {
            MOrderLandedCostAllocation[] allocations;
            MMatchInv matchInv = (MMatchInv)this.getPO();
            BigDecimal LineNetAmt = this.m_invoiceLine.getLineNetAmt();
            BigDecimal multiplier = this.getQty().divide(this.m_invoiceLine.getQtyInvoiced(), 12, RoundingMode.HALF_UP);
            if (multiplier.compareTo(Env.ONE) != 0) {
                LineNetAmt = LineNetAmt.multiply(multiplier);
            }
            MMatchInv[] mInv = MMatchInv.getInvoiceLine((Properties)this.getCtx(), (int)this.m_invoiceLine.getC_InvoiceLine_ID(), (String)this.getTrxName());
            BigDecimal tQty = Env.ZERO;
            BigDecimal tAmt = Env.ZERO;
            int i = 0;
            while (i < mInv.length) {
                if (mInv[i].isPosted() && mInv[i].getM_MatchInv_ID() != this.get_ID() && mInv[i].getM_AttributeSetInstance_ID() == matchInv.getM_AttributeSetInstance_ID()) {
                    tQty = tQty.add(mInv[i].getQty());
                    multiplier = mInv[i].getQty().divide(this.m_invoiceLine.getQtyInvoiced(), 12, RoundingMode.HALF_UP);
                    tAmt = tAmt.add(this.m_invoiceLine.getLineNetAmt().multiply(multiplier));
                }
                ++i;
            }
            tAmt = tAmt.add(LineNetAmt);
            MInvoice invoice = this.m_invoiceLine.getParent();
            if (as.getC_Currency_ID() != invoice.getC_Currency_ID() && (tAmt = MConversionRate.convert((Properties)this.getCtx(), (BigDecimal)tAmt, (int)invoice.getC_Currency_ID(), (int)as.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID())) == null) {
                return "AP Invoice not convertible - " + as.getName();
            }
            MInOut receipt = this.m_receiptLine.getParent();
            tQty = receipt.getMovementType().equals("V-") ? tQty.add(this.getQty().negate()) : tQty.add(this.getQty());
            if (!MCostDetail.createInvoice((MAcctSchema)as, (int)this.getAD_Org_ID(), (int)this.getM_Product_ID(), (int)matchInv.getM_AttributeSetInstance_ID(), (int)this.m_invoiceLine.getC_InvoiceLine_ID(), (int)0, (BigDecimal)tAmt, (BigDecimal)tQty, (String)this.getDescription(), (String)this.getTrxName())) {
                return "Failed to create cost detail record";
            }
            LinkedHashMap<Integer, BigDecimal> landedCostMap = new LinkedHashMap<Integer, BigDecimal>();
            I_C_OrderLine orderLine = this.m_receiptLine.getC_OrderLine();
            if (orderLine == null) {
                return "";
            }
            int C_OrderLine_ID = orderLine.getC_OrderLine_ID();
            MOrderLandedCostAllocation[] mOrderLandedCostAllocationArray = allocations = MOrderLandedCostAllocation.getOfOrderLine((int)C_OrderLine_ID, (String)this.getTrxName());
            int n = allocations.length;
            int n2 = 0;
            while (n2 < n) {
                int elementId;
                BigDecimal elementAmt;
                MOrderLandedCostAllocation allocation = mOrderLandedCostAllocationArray[n2];
                BigDecimal totalAmt = allocation.getAmt();
                BigDecimal totalQty = allocation.getQty();
                BigDecimal amt = totalAmt.multiply(tQty).divide(totalQty, 12, RoundingMode.HALF_UP);
                if (orderLine.getC_Currency_ID() != as.getC_Currency_ID()) {
                    I_C_Order order = orderLine.getC_Order();
                    Timestamp dateAcct = order.getDateAcct();
                    BigDecimal rate = MConversionRate.getRate((int)order.getC_Currency_ID(), (int)as.getC_Currency_ID(), (Timestamp)dateAcct, (int)order.getC_ConversionType_ID(), (int)order.getAD_Client_ID(), (int)order.getAD_Org_ID());
                    if (rate == null) {
                        this.p_Error = "Purchase Order not convertible - " + as.getName();
                        return null;
                    }
                    if ((amt = amt.multiply(rate)).scale() > as.getCostingPrecision()) {
                        amt = amt.setScale(as.getCostingPrecision(), RoundingMode.HALF_UP);
                    }
                }
                elementAmt = (elementAmt = (BigDecimal)landedCostMap.get(elementId = allocation.getC_OrderLandedCost().getM_CostElement_ID())) == null ? amt : elementAmt.add(amt);
                landedCostMap.put(elementId, elementAmt);
                ++n2;
            }
            for (Integer elementId : landedCostMap.keySet()) {
                BigDecimal amt = (BigDecimal)landedCostMap.get(elementId);
                if (MCostDetail.createShipment((MAcctSchema)as, (int)this.getAD_Org_ID(), (int)this.getM_Product_ID(), (int)matchInv.getM_AttributeSetInstance_ID(), (int)this.m_receiptLine.getM_InOutLine_ID(), (int)elementId, (BigDecimal)amt, (BigDecimal)tQty, (String)this.getDescription(), (boolean)false, (String)this.getTrxName())) continue;
                return "Failed to create cost detail record";
            }
        }
        return "";
    }

    private ArrayList<Fact> createMatShipmentFacts(MAcctSchema as) {
        BigDecimal credit;
        BigDecimal debit;
        MInvoice invoice;
        ArrayList<Fact> facts = new ArrayList<Fact>();
        ArrayList<FactLine> invGainLossFactLines = new ArrayList<FactLine>();
        ArrayList<MInvoice> invList = new ArrayList<MInvoice>();
        ArrayList<MInvoiceLine> invLineList = new ArrayList<MInvoiceLine>();
        HashMap<Integer, ArrayList<FactLine>> htFactLineInv = new HashMap<Integer, ArrayList<FactLine>>();
        ArrayList<FactLine> mrGainLossFactLines = new ArrayList<FactLine>();
        ArrayList<FactLine> mrFactLines = new ArrayList<FactLine>();
        Fact fact = new Fact((Doc)this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        boolean isInterOrg = this.isInterOrg(as);
        BigDecimal multiplier = this.getQty().divide(this.m_receiptLine.getMovementQty(), 12, RoundingMode.HALF_UP);
        multiplier = multiplier.negate();
        FactLine dr = fact.createLine(null, this.getAccount(51, as), as.getC_Currency_ID(), null, Env.ONE);
        if (dr == null) {
            this.p_Error = "No Product Costs";
            return null;
        }
        dr.setQty(this.getQty());
        BigDecimal temp = dr.getAcctBalance();
        if (this.m_matchInv.isReversal()) {
            if (!dr.updateReverseLine(472, this.m_matchInv.getReversal_ID(), 0, BigDecimal.ONE)) {
                this.p_Error = "Failed to create reversal entry";
                return null;
            }
        } else if (!dr.updateReverseLine(319, this.m_receiptLine.getM_InOut_ID(), this.m_receiptLine.getM_InOutLine_ID(), multiplier)) {
            this.p_Error = "Mat.Shipment not posted yet";
            return null;
        }
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("CR - Amt(" + temp + "->" + dr.getAcctBalance() + ") - " + dr.toString());
        }
        MAccount expense = this.m_pc.getAccount(10, as);
        if (this.m_pc.isService()) {
            expense = this.m_pc.getAccount(2, as);
        }
        BigDecimal LineNetAmt = this.m_invoiceLine.getLineNetAmt();
        multiplier = this.getQty().divide(this.m_invoiceLine.getQtyInvoiced(), 12, RoundingMode.HALF_UP);
        if ((multiplier = multiplier.negate()).compareTo(Env.ONE) != 0) {
            LineNetAmt = LineNetAmt.multiply(multiplier);
        }
        if (this.m_pc.isService()) {
            LineNetAmt = dr.getAcctBalance();
        }
        FactLine cr = null;
        if (as.isAccrual()) {
            cr = fact.createLine(null, expense, as.getC_Currency_ID(), LineNetAmt, null);
            if (cr == null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Line Net Amt=0 - M_Product_ID=" + this.getM_Product_ID() + ",Qty=" + this.getQty() + ",InOutQty=" + this.m_receiptLine.getMovementQty());
                }
                cr = fact.createLine(null, expense, as.getC_Currency_ID(), Env.ONE, null);
                cr.setAmtAcctCr(BigDecimal.ZERO);
                cr.setAmtSourceCr(BigDecimal.ZERO);
            }
            temp = cr.getAcctBalance();
            if (this.m_matchInv.isReversal()) {
                if (!cr.updateReverseLine(472, this.m_matchInv.getReversal_ID(), 0, BigDecimal.ONE)) {
                    this.p_Error = "Failed to create reversal entry";
                    return null;
                }
            } else {
                cr.setQty(this.getQty().negate());
                if (this.m_pc.isService() && this.m_contractAcct != null) {
                    cr.setAccount(as, this.getInvoiceExpenseAccount(as));
                }
                if (!cr.updateReverseLine(318, this.m_invoiceLine.getC_Invoice_ID(), this.m_invoiceLine.getC_InvoiceLine_ID(), multiplier)) {
                    this.p_Error = "Invoice not posted yet";
                    return null;
                }
                if (this.m_pc.isService() && this.m_contractAcct != null) {
                    cr.setAccount(as, expense);
                }
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("DR - Amt(" + temp + "->" + cr.getAcctBalance() + ") - " + cr.toString());
            }
        } else {
            invoice = this.m_invoiceLine.getParent();
            if (as.getC_Currency_ID() != invoice.getC_Currency_ID()) {
                LineNetAmt = MConversionRate.convert((Properties)this.getCtx(), (BigDecimal)LineNetAmt, (int)invoice.getC_Currency_ID(), (int)as.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
            }
            cr = fact.createLine(null, expense, as.getC_Currency_ID(), LineNetAmt, null);
            if (this.m_matchInv.isReversal()) {
                if (!cr.updateReverseLine(472, this.m_matchInv.getReversal_ID(), 0, BigDecimal.ONE)) {
                    this.p_Error = "Failed to create reversal entry";
                    return null;
                }
            } else {
                int precision = MUOM.getPrecision((Properties)this.getCtx(), (int)this.m_invoiceLine.getC_UOM_ID());
                cr.setQty(this.getQty().multiply(multiplier).negate().setScale(precision, RoundingMode.HALF_UP));
            }
        }
        if (this.m_receiptLine != null && this.m_invoiceLine.getParent().getC_Currency_ID() != as.getC_Currency_ID()) {
            mrFactLines.add(dr);
            this.p_Error = this.createReceiptGainLoss(as, fact, this.getAccount(51, as), this.m_receiptLine.getParent(), dr.getAmtSourceCr(), dr.getAmtAcctCr(), mrGainLossFactLines, mrFactLines);
            if (this.p_Error != null) {
                return null;
            }
        }
        if (!mrFactLines.isEmpty()) {
            this.p_Error = this.createReceiptRoundingCorrection(as, fact, this.getAccount(51, as), mrGainLossFactLines, mrFactLines);
            if (this.p_Error != null) {
                return null;
            }
        }
        if (this.m_invoiceLine != null && this.m_invoiceLine.getParent().getC_Currency_ID() != as.getC_Currency_ID()) {
            ArrayList<Object> factLineList;
            invoice = this.m_invoiceLine.getParent();
            if (!invList.contains(invoice)) {
                invList.add(invoice);
            }
            if (!invLineList.contains(this.m_invoiceLine)) {
                invLineList.add(this.m_invoiceLine);
            }
            if ((factLineList = htFactLineInv.get(invoice.get_ID())) == null) {
                factLineList = new ArrayList();
            }
            factLineList.add(cr);
            htFactLineInv.put(invoice.get_ID(), factLineList);
            this.p_Error = this.createInvoiceGainLoss(as, fact, expense, invoice, cr.getAmtSourceDr(), cr.getAmtAcctDr(), invGainLossFactLines, htFactLineInv);
            if (this.p_Error != null) {
                return null;
            }
        }
        if (!htFactLineInv.isEmpty()) {
            this.p_Error = this.createInvoiceRoundingCorrection(as, fact, expense, invGainLossFactLines, invList, invLineList, htFactLineInv);
            if (this.p_Error != null) {
                return null;
            }
        }
        if (!this.m_matchInv.isReversal()) {
            cr.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
            cr.setC_Campaign_ID(this.m_invoiceLine.getC_Campaign_ID());
            cr.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
            cr.setC_ProjectPhase_ID(this.m_invoiceLine.getC_ProjectPhase_ID());
            cr.setC_ProjectTask_ID(this.m_invoiceLine.getC_ProjectTask_ID());
            cr.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
            cr.setUser1_ID(this.m_invoiceLine.getUser1_ID());
            cr.setUser2_ID(this.m_invoiceLine.getUser2_ID());
        } else {
            this.updateFactLine(cr);
        }
        if (dr.getC_Currency_ID() != cr.getC_Currency_ID()) {
            this.setIsMultiCurrency(true);
        }
        MAccount acct_db = dr.getAccount();
        MAccount acct_cr = cr.getAccount();
        if (!as.isPostIfClearingEqual() && acct_db.equals((Object)acct_cr) && !isInterOrg && (debit = dr.getAmtSourceDr()).compareTo(credit = cr.getAmtSourceCr()) == 0) {
            fact.remove(dr);
            fact.remove(cr);
        }
        BigDecimal ipv = cr.getAcctBalance().add(dr.getAcctBalance()).negate();
        this.processInvoicePriceVariance(as, fact, ipv);
        String error = this.createMatchInvCostDetail(as);
        if (error != null && error.trim().length() > 0) {
            this.p_Error = error;
            return null;
        }
        facts.add(fact);
        return facts;
    }

    public ArrayList<Fact> createCreditMemoFacts(MAcctSchema as) {
        BigDecimal credit;
        BigDecimal debit;
        MInvoice invoice;
        ArrayList<Fact> facts = new ArrayList<Fact>();
        ArrayList<FactLine> invGainLossFactLines = new ArrayList<FactLine>();
        ArrayList<MInvoice> invList = new ArrayList<MInvoice>();
        ArrayList<MInvoiceLine> invLineList = new ArrayList<MInvoiceLine>();
        HashMap<Integer, ArrayList<FactLine>> htFactLineInv = new HashMap<Integer, ArrayList<FactLine>>();
        Fact fact = new Fact((Doc)this, as, "A");
        this.setC_Currency_ID(as.getC_Currency_ID());
        MMatchInv refMatchInv = new MMatchInv(this.getCtx(), this.m_matchInv.getRef_MatchInv_ID(), this.getTrxName());
        MInvoiceLine refInvLine = new MInvoiceLine(this.getCtx(), refMatchInv.getC_InvoiceLine_ID(), this.getTrxName());
        boolean isInterOrg = false;
        MAcctSchemaElement elementorg = as.getAcctSchemaElement("OO");
        if (elementorg == null || !elementorg.isBalanced()) {
            isInterOrg = false;
        }
        if (refInvLine != null && this.m_invoiceLine != null && refInvLine.getAD_Org_ID() != this.m_invoiceLine.getAD_Org_ID()) {
            isInterOrg = true;
        }
        MAccount expense = this.m_pc.getAccount(10, as);
        if (this.m_pc.isService()) {
            expense = this.m_pc.getAccount(2, as);
        }
        BigDecimal LineNetAmt = refInvLine.getLineNetAmt();
        BigDecimal multiplier = this.getQty().divide(refInvLine.getQtyInvoiced(), 12, RoundingMode.HALF_UP);
        if ((multiplier = multiplier.negate()).compareTo(Env.ONE) != 0) {
            LineNetAmt = LineNetAmt.multiply(multiplier);
        }
        FactLine dr = null;
        if (as.isAccrual()) {
            dr = fact.createLine(null, expense, as.getC_Currency_ID(), LineNetAmt, null);
            if (dr == null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Line Net Amt=0 - M_Product_ID=" + this.getM_Product_ID() + ",Qty=" + this.getQty() + ",InOutQty=" + this.m_receiptLine.getMovementQty());
                }
                dr = fact.createLine(null, expense, as.getC_Currency_ID(), Env.ONE, null);
                dr.setAmtAcctCr(BigDecimal.ZERO);
                dr.setAmtSourceCr(BigDecimal.ZERO);
            }
            BigDecimal temp = dr.getAcctBalance();
            if (this.m_matchInv.isReversal()) {
                if (!dr.updateReverseLine(472, this.m_matchInv.getReversal_ID(), 0, BigDecimal.ONE)) {
                    this.p_Error = "Failed to create reversal entry";
                    return null;
                }
            } else {
                dr.setQty(this.getQty().negate());
                if (this.m_pc.isService() && this.m_contractAcct != null) {
                    dr.setAccount(as, this.getInvoiceExpenseAccount(as));
                }
                if (!dr.updateReverseLine(318, refInvLine.getC_Invoice_ID(), refInvLine.getC_InvoiceLine_ID(), multiplier)) {
                    this.p_Error = "Invoice not posted yet";
                    return null;
                }
                if (this.m_pc.isService() && this.m_contractAcct != null) {
                    dr.setAccount(as, expense);
                }
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("DR - Amt(" + temp + "->" + dr.getAcctBalance() + ") - " + dr.toString());
            }
        } else {
            MInvoice invoice2 = refInvLine.getParent();
            if (as.getC_Currency_ID() != invoice2.getC_Currency_ID()) {
                LineNetAmt = MConversionRate.convert((Properties)this.getCtx(), (BigDecimal)LineNetAmt, (int)invoice2.getC_Currency_ID(), (int)as.getC_Currency_ID(), (Timestamp)invoice2.getDateAcct(), (int)invoice2.getC_ConversionType_ID(), (int)invoice2.getAD_Client_ID(), (int)invoice2.getAD_Org_ID());
            }
            dr = fact.createLine(null, expense, as.getC_Currency_ID(), LineNetAmt, null);
            if (this.m_matchInv.isReversal()) {
                if (!dr.updateReverseLine(472, this.m_matchInv.getReversal_ID(), 0, BigDecimal.ONE)) {
                    this.p_Error = "Failed to create reversal entry";
                    return null;
                }
            } else {
                int precision = MUOM.getPrecision((Properties)this.getCtx(), (int)this.m_invoiceLine.getC_UOM_ID());
                dr.setQty(this.getQty().multiply(multiplier).negate().setScale(precision, RoundingMode.HALF_UP));
            }
        }
        if (!this.m_matchInv.isReversal()) {
            dr.setC_Activity_ID(refInvLine.getC_Activity_ID());
            dr.setC_Campaign_ID(refInvLine.getC_Campaign_ID());
            dr.setC_Project_ID(refInvLine.getC_Project_ID());
            dr.setC_ProjectPhase_ID(refInvLine.getC_ProjectPhase_ID());
            dr.setC_ProjectTask_ID(refInvLine.getC_ProjectTask_ID());
            dr.setC_UOM_ID(refInvLine.getC_UOM_ID());
            dr.setUser1_ID(refInvLine.getUser1_ID());
            dr.setUser2_ID(refInvLine.getUser2_ID());
        } else {
            this.updateFactLine(dr);
        }
        LineNetAmt = this.m_invoiceLine.getLineNetAmt();
        multiplier = this.getQty().divide(this.m_invoiceLine.getQtyInvoiced(), 12, RoundingMode.HALF_UP);
        multiplier = multiplier.negate();
        if (multiplier.compareTo(Env.ONE) != 0) {
            LineNetAmt = LineNetAmt.multiply(multiplier);
        }
        if (this.m_pc.isService()) {
            LineNetAmt = dr.getAcctBalance();
        }
        FactLine cr = null;
        if (as.isAccrual()) {
            cr = fact.createLine(null, expense, as.getC_Currency_ID(), LineNetAmt, null);
            if (cr == null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Line Net Amt=0 - M_Product_ID=" + this.getM_Product_ID() + ",Qty=" + this.getQty() + ",InOutQty=" + this.m_receiptLine.getMovementQty());
                }
                cr = fact.createLine(null, expense, as.getC_Currency_ID(), Env.ONE, null);
                cr.setAmtAcctCr(BigDecimal.ZERO);
                cr.setAmtSourceCr(BigDecimal.ZERO);
            }
            BigDecimal temp = cr.getAcctBalance();
            if (this.m_matchInv.isReversal()) {
                if (!cr.updateReverseLine(472, this.m_matchInv.getReversal_ID(), 0, BigDecimal.ONE)) {
                    this.p_Error = "Failed to create reversal entry";
                    return null;
                }
            } else {
                cr.setQty(this.getQty().negate());
                if (!cr.updateReverseLine(318, this.m_invoiceLine.getC_Invoice_ID(), this.m_invoiceLine.getC_InvoiceLine_ID(), multiplier)) {
                    this.p_Error = "Invoice not posted yet";
                    return null;
                }
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("DR - Amt(" + temp + "->" + cr.getAcctBalance() + ") - " + cr.toString());
            }
        } else {
            invoice = this.m_invoiceLine.getParent();
            if (as.getC_Currency_ID() != invoice.getC_Currency_ID()) {
                LineNetAmt = MConversionRate.convert((Properties)this.getCtx(), (BigDecimal)LineNetAmt, (int)invoice.getC_Currency_ID(), (int)as.getC_Currency_ID(), (Timestamp)invoice.getDateAcct(), (int)invoice.getC_ConversionType_ID(), (int)invoice.getAD_Client_ID(), (int)invoice.getAD_Org_ID());
            }
            cr = fact.createLine(null, expense, as.getC_Currency_ID(), LineNetAmt, null);
            if (this.m_matchInv.isReversal()) {
                if (!cr.updateReverseLine(472, this.m_matchInv.getReversal_ID(), 0, BigDecimal.ONE)) {
                    this.p_Error = "Failed to create reversal entry";
                    return null;
                }
            } else {
                int precision = MUOM.getPrecision((Properties)this.getCtx(), (int)this.m_invoiceLine.getC_UOM_ID());
                cr.setQty(this.getQty().multiply(multiplier).negate().setScale(precision, RoundingMode.HALF_UP));
            }
        }
        if (refInvLine != null && refInvLine.getParent().getC_Currency_ID() != as.getC_Currency_ID()) {
            ArrayList<Object> factLineList;
            invoice = refInvLine.getParent();
            if (!invList.contains(invoice)) {
                invList.add(invoice);
            }
            if (!invLineList.contains(refInvLine)) {
                invLineList.add(refInvLine);
            }
            if ((factLineList = htFactLineInv.get(invoice.get_ID())) == null) {
                factLineList = new ArrayList();
            }
            factLineList.add(dr);
            htFactLineInv.put(invoice.get_ID(), factLineList);
            this.p_Error = this.createInvoiceGainLoss(as, fact, expense, invoice, dr.getAmtSourceCr(), dr.getAmtAcctCr(), invGainLossFactLines, htFactLineInv);
            if (this.p_Error != null) {
                return null;
            }
        }
        if (this.m_invoiceLine != null && this.m_invoiceLine.getParent().getC_Currency_ID() != as.getC_Currency_ID()) {
            ArrayList<Object> factLineList;
            invoice = this.m_invoiceLine.getParent();
            if (!invList.contains(invoice)) {
                invList.add(invoice);
            }
            if (!invLineList.contains(this.m_invoiceLine)) {
                invLineList.add(this.m_invoiceLine);
            }
            if ((factLineList = htFactLineInv.get(invoice.get_ID())) == null) {
                factLineList = new ArrayList();
            }
            factLineList.add(cr);
            htFactLineInv.put(invoice.get_ID(), factLineList);
            this.p_Error = this.createInvoiceGainLoss(as, fact, expense, invoice, cr.getAmtSourceDr(), cr.getAmtAcctDr(), invGainLossFactLines, htFactLineInv);
            if (this.p_Error != null) {
                return null;
            }
        }
        if (!htFactLineInv.isEmpty()) {
            this.p_Error = this.createInvoiceRoundingCorrection(as, fact, expense, invGainLossFactLines, invList, invLineList, htFactLineInv);
            if (this.p_Error != null) {
                return null;
            }
        }
        if (!this.m_matchInv.isReversal()) {
            cr.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
            cr.setC_Campaign_ID(this.m_invoiceLine.getC_Campaign_ID());
            cr.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
            cr.setC_ProjectPhase_ID(this.m_invoiceLine.getC_ProjectPhase_ID());
            cr.setC_ProjectTask_ID(this.m_invoiceLine.getC_ProjectTask_ID());
            cr.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
            cr.setUser1_ID(this.m_invoiceLine.getUser1_ID());
            cr.setUser2_ID(this.m_invoiceLine.getUser2_ID());
        } else {
            this.updateFactLine(cr);
        }
        if (dr.getC_Currency_ID() != cr.getC_Currency_ID()) {
            this.setIsMultiCurrency(true);
        }
        MAccount acct_db = dr.getAccount();
        MAccount acct_cr = cr.getAccount();
        if (!as.isPostIfClearingEqual() && acct_db.equals((Object)acct_cr) && !isInterOrg && (debit = dr.getAmtSourceDr()).compareTo(credit = cr.getAmtSourceCr()) == 0 && cr.getAcctBalance().add(dr.getAcctBalance()).compareTo(Env.ZERO) == 0) {
            fact.remove(dr);
            fact.remove(cr);
        }
        MAccount gain = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedLoss_Acct());
        BigDecimal ipv = cr.getAcctBalance().add(dr.getAcctBalance()).negate();
        if (ipv.compareTo(Env.ZERO) != 0) {
            FactLine pv = fact.createLine(null, cr.getAcctBalance().abs().compareTo(dr.getAcctBalance().abs()) < 0 ? loss : gain, as.getC_Currency_ID(), ipv);
            this.updateFactLine(pv);
        }
        facts.add(fact);
        return facts;
    }

    protected void updateFactLine(FactLine factLine) {
        factLine.setC_Activity_ID(this.m_invoiceLine.getC_Activity_ID());
        factLine.setC_Campaign_ID(this.m_invoiceLine.getC_Campaign_ID());
        factLine.setC_Project_ID(this.m_invoiceLine.getC_Project_ID());
        factLine.setC_ProjectPhase_ID(this.m_invoiceLine.getC_ProjectPhase_ID());
        factLine.setC_ProjectTask_ID(this.m_invoiceLine.getC_ProjectTask_ID());
        factLine.setC_UOM_ID(this.m_invoiceLine.getC_UOM_ID());
        factLine.setUser1_ID(this.m_invoiceLine.getUser1_ID());
        factLine.setUser2_ID(this.m_invoiceLine.getUser2_ID());
        factLine.setM_Product_ID(this.m_invoiceLine.getM_Product_ID());
        factLine.setQty(this.getQty());
    }

    protected void updateFactLineByReceiptLine(FactLine factLine) {
        factLine.setAD_Org_ID(this.m_receiptLine.getAD_Org_ID());
        factLine.setAD_OrgTrx_ID(this.m_receiptLine.getAD_OrgTrx_ID());
        factLine.setC_Activity_ID(this.m_receiptLine.getC_Activity_ID());
        factLine.setC_Campaign_ID(this.m_receiptLine.getC_Campaign_ID());
        factLine.setC_Project_ID(this.m_receiptLine.getC_Project_ID());
        factLine.setC_ProjectPhase_ID(this.m_receiptLine.getC_ProjectPhase_ID());
        factLine.setC_ProjectTask_ID(this.m_receiptLine.getC_ProjectTask_ID());
        factLine.setC_UOM_ID(this.m_receiptLine.getC_UOM_ID());
        factLine.setUser1_ID(this.m_receiptLine.getUser1_ID());
        factLine.setUser2_ID(this.m_receiptLine.getUser2_ID());
        factLine.setM_Product_ID(this.m_receiptLine.getM_Product_ID());
        factLine.setQty(this.getQty());
    }

    private String createInvoiceGainLoss(MAcctSchema as, Fact fact, MAccount acct, MInvoice invoice, BigDecimal matchInvSource, BigDecimal matchInvAccounted, ArrayList<FactLine> invGainLossFactLines, HashMap<Integer, ArrayList<FactLine>> htFactLineInv) {
        if (this.m_matchInv.isReversal()) {
            return this.createReversalInvoiceGainLossRoundingCorrection(as, fact, acct);
        }
        BigDecimal invoiceSource = null;
        BigDecimal invoiceAccounted = null;
        StringBuilder sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND Account_ID=?").append(" AND PostingType='A'");
        List valuesInv = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sql.toString(), (Object[])new Object[]{318, invoice.getC_Invoice_ID(), as.getC_AcctSchema_ID(), acct.getAccount_ID()});
        if (valuesInv != null) {
            invoiceSource = (BigDecimal)valuesInv.get(0);
            invoiceAccounted = (BigDecimal)valuesInv.get(1);
            if (invoiceSource.signum() == 0 && invoiceAccounted.signum() == 0) {
                invoiceSource = (BigDecimal)valuesInv.get(2);
                invoiceAccounted = (BigDecimal)valuesInv.get(3);
            }
        }
        if (invoiceSource == null || invoiceAccounted == null) {
            return null;
        }
        StringBuilder description = new StringBuilder("Invoice=(").append(invoice.getC_Currency_ID()).append(")").append(invoiceSource).append("/").append(invoiceAccounted).append(" - MatchInv=(").append(this.getC_Currency_ID()).append(")").append(matchInvSource).append("/").append(matchInvAccounted);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(description.toString());
        }
        BigDecimal acctDifference = null;
        if (matchInvSource.compareTo(invoiceSource) == 0) {
            acctDifference = matchInvAccounted.abs().subtract(invoiceAccounted.abs());
            StringBuilder d2 = new StringBuilder("(full) = ").append(acctDifference);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(d2.toString());
            }
            description.append(" - ").append((CharSequence)d2);
        }
        if (acctDifference == null || acctDifference.signum() == 0) {
            this.log.fine("No Difference");
            return null;
        }
        MAccount gain = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedLoss_Acct());
        FactLine fl = fact.createLine(null, acct, as.getC_Currency_ID(), acctDifference);
        fl.setDescription(description.toString());
        this.updateFactLine(fl);
        ArrayList<Object> factLineList = htFactLineInv.get(invoice.get_ID());
        if (factLineList == null) {
            factLineList = new ArrayList();
        }
        factLineList.add(fl);
        fl = fact.createLine(null, loss, gain, as.getC_Currency_ID(), acctDifference.negate());
        fl.setDescription(description.toString());
        this.updateFactLine(fl);
        invGainLossFactLines.add(fl);
        factLineList.add(fl);
        htFactLineInv.put(invoice.get_ID(), factLineList);
        return null;
    }

    private String createReversalInvoiceGainLossRoundingCorrection(MAcctSchema as, Fact fact, MAccount acct) {
        if (!this.m_matchInv.isReversal()) {
            return null;
        }
        MAccount gain = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedLoss_Acct());
        StringBuilder whereClause = new StringBuilder().append("AD_Table_ID=?").append(" AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND PostingType='A'").append(" AND (Account_ID=? OR Account_ID=? OR Account_ID=? OR Account_ID=?)").append(" AND Description LIKE 'Invoice%'");
        List list = new Query(this.getCtx(), "Fact_Acct", whereClause.toString(), this.getTrxName()).setParameters(new Object[]{472, this.m_matchInv.getReversal_ID(), as.getC_AcctSchema_ID(), acct.getAccount_ID(), gain.getAccount_ID(), loss.getAccount_ID(), as.getCurrencyBalancing_Acct().getAccount_ID()}).setOrderBy("Fact_Acct_ID").list();
        for (MFactAcct fa : list) {
            FactLine fl = fact.createLine(null, fa.getMAccount(), fa.getC_Currency_ID(), fa.getAmtAcctCr(), fa.getAmtAcctDr());
            fl.setDescription(fa.getDescription());
            this.updateFactLine(fl);
        }
        return null;
    }

    private String createInvoiceRoundingCorrection(MAcctSchema as, Fact fact, MAccount acct, ArrayList<FactLine> invGainLossFactLines, ArrayList<MInvoice> invList, ArrayList<MInvoiceLine> invLineList, HashMap<Integer, ArrayList<FactLine>> htFactLineInv) {
        if (this.m_matchInv.isReversal()) {
            return null;
        }
        ArrayList<FactLine> invLineRoundingLines = new ArrayList<FactLine>();
        HashMap<Integer, ArrayList<FactLine>> htRoundingLineInvLine = new HashMap<Integer, ArrayList<FactLine>>();
        boolean isLineFullyMatched = this.createInvoiceLineRoundingCorrection(as, fact, acct, invGainLossFactLines, invList, invLineList, htFactLineInv, invLineRoundingLines, htRoundingLineInvLine);
        if (!isLineFullyMatched) {
            return null;
        }
        BigDecimal totalInvClrAccounted = Env.ZERO;
        for (FactLine invLineRoundingLine : invLineRoundingLines) {
            if (invLineRoundingLine.getAccount() != acct) continue;
            totalInvClrAccounted = totalInvClrAccounted.add(invLineRoundingLine.getAmtAcctDr()).subtract(invLineRoundingLine.getAmtAcctCr());
        }
        StringBuilder sqlInv = new StringBuilder().append("SELECT SUM(AmtSourceDr)-SUM(AmtSourceCr), SUM(AmtAcctDr)-SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND Account_ID=?").append(" AND PostingType='A'");
        HashMap<Integer, BigDecimal> htInvSource = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htInvAccounted = new HashMap<Integer, BigDecimal>();
        for (MInvoice invoice : invList) {
            BigDecimal invoiceAccountedDrCr;
            BigDecimal invoiceSourceDrCr;
            BigDecimal invoiceSource = Env.ZERO;
            BigDecimal invoiceAccounted = Env.ZERO;
            List valuesInv = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sqlInv.toString(), (Object[])new Object[]{318, invoice.getC_Invoice_ID(), as.getC_AcctSchema_ID(), acct.getAccount_ID()});
            if (valuesInv != null) {
                invoiceSourceDrCr = (BigDecimal)valuesInv.get(0);
                invoiceAccountedDrCr = (BigDecimal)valuesInv.get(1);
                invoiceSource = invoiceSource.add(invoiceSourceDrCr);
                invoiceAccounted = invoiceAccounted.add(invoiceAccountedDrCr);
                totalInvClrAccounted = totalInvClrAccounted.add(invoiceAccountedDrCr);
            }
            if ((valuesInv = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sqlInv.toString(), (Object[])new Object[]{318, invoice.getC_Invoice_ID(), as.getC_AcctSchema_ID(), as.getCurrencyBalancing_Acct().getAccount_ID()})) != null) {
                invoiceSourceDrCr = (BigDecimal)valuesInv.get(0);
                invoiceAccountedDrCr = (BigDecimal)valuesInv.get(1);
                if (invoiceSourceDrCr == null) {
                    invoiceSourceDrCr = Env.ZERO;
                }
                if (invoiceAccountedDrCr == null) {
                    invoiceAccountedDrCr = Env.ZERO;
                }
                invoiceSource = invoiceSource.add(invoiceSourceDrCr);
                invoiceAccounted = invoiceAccounted.add(invoiceAccountedDrCr);
            }
            htInvSource.put(invoice.getC_Invoice_ID(), invoiceSource.abs());
            htInvAccounted.put(invoice.getC_Invoice_ID(), invoiceAccounted.abs());
        }
        MAccount gain = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedLoss_Acct());
        HashMap<Integer, BigDecimal> htTotalAmtSourceDr = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htTotalAmtAcctDr = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htTotalAmtSourceCr = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htTotalAmtAcctCr = new HashMap<Integer, BigDecimal>();
        for (Integer C_Invoice_ID : htFactLineInv.keySet()) {
            ArrayList<FactLine> factLineList = htFactLineInv.get(C_Invoice_ID);
            for (FactLine factLine : factLineList) {
                BigDecimal totalAmtAcctCr;
                BigDecimal totalAmtSourceCr;
                BigDecimal totalAmtAcctDr;
                BigDecimal totalAmtSourceDr;
                if (factLine.getAccount_ID() == acct.getAccount_ID()) {
                    totalAmtSourceDr = (BigDecimal)htTotalAmtSourceDr.get(C_Invoice_ID);
                    if (totalAmtSourceDr == null) {
                        totalAmtSourceDr = Env.ZERO;
                    }
                    if ((totalAmtAcctDr = (BigDecimal)htTotalAmtAcctDr.get(C_Invoice_ID)) == null) {
                        totalAmtAcctDr = Env.ZERO;
                    }
                    if ((totalAmtSourceCr = (BigDecimal)htTotalAmtSourceCr.get(C_Invoice_ID)) == null) {
                        totalAmtSourceCr = Env.ZERO;
                    }
                    if ((totalAmtAcctCr = (BigDecimal)htTotalAmtAcctCr.get(C_Invoice_ID)) == null) {
                        totalAmtAcctCr = Env.ZERO;
                    }
                    totalAmtSourceDr = totalAmtSourceDr.add(factLine.getAmtSourceDr());
                    totalAmtAcctDr = totalAmtAcctDr.add(factLine.getAmtAcctDr());
                    totalAmtSourceCr = totalAmtSourceCr.add(factLine.getAmtSourceCr());
                    totalAmtAcctCr = totalAmtAcctCr.add(factLine.getAmtAcctCr());
                    htTotalAmtSourceDr.put(C_Invoice_ID, totalAmtSourceDr);
                    htTotalAmtAcctDr.put(C_Invoice_ID, totalAmtAcctDr);
                    htTotalAmtSourceCr.put(C_Invoice_ID, totalAmtSourceCr);
                    htTotalAmtAcctCr.put(C_Invoice_ID, totalAmtAcctCr);
                    totalInvClrAccounted = totalInvClrAccounted.add(factLine.getAmtAcctDr()).subtract(factLine.getAmtAcctCr());
                    continue;
                }
                if (factLine.getAccount_ID() != gain.getAccount_ID() && factLine.getAccount_ID() != loss.getAccount_ID() || !invGainLossFactLines.contains(factLine)) continue;
                totalAmtSourceDr = (BigDecimal)htTotalAmtSourceDr.get(C_Invoice_ID);
                if (totalAmtSourceDr == null) {
                    totalAmtSourceDr = Env.ZERO;
                }
                if ((totalAmtAcctDr = (BigDecimal)htTotalAmtAcctDr.get(C_Invoice_ID)) == null) {
                    totalAmtAcctDr = Env.ZERO;
                }
                if ((totalAmtSourceCr = (BigDecimal)htTotalAmtSourceCr.get(C_Invoice_ID)) == null) {
                    totalAmtSourceCr = Env.ZERO;
                }
                if ((totalAmtAcctCr = (BigDecimal)htTotalAmtAcctCr.get(C_Invoice_ID)) == null) {
                    totalAmtAcctCr = Env.ZERO;
                }
                totalAmtSourceDr = totalAmtSourceDr.add(factLine.getAmtSourceDr());
                totalAmtSourceCr = totalAmtSourceCr.add(factLine.getAmtSourceCr());
                htTotalAmtSourceDr.put(C_Invoice_ID, totalAmtSourceDr);
                htTotalAmtAcctDr.put(C_Invoice_ID, totalAmtAcctDr);
                htTotalAmtSourceCr.put(C_Invoice_ID, totalAmtSourceCr);
                htTotalAmtAcctCr.put(C_Invoice_ID, totalAmtAcctCr);
            }
        }
        HashMap<Integer, Object> htMatchInvSource = new HashMap<Integer, Object>();
        HashMap<Integer, BigDecimal> htMatchInvAccounted = new HashMap<Integer, BigDecimal>();
        HashMap htMatchInvAcctDiff = new HashMap();
        for (MInvoice invoice : invList) {
            MMatchInv matchInv;
            BigDecimal totalAmtAcctCr;
            BigDecimal totalAmtSourceCr;
            BigDecimal totalAmtAcctDr;
            Object matchInvSource = Env.ZERO;
            BigDecimal matchInvAccounted = Env.ZERO;
            BigDecimal totalAmtSourceDr = (BigDecimal)htTotalAmtSourceDr.get(invoice.getC_Invoice_ID());
            if (totalAmtSourceDr == null) {
                totalAmtSourceDr = Env.ZERO;
            }
            if ((totalAmtAcctDr = (BigDecimal)htTotalAmtAcctDr.get(invoice.getC_Invoice_ID())) == null) {
                totalAmtAcctDr = Env.ZERO;
            }
            if ((totalAmtSourceCr = (BigDecimal)htTotalAmtSourceCr.get(invoice.getC_Invoice_ID())) == null) {
                totalAmtSourceCr = Env.ZERO;
            }
            if ((totalAmtAcctCr = (BigDecimal)htTotalAmtAcctCr.get(invoice.getC_Invoice_ID())) == null) {
                totalAmtAcctCr = Env.ZERO;
            }
            matchInvSource = ((BigDecimal)matchInvSource).add(totalAmtSourceDr).subtract(totalAmtSourceCr);
            matchInvAccounted = matchInvAccounted.add(totalAmtAcctDr).subtract(totalAmtAcctCr);
            for (FactLine invLineRoundingLine : invLineRoundingLines) {
                ArrayList<FactLine> roundingLineList;
                if (invLineRoundingLine.getAccount() != acct || (roundingLineList = htRoundingLineInvLine.get(invoice.get_ID())) == null || !roundingLineList.contains(invLineRoundingLine)) continue;
                matchInvAccounted = matchInvAccounted.add(invLineRoundingLine.getAmtAcctDr()).subtract(invLineRoundingLine.getAmtAcctCr());
            }
            MMatchInv[] matchInvs = MMatchInv.getInvoice((Properties)this.getCtx(), (int)invoice.get_ID(), (String)this.getTrxName());
            ArrayList<Integer> skipMatchInvIdList = new ArrayList<Integer>();
            skipMatchInvIdList.add(this.m_matchInv.get_ID());
            MMatchInv[] mMatchInvArray = matchInvs;
            int n = matchInvs.length;
            int n2 = 0;
            while (n2 < n) {
                matchInv = mMatchInvArray[n2];
                if (matchInv.isReversal()) {
                    skipMatchInvIdList.add(matchInv.get_ID());
                }
                ++n2;
            }
            mMatchInvArray = matchInvs;
            n = matchInvs.length;
            n2 = 0;
            while (n2 < n) {
                matchInv = mMatchInvArray[n2];
                if (matchInv.get_ID() != this.m_matchInv.get_ID() && !skipMatchInvIdList.contains(matchInv.get_ID())) {
                    List valuesMatchInv;
                    StringBuilder sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND (Record_ID=? OR Record_ID=?)").append(" AND C_AcctSchema_ID=?").append(" AND PostingType='A'").append(" AND Account_ID=?");
                    if (this.m_matchInv.isReversal()) {
                        if (matchInv.isReversal()) {
                            sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                        }
                        sql.append(" AND Record_ID < ").append(this.m_matchInv.getReversal_ID());
                    } else if (matchInv.getReversal_ID() > 0) {
                        sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                    }
                    if (matchInv.getRef_MatchInv_ID() > 0) {
                        if (invoice.isCreditMemo() && matchInv.getQty().compareTo(BigDecimal.ZERO) < 0) {
                            sql.append(" AND Qty > 0");
                        } else {
                            sql.append(" AND Qty < 0");
                        }
                    }
                    if ((valuesMatchInv = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sql.toString(), (Object[])new Object[]{472, matchInv.get_ID(), matchInv.getRef_MatchInv_ID() > 0 ? matchInv.getRef_MatchInv_ID() : -1, as.getC_AcctSchema_ID(), acct.getAccount_ID()})) != null) {
                        totalAmtSourceDr = (BigDecimal)valuesMatchInv.get(0);
                        if (totalAmtSourceDr == null) {
                            totalAmtSourceDr = Env.ZERO;
                        }
                        if ((totalAmtAcctDr = (BigDecimal)valuesMatchInv.get(1)) == null) {
                            totalAmtAcctDr = Env.ZERO;
                        }
                        if ((totalAmtSourceCr = (BigDecimal)valuesMatchInv.get(2)) == null) {
                            totalAmtSourceCr = Env.ZERO;
                        }
                        if ((totalAmtAcctCr = (BigDecimal)valuesMatchInv.get(3)) == null) {
                            totalAmtAcctCr = Env.ZERO;
                        }
                        matchInvSource = ((BigDecimal)matchInvSource).add(totalAmtSourceDr).subtract(totalAmtSourceCr);
                        matchInvAccounted = matchInvAccounted.add(totalAmtAcctDr).subtract(totalAmtAcctCr);
                        totalInvClrAccounted = totalInvClrAccounted.add(totalAmtAcctDr).subtract(totalAmtAcctCr);
                    }
                    sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND (Record_ID=? OR Record_ID=?)").append(" AND C_AcctSchema_ID=?").append(" AND PostingType='A'").append(" AND (Account_ID=? OR Account_ID=? OR Account_ID=?)").append(" AND Description LIKE 'Invoice%'");
                    if (this.m_matchInv.isReversal()) {
                        if (matchInv.isReversal()) {
                            sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                        }
                        sql.append(" AND Record_ID < ").append(this.m_matchInv.getReversal_ID());
                    } else if (matchInv.getReversal_ID() > 0) {
                        sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                    }
                    if (matchInv.getRef_MatchInv_ID() > 0) {
                        if (invoice.isCreditMemo() && matchInv.getQty().compareTo(BigDecimal.ZERO) < 0) {
                            sql.append(" AND Qty > 0");
                        } else {
                            sql.append(" AND Qty < 0");
                        }
                    }
                    if ((valuesMatchInv = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sql.toString(), (Object[])new Object[]{472, matchInv.get_ID(), matchInv.getRef_MatchInv_ID() > 0 ? matchInv.getRef_MatchInv_ID() : -1, as.getC_AcctSchema_ID(), gain.getAccount_ID(), loss.getAccount_ID(), as.getCurrencyBalancing_Acct().getAccount_ID()})) != null) {
                        totalAmtSourceDr = (BigDecimal)valuesMatchInv.get(0);
                        if (totalAmtSourceDr == null) {
                            totalAmtSourceDr = Env.ZERO;
                        }
                        if ((totalAmtAcctDr = (BigDecimal)valuesMatchInv.get(1)) == null) {
                            totalAmtAcctDr = Env.ZERO;
                        }
                        if ((totalAmtSourceCr = (BigDecimal)valuesMatchInv.get(2)) == null) {
                            totalAmtSourceCr = Env.ZERO;
                        }
                        if ((totalAmtAcctCr = (BigDecimal)valuesMatchInv.get(3)) == null) {
                            totalAmtAcctCr = Env.ZERO;
                        }
                        matchInvSource = ((BigDecimal)matchInvSource).add(totalAmtSourceDr).subtract(totalAmtSourceCr);
                    }
                }
                ++n2;
            }
            htMatchInvSource.put(invoice.getC_Invoice_ID(), matchInvSource);
            htMatchInvAccounted.put(invoice.getC_Invoice_ID(), matchInvAccounted);
        }
        ArrayList<FactLine> invRoundingLines = new ArrayList<FactLine>();
        for (MInvoice invoice : invList) {
            BigDecimal matchInvAccounted;
            BigDecimal matchInvSource;
            BigDecimal invAccounted;
            BigDecimal invSource = (BigDecimal)htInvSource.get(invoice.getC_Invoice_ID());
            if (invSource == null) {
                invSource = Env.ZERO;
            }
            if ((invAccounted = (BigDecimal)htInvAccounted.get(invoice.getC_Invoice_ID())) == null) {
                invAccounted = Env.ZERO;
            }
            if ((matchInvSource = (BigDecimal)htMatchInvSource.get(invoice.getC_Invoice_ID())) == null) {
                matchInvSource = Env.ZERO;
            }
            if ((matchInvAccounted = (BigDecimal)htMatchInvAccounted.get(invoice.getC_Invoice_ID())) == null) {
                matchInvAccounted = Env.ZERO;
            }
            BigDecimal acctDifference = (BigDecimal)htMatchInvAcctDiff.get(invoice.getC_Invoice_ID());
            StringBuilder description = new StringBuilder("Invoice=(").append(this.getC_Currency_ID()).append(")").append(invSource).append("/").append(invAccounted).append(" - Match Invoice=(").append(this.getC_Currency_ID()).append(")").append(matchInvSource).append("/").append(matchInvAccounted);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(description.toString());
            }
            if (acctDifference == null && matchInvSource.abs().compareTo(invSource.abs()) == 0) {
                acctDifference = invAccounted.abs().subtract(matchInvAccounted.abs());
                StringBuilder d2 = new StringBuilder("(full) = ").append(acctDifference);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(d2.toString());
                }
                description.append(" - ").append((CharSequence)d2);
            } else {
                isLineFullyMatched = false;
            }
            if (acctDifference == null || acctDifference.signum() == 0) {
                this.log.fine("No Difference");
                continue;
            }
            if (acctDifference.abs().compareTo(TOLERANCE) >= 0) {
                this.log.fine("acctDifference=" + acctDifference);
                continue;
            }
            FactLine fl = fact.createLine(null, acct, as.getC_Currency_ID(), acctDifference.negate());
            fl.setDescription(description.toString());
            this.updateFactLine(fl);
            invRoundingLines.add(fl);
            totalInvClrAccounted = totalInvClrAccounted.add(fl.getAmtAcctDr()).subtract(fl.getAmtAcctCr());
            fl = as.isCurrencyBalancing() && as.getC_Currency_ID() != invoice.getC_Currency_ID() ? fact.createLine(null, as.getCurrencyBalancing_Acct(), as.getC_Currency_ID(), acctDifference) : fact.createLine(null, loss, gain, as.getC_Currency_ID(), acctDifference);
            fl.setDescription(description.toString());
            this.updateFactLine(fl);
            invRoundingLines.add(fl);
        }
        if (isLineFullyMatched) {
            if (totalInvClrAccounted != null && totalInvClrAccounted.signum() != 0 && totalInvClrAccounted.abs().compareTo(TOLERANCE) < 0) {
                BigDecimal totalRounding = Env.ZERO;
                for (FactLine invRoundingLine : invRoundingLines) {
                    if (invRoundingLine.getAccount() != acct) continue;
                    totalRounding = totalRounding.add(invRoundingLine.getAmtAcctDr()).subtract(invRoundingLine.getAmtAcctCr());
                }
                if (totalRounding.compareTo(totalInvClrAccounted) == 0) {
                    for (FactLine invRoundingLine : invRoundingLines) {
                        fact.remove(invRoundingLine);
                    }
                    totalInvClrAccounted = Env.ZERO;
                }
            }
            if (totalInvClrAccounted != null && totalInvClrAccounted.signum() != 0 && totalInvClrAccounted.abs().compareTo(TOLERANCE) < 0) {
                StringBuilder description = new StringBuilder("Invoice - MatchInv - (full) = ").append(totalInvClrAccounted);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(description.toString());
                }
                FactLine fl = fact.createLine(null, acct, as.getC_Currency_ID(), totalInvClrAccounted.negate());
                fl.setDescription(description.toString());
                this.updateFactLine(fl);
                fl = as.isCurrencyBalancing() ? fact.createLine(null, as.getCurrencyBalancing_Acct(), as.getC_Currency_ID(), totalInvClrAccounted) : fact.createLine(null, loss, gain, as.getC_Currency_ID(), totalInvClrAccounted);
                fl.setDescription(description.toString());
                this.updateFactLine(fl);
            }
        }
        return null;
    }

    private boolean createInvoiceLineRoundingCorrection(MAcctSchema as, Fact fact, MAccount acct, ArrayList<FactLine> invGainLossFactLines, ArrayList<MInvoice> invList, ArrayList<MInvoiceLine> invLineList, HashMap<Integer, ArrayList<FactLine>> htFactLineInv, ArrayList<FactLine> invRoundingLines, HashMap<Integer, ArrayList<FactLine>> htRoundingLineInv) {
        StringBuilder sqlInvLine = new StringBuilder().append("SELECT SUM(AmtSourceDr)-SUM(AmtSourceCr), SUM(AmtAcctDr)-SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=? AND Line_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND Account_ID=?").append(" AND PostingType='A'");
        HashMap<Integer, BigDecimal> htInvLineSource = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htInvLineAccounted = new HashMap<Integer, BigDecimal>();
        for (MInvoiceLine invoiceLine : invLineList) {
            List valuesInv = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sqlInvLine.toString(), (Object[])new Object[]{318, invoiceLine.getC_Invoice_ID(), invoiceLine.getC_InvoiceLine_ID(), as.getC_AcctSchema_ID(), acct.getAccount_ID()});
            if (valuesInv == null) continue;
            BigDecimal invoiceSourceDrCr = (BigDecimal)valuesInv.get(0);
            BigDecimal invoiceAccountedDrCr = (BigDecimal)valuesInv.get(1);
            htInvLineSource.put(invoiceLine.getC_InvoiceLine_ID(), invoiceSourceDrCr.abs());
            htInvLineAccounted.put(invoiceLine.getC_InvoiceLine_ID(), invoiceAccountedDrCr.abs());
        }
        MAccount gain = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedLoss_Acct());
        HashMap<Integer, BigDecimal> htInvClrSource = new HashMap<Integer, BigDecimal>();
        HashMap<Integer, BigDecimal> htInvClrAccounted = new HashMap<Integer, BigDecimal>();
        for (Integer C_Invoice_ID : htFactLineInv.keySet()) {
            ArrayList<FactLine> factLineList = htFactLineInv.get(C_Invoice_ID);
            for (FactLine factLine : factLineList) {
                if (factLine.getAccount_ID() != acct.getAccount_ID()) continue;
                BigDecimal invClrSource = (BigDecimal)htInvClrSource.get(C_Invoice_ID);
                if (invClrSource == null) {
                    invClrSource = Env.ZERO;
                }
                invClrSource = invClrSource.add(factLine.getAmtSourceDr()).subtract(factLine.getAmtSourceCr());
                htInvClrSource.put(C_Invoice_ID, invClrSource);
                BigDecimal invClrAccounted = (BigDecimal)htInvClrAccounted.get(C_Invoice_ID);
                if (invClrAccounted == null) {
                    invClrAccounted = Env.ZERO;
                }
                invClrAccounted = invClrAccounted.add(factLine.getAmtAcctDr()).subtract(factLine.getAmtAcctCr());
                htInvClrAccounted.put(C_Invoice_ID, invClrAccounted);
            }
        }
        for (MInvoiceLine invoiceLine : invLineList) {
            MMatchInv matchInv;
            MMatchInv[] matchInvs = MMatchInv.getInvoiceLine((Properties)this.getCtx(), (int)invoiceLine.get_ID(), (String)this.getTrxName());
            ArrayList<Integer> skipMatchInvIdList = new ArrayList<Integer>();
            skipMatchInvIdList.add(this.m_matchInv.get_ID());
            MMatchInv[] mMatchInvArray = matchInvs;
            int invClrAccounted = matchInvs.length;
            int invClrSource = 0;
            while (invClrSource < invClrAccounted) {
                matchInv = mMatchInvArray[invClrSource];
                if (matchInv.isReversal()) {
                    skipMatchInvIdList.add(matchInv.get_ID());
                }
                ++invClrSource;
            }
            mMatchInvArray = matchInvs;
            invClrAccounted = matchInvs.length;
            invClrSource = 0;
            while (invClrSource < invClrAccounted) {
                matchInv = mMatchInvArray[invClrSource];
                if (matchInv.get_ID() != this.m_matchInv.get_ID() && !skipMatchInvIdList.contains(matchInv.get_ID())) {
                    BigDecimal invClrSource2;
                    BigDecimal totalAmtAcctCr;
                    BigDecimal totalAmtSourceCr;
                    BigDecimal totalAmtAcctDr;
                    BigDecimal totalAmtSourceDr;
                    List valuesMatchInv;
                    StringBuilder sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND (Record_ID=? OR Record_ID=?)").append(" AND C_AcctSchema_ID=?").append(" AND PostingType='A'").append(" AND Account_ID=?");
                    if (this.m_matchInv.isReversal()) {
                        if (matchInv.isReversal()) {
                            sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                        }
                        sql.append(" AND Record_ID < ").append(this.m_matchInv.getReversal_ID());
                    } else if (matchInv.getReversal_ID() > 0) {
                        sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                    }
                    if (matchInv.getRef_MatchInv_ID() > 0) {
                        if (invoiceLine.getParent().isCreditMemo() && matchInv.getQty().compareTo(BigDecimal.ZERO) < 0) {
                            sql.append(" AND Qty > 0");
                        } else {
                            sql.append(" AND Qty < 0");
                        }
                    }
                    if ((valuesMatchInv = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sql.toString(), (Object[])new Object[]{472, matchInv.get_ID(), matchInv.getRef_MatchInv_ID() > 0 ? matchInv.getRef_MatchInv_ID() : -1, as.getC_AcctSchema_ID(), acct.getAccount_ID()})) != null) {
                        totalAmtSourceDr = (BigDecimal)valuesMatchInv.get(0);
                        if (totalAmtSourceDr == null) {
                            totalAmtSourceDr = Env.ZERO;
                        }
                        if ((totalAmtAcctDr = (BigDecimal)valuesMatchInv.get(1)) == null) {
                            totalAmtAcctDr = Env.ZERO;
                        }
                        if ((totalAmtSourceCr = (BigDecimal)valuesMatchInv.get(2)) == null) {
                            totalAmtSourceCr = Env.ZERO;
                        }
                        if ((totalAmtAcctCr = (BigDecimal)valuesMatchInv.get(3)) == null) {
                            totalAmtAcctCr = Env.ZERO;
                        }
                        if ((invClrSource2 = (BigDecimal)htInvClrSource.get(invoiceLine.getC_Invoice_ID())) == null) {
                            invClrSource2 = Env.ZERO;
                        }
                        invClrSource2 = invClrSource2.add(totalAmtSourceDr).subtract(totalAmtSourceCr);
                        htInvClrSource.put(invoiceLine.getC_Invoice_ID(), invClrSource2);
                        BigDecimal invClrAccounted2 = (BigDecimal)htInvClrAccounted.get(invoiceLine.getC_Invoice_ID());
                        if (invClrAccounted2 == null) {
                            invClrAccounted2 = Env.ZERO;
                        }
                        invClrAccounted2 = invClrAccounted2.add(totalAmtAcctDr).subtract(totalAmtAcctCr);
                        htInvClrAccounted.put(invoiceLine.getC_Invoice_ID(), invClrAccounted2);
                    }
                    sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND (Record_ID=? OR Record_ID=?)").append(" AND C_AcctSchema_ID=?").append(" AND PostingType='A'").append(" AND (Account_ID=? OR Account_ID=? OR Account_ID=?)").append(" AND Description LIKE 'Invoice Line%'");
                    if (this.m_matchInv.isReversal()) {
                        if (matchInv.isReversal()) {
                            sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                        }
                        sql.append(" AND Record_ID < ").append(this.m_matchInv.getReversal_ID());
                    } else if (matchInv.getReversal_ID() > 0) {
                        sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                    }
                    if (matchInv.getRef_MatchInv_ID() > 0) {
                        if (invoiceLine.getParent().isCreditMemo() && matchInv.getQty().compareTo(BigDecimal.ZERO) < 0) {
                            sql.append(" AND Qty > 0");
                        } else {
                            sql.append(" AND Qty < 0");
                        }
                    }
                    if ((valuesMatchInv = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sql.toString(), (Object[])new Object[]{472, matchInv.get_ID(), matchInv.getRef_MatchInv_ID() > 0 ? matchInv.getRef_MatchInv_ID() : -1, as.getC_AcctSchema_ID(), gain.getAccount_ID(), loss.getAccount_ID(), as.getCurrencyBalancing_Acct().getAccount_ID()})) != null) {
                        totalAmtSourceDr = (BigDecimal)valuesMatchInv.get(0);
                        if (totalAmtSourceDr == null) {
                            totalAmtSourceDr = Env.ZERO;
                        }
                        if ((totalAmtAcctDr = (BigDecimal)valuesMatchInv.get(1)) == null) {
                            totalAmtAcctDr = Env.ZERO;
                        }
                        if ((totalAmtSourceCr = (BigDecimal)valuesMatchInv.get(2)) == null) {
                            totalAmtSourceCr = Env.ZERO;
                        }
                        if ((totalAmtAcctCr = (BigDecimal)valuesMatchInv.get(3)) == null) {
                            totalAmtAcctCr = Env.ZERO;
                        }
                        if ((invClrSource2 = (BigDecimal)htInvClrSource.get(invoiceLine.getC_Invoice_ID())) == null) {
                            invClrSource2 = Env.ZERO;
                        }
                        invClrSource2 = invClrSource2.add(totalAmtSourceDr).subtract(totalAmtSourceCr);
                        htInvClrSource.put(invoiceLine.getC_Invoice_ID(), invClrSource2);
                    }
                }
                ++invClrSource;
            }
        }
        boolean isLineFullyMatched = true;
        for (MInvoiceLine invoiceLine : invLineList) {
            BigDecimal invClrAccounted;
            BigDecimal invClrSource;
            BigDecimal invLineAccounted;
            BigDecimal invLineSource = (BigDecimal)htInvLineSource.get(invoiceLine.get_ID());
            if (invLineSource == null) {
                invLineSource = Env.ZERO;
            }
            if ((invLineAccounted = (BigDecimal)htInvLineAccounted.get(invoiceLine.get_ID())) == null) {
                invLineAccounted = Env.ZERO;
            }
            if ((invClrSource = (BigDecimal)htInvClrSource.get(invoiceLine.getC_Invoice_ID())) == null) {
                invClrSource = Env.ZERO;
            }
            if ((invClrAccounted = (BigDecimal)htInvClrAccounted.get(invoiceLine.getC_Invoice_ID())) == null) {
                invClrAccounted = Env.ZERO;
            }
            StringBuilder description = new StringBuilder("Invoice Line=(").append(this.getC_Currency_ID()).append(")").append(invLineSource).append("/").append(invLineAccounted).append(" - Match Invoice=(").append(this.getC_Currency_ID()).append(")").append(invClrSource).append("/").append(invClrAccounted);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(description.toString());
            }
            BigDecimal acctDifference = invLineAccounted.abs().subtract(invClrAccounted.abs());
            if (invClrSource.abs().compareTo(invLineSource.abs()) == 0) {
                if (acctDifference == null || acctDifference.signum() == 0 || acctDifference.abs().compareTo(TOLERANCE) >= 0) continue;
                StringBuilder d2 = new StringBuilder("(full) = ").append(acctDifference);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(d2.toString());
                }
                description.append(" - ").append((CharSequence)d2);
                FactLine fl = fact.createLine(null, acct, as.getC_Currency_ID(), acctDifference.negate());
                fl.setDescription(description.toString());
                this.updateFactLine(fl);
                invRoundingLines.add(fl);
                ArrayList<Object> roundingLineList = htRoundingLineInv.get(invoiceLine.getC_Invoice_ID());
                if (roundingLineList == null) {
                    roundingLineList = new ArrayList();
                }
                roundingLineList.add(fl);
                fl = as.isCurrencyBalancing() ? fact.createLine(null, as.getCurrencyBalancing_Acct(), as.getC_Currency_ID(), acctDifference) : fact.createLine(null, loss, gain, as.getC_Currency_ID(), acctDifference);
                fl.setDescription(description.toString());
                this.updateFactLine(fl);
                invRoundingLines.add(fl);
                roundingLineList.add(fl);
                htRoundingLineInv.put(invoiceLine.getC_Invoice_ID(), roundingLineList);
                continue;
            }
            if (acctDifference != null && acctDifference.signum() != 0 && acctDifference.abs().compareTo(TOLERANCE) < 0) continue;
            isLineFullyMatched = false;
        }
        return isLineFullyMatched;
    }

    private String createReceiptGainLoss(MAcctSchema as, Fact fact, MAccount acct, MInOut receipt, BigDecimal matchInvSource, BigDecimal matchInvAccounted, ArrayList<FactLine> mrGainLossFactLines, ArrayList<FactLine> mrFactLines) {
        if (this.m_matchInv.isReversal()) {
            return this.createReversalReceiptGainLossRoundingCorrection(as, fact, acct);
        }
        BigDecimal receiptSource = null;
        BigDecimal receiptAccounted = null;
        StringBuilder sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND Account_ID=?").append(" AND PostingType='A'");
        List valuesInv = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sql.toString(), (Object[])new Object[]{319, receipt.getM_InOut_ID(), as.getC_AcctSchema_ID(), acct.getAccount_ID()});
        if (valuesInv != null) {
            receiptSource = (BigDecimal)valuesInv.get(0);
            receiptAccounted = (BigDecimal)valuesInv.get(1);
            if (receiptSource.signum() == 0 && receiptAccounted.signum() == 0) {
                receiptSource = (BigDecimal)valuesInv.get(2);
                receiptAccounted = (BigDecimal)valuesInv.get(3);
            }
        }
        if (receiptSource == null || receiptAccounted == null) {
            return null;
        }
        StringBuilder description = new StringBuilder("InOut=(").append(receipt.getC_Currency_ID()).append(")").append(receiptSource).append("/").append(receiptAccounted).append(" - MatchInv=(").append(this.getC_Currency_ID()).append(")").append(matchInvSource).append("/").append(matchInvAccounted);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(description.toString());
        }
        BigDecimal acctDifference = null;
        if (matchInvSource.compareTo(receiptSource) == 0) {
            acctDifference = matchInvAccounted.abs().subtract(receiptAccounted.abs());
            StringBuilder d2 = new StringBuilder("(full) = ").append(acctDifference);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(d2.toString());
            }
            description.append(" - ").append((CharSequence)d2);
        }
        if (acctDifference == null || acctDifference.signum() == 0) {
            this.log.fine("No Difference");
            return null;
        }
        MAccount gain = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedLoss_Acct());
        FactLine fl = fact.createLine(null, acct, as.getC_Currency_ID(), acctDifference.negate());
        fl.setDescription(description.toString());
        this.updateFactLine(fl);
        mrFactLines.add(fl);
        fl = fact.createLine(null, loss, gain, as.getC_Currency_ID(), acctDifference);
        fl.setDescription(description.toString());
        this.updateFactLine(fl);
        mrGainLossFactLines.add(fl);
        mrFactLines.add(fl);
        return null;
    }

    private String createReversalReceiptGainLossRoundingCorrection(MAcctSchema as, Fact fact, MAccount acct) {
        if (!this.m_matchInv.isReversal()) {
            return null;
        }
        MAccount gain = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedLoss_Acct());
        StringBuilder whereClause = new StringBuilder().append("AD_Table_ID=?").append(" AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND PostingType='A'").append(" AND (Account_ID=? OR Account_ID=? OR Account_ID=? OR Account_ID=?)").append(" AND Description LIKE 'InOut%'");
        List list = new Query(this.getCtx(), "Fact_Acct", whereClause.toString(), this.getTrxName()).setParameters(new Object[]{472, this.m_matchInv.getReversal_ID(), as.getC_AcctSchema_ID(), acct.getAccount_ID(), gain.getAccount_ID(), loss.getAccount_ID(), as.getCurrencyBalancing_Acct().getAccount_ID()}).setOrderBy("Fact_Acct_ID").list();
        for (MFactAcct fa : list) {
            FactLine fl = fact.createLine(null, fa.getMAccount(), fa.getC_Currency_ID(), fa.getAmtAcctCr(), fa.getAmtAcctDr());
            fl.setDescription(fa.getDescription());
            this.updateFactLine(fl);
        }
        return null;
    }

    private String createReceiptRoundingCorrection(MAcctSchema as, Fact fact, MAccount acct, ArrayList<FactLine> mrGainLossFactLines, ArrayList<FactLine> mrFactLines) {
        MMatchInv matchInv;
        BigDecimal receiptAccountedDrCr;
        BigDecimal receiptSourceDrCr;
        if (this.m_matchInv.isReversal()) {
            return null;
        }
        ArrayList<FactLine> mrLineRoundingLines = new ArrayList<FactLine>();
        boolean isLineFullyMatched = this.createReceiptLineRoundingCorrection(as, fact, acct, mrGainLossFactLines, mrFactLines, mrLineRoundingLines);
        if (!isLineFullyMatched) {
            return null;
        }
        int M_InOut_ID = this.m_receiptLine.getM_InOut_ID();
        BigDecimal totalNIRAccounted = Env.ZERO;
        for (FactLine mrLineRoundingLine : mrLineRoundingLines) {
            if (mrLineRoundingLine.getAccount() != acct) continue;
            totalNIRAccounted = totalNIRAccounted.add(mrLineRoundingLine.getAmtAcctDr()).subtract(mrLineRoundingLine.getAmtAcctCr());
        }
        StringBuilder sqlMR = new StringBuilder().append("SELECT SUM(AmtSourceDr)-SUM(AmtSourceCr), SUM(AmtAcctDr)-SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND Account_ID=?").append(" AND PostingType='A'");
        BigDecimal mrSource = Env.ZERO;
        BigDecimal mrAccounted = Env.ZERO;
        List valuesInv = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sqlMR.toString(), (Object[])new Object[]{319, M_InOut_ID, as.getC_AcctSchema_ID(), acct.getAccount_ID()});
        if (valuesInv != null) {
            receiptSourceDrCr = (BigDecimal)valuesInv.get(0);
            receiptAccountedDrCr = (BigDecimal)valuesInv.get(1);
            mrSource = mrSource.add(receiptSourceDrCr);
            mrAccounted = mrAccounted.add(receiptAccountedDrCr);
            totalNIRAccounted = totalNIRAccounted.add(receiptAccountedDrCr);
        }
        if ((valuesInv = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sqlMR.toString(), (Object[])new Object[]{319, M_InOut_ID, as.getC_AcctSchema_ID(), as.getCurrencyBalancing_Acct().getAccount_ID()})) != null) {
            receiptSourceDrCr = (BigDecimal)valuesInv.get(0);
            receiptAccountedDrCr = (BigDecimal)valuesInv.get(1);
            if (receiptSourceDrCr == null) {
                receiptSourceDrCr = Env.ZERO;
            }
            if (receiptAccountedDrCr == null) {
                receiptAccountedDrCr = Env.ZERO;
            }
            mrSource = mrSource.add(receiptSourceDrCr);
            mrAccounted = mrAccounted.add(receiptAccountedDrCr);
        }
        MAccount gain = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedLoss_Acct());
        BigDecimal totalAmtSourceDr = Env.ZERO;
        BigDecimal totalAmtAcctDr = Env.ZERO;
        BigDecimal totalAmtSourceCr = Env.ZERO;
        BigDecimal totalAmtAcctCr = Env.ZERO;
        ArrayList<FactLine> factLineList = mrFactLines;
        for (FactLine factLine : factLineList) {
            if (factLine.getAccount_ID() == acct.getAccount_ID()) {
                totalAmtSourceDr = totalAmtSourceDr.add(factLine.getAmtSourceDr());
                totalAmtAcctDr = totalAmtAcctDr.add(factLine.getAmtAcctDr());
                totalAmtSourceCr = totalAmtSourceCr.add(factLine.getAmtSourceCr());
                totalAmtAcctCr = totalAmtAcctCr.add(factLine.getAmtAcctCr());
                totalNIRAccounted = totalNIRAccounted.add(factLine.getAmtAcctDr()).subtract(factLine.getAmtAcctCr());
                continue;
            }
            if (factLine.getAccount_ID() != gain.getAccount_ID() && factLine.getAccount_ID() != loss.getAccount_ID() || !mrGainLossFactLines.contains(factLine)) continue;
            totalAmtSourceDr = totalAmtSourceDr.add(factLine.getAmtSourceDr());
            totalAmtSourceCr = totalAmtSourceCr.add(factLine.getAmtSourceCr());
        }
        BigDecimal matchInvSource = Env.ZERO;
        BigDecimal matchInvAccounted = Env.ZERO;
        matchInvSource = matchInvSource.add(totalAmtSourceDr).subtract(totalAmtSourceCr);
        matchInvAccounted = matchInvAccounted.add(totalAmtAcctDr).subtract(totalAmtAcctCr);
        for (FactLine mrLineRoundingLine : mrLineRoundingLines) {
            if (mrLineRoundingLine.getAccount() != acct) continue;
            matchInvAccounted = matchInvAccounted.add(mrLineRoundingLine.getAmtAcctDr()).subtract(mrLineRoundingLine.getAmtAcctCr());
        }
        MMatchInv[] matchInvs = MMatchInv.getInOut((Properties)this.getCtx(), (int)M_InOut_ID, (String)this.getTrxName());
        ArrayList<Integer> skipMatchInvIdList = new ArrayList<Integer>();
        skipMatchInvIdList.add(this.m_matchInv.get_ID());
        MMatchInv[] mMatchInvArray = matchInvs;
        int n = matchInvs.length;
        int n2 = 0;
        while (n2 < n) {
            matchInv = mMatchInvArray[n2];
            if (matchInv.isReversal()) {
                skipMatchInvIdList.add(matchInv.get_ID());
            }
            ++n2;
        }
        mMatchInvArray = matchInvs;
        n = matchInvs.length;
        n2 = 0;
        while (n2 < n) {
            matchInv = mMatchInvArray[n2];
            if (matchInv.get_ID() != this.m_matchInv.get_ID() && !skipMatchInvIdList.contains(matchInv.get_ID())) {
                StringBuilder sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND PostingType='A'").append(" AND Account_ID=?");
                if (this.m_matchInv.isReversal()) {
                    if (matchInv.isReversal()) {
                        sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                    }
                    sql.append(" AND Record_ID < ").append(this.m_matchInv.getReversal_ID());
                } else if (matchInv.getReversal_ID() > 0) {
                    sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                }
                List valuesMatchInv = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sql.toString(), (Object[])new Object[]{472, matchInv.get_ID(), as.getC_AcctSchema_ID(), acct.getAccount_ID()});
                if (valuesMatchInv != null) {
                    totalAmtSourceDr = (BigDecimal)valuesMatchInv.get(0);
                    if (totalAmtSourceDr == null) {
                        totalAmtSourceDr = Env.ZERO;
                    }
                    if ((totalAmtAcctDr = (BigDecimal)valuesMatchInv.get(1)) == null) {
                        totalAmtAcctDr = Env.ZERO;
                    }
                    if ((totalAmtSourceCr = (BigDecimal)valuesMatchInv.get(2)) == null) {
                        totalAmtSourceCr = Env.ZERO;
                    }
                    if ((totalAmtAcctCr = (BigDecimal)valuesMatchInv.get(3)) == null) {
                        totalAmtAcctCr = Env.ZERO;
                    }
                    matchInvSource = matchInvSource.add(totalAmtSourceDr).subtract(totalAmtSourceCr);
                    matchInvAccounted = matchInvAccounted.add(totalAmtAcctDr).subtract(totalAmtAcctCr);
                    totalNIRAccounted = totalNIRAccounted.add(totalAmtAcctDr).subtract(totalAmtAcctCr);
                }
                sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND PostingType='A'").append(" AND (Account_ID=? OR Account_ID=? OR Account_ID=?)").append(" AND Description LIKE 'InOut%'");
                if (this.m_matchInv.isReversal()) {
                    if (matchInv.isReversal()) {
                        sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                    }
                    sql.append(" AND Record_ID < ").append(this.m_matchInv.getReversal_ID());
                } else if (matchInv.getReversal_ID() > 0) {
                    sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                }
                valuesMatchInv = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sql.toString(), (Object[])new Object[]{472, matchInv.get_ID(), as.getC_AcctSchema_ID(), gain.getAccount_ID(), loss.getAccount_ID(), as.getCurrencyBalancing_Acct().getAccount_ID()});
                if (valuesMatchInv != null) {
                    totalAmtSourceDr = (BigDecimal)valuesMatchInv.get(0);
                    if (totalAmtSourceDr == null) {
                        totalAmtSourceDr = Env.ZERO;
                    }
                    if ((totalAmtAcctDr = (BigDecimal)valuesMatchInv.get(1)) == null) {
                        totalAmtAcctDr = Env.ZERO;
                    }
                    if ((totalAmtSourceCr = (BigDecimal)valuesMatchInv.get(2)) == null) {
                        totalAmtSourceCr = Env.ZERO;
                    }
                    if ((totalAmtAcctCr = (BigDecimal)valuesMatchInv.get(3)) == null) {
                        totalAmtAcctCr = Env.ZERO;
                    }
                    matchInvSource = matchInvSource.add(totalAmtSourceDr).subtract(totalAmtSourceCr);
                }
            }
            ++n2;
        }
        StringBuilder description = new StringBuilder("InOut=(").append(this.getC_Currency_ID()).append(")").append(mrSource).append("/").append(mrAccounted).append(" - Match Invoice=(").append(this.getC_Currency_ID()).append(")").append(matchInvSource).append("/").append(matchInvAccounted);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(description.toString());
        }
        BigDecimal acctDifference = Env.ZERO;
        if (matchInvSource.abs().compareTo(mrSource.abs()) == 0) {
            acctDifference = mrAccounted.abs().subtract(matchInvAccounted.abs());
            StringBuilder d2 = new StringBuilder("(full) = ").append(acctDifference);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(d2.toString());
            }
            description.append(" - ").append((CharSequence)d2);
        } else {
            isLineFullyMatched = false;
        }
        if (acctDifference == null || acctDifference.signum() == 0) {
            this.log.fine("No Difference");
            return null;
        }
        if (acctDifference.abs().compareTo(TOLERANCE) >= 0) {
            this.log.fine("acctDifference=" + acctDifference);
            return null;
        }
        ArrayList<FactLine> mrRoundingLines = new ArrayList<FactLine>();
        FactLine fl = fact.createLine(null, acct, as.getC_Currency_ID(), acctDifference);
        fl.setDescription(description.toString());
        this.updateFactLine(fl);
        mrRoundingLines.add(fl);
        totalNIRAccounted = totalNIRAccounted.add(fl.getAmtAcctDr()).subtract(fl.getAmtAcctCr());
        fl = as.isCurrencyBalancing() && as.getC_Currency_ID() != this.m_invoiceLine.getParent().getC_Currency_ID() ? fact.createLine(null, as.getCurrencyBalancing_Acct(), as.getC_Currency_ID(), acctDifference.negate()) : fact.createLine(null, loss, gain, as.getC_Currency_ID(), acctDifference.negate());
        fl.setDescription(description.toString());
        this.updateFactLine(fl);
        mrRoundingLines.add(fl);
        if (isLineFullyMatched) {
            if (totalNIRAccounted != null && totalNIRAccounted.signum() != 0 && totalNIRAccounted.abs().compareTo(TOLERANCE) < 0) {
                BigDecimal totalRounding = Env.ZERO;
                for (FactLine mrRoundingLine : mrRoundingLines) {
                    if (mrRoundingLine.getAccount() != acct) continue;
                    totalRounding = totalRounding.add(mrRoundingLine.getAmtAcctDr()).subtract(mrRoundingLine.getAmtAcctCr());
                }
                if (totalRounding.compareTo(totalNIRAccounted) == 0) {
                    for (FactLine invRoundingLine : mrRoundingLines) {
                        fact.remove(invRoundingLine);
                    }
                    totalNIRAccounted = Env.ZERO;
                }
            }
            if (totalNIRAccounted != null && totalNIRAccounted.signum() != 0 && totalNIRAccounted.abs().compareTo(TOLERANCE) < 0) {
                description = new StringBuilder("InOut - MatchInv - (full) = ").append(totalNIRAccounted);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(description.toString());
                }
                fl = fact.createLine(null, acct, as.getC_Currency_ID(), totalNIRAccounted);
                fl.setDescription(description.toString());
                this.updateFactLine(fl);
                fl = as.isCurrencyBalancing() ? fact.createLine(null, as.getCurrencyBalancing_Acct(), as.getC_Currency_ID(), totalNIRAccounted.negate()) : fact.createLine(null, loss, gain, as.getC_Currency_ID(), totalNIRAccounted.negate());
                fl.setDescription(description.toString());
                this.updateFactLine(fl);
            }
        }
        return null;
    }

    private boolean createReceiptLineRoundingCorrection(MAcctSchema as, Fact fact, MAccount acct, ArrayList<FactLine> mrGainLossFactLines, ArrayList<FactLine> mrFactLines, ArrayList<FactLine> mrRoundingLines) {
        MMatchInv matchInv;
        BigDecimal mrLineSource = null;
        BigDecimal mrLineAccounted = null;
        StringBuilder sqlMRLine = new StringBuilder().append("SELECT SUM(AmtSourceDr)-SUM(AmtSourceCr), SUM(AmtAcctDr)-SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=? AND Line_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND Account_ID=?").append(" AND PostingType='A'");
        List valuesMR = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sqlMRLine.toString(), (Object[])new Object[]{319, this.m_receiptLine.getM_InOut_ID(), this.m_receiptLine.getM_InOutLine_ID(), as.getC_AcctSchema_ID(), acct.getAccount_ID()});
        if (valuesMR != null) {
            mrLineSource = (BigDecimal)valuesMR.get(0);
            mrLineAccounted = (BigDecimal)valuesMR.get(1);
        }
        MAccount gain = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedGain_Acct());
        MAccount loss = MAccount.get((Properties)as.getCtx(), (int)as.getAcctSchemaDefault().getRealizedLoss_Acct());
        BigDecimal nirSource = Env.ZERO;
        BigDecimal nirAccounted = Env.ZERO;
        ArrayList<FactLine> factLineList = mrFactLines;
        for (FactLine factLine : factLineList) {
            if (factLine.getAccount_ID() != acct.getAccount_ID()) continue;
            nirSource = nirSource.add(factLine.getAmtSourceDr()).subtract(factLine.getAmtSourceCr());
            nirAccounted = nirAccounted.add(factLine.getAmtAcctDr()).subtract(factLine.getAmtAcctCr());
        }
        MMatchInv[] matchInvs = MMatchInv.getInOutLine((Properties)this.getCtx(), (int)this.m_receiptLine.get_ID(), (String)this.getTrxName());
        ArrayList<Integer> skipMatchInvIdList = new ArrayList<Integer>();
        skipMatchInvIdList.add(this.m_matchInv.get_ID());
        MMatchInv[] mMatchInvArray = matchInvs;
        int n = matchInvs.length;
        int n2 = 0;
        while (n2 < n) {
            matchInv = mMatchInvArray[n2];
            if (matchInv.isReversal()) {
                skipMatchInvIdList.add(matchInv.get_ID());
            }
            ++n2;
        }
        mMatchInvArray = matchInvs;
        n = matchInvs.length;
        n2 = 0;
        while (n2 < n) {
            matchInv = mMatchInvArray[n2];
            if (matchInv.get_ID() != this.m_matchInv.get_ID() && !skipMatchInvIdList.contains(matchInv.get_ID())) {
                BigDecimal totalAmtAcctCr;
                BigDecimal totalAmtSourceCr;
                BigDecimal totalAmtAcctDr;
                BigDecimal totalAmtSourceDr;
                StringBuilder sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND PostingType='A'").append(" AND Account_ID=?");
                if (this.m_matchInv.isReversal()) {
                    if (matchInv.isReversal()) {
                        sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                    }
                    sql.append(" AND Record_ID < ").append(this.m_matchInv.getReversal_ID());
                } else if (matchInv.getReversal_ID() > 0) {
                    sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                }
                List valuesMatchInv = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sql.toString(), (Object[])new Object[]{472, matchInv.get_ID(), as.getC_AcctSchema_ID(), acct.getAccount_ID()});
                if (valuesMatchInv != null) {
                    totalAmtSourceDr = (BigDecimal)valuesMatchInv.get(0);
                    if (totalAmtSourceDr == null) {
                        totalAmtSourceDr = Env.ZERO;
                    }
                    if ((totalAmtAcctDr = (BigDecimal)valuesMatchInv.get(1)) == null) {
                        totalAmtAcctDr = Env.ZERO;
                    }
                    if ((totalAmtSourceCr = (BigDecimal)valuesMatchInv.get(2)) == null) {
                        totalAmtSourceCr = Env.ZERO;
                    }
                    if ((totalAmtAcctCr = (BigDecimal)valuesMatchInv.get(3)) == null) {
                        totalAmtAcctCr = Env.ZERO;
                    }
                    nirSource = nirSource.add(totalAmtSourceDr).subtract(totalAmtSourceCr);
                    nirAccounted = nirAccounted.add(totalAmtAcctDr).subtract(totalAmtAcctCr);
                }
                sql = new StringBuilder().append("SELECT SUM(AmtSourceDr), SUM(AmtAcctDr), SUM(AmtSourceCr), SUM(AmtAcctCr)").append(" FROM Fact_Acct ").append("WHERE AD_Table_ID=? AND Record_ID=?").append(" AND C_AcctSchema_ID=?").append(" AND PostingType='A'").append(" AND (Account_ID=? OR Account_ID=? OR Account_ID=?)").append(" AND Description LIKE 'InOut Line%'");
                if (this.m_matchInv.isReversal()) {
                    if (matchInv.isReversal()) {
                        sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                    }
                    sql.append(" AND Record_ID < ").append(this.m_matchInv.getReversal_ID());
                } else if (matchInv.getReversal_ID() > 0) {
                    sql.append(" AND Record_ID <> ").append(matchInv.get_ID());
                }
                valuesMatchInv = DB.getSQLValueObjectsEx((String)this.getTrxName(), (String)sql.toString(), (Object[])new Object[]{472, matchInv.get_ID(), as.getC_AcctSchema_ID(), gain.getAccount_ID(), loss.getAccount_ID(), as.getCurrencyBalancing_Acct().getAccount_ID()});
                if (valuesMatchInv != null) {
                    totalAmtSourceDr = (BigDecimal)valuesMatchInv.get(0);
                    if (totalAmtSourceDr == null) {
                        totalAmtSourceDr = Env.ZERO;
                    }
                    if ((totalAmtAcctDr = (BigDecimal)valuesMatchInv.get(1)) == null) {
                        totalAmtAcctDr = Env.ZERO;
                    }
                    if ((totalAmtSourceCr = (BigDecimal)valuesMatchInv.get(2)) == null) {
                        totalAmtSourceCr = Env.ZERO;
                    }
                    if ((totalAmtAcctCr = (BigDecimal)valuesMatchInv.get(3)) == null) {
                        totalAmtAcctCr = Env.ZERO;
                    }
                    nirSource = nirSource.add(totalAmtSourceDr).subtract(totalAmtSourceCr);
                }
            }
            ++n2;
        }
        boolean isLineFullyMatched = true;
        StringBuilder description = new StringBuilder("InOut Line=(").append(this.getC_Currency_ID()).append(")").append(mrLineSource).append("/").append(mrLineAccounted).append(" - Match Invoice=(").append(this.getC_Currency_ID()).append(")").append(nirSource).append("/").append(nirAccounted);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(description.toString());
        }
        BigDecimal acctDifference = mrLineAccounted.abs().subtract(nirAccounted.abs());
        if (nirSource.abs().compareTo(mrLineSource.abs()) == 0) {
            if (acctDifference != null && acctDifference.signum() != 0 && acctDifference.abs().compareTo(TOLERANCE) < 0) {
                StringBuilder d2 = new StringBuilder("(full) = ").append(acctDifference);
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine(d2.toString());
                }
                description.append(" - ").append((CharSequence)d2);
                FactLine fl = fact.createLine(null, acct, as.getC_Currency_ID(), acctDifference);
                fl.setDescription(description.toString());
                this.updateFactLine(fl);
                mrRoundingLines.add(fl);
                fl = as.isCurrencyBalancing() && as.getC_Currency_ID() != this.m_invoiceLine.getParent().getC_Currency_ID() ? fact.createLine(null, as.getCurrencyBalancing_Acct(), as.getC_Currency_ID(), acctDifference.negate()) : fact.createLine(null, loss, gain, as.getC_Currency_ID(), acctDifference.negate());
                fl.setDescription(description.toString());
                this.updateFactLine(fl);
                mrRoundingLines.add(fl);
            }
        } else if (acctDifference == null || acctDifference.signum() == 0 || acctDifference.abs().compareTo(TOLERANCE) >= 0) {
            isLineFullyMatched = false;
        }
        return isLineFullyMatched;
    }

    private MAccount getInvoiceExpenseAccount(MAcctSchema as) {
        MInvoiceLine line = this.m_invoiceLine;
        if (line.getM_Product_ID() == 0 && line.getC_Charge_ID() != 0) {
            MContractChargeAcct contractChargeAcct = this.m_contractAcct.getContracChargeAcct(line.getC_Charge_ID(), as.getC_AcctSchema_ID(), false);
            if (contractChargeAcct != null && contractChargeAcct.getCh_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractChargeAcct.getCh_Expense_Acct());
            }
            return MCharge.getAccount((int)line.getC_Charge_ID(), (MAcctSchema)as);
        }
        if (line.getM_Product_ID() > 0) {
            if (line.getM_Product().getProductType().equals("I")) {
                return this.m_pc.getAccount(10, as);
            }
            MContractProductAcct contractProductAcct = this.m_contractAcct.getContractProductAcct(line.getM_Product().getM_Product_Category_ID(), as.getC_AcctSchema_ID(), false);
            if (contractProductAcct != null && contractProductAcct.getP_Expense_Acct() > 0) {
                return MAccount.get((Properties)this.getCtx(), (int)contractProductAcct.getP_Expense_Acct());
            }
            return this.m_pc.getAccount(2, as);
        }
        return this.m_pc.getAccount(2, as);
    }
}

