/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.base.IJPiereTaxProvider;
import jpiere.base.plugin.org.adempiere.model.JPiereTaxProvider;
import jpiere.base.plugin.util.JPiereUtil;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocTax;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MCurrency;
import org.compiere.model.MElementValue;
import org.compiere.model.MJournal;
import org.compiere.model.MJournalLine;
import org.compiere.model.MTax;
import org.compiere.model.PO;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class Doc_GLJournalJP
extends Doc {
    protected String m_PostingType = null;
    protected int m_C_AcctSchema_ID = 0;
    protected DocTax[] m_taxes = null;
    protected int m_precision = -1;

    public Doc_GLJournalJP(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MJournal.class, rs, null, trxName);
    }

    protected String loadDocumentDetails() {
        MJournal journal = (MJournal)this.getPO();
        this.m_PostingType = journal.getPostingType();
        this.m_C_AcctSchema_ID = journal.getC_AcctSchema_ID();
        this.m_taxes = this.loadTaxes();
        this.p_lines = this.loadLines(journal);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Lines=" + this.p_lines.length);
        }
        return null;
    }

    private DocTax[] loadTaxes() {
        ArrayList<DocTax> list = new ArrayList<DocTax>();
        String sql = "SELECT it.C_Tax_ID, t.Name, t.Rate, it.TaxBaseAmt, it.TaxAmt, it.JP_SOPOType FROM C_Tax t, JP_GLJournalTax it WHERE t.C_Tax_ID=it.C_Tax_ID AND it.GL_Journal_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName());
                pstmt.setInt(1, this.get_ID());
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    int C_Tax_ID = rs.getInt(1);
                    String name = rs.getString(2);
                    BigDecimal rate = rs.getBigDecimal(3);
                    BigDecimal taxBaseAmt = rs.getBigDecimal(4);
                    BigDecimal amount = rs.getBigDecimal(5);
                    boolean salesTax = "S".equals(rs.getString(6));
                    DocTax taxLine = new DocTax(C_Tax_ID, name, rate, taxBaseAmt, amount, salesTax);
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine(taxLine.toString());
                    }
                    list.add(taxLine);
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        DocTax[] tl = new DocTax[list.size()];
        list.toArray(tl);
        return tl;
    }

    protected DocLine[] loadLines(MJournal journal) {
        ArrayList<DocLine> list = new ArrayList<DocLine>();
        MJournalLine[] journalLines = journal.getLines(false);
        int i = 0;
        while (i < journalLines.length) {
            MJournalLine journalLine = journalLines[i];
            DocLine docLine = new DocLine((PO)journalLine, (Doc)this);
            docLine.setQty(journalLine.getQty(), false);
            BigDecimal JP_TaxAmt = Env.ZERO;
            if (journalLine.get_Value("JP_TaxAmt") != null) {
                JP_TaxAmt = (BigDecimal)journalLine.get_Value("JP_TaxAmt");
            }
            int C_Tax_ID = docLine.getC_Tax_ID();
            String JP_SOPOType = journalLine.get_ValueAsString("JP_SOPOType");
            MTax tax = null;
            if (C_Tax_ID != 0) {
                tax = MTax.get((Properties)this.getCtx(), (int)C_Tax_ID);
            }
            if (tax != null && !tax.isZeroTax() && ("S".equals(JP_SOPOType) || "P".equals(JP_SOPOType)) && JP_TaxAmt.compareTo(Env.ZERO) != 0) {
                int t = 0;
                while (t < this.m_taxes.length) {
                    if (this.m_taxes[t].getC_Tax_ID() == C_Tax_ID && ("S".equals(JP_SOPOType) && this.m_taxes[t].isSalesTax() || "P".equals(JP_SOPOType) && !this.m_taxes[t].isSalesTax())) {
                        this.m_taxes[t].addIncludedTax(JP_TaxAmt);
                        break;
                    }
                    ++t;
                }
            }
            docLine.setAmount(journalLine.getAmtSourceDr(), journalLine.getAmtSourceCr());
            MAccount account = journalLine.getAccount_Combi();
            docLine.setAccount(account);
            list.add(docLine);
            if (docLine.getC_Currency_ID() != this.getC_Currency_ID()) {
                this.setIsMultiCurrency(true);
            }
            ++i;
        }
        DocLine[] dls = new DocLine[list.size()];
        list.toArray(dls);
        return dls;
    }

    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuilder sb = new StringBuilder(" [");
        int i = 0;
        while (i < this.p_lines.length) {
            retValue = retValue.add(this.p_lines[i].getAmtSource());
            sb.append("+").append(this.p_lines[i].getAmtSource());
            ++i;
        }
        sb.append("]");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.toString()) + " Balance=" + retValue + sb.toString());
        }
        return retValue;
    }

    public ArrayList<Fact> createFacts(MAcctSchema as) {
        ArrayList<Fact> facts = new ArrayList<Fact>();
        if (as.getC_AcctSchema_ID() != this.m_C_AcctSchema_ID) {
            return facts;
        }
        Fact fact = new Fact((Doc)this, as, this.m_PostingType);
        if (this.getDocumentType().equals("GLJ")) {
            DocLine docLine = null;
            int C_Tax_ID = 0;
            String JP_SOPOType = null;
            BigDecimal amtSourceDr = Env.ZERO;
            BigDecimal JP_TaxBaseAmt = Env.ZERO;
            BigDecimal JP_TaxAmt = Env.ZERO;
            FactLine fLine = null;
            DocTax docTax = null;
            MElementValue elementValue = null;
            int C_BankAccount_ID = 0;
            int i = 0;
            while (i < this.p_lines.length) {
                docLine = this.p_lines[i];
                if (docLine.getPO().get_Value("JP_BankAccount_ID") != null) {
                    C_BankAccount_ID = (Integer)docLine.getPO().get_Value("JP_BankAccount_ID");
                } else if (docLine.getAccount() != null) {
                    elementValue = docLine.getAccount().getAccount();
                    C_BankAccount_ID = elementValue != null ? elementValue.getC_BankAccount_ID() : 0;
                } else {
                    elementValue = null;
                    C_BankAccount_ID = 0;
                }
                C_Tax_ID = docLine.getC_Tax_ID();
                JP_SOPOType = docLine.getPO().get_ValueAsString("JP_SOPOType");
                JP_TaxBaseAmt = docLine.getPO().get_Value("JP_TaxBaseAmt") != null ? (BigDecimal)docLine.getPO().get_Value("JP_TaxBaseAmt") : Env.ZERO;
                JP_TaxAmt = docLine.getPO().get_Value("JP_TaxAmt") != null ? (BigDecimal)docLine.getPO().get_Value("JP_TaxAmt") : Env.ZERO;
                amtSourceDr = docLine.getAmtSourceDr();
                docTax = this.getDocTax(C_Tax_ID, JP_SOPOType);
                if (docTax != null && ("S".equals(JP_SOPOType) || "P".equals(JP_SOPOType)) && JP_TaxBaseAmt.compareTo(Env.ZERO) != 0 && JP_TaxAmt.compareTo(Env.ZERO) != 0) {
                    if ("S".equals(JP_SOPOType)) {
                        if (amtSourceDr.compareTo(Env.ZERO) == 0) {
                            fLine = fact.createLine(docLine, docLine.getAccount(), this.getC_Currency_ID(), Env.ZERO, JP_TaxBaseAmt);
                            this.setTaxInfo(fLine, C_Tax_ID, JP_SOPOType, JP_TaxBaseAmt, JP_TaxAmt);
                            fLine.set_ValueNoCheck("JP_PriceActual", this.p_lines[i].getPO().get_Value("JP_PriceActual"));
                            if (C_BankAccount_ID > 0) {
                                fLine.set_ValueNoCheck("JP_BankAccount_ID", (Object)C_BankAccount_ID);
                            }
                            fLine = fact.createLine(docLine, docTax.getAccount(0, as), this.getC_Currency_ID(), Env.ZERO, JP_TaxAmt);
                            this.setTaxInfo(fLine, C_Tax_ID, JP_SOPOType, JP_TaxBaseAmt, JP_TaxAmt);
                            fLine.set_ValueNoCheck("JP_PriceActual", (Object)Env.ZERO);
                            fLine.set_ValueNoCheck("Qty", (Object)Env.ZERO);
                            fLine.set_ValueNoCheck("C_UOM_ID", null);
                        } else {
                            fLine = fact.createLine(docLine, docLine.getAccount(), this.getC_Currency_ID(), JP_TaxBaseAmt.negate(), Env.ZERO);
                            this.setTaxInfo(fLine, C_Tax_ID, JP_SOPOType, JP_TaxBaseAmt, JP_TaxAmt);
                            fLine.set_ValueNoCheck("JP_PriceActual", this.p_lines[i].getPO().get_Value("JP_PriceActual"));
                            if (C_BankAccount_ID > 0) {
                                fLine.set_ValueNoCheck("JP_BankAccount_ID", (Object)C_BankAccount_ID);
                            }
                            fLine = fact.createLine(docLine, docTax.getAccount(0, as), this.getC_Currency_ID(), JP_TaxAmt.negate(), Env.ZERO);
                            this.setTaxInfo(fLine, C_Tax_ID, JP_SOPOType, JP_TaxBaseAmt, JP_TaxAmt);
                            fLine.set_ValueNoCheck("JP_PriceActual", (Object)Env.ZERO);
                            fLine.set_ValueNoCheck("Qty", (Object)Env.ZERO);
                            fLine.set_ValueNoCheck("C_UOM_ID", null);
                        }
                    } else if ("P".equals(JP_SOPOType)) {
                        boolean isSalesTax = MTax.get((int)docLine.getC_Tax_ID()).isSalesTax();
                        if (amtSourceDr.compareTo(Env.ZERO) == 0) {
                            fLine = fact.createLine(docLine, docLine.getAccount(), this.getC_Currency_ID(), Env.ZERO, JP_TaxBaseAmt.negate());
                            this.setTaxInfo(fLine, C_Tax_ID, JP_SOPOType, JP_TaxBaseAmt, JP_TaxAmt);
                            fLine.set_ValueNoCheck("JP_PriceActual", this.p_lines[i].getPO().get_Value("JP_PriceActual"));
                            if (C_BankAccount_ID > 0) {
                                fLine.set_ValueNoCheck("JP_BankAccount_ID", (Object)C_BankAccount_ID);
                            }
                            fLine = fact.createLine(docLine, docTax.getAccount(isSalesTax ? 2 : 1, as), this.getC_Currency_ID(), Env.ZERO, JP_TaxAmt.negate());
                            this.setTaxInfo(fLine, C_Tax_ID, JP_SOPOType, JP_TaxBaseAmt, JP_TaxAmt);
                            fLine.set_ValueNoCheck("JP_PriceActual", (Object)Env.ZERO);
                            fLine.set_ValueNoCheck("Qty", (Object)Env.ZERO);
                            fLine.set_ValueNoCheck("C_UOM_ID", null);
                        } else {
                            fLine = fact.createLine(docLine, docLine.getAccount(), this.getC_Currency_ID(), JP_TaxBaseAmt, Env.ZERO);
                            this.setTaxInfo(fLine, C_Tax_ID, JP_SOPOType, JP_TaxBaseAmt, JP_TaxAmt);
                            fLine.set_ValueNoCheck("JP_PriceActual", this.p_lines[i].getPO().get_Value("JP_PriceActual"));
                            if (C_BankAccount_ID > 0) {
                                fLine.set_ValueNoCheck("JP_BankAccount_ID", (Object)C_BankAccount_ID);
                            }
                            fLine = fact.createLine(docLine, docTax.getAccount(isSalesTax ? 2 : 1, as), this.getC_Currency_ID(), JP_TaxAmt, Env.ZERO);
                            this.setTaxInfo(fLine, C_Tax_ID, JP_SOPOType, JP_TaxBaseAmt, JP_TaxAmt);
                            fLine.set_ValueNoCheck("JP_PriceActual", (Object)Env.ZERO);
                            fLine.set_ValueNoCheck("Qty", (Object)Env.ZERO);
                            fLine.set_ValueNoCheck("C_UOM_ID", null);
                        }
                    }
                } else {
                    fLine = fact.createLine(docLine, docLine.getAccount(), docLine.getC_Currency_ID(), docLine.getAmtSourceDr(), docLine.getAmtSourceCr());
                    this.setTaxInfo(fLine, C_Tax_ID, JP_SOPOType, JP_TaxBaseAmt, JP_TaxAmt);
                    fLine.set_ValueNoCheck("JP_PriceActual", this.p_lines[i].getPO().get_Value("JP_PriceActual"));
                    if (C_BankAccount_ID > 0) {
                        fLine.set_ValueNoCheck("JP_BankAccount_ID", (Object)C_BankAccount_ID);
                    }
                }
                ++i;
            }
        } else {
            this.p_Error = "DocumentType unknown: " + this.getDocumentType();
            this.log.log(Level.SEVERE, this.p_Error);
            fact = null;
        }
        int i = 0;
        while (i < this.m_taxes.length) {
            if (MTax.get((int)this.m_taxes[i].getC_Tax_ID()).isDocumentLevel() && this.m_taxes[i].isIncludedTaxDifference()) {
                BigDecimal differenceAmt = this.m_taxes[i].getIncludedTaxDifference();
                if (this.m_taxes[i].isSalesTax()) {
                    AdjustTaxInfo[] adjustTaxInfos;
                    FactLine fLine = fact.createLine(null, this.m_taxes[i].getAccount(0, as), this.getC_Currency_ID(), null, differenceAmt);
                    this.setTaxInfo(fLine, this.m_taxes[i].getC_Tax_ID(), "S", differenceAmt.negate(), differenceAmt);
                    AdjustTaxInfo[] adjustTaxInfoArray = adjustTaxInfos = this.getAdjustTaxInfo(this.m_taxes[i], "S");
                    int n = adjustTaxInfos.length;
                    int JP_TaxAmt = 0;
                    while (JP_TaxAmt < n) {
                        AdjustTaxInfo adjustTaxInfo = adjustTaxInfoArray[JP_TaxAmt];
                        fLine = fact.createLine(null, adjustTaxInfo.getAccount(), this.getC_Currency_ID(), adjustTaxInfo.getAdjustTaxAmt(), null);
                        this.setTaxInfo(fLine, this.m_taxes[i].getC_Tax_ID(), "S", adjustTaxInfo.getAdjustTaxBaseAmt(), adjustTaxInfo.getAdjustTaxAmt());
                        ++JP_TaxAmt;
                    }
                } else {
                    AdjustTaxInfo[] adjustTaxInfos;
                    boolean isSalesTax = MTax.get((int)this.m_taxes[i].getC_Tax_ID()).isSalesTax();
                    FactLine fLine = fact.createLine(null, this.m_taxes[i].getAccount(isSalesTax ? 2 : 1, as), this.getC_Currency_ID(), differenceAmt, null);
                    this.setTaxInfo(fLine, this.m_taxes[i].getC_Tax_ID(), "P", differenceAmt.negate(), differenceAmt);
                    AdjustTaxInfo[] adjustTaxInfoArray = adjustTaxInfos = this.getAdjustTaxInfo(this.m_taxes[i], "P");
                    int n = adjustTaxInfos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        AdjustTaxInfo adjustTaxInfo = adjustTaxInfoArray[n2];
                        fLine = fact.createLine(null, adjustTaxInfo.getAccount(), this.getC_Currency_ID(), null, adjustTaxInfo.getAdjustTaxAmt());
                        this.setTaxInfo(fLine, this.m_taxes[i].getC_Tax_ID(), "P", adjustTaxInfo.getAdjustTaxBaseAmt(), adjustTaxInfo.getAdjustTaxAmt());
                        ++n2;
                    }
                }
            }
            ++i;
        }
        facts.add(fact);
        return facts;
    }

    private DocTax getDocTax(int C_Tax_ID, String JP_SOPOType) {
        int i = 0;
        while (i < this.m_taxes.length) {
            if (this.m_taxes[i].getC_Tax_ID() == C_Tax_ID && (this.m_taxes[i].isSalesTax() && "S".equals(JP_SOPOType) || !this.m_taxes[i].isSalesTax() && "P".equals(JP_SOPOType))) {
                return this.m_taxes[i];
            }
            ++i;
        }
        return null;
    }

    private void setTaxInfo(FactLine fLine, int C_Tax_ID, String JP_SOPOType, BigDecimal JP_TaxBaseAmt, BigDecimal JP_TaxAmt) {
        if (fLine != null) {
            if (C_Tax_ID != 0) {
                fLine.setC_Tax_ID(C_Tax_ID);
            }
            if (!Util.isEmpty((String)JP_SOPOType)) {
                fLine.set_ValueNoCheck("JP_SOPOType", (Object)JP_SOPOType);
            }
            if (JP_TaxBaseAmt == null) {
                fLine.set_ValueNoCheck("JP_TaxBaseAmt", (Object)Env.ZERO);
            } else {
                fLine.set_ValueNoCheck("JP_TaxBaseAmt", (Object)JP_TaxBaseAmt);
            }
            if (JP_TaxAmt == null) {
                fLine.set_ValueNoCheck("JP_TaxAmt", (Object)Env.ZERO);
            } else {
                fLine.set_ValueNoCheck("JP_TaxAmt", (Object)JP_TaxAmt);
            }
            int C_BPartner_ID = fLine.getC_BPartner_ID();
            if (C_BPartner_ID > 0 && "P".equals(JP_SOPOType)) {
                MBPartner bp = MBPartner.get((Properties)this.getCtx(), (int)C_BPartner_ID);
                boolean IsQualifiedInvoiceIssuerJP = bp.get_ValueAsBoolean("IsQualifiedInvoiceIssuerJP");
                fLine.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)false);
                if (IsQualifiedInvoiceIssuerJP) {
                    Object obj_RegisteredDateOfQII = bp.get_Value("JP_RegisteredDateOfQII");
                    if (obj_RegisteredDateOfQII == null) {
                        fLine.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)IsQualifiedInvoiceIssuerJP);
                        fLine.set_ValueNoCheck("JP_RegisteredNumberOfQII", bp.get_Value("JP_RegisteredNumberOfQII"));
                    } else {
                        Timestamp JP_RegisteredDateOfQII = (Timestamp)obj_RegisteredDateOfQII;
                        if (this.getDateAcct().compareTo(JP_RegisteredDateOfQII) >= 0) {
                            fLine.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)IsQualifiedInvoiceIssuerJP);
                            fLine.set_ValueNoCheck("JP_RegisteredNumberOfQII", bp.get_Value("JP_RegisteredNumberOfQII"));
                        }
                    }
                }
            }
        }
    }

    private AdjustTaxInfo[] getAdjustTaxInfo(DocTax tax, String JP_SOPOType) {
        ArrayList<AdjustTaxInfo> adjustTaxInfoList = new ArrayList<AdjustTaxInfo>();
        int i = 0;
        while (i < this.p_lines.length) {
            if (JP_SOPOType.equals(this.p_lines[i].getPO().get_ValueAsString("JP_SOPOType")) && this.p_lines[i].getC_Tax_ID() == tax.getC_Tax_ID()) {
                AdjustTaxInfo adjustTaxInfo = null;
                for (AdjustTaxInfo ati : adjustTaxInfoList) {
                    if (this.p_lines[i].getAccount().getAccount_ID() != ati.getAccount().getAccount_ID()) continue;
                    adjustTaxInfo = ati;
                    break;
                }
                if (adjustTaxInfo == null) {
                    AdjustTaxInfo ati;
                    ati = new AdjustTaxInfo(this.p_lines[i], tax, JP_SOPOType);
                    ati.addJP_TaxBaseAmt((BigDecimal)this.p_lines[i].getPO().get_Value("JP_TaxBaseAmt"));
                    ati.addJP_TaxAmt((BigDecimal)this.p_lines[i].getPO().get_Value("JP_TaxAmt"));
                    adjustTaxInfoList.add(ati);
                } else {
                    adjustTaxInfo.addJP_TaxBaseAmt((BigDecimal)this.p_lines[i].getPO().get_Value("JP_TaxBaseAmt"));
                    adjustTaxInfo.addJP_TaxAmt((BigDecimal)this.p_lines[i].getPO().get_Value("JP_TaxAmt"));
                }
            }
            ++i;
        }
        BigDecimal accumulate_JP_TaxBaseAmt = Env.ZERO;
        BigDecimal accumulate_JP_TaxAmt = Env.ZERO;
        for (AdjustTaxInfo ati : adjustTaxInfoList) {
            ati.reCalculateTax();
            accumulate_JP_TaxBaseAmt = accumulate_JP_TaxBaseAmt.add(ati.getReCalculateJP_TaxBaseAmt());
            accumulate_JP_TaxAmt = accumulate_JP_TaxAmt.add(ati.getReCalculateJP_TaxAmt());
        }
        if (accumulate_JP_TaxBaseAmt.compareTo(tax.getTaxBaseAmt()) != 0 || accumulate_JP_TaxAmt.compareTo(tax.getAmount()) != 0) {
            BigDecimal diff_JP_TaxBaseAmt = tax.getTaxBaseAmt().subtract(accumulate_JP_TaxBaseAmt);
            BigDecimal diff_JP_TaxAmt = tax.getAmount().subtract(accumulate_JP_TaxAmt);
            AdjustTaxInfo maxAdjustTaxInfo = null;
            BigDecimal maxJP_TaxBaseAmtABS = Env.ZERO;
            BigDecimal tempJP_TaxBaseAmtABS = Env.ZERO;
            for (AdjustTaxInfo ati : adjustTaxInfoList) {
                if (maxAdjustTaxInfo == null) {
                    maxAdjustTaxInfo = ati;
                    maxJP_TaxBaseAmtABS = ati.getJP_TaxBaseAmt().abs();
                    continue;
                }
                tempJP_TaxBaseAmtABS = ati.getJP_TaxBaseAmt().abs();
                if (tempJP_TaxBaseAmtABS.compareTo(maxJP_TaxBaseAmtABS) <= 0) continue;
                maxAdjustTaxInfo = ati;
                maxJP_TaxBaseAmtABS = tempJP_TaxBaseAmtABS;
            }
            maxAdjustTaxInfo.addRecalculateJP_TaxBaseAmt(diff_JP_TaxBaseAmt);
            maxAdjustTaxInfo.addRecalculateJP_TaxAmt(diff_JP_TaxAmt);
        }
        AdjustTaxInfo[] adjustTaxInfos = new AdjustTaxInfo[adjustTaxInfoList.size()];
        adjustTaxInfoList.toArray(adjustTaxInfos);
        return adjustTaxInfos;
    }

    class AdjustTaxInfo {
        private DocLine docLine = null;
        private DocTax docTax = null;
        private String JP_SOPOType;
        private BigDecimal JP_TaxBaseAmt = Env.ZERO;
        private BigDecimal JP_TaxAmt = Env.ZERO;
        private BigDecimal reCalculate_TaxBaseAmt = Env.ZERO;
        private BigDecimal reCalculate_TaxAmt = Env.ZERO;

        public AdjustTaxInfo(DocLine docLine, DocTax docTax, String JP_SOPOType) {
            this.docLine = docLine;
            this.docTax = docTax;
            this.JP_SOPOType = JP_SOPOType;
        }

        public void addJP_TaxBaseAmt(BigDecimal JP_TaxBaseAmt) {
            this.JP_TaxBaseAmt = this.JP_TaxBaseAmt.add(JP_TaxBaseAmt);
        }

        public void addJP_TaxAmt(BigDecimal JP_TaxAmt) {
            this.JP_TaxAmt = this.JP_TaxAmt.add(JP_TaxAmt);
        }

        public void addRecalculateJP_TaxBaseAmt(BigDecimal JP_TaxBaseAmt) {
            this.reCalculate_TaxBaseAmt = this.reCalculate_TaxBaseAmt.add(JP_TaxBaseAmt);
        }

        public void addRecalculateJP_TaxAmt(BigDecimal JP_TaxAmt) {
            this.reCalculate_TaxAmt = this.reCalculate_TaxAmt.add(JP_TaxAmt);
        }

        public MAccount getAccount() {
            return this.docLine.getAccount();
        }

        public BigDecimal getJP_TaxBaseAmt() {
            return this.JP_TaxBaseAmt;
        }

        public BigDecimal getJP_TaxAmt() {
            return this.JP_TaxAmt;
        }

        public BigDecimal getReCalculateJP_TaxBaseAmt() {
            return this.reCalculate_TaxBaseAmt;
        }

        public BigDecimal getReCalculateJP_TaxAmt() {
            return this.reCalculate_TaxAmt;
        }

        public BigDecimal getAdjustTaxBaseAmt() {
            BigDecimal diff = this.JP_TaxBaseAmt.subtract(this.reCalculate_TaxBaseAmt);
            return diff.negate();
        }

        public BigDecimal getAdjustTaxAmt() {
            BigDecimal diff = this.JP_TaxAmt.subtract(this.reCalculate_TaxAmt);
            return diff.negate();
        }

        public void reCalculateTax() {
            MTax m_tax = MTax.get((int)this.docTax.getC_Tax_ID());
            BigDecimal IncludeTaxAmt = this.JP_TaxBaseAmt.add(this.JP_TaxAmt);
            IJPiereTaxProvider taxCalculater = JPiereUtil.getJPiereTaxProvider(m_tax);
            this.reCalculate_TaxAmt = taxCalculater != null ? taxCalculater.calculateTax(m_tax, IncludeTaxAmt, true, MCurrency.getStdPrecision((Properties)Env.getCtx(), (int)this.docLine.getC_Currency_ID()), JPiereTaxProvider.getRoundingMode(this.docLine.getC_BPartner_ID(), this.JP_SOPOType == "S", m_tax.getC_TaxProvider())) : m_tax.calculateTax(IncludeTaxAmt, true, MCurrency.getStdPrecision((Properties)Env.getCtx(), (int)this.docLine.getC_Currency_ID()));
            this.reCalculate_TaxBaseAmt = IncludeTaxAmt.subtract(this.reCalculate_TaxAmt);
        }
    }
}

