/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.compiere.acct;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.compiere.acct.DocLine_BankStatementJP;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocTax;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MBPartner;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MConversionRate;
import org.compiere.model.MPayment;
import org.compiere.model.MTax;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class Doc_BankStatementJP
extends Doc {
    protected int m_C_BankAccount_ID = 0;
    private DocTax[] m_taxes = null;

    public Doc_BankStatementJP(MAcctSchema as, ResultSet rs, String trxName) {
        super(as, MBankStatement.class, rs, "CMB", trxName);
    }

    protected String loadDocumentDetails() {
        MBankStatement bs = (MBankStatement)this.getPO();
        this.setDateDoc(bs.getStatementDate());
        this.setDateAcct(bs.getDateAcct());
        this.m_C_BankAccount_ID = bs.getC_BankAccount_ID();
        this.setAmount(0, bs.getStatementDifference());
        MBankAccount ba = MBankAccount.get((Properties)this.getCtx(), (int)this.m_C_BankAccount_ID);
        this.setC_Currency_ID(ba.getC_Currency_ID());
        this.p_lines = this.loadLines(bs);
        this.m_taxes = this.loadTaxes();
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("Lines=" + this.p_lines.length);
        }
        return null;
    }

    protected DocLine[] loadLines(MBankStatement bs) {
        ArrayList<DocLine_BankStatementJP> list = new ArrayList<DocLine_BankStatementJP>();
        MBankStatementLine[] lines = bs.getLines(false);
        int i = 0;
        while (i < lines.length) {
            MBankStatementLine line = lines[i];
            if (line.isActive()) {
                DocLine_BankStatementJP docLine = new DocLine_BankStatementJP(line, this);
                if (line.getC_Payment_ID() != 0) {
                    MPayment payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.getTrxName());
                    int C_ConversionType_ID = payment.getC_ConversionType_ID();
                    docLine.setC_ConversionType_ID(C_ConversionType_ID);
                    if (payment.isOverrideCurrencyRate()) {
                        docLine.setCurrencyRate(payment.getCurrencyRate());
                    } else {
                        BigDecimal rate = MConversionRate.getRate((int)payment.getC_Currency_ID(), (int)this.getAcctSchema().getC_Currency_ID(), (Timestamp)payment.getDateAcct(), (int)C_ConversionType_ID, (int)this.getAD_Client_ID(), (int)payment.getAD_Org_ID());
                        docLine.setCurrencyRate(rate);
                    }
                }
                list.add(docLine);
            }
            ++i;
        }
        DocLine[] dls = new DocLine_BankStatementJP[list.size()];
        list.toArray(dls);
        return dls;
    }

    private DocTax[] loadTaxes() {
        ArrayList<DocTax> list = new ArrayList<DocTax>();
        String sql = "SELECT bst.C_Tax_ID, t.Name, t.Rate, bst.TaxBaseAmt, bst.TaxAmt, t.IsSalesTax,bst.C_BankStatementLine_ID FROM C_Tax t, JP_BankStatementTax bst WHERE t.C_Tax_ID=bst.C_Tax_ID AND bst.C_BankStatement_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement((String)sql, (String)this.getTrxName());
                pstmt.setInt(1, this.get_ID());
                rs = pstmt.executeQuery();
                block4: while (rs.next()) {
                    int C_Tax_ID = rs.getInt(1);
                    String name = rs.getString(2);
                    BigDecimal rate = rs.getBigDecimal(3);
                    BigDecimal taxBaseAmt = rs.getBigDecimal(4);
                    BigDecimal amount = rs.getBigDecimal(5);
                    boolean salesTax = "Y".equals(rs.getString(6));
                    int C_BankStatementLine_ID = rs.getInt(7);
                    DocTax docTax = new DocTax(C_Tax_ID, name, rate, taxBaseAmt, amount, salesTax);
                    list.add(docTax);
                    int i = 0;
                    while (i < this.p_lines.length) {
                        DocLine_BankStatementJP docLine = (DocLine_BankStatementJP)this.p_lines[i];
                        if (docLine.get_ID() == C_BankStatementLine_ID) {
                            docLine.setDocTax(docTax);
                            docLine.setTaxBaseAmt(taxBaseAmt);
                            docLine.setTaxAmt(amount);
                            continue block4;
                        }
                        ++i;
                    }
                }
            }
            catch (SQLException e) {
                this.log.log(Level.SEVERE, sql, (Throwable)e);
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                return null;
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            throw throwable;
        }
        DB.close((ResultSet)rs, (Statement)pstmt);
        rs = null;
        pstmt = null;
        DocTax[] tl = new DocTax[list.size()];
        list.toArray(tl);
        return tl;
    }

    public BigDecimal getBalance() {
        BigDecimal retValue = Env.ZERO;
        StringBuilder sb = new StringBuilder(" [");
        retValue = retValue.add(this.getAmount(0));
        sb.append(this.getAmount(0));
        int i = 0;
        while (i < this.p_lines.length) {
            BigDecimal lineBalance = ((DocLine_BankStatementJP)this.p_lines[i]).getStmtAmt();
            retValue = retValue.subtract(lineBalance);
            sb.append("-").append(lineBalance);
            ++i;
        }
        sb.append("]");
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.toString()) + " Balance=" + retValue + sb.toString());
        }
        return retValue;
    }

    public ArrayList<Fact> createFacts(MAcctSchema as) {
        Fact fact = new Fact((Doc)this, as, "A");
        FactLine fl = null;
        int AD_Org_ID = this.getBank_Org_ID();
        int i = 0;
        while (i < this.p_lines.length) {
            Timestamp JP_RegisteredDateOfQII;
            Object obj_RegisteredDateOfQII;
            boolean IsQualifiedInvoiceIssuerJP;
            boolean isSalesTax;
            MBPartner bp;
            DocLine_BankStatementJP line = (DocLine_BankStatementJP)this.p_lines[i];
            int C_BPartner_ID = line.getC_BPartner_ID();
            MAccount acct_bank_asset = this.getAccount(40, as);
            MAccount acct_bank_in_transit = this.getAccount(11, as);
            if (!as.isPostIfClearingEqual() && acct_bank_asset.equals((Object)acct_bank_in_transit)) {
                BigDecimal amt_stmt_minus_trx = line.getStmtAmt().subtract(line.getTrxAmt());
                if (amt_stmt_minus_trx.compareTo(Env.ZERO) != 0) {
                    fl = fact.createLine((DocLine)line, this.getAccount(40, as), line.getC_Currency_ID(), amt_stmt_minus_trx);
                    if (fl != null && AD_Org_ID != 0) {
                        fl.setAD_Org_ID(AD_Org_ID);
                    }
                    if (fl != null && C_BPartner_ID != 0) {
                        fl.setC_BPartner_ID(C_BPartner_ID);
                    }
                    this.setAccountInfo(fl);
                }
            } else {
                fl = fact.createLine((DocLine)line, this.getAccount(40, as), line.getC_Currency_ID(), line.getStmtAmt());
                if (fl != null && AD_Org_ID != 0) {
                    fl.setAD_Org_ID(AD_Org_ID);
                }
                if (fl != null && C_BPartner_ID != 0) {
                    fl.setC_BPartner_ID(C_BPartner_ID);
                }
                this.setAccountInfo(fl);
                fl = fact.createLine((DocLine)line, this.getAccount(11, as), line.getC_Currency_ID(), line.getTrxAmt().negate());
                if (fl != null) {
                    if (C_BPartner_ID != 0) {
                        fl.setC_BPartner_ID(C_BPartner_ID);
                    }
                    if (AD_Org_ID != 0) {
                        fl.setAD_Org_ID(AD_Org_ID);
                    } else {
                        fl.setAD_Org_ID(line.getAD_Org_ID(true));
                    }
                    this.setAccountInfo(fl);
                }
            }
            if (line.getChargeAmt().compareTo(Env.ZERO) > 0) {
                if (line.getDocTax() == null) {
                    fl = fact.createLine((DocLine)line, line.getChargeAccount(as, line.getChargeAmt().negate()), line.getC_Currency_ID(), null, line.getChargeAmt());
                    if (fl != null) {
                        if (line.getC_Tax_ID() != 0) {
                            fl.setC_Tax_ID(line.getC_Tax_ID());
                            fl.set_ValueNoCheck("JP_SOPOType", (Object)"N");
                            fl.set_ValueNoCheck("JP_TaxBaseAmt", (Object)Env.ZERO);
                            fl.set_ValueNoCheck("JP_TaxAmt", (Object)Env.ZERO);
                        }
                        this.setAdditionalChargeInfo(fl, line);
                    }
                } else if (line.getPO().get_Value("JP_SOPOType") == null || line.getPO().get_ValueAsString("JP_SOPOType").equals("S")) {
                    fl = fact.createLine((DocLine)line, line.getDocTax().getAccount(0, as), this.getC_Currency_ID(), null, line.getDocTax().getAmount());
                    if (fl != null) {
                        fl.setC_Tax_ID(line.getC_Tax_ID());
                        fl.set_ValueNoCheck("JP_SOPOType", (Object)"S");
                        fl.set_ValueNoCheck("JP_TaxBaseAmt", (Object)line.getTaxBaseAmt());
                        fl.set_ValueNoCheck("JP_TaxAmt", (Object)line.getTaxAmt());
                        this.setAccountInfo(fl);
                    }
                    if ((fl = fact.createLine((DocLine)line, line.getChargeAccount(as, line.getChargeAmt().negate()), line.getC_Currency_ID(), null, line.getTaxBaseAmt())) != null) {
                        fl.setC_Tax_ID(line.getC_Tax_ID());
                        fl.set_ValueNoCheck("JP_SOPOType", (Object)"S");
                        fl.set_ValueNoCheck("JP_TaxBaseAmt", (Object)line.getTaxBaseAmt());
                        fl.set_ValueNoCheck("JP_TaxAmt", (Object)line.getTaxAmt());
                        this.setAdditionalChargeInfo(fl, line);
                    }
                } else {
                    bp = null;
                    if (C_BPartner_ID > 0) {
                        bp = MBPartner.get((Properties)this.getCtx(), (int)C_BPartner_ID);
                    }
                    isSalesTax = MTax.get((int)line.getC_Tax_ID()).isSalesTax();
                    fl = fact.createLine((DocLine)line, line.getDocTax().getAccount(isSalesTax ? 2 : 1, as), this.getC_Currency_ID(), null, line.getDocTax().getAmount().negate());
                    if (fl != null) {
                        fl.setC_Tax_ID(line.getC_Tax_ID());
                        fl.set_ValueNoCheck("JP_SOPOType", (Object)"P");
                        fl.set_ValueNoCheck("JP_TaxBaseAmt", (Object)line.getTaxBaseAmt());
                        fl.set_ValueNoCheck("JP_TaxAmt", (Object)line.getTaxAmt());
                        this.setAccountInfo(fl);
                        if (bp != null) {
                            IsQualifiedInvoiceIssuerJP = bp.get_ValueAsBoolean("IsQualifiedInvoiceIssuerJP");
                            fl.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)false);
                            if (IsQualifiedInvoiceIssuerJP) {
                                obj_RegisteredDateOfQII = bp.get_Value("JP_RegisteredDateOfQII");
                                if (obj_RegisteredDateOfQII == null) {
                                    fl.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)IsQualifiedInvoiceIssuerJP);
                                    fl.set_ValueNoCheck("JP_RegisteredNumberOfQII", bp.get_Value("JP_RegisteredNumberOfQII"));
                                } else {
                                    JP_RegisteredDateOfQII = (Timestamp)obj_RegisteredDateOfQII;
                                    if (this.getDateAcct().compareTo(JP_RegisteredDateOfQII) >= 0) {
                                        fl.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)IsQualifiedInvoiceIssuerJP);
                                        fl.set_ValueNoCheck("JP_RegisteredNumberOfQII", bp.get_Value("JP_RegisteredNumberOfQII"));
                                    }
                                }
                            }
                        }
                    }
                    if ((fl = fact.createLine((DocLine)line, line.getChargeAccount(as, line.getChargeAmt().negate()), line.getC_Currency_ID(), null, line.getTaxBaseAmt().negate())) != null) {
                        fl.setC_Tax_ID(line.getC_Tax_ID());
                        fl.set_ValueNoCheck("JP_SOPOType", (Object)"P");
                        fl.set_ValueNoCheck("JP_TaxBaseAmt", (Object)line.getTaxBaseAmt());
                        fl.set_ValueNoCheck("JP_TaxAmt", (Object)line.getTaxAmt());
                        if (bp != null) {
                            IsQualifiedInvoiceIssuerJP = bp.get_ValueAsBoolean("IsQualifiedInvoiceIssuerJP");
                            fl.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)false);
                            if (IsQualifiedInvoiceIssuerJP) {
                                obj_RegisteredDateOfQII = bp.get_Value("JP_RegisteredDateOfQII");
                                if (obj_RegisteredDateOfQII == null) {
                                    fl.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)IsQualifiedInvoiceIssuerJP);
                                    fl.set_ValueNoCheck("JP_RegisteredNumberOfQII", bp.get_Value("JP_RegisteredNumberOfQII"));
                                } else {
                                    JP_RegisteredDateOfQII = (Timestamp)obj_RegisteredDateOfQII;
                                    if (this.getDateAcct().compareTo(JP_RegisteredDateOfQII) >= 0) {
                                        fl.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)IsQualifiedInvoiceIssuerJP);
                                        fl.set_ValueNoCheck("JP_RegisteredNumberOfQII", bp.get_Value("JP_RegisteredNumberOfQII"));
                                    }
                                }
                            }
                        }
                        this.setAdditionalChargeInfo(fl, line);
                    }
                }
            } else if (line.getDocTax() == null) {
                fl = fact.createLine((DocLine)line, line.getChargeAccount(as, line.getChargeAmt().negate()), line.getC_Currency_ID(), line.getChargeAmt().negate(), null);
                if (fl != null) {
                    if (line.getC_Tax_ID() != 0) {
                        fl.setC_Tax_ID(line.getC_Tax_ID());
                        fl.set_ValueNoCheck("JP_SOPOType", (Object)"N");
                        fl.set_ValueNoCheck("JP_TaxBaseAmt", (Object)Env.ZERO);
                        fl.set_ValueNoCheck("JP_TaxAmt", (Object)Env.ZERO);
                    }
                    this.setAdditionalChargeInfo(fl, line);
                }
            } else if (line.getPO().get_Value("JP_SOPOType") == null || line.getPO().get_ValueAsString("JP_SOPOType").equals("P")) {
                bp = null;
                if (C_BPartner_ID > 0) {
                    bp = MBPartner.get((Properties)this.getCtx(), (int)C_BPartner_ID);
                }
                isSalesTax = MTax.get((int)line.getC_Tax_ID()).isSalesTax();
                fl = fact.createLine((DocLine)line, line.getDocTax().getAccount(isSalesTax ? 2 : 1, as), this.getC_Currency_ID(), line.getDocTax().getAmount(), null);
                if (fl != null) {
                    fl.setC_Tax_ID(line.getC_Tax_ID());
                    fl.set_ValueNoCheck("JP_SOPOType", (Object)"P");
                    fl.set_ValueNoCheck("JP_TaxBaseAmt", (Object)line.getTaxBaseAmt());
                    fl.set_ValueNoCheck("JP_TaxAmt", (Object)line.getTaxAmt());
                    this.setAccountInfo(fl);
                    if (bp != null) {
                        IsQualifiedInvoiceIssuerJP = bp.get_ValueAsBoolean("IsQualifiedInvoiceIssuerJP");
                        fl.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)false);
                        if (IsQualifiedInvoiceIssuerJP) {
                            obj_RegisteredDateOfQII = bp.get_Value("JP_RegisteredDateOfQII");
                            if (obj_RegisteredDateOfQII == null) {
                                fl.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)IsQualifiedInvoiceIssuerJP);
                                fl.set_ValueNoCheck("JP_RegisteredNumberOfQII", bp.get_Value("JP_RegisteredNumberOfQII"));
                            } else {
                                JP_RegisteredDateOfQII = (Timestamp)obj_RegisteredDateOfQII;
                                if (this.getDateAcct().compareTo(JP_RegisteredDateOfQII) >= 0) {
                                    fl.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)IsQualifiedInvoiceIssuerJP);
                                    fl.set_ValueNoCheck("JP_RegisteredNumberOfQII", bp.get_Value("JP_RegisteredNumberOfQII"));
                                }
                            }
                        }
                    }
                }
                fl = fact.createLine((DocLine)line, line.getChargeAccount(as, line.getChargeAmt().negate()), line.getC_Currency_ID(), line.getTaxBaseAmt(), null);
                fl.setC_Tax_ID(line.getC_Tax_ID());
                fl.set_ValueNoCheck("JP_SOPOType", (Object)"P");
                fl.set_ValueNoCheck("JP_TaxBaseAmt", (Object)line.getTaxBaseAmt());
                fl.set_ValueNoCheck("JP_TaxAmt", (Object)line.getTaxAmt());
                if (bp != null) {
                    IsQualifiedInvoiceIssuerJP = bp.get_ValueAsBoolean("IsQualifiedInvoiceIssuerJP");
                    fl.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)false);
                    if (IsQualifiedInvoiceIssuerJP) {
                        obj_RegisteredDateOfQII = bp.get_Value("JP_RegisteredDateOfQII");
                        if (obj_RegisteredDateOfQII == null) {
                            fl.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)IsQualifiedInvoiceIssuerJP);
                            fl.set_ValueNoCheck("JP_RegisteredNumberOfQII", bp.get_Value("JP_RegisteredNumberOfQII"));
                        } else {
                            JP_RegisteredDateOfQII = (Timestamp)obj_RegisteredDateOfQII;
                            if (this.getDateAcct().compareTo(JP_RegisteredDateOfQII) >= 0) {
                                fl.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)IsQualifiedInvoiceIssuerJP);
                                fl.set_ValueNoCheck("JP_RegisteredNumberOfQII", bp.get_Value("JP_RegisteredNumberOfQII"));
                            }
                        }
                    }
                }
                this.setAdditionalChargeInfo(fl, line);
            } else {
                fl = fact.createLine((DocLine)line, line.getDocTax().getAccount(0, as), this.getC_Currency_ID(), line.getDocTax().getAmount().negate(), null);
                if (fl != null) {
                    fl.setC_Tax_ID(line.getC_Tax_ID());
                    fl.set_ValueNoCheck("JP_SOPOType", (Object)"S");
                    fl.set_ValueNoCheck("JP_TaxBaseAmt", (Object)line.getTaxBaseAmt());
                    fl.set_ValueNoCheck("JP_TaxAmt", (Object)line.getTaxAmt());
                    this.setAccountInfo(fl);
                }
                fl = fact.createLine((DocLine)line, line.getChargeAccount(as, line.getChargeAmt().negate()), line.getC_Currency_ID(), line.getTaxBaseAmt().negate(), null);
                fl.setC_Tax_ID(line.getC_Tax_ID());
                fl.set_ValueNoCheck("JP_SOPOType", (Object)"S");
                fl.set_ValueNoCheck("JP_TaxBaseAmt", (Object)line.getTaxBaseAmt());
                fl.set_ValueNoCheck("JP_TaxAmt", (Object)line.getTaxAmt());
                this.setAdditionalChargeInfo(fl, line);
            }
            if (fl != null && C_BPartner_ID != 0) {
                fl.setC_BPartner_ID(C_BPartner_ID);
            }
            if ((fl = line.getInterestAmt().signum() < 0 ? fact.createLine((DocLine)line, this.getAccount(42, as), this.getAccount(42, as), line.getC_Currency_ID(), line.getInterestAmt().negate()) : fact.createLine((DocLine)line, this.getAccount(41, as), this.getAccount(41, as), line.getC_Currency_ID(), line.getInterestAmt().negate())) != null && C_BPartner_ID != 0) {
                fl.setC_BPartner_ID(C_BPartner_ID);
            }
            this.setAccountInfo(fl);
            ++i;
        }
        ArrayList<Fact> facts = new ArrayList<Fact>();
        facts.add(fact);
        return facts;
    }

    protected int getBank_Org_ID() {
        if (this.m_C_BankAccount_ID == 0) {
            return 0;
        }
        MBankAccount ba = MBankAccount.get((Properties)this.getCtx(), (int)this.m_C_BankAccount_ID);
        return ba.getAD_Org_ID();
    }

    private void setAdditionalChargeInfo(FactLine fl, DocLine_BankStatementJP line) {
        this.setAccountInfo(fl);
        fl.set_ValueNoCheck("JP_Charge_ID", line.getPO().get_Value("C_Charge_ID"));
        fl.set_ValueNoCheck("JP_PriceActual", line.getPO().get_Value("JP_PriceActual"));
        fl.set_ValueNoCheck("Qty", line.getPO().get_Value("JP_Qty"));
        fl.set_ValueNoCheck("M_Product_ID", line.getPO().get_Value("JP_Product_ID"));
        fl.set_ValueNoCheck("C_UOM_ID", line.getPO().get_Value("JP_UOM_ID"));
    }

    private void setAccountInfo(FactLine fl) {
        if (fl != null) {
            fl.set_ValueNoCheck("JP_BankAccount_ID", (Object)this.m_C_BankAccount_ID);
        }
    }
}

