/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.compiere.acct;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.acct.Doc;
import org.compiere.acct.DocLine;
import org.compiere.acct.DocManager;
import org.compiere.acct.Fact;
import org.compiere.acct.FactLine;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

class Doc_AllocationTax {
    private static final CLogger log = CLogger.getCLogger(Doc_AllocationTax.class);
    private MAccount m_DiscountAccount;
    private BigDecimal m_DiscountAmt;
    private MAccount m_WriteOffAccount;
    private BigDecimal m_WriteOffAmt;
    private boolean m_IsSOTrx;
    private ArrayList<MFactAcct> m_facts = new ArrayList();
    private int m_totalIndex = 0;

    public Doc_AllocationTax(MAccount DiscountAccount, BigDecimal DiscountAmt, MAccount WriteOffAccount, BigDecimal WriteOffAmt, boolean isSOTrx) {
        this.m_DiscountAccount = DiscountAccount;
        this.m_DiscountAmt = DiscountAmt;
        this.m_WriteOffAccount = WriteOffAccount;
        this.m_WriteOffAmt = WriteOffAmt;
        this.m_IsSOTrx = isSOTrx;
    }

    public void addInvoiceFact(MFactAcct fact) {
        this.m_facts.add(fact);
    }

    public int getLineCount() {
        return this.m_facts.size();
    }

    public boolean createEntries(MAcctSchema as, Fact fact, DocLine line) {
        BigDecimal total = Env.ZERO;
        int i = 0;
        while (i < this.m_facts.size()) {
            MFactAcct factAcct = this.m_facts.get(i);
            if (factAcct.getAmtSourceDr().signum() > 0 && factAcct.getAmtSourceDr().compareTo(total) > 0 || factAcct.getAmtSourceDr().signum() < 0 && factAcct.getAmtSourceDr().compareTo(total) < 0) {
                total = factAcct.getAmtSourceDr();
                this.m_totalIndex = i;
            }
            if (factAcct.getAmtSourceCr().signum() > 0 && factAcct.getAmtSourceCr().compareTo(total) > 0 || factAcct.getAmtSourceCr().signum() < 0 && factAcct.getAmtSourceCr().compareTo(total) < 0) {
                total = factAcct.getAmtSourceCr();
                this.m_totalIndex = i;
            }
            ++i;
        }
        MFactAcct factAcct = this.m_facts.get(this.m_totalIndex);
        if (log.isLoggable(Level.INFO)) {
            log.info("Total Invoice = " + total + " - " + factAcct);
        }
        int precision = as.getStdPrecision();
        FactLine fl = null;
        int i2 = 0;
        while (i2 < this.m_facts.size()) {
            if (i2 != this.m_totalIndex) {
                BigDecimal amount;
                String docBaseType;
                MAccount taxAcct;
                factAcct = this.m_facts.get(i2);
                if (log.isLoggable(Level.INFO)) {
                    log.info(String.valueOf(i2) + ": " + factAcct);
                }
                if ((taxAcct = factAcct.getMAccount()) == null || taxAcct.get_ID() == 0) {
                    log.severe("Tax Account not found/created");
                    return false;
                }
                Doc doc = DocManager.getDocument((MAcctSchema)as, (int)318, (int)factAcct.getRecord_ID(), (String)line.getPO().get_TrxName());
                MDocType dt = new MDocType(Env.getCtx(), doc != null ? doc.getC_DocType_ID() : -1, line.getPO().get_TrxName());
                String string = docBaseType = dt.getC_DocType_ID() > 0 ? dt.getDocBaseType() : "";
                if (this.m_DiscountAmt.signum() != 0) {
                    if (Env.ZERO.compareTo(factAcct.getAmtSourceDr()) != 0) {
                        amount = this.calcAmount(factAcct.getAmtSourceDr(), total, this.m_DiscountAmt, precision);
                        if (amount.signum() != 0) {
                            if (this.m_IsSOTrx) {
                                if (docBaseType.equals("ARC")) {
                                    fl = fact.createLine(line, this.m_DiscountAccount, line.getC_Currency_ID(), amount.negate(), null);
                                    this.copyAcctInfo(fl, factAcct, false);
                                    fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), null, amount.negate());
                                    this.copyAcctInfo(fl, factAcct, true);
                                } else {
                                    fl = fact.createLine(line, this.m_DiscountAccount, line.getC_Currency_ID(), amount, null);
                                    this.copyAcctInfo(fl, factAcct, false);
                                    fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), null, amount);
                                    this.copyAcctInfo(fl, factAcct, true);
                                }
                            } else if (docBaseType.equals("APC")) {
                                fl = fact.createLine(line, this.m_DiscountAccount, line.getC_Currency_ID(), amount, null);
                                this.copyAcctInfo(fl, factAcct, false);
                                fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), null, amount);
                                this.copyAcctInfo(fl, factAcct, true);
                            } else {
                                fl = fact.createLine(line, this.m_DiscountAccount, line.getC_Currency_ID(), amount.negate(), null);
                                this.copyAcctInfo(fl, factAcct, false);
                                fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), null, amount.negate());
                                this.copyAcctInfo(fl, factAcct, true);
                            }
                        }
                    } else {
                        amount = this.calcAmount(factAcct.getAmtSourceCr(), total, this.m_DiscountAmt, precision);
                        if (amount.signum() != 0) {
                            if (this.m_IsSOTrx) {
                                if (docBaseType.equals("ARC")) {
                                    fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), amount.negate(), null);
                                    this.copyAcctInfo(fl, factAcct, true);
                                    fl = fact.createLine(line, this.m_DiscountAccount, line.getC_Currency_ID(), null, amount.negate());
                                    this.copyAcctInfo(fl, factAcct, false);
                                } else {
                                    fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), amount, null);
                                    this.copyAcctInfo(fl, factAcct, true);
                                    fl = fact.createLine(line, this.m_DiscountAccount, line.getC_Currency_ID(), null, amount);
                                    this.copyAcctInfo(fl, factAcct, false);
                                }
                            } else if (docBaseType.equals("APC")) {
                                fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), amount, null);
                                this.copyAcctInfo(fl, factAcct, true);
                                fl = fact.createLine(line, this.m_DiscountAccount, line.getC_Currency_ID(), null, amount);
                                this.copyAcctInfo(fl, factAcct, false);
                            } else {
                                fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), amount.negate(), null);
                                this.copyAcctInfo(fl, factAcct, true);
                                fl = fact.createLine(line, this.m_DiscountAccount, line.getC_Currency_ID(), null, amount.negate());
                                this.copyAcctInfo(fl, factAcct, false);
                            }
                        }
                    }
                }
                if (this.m_WriteOffAmt.signum() != 0) {
                    if (Env.ZERO.compareTo(factAcct.getAmtSourceDr()) != 0) {
                        amount = this.calcAmount(factAcct.getAmtSourceDr(), total, this.m_WriteOffAmt, precision);
                        if (amount.signum() != 0) {
                            if (this.m_IsSOTrx) {
                                if (docBaseType.equals("ARC")) {
                                    fl = fact.createLine(line, this.m_WriteOffAccount, line.getC_Currency_ID(), amount.negate(), null);
                                    this.copyAcctInfo(fl, factAcct, false);
                                    fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), null, amount.negate());
                                    this.copyAcctInfo(fl, factAcct, true);
                                } else {
                                    fl = fact.createLine(line, this.m_WriteOffAccount, line.getC_Currency_ID(), amount, null);
                                    this.copyAcctInfo(fl, factAcct, false);
                                    fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), null, amount);
                                    this.copyAcctInfo(fl, factAcct, true);
                                }
                            } else if (docBaseType.equals("APC")) {
                                fl = fact.createLine(line, this.m_WriteOffAccount, line.getC_Currency_ID(), amount, null);
                                this.copyAcctInfo(fl, factAcct, false);
                                fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), null, amount);
                                this.copyAcctInfo(fl, factAcct, true);
                            } else {
                                fl = fact.createLine(line, this.m_WriteOffAccount, line.getC_Currency_ID(), amount.negate(), null);
                                this.copyAcctInfo(fl, factAcct, false);
                                fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), null, amount.negate());
                                this.copyAcctInfo(fl, factAcct, true);
                            }
                        }
                    } else {
                        amount = this.calcAmount(factAcct.getAmtSourceCr(), total, this.m_WriteOffAmt, precision);
                        if (amount.signum() != 0) {
                            if (this.m_IsSOTrx) {
                                if (docBaseType.equals("ARC")) {
                                    fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), amount.negate(), null);
                                    this.copyAcctInfo(fl, factAcct, true);
                                    fl = fact.createLine(line, this.m_WriteOffAccount, line.getC_Currency_ID(), null, amount.negate());
                                    this.copyAcctInfo(fl, factAcct, false);
                                } else {
                                    fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), amount, null);
                                    this.copyAcctInfo(fl, factAcct, true);
                                    fl = fact.createLine(line, this.m_WriteOffAccount, line.getC_Currency_ID(), null, amount);
                                    this.copyAcctInfo(fl, factAcct, false);
                                }
                            } else if (docBaseType.equals("APC")) {
                                fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), amount, null);
                                this.copyAcctInfo(fl, factAcct, true);
                                fl = fact.createLine(line, this.m_WriteOffAccount, line.getC_Currency_ID(), null, amount);
                                this.copyAcctInfo(fl, factAcct, false);
                            } else {
                                fl = fact.createLine(line, taxAcct, line.getC_Currency_ID(), amount.negate(), null);
                                this.copyAcctInfo(fl, factAcct, true);
                                fl = fact.createLine(line, this.m_WriteOffAccount, line.getC_Currency_ID(), null, amount.negate());
                                this.copyAcctInfo(fl, factAcct, false);
                            }
                        }
                    }
                }
            }
            ++i2;
        }
        return true;
    }

    private BigDecimal calcAmount(BigDecimal tax, BigDecimal total, BigDecimal amt, int precision) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Amt=" + amt + " - Total=" + total + ", Tax=" + tax);
        }
        if (tax.signum() == 0 || total.signum() == 0 || amt.signum() == 0) {
            return Env.ZERO;
        }
        BigDecimal multiplier = tax.divide(total, 10, RoundingMode.HALF_UP);
        BigDecimal retValue = multiplier.multiply(amt);
        if (retValue.scale() > precision) {
            retValue = retValue.setScale(precision, RoundingMode.HALF_UP);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(retValue + " (Mult=" + multiplier + "(Prec=" + precision + ")");
        }
        return retValue;
    }

    private void copyAcctInfo(FactLine fl, MFactAcct factAcct, boolean isCopyTaxInfo) {
        int JP_BankAccount_ID;
        int JP_Payment_ID;
        int JP_Invoice_ID;
        int JP_Order_ID;
        int JP_ContractProcPeriod_ID;
        int JP_ContractContent_ID;
        int JP_Contract_ID;
        fl.setAD_Org_ID(factAcct.getAD_Org_ID());
        fl.setAD_OrgTrx_ID(factAcct.getAD_OrgTrx_ID());
        String TaxCorrectionType = Msg.getElement((Properties)Env.getCtx(), (String)"TaxCorrectionType");
        fl.setDescription(String.valueOf(TaxCorrectionType) + " : " + fl.getDescription());
        fl.setC_BPartner_ID(factAcct.getC_BPartner_ID());
        fl.setC_Project_ID(factAcct.getC_Project_ID());
        fl.setC_ProjectPhase_ID(factAcct.getC_ProjectPhase_ID());
        fl.setC_ProjectTask_ID(factAcct.getC_ProjectTask_ID());
        fl.setC_Campaign_ID(factAcct.getC_Campaign_ID());
        fl.setC_Activity_ID(factAcct.getC_Activity_ID());
        fl.setC_SalesRegion_ID(factAcct.getC_SalesRegion_ID());
        fl.setC_LocFrom_ID(factAcct.getC_LocFrom_ID());
        fl.setC_LocTo_ID(factAcct.getC_LocTo_ID());
        fl.setM_Locator_ID(factAcct.getM_Locator_ID());
        fl.setUser1_ID(factAcct.getUser1_ID());
        fl.setUser2_ID(factAcct.getUser2_ID());
        fl.setUserElement1_ID(factAcct.getUserElement1_ID());
        fl.setUserElement2_ID(factAcct.getUserElement2_ID());
        fl.set_ValueNoCheck("JP_TaxBaseAmt", (Object)Env.ZERO);
        fl.set_ValueNoCheck("JP_TaxAmt", (Object)Env.ZERO);
        if (isCopyTaxInfo) {
            fl.setC_Tax_ID(factAcct.getC_Tax_ID());
            String JP_SOPOType = factAcct.get_ValueAsString("JP_SOPOType");
            if (!Util.isEmpty((String)JP_SOPOType)) {
                fl.set_ValueNoCheck("JP_SOPOType", (Object)JP_SOPOType);
            }
            boolean IsQualifiedInvoiceIssuerJP = factAcct.get_ValueAsBoolean("IsQualifiedInvoiceIssuerJP");
            fl.set_ValueNoCheck("IsQualifiedInvoiceIssuerJP", (Object)IsQualifiedInvoiceIssuerJP);
            String JP_RegisteredNumberOfQII = factAcct.get_ValueAsString("JP_RegisteredNumberOfQII");
            if (!Util.isEmpty((String)JP_RegisteredNumberOfQII)) {
                fl.set_ValueNoCheck("JP_RegisteredNumberOfQII", (Object)JP_RegisteredNumberOfQII);
            }
        }
        if ((JP_Contract_ID = factAcct.get_ValueAsInt("JP_Contract_ID")) > 0) {
            fl.set_ValueNoCheck("JP_Contract_ID", (Object)JP_Contract_ID);
        }
        if ((JP_ContractContent_ID = factAcct.get_ValueAsInt("JP_ContractContent_ID")) > 0) {
            fl.set_ValueNoCheck("JP_ContractContent_ID", (Object)JP_ContractContent_ID);
        }
        if ((JP_ContractProcPeriod_ID = factAcct.get_ValueAsInt("JP_ContractProcPeriod_ID")) > 0) {
            fl.set_ValueNoCheck("JP_ContractProcPeriod_ID", (Object)JP_ContractProcPeriod_ID);
        }
        if ((JP_Order_ID = factAcct.get_ValueAsInt("JP_Order_ID")) > 0) {
            fl.set_ValueNoCheck("JP_Order_ID", (Object)JP_Order_ID);
        }
        if ((JP_Invoice_ID = factAcct.get_ValueAsInt("JP_Invoice_ID")) > 0) {
            fl.set_ValueNoCheck("JP_Invoice_ID", (Object)JP_Invoice_ID);
        }
        if ((JP_Payment_ID = factAcct.get_ValueAsInt("JP_Payment_ID")) > 0) {
            fl.set_ValueNoCheck("JP_Payment_ID", (Object)JP_Payment_ID);
        }
        if ((JP_BankAccount_ID = factAcct.get_ValueAsInt("JP_BankAccount_ID")) > 0) {
            fl.set_ValueNoCheck("JP_BankAccount_ID", (Object)JP_BankAccount_ID);
        }
    }
}

