/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MBankAccount;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionCheck;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.PaymentExport;

public class WPayPrintProcess
extends SvrProcess {
    private int p_C_PaySelection_ID = 0;
    private String p_PaymentRule = null;
    private int p_C_BankAccount_ID = 0;
    IProcessUI processUI = null;
    public String m_PaymentExportClass = null;
    public MPaySelectionCheck[] m_checks = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameterName() != null || para[i].getParameter_To() != null) {
                if (name.equals("PaymentRule")) {
                    this.p_PaymentRule = para[i].getParameterAsString();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Paramtere :" + name);
                }
            }
            this.p_C_PaySelection_ID = this.getRecord_ID();
            this.processUI = Env.getProcessUI((Properties)this.getCtx());
            ++i;
        }
    }

    protected String doIt() throws Exception {
        MPaySelection paySelection = new MPaySelection(this.getCtx(), this.p_C_PaySelection_ID, this.get_TrxName());
        this.p_C_BankAccount_ID = paySelection.getC_BankAccount_ID();
        MBankAccount bankAccount = new MBankAccount(this.getCtx(), this.p_C_BankAccount_ID, this.get_TrxName());
        this.m_PaymentExportClass = bankAccount.getPaymentExportClass();
        if (!this.getChecks(this.p_PaymentRule)) {
            return Msg.getMsg((Properties)this.getCtx(), (String)"FindZeroRecords");
        }
        int no = 0;
        StringBuffer err = new StringBuffer("");
        try {
            File tempFile = File.createTempFile("paymentExport", ".txt");
            if (this.m_PaymentExportClass == null || this.m_PaymentExportClass.trim().length() == 0) {
                this.m_PaymentExportClass = "org.compiere.util.GenericPaymentExport";
            }
            PaymentExport custom = null;
            try {
                Class<?> clazz = Class.forName(this.m_PaymentExportClass);
                custom = (PaymentExport)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                no = custom.exportToFile(this.m_checks, tempFile, err);
            }
            catch (ClassNotFoundException e) {
                no = -1;
                err.append(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"JP_ClassNotFound")) + this.m_PaymentExportClass + " - " + e.toString());
                this.log.log(Level.SEVERE, err.toString(), (Throwable)e);
            }
            catch (Exception e) {
                no = -1;
                err.append(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + this.m_PaymentExportClass + " check log, " + e.toString());
                this.log.log(Level.SEVERE, err.toString(), (Throwable)e);
            }
            if (no >= 0) {
                String AccountNo = bankAccount.getAccountNo();
                String payDateString = paySelection.getPayDate().toString().substring(0, 10).replace("-", "");
                LocalDateTime dateTime = LocalDateTime.now();
                int downloadNum = 0;
                if (paySelection.get_ColumnIndex("JP_DownloadNum") > 0) {
                    downloadNum = paySelection.get_ValueAsInt("JP_DownloadNum");
                    paySelection.set_ValueNoCheck("JP_DownloadNum", (Object)(++downloadNum));
                    paySelection.saveEx(this.get_TrxName());
                }
                Path inputPath = FileSystems.getDefault().getPath(tempFile.getAbsolutePath(), new String[0]);
                Path outputPath = FileSystems.getDefault().getPath("ExpPayment_" + AccountNo + "_" + payDateString + (downloadNum == 0 ? "" : "_" + downloadNum) + "_" + dateTime.truncatedTo(ChronoUnit.SECONDS).toString().replace(":", "").replace("-", "") + ".txt", new String[0]);
                Files.copy(inputPath, outputPath, new CopyOption[0]);
                tempFile.delete();
                this.processUI.download(new File(outputPath.toString()));
            }
        }
        catch (Exception e) {
            System.out.println(e);
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
            return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"Error")) + " : " + e.toString();
        }
        if (no == -1) {
            throw new Exception(err.toString());
        }
        return String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"ProcessOK")) + " : " + paySelection.getName();
    }

    private boolean getChecks(String PaymentRule) {
        if (this.p_C_PaySelection_ID <= 0 || this.p_C_BankAccount_ID <= 0 || this.p_PaymentRule == null) {
            return false;
        }
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config("C_PaySelection_ID=" + this.p_C_PaySelection_ID + ", PaymentRule=" + PaymentRule);
        }
        this.m_checks = MPaySelectionCheck.get((int)this.p_C_PaySelection_ID, (String)this.p_PaymentRule, null);
        return this.m_checks != null && this.m_checks.length != 0;
    }
}

