/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.IProcessUI;
import org.compiere.model.MPInstance;
import org.compiere.model.MProcess;
import org.compiere.model.Query;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.wf.MWFActivity;

public class WFActivityRespBulkUpdate
extends SvrProcess {
    private static final int PROCESS_Manage_Activity = 278;
    private int p_AD_Client_ID = 0;
    private int p_AD_Workflow_ID = 0;
    private int p_AD_WF_Responsible_ID = 0;
    private int p_AD_WF_RespSubstitute_ID = 0;
    private int p_AD_Org_ID = 0;
    private int p_AD_User_ID = 0;
    private Timestamp p_Created_From = null;
    private Timestamp p_Created_To = null;

    protected void prepare() {
        this.p_AD_Client_ID = this.getProcessInfo().getAD_Client_ID();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("AD_WF_Responsible_ID")) {
                    this.p_AD_WF_Responsible_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_WF_RespSubstitute_ID")) {
                    this.p_AD_WF_RespSubstitute_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_Workflow_ID")) {
                    this.p_AD_Workflow_ID = para[i].getParameterAsInt();
                } else if (name.equals("Created")) {
                    this.p_Created_From = (Timestamp)para[i].getParameter();
                    this.p_Created_To = (Timestamp)para[i].getParameter_To();
                    Calendar cal = Calendar.getInstance();
                    cal.setTimeInMillis(this.p_Created_To.getTime());
                    cal.add(5, 1);
                    this.p_Created_To = new Timestamp(cal.getTimeInMillis());
                } else if (name.equals("AD_Org_ID")) {
                    this.p_AD_Org_ID = para[i].getParameterAsInt();
                } else if (name.equals("AD_User_ID")) {
                    this.p_AD_User_ID = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        StringBuilder whereClause = new StringBuilder("AD_WF_Responsible_ID = ? AND AD_Workflow_ID= ? AND AD_Client_ID = ? AND Processed = 'N' AND WFState = 'OS' ");
        ArrayList<Comparable<Integer>> getWFActivitiesParamList = new ArrayList<Comparable<Integer>>();
        getWFActivitiesParamList.add(Integer.valueOf(this.p_AD_WF_Responsible_ID));
        getWFActivitiesParamList.add(Integer.valueOf(this.p_AD_Workflow_ID));
        getWFActivitiesParamList.add(Integer.valueOf(this.p_AD_Client_ID));
        if (this.p_AD_Org_ID != 0) {
            whereClause.append("AND AD_Org_ID = ? ");
            getWFActivitiesParamList.add(Integer.valueOf(this.p_AD_Org_ID));
        }
        if (this.p_AD_User_ID != 0) {
            whereClause.append("AND AD_User_ID = ? ");
            getWFActivitiesParamList.add(Integer.valueOf(this.p_AD_User_ID));
        }
        if (this.p_Created_From != null) {
            whereClause.append("AND Created >= ? ");
            getWFActivitiesParamList.add(this.p_Created_From);
        }
        if (this.p_Created_To != null) {
            whereClause.append("AND Created <= ? ");
            getWFActivitiesParamList.add(this.p_Created_To);
        }
        List list = new Query(this.getCtx(), "AD_WF_Activity", whereClause.toString(), this.get_TrxName()).setParameters(getWFActivitiesParamList).list();
        MWFActivity[] activities = list.toArray(new MWFActivity[list.size()]);
        ProcessInfoParameter[] pipParams = new ProcessInfoParameter[]{new ProcessInfoParameter("AD_WF_Responsible_ID", (Object)this.p_AD_WF_RespSubstitute_ID, null, null, null)};
        IProcessUI processMonitor = Env.getProcessUI((Properties)this.getCtx());
        int success = 0;
        int failure = 0;
        int i = 0;
        while (i < activities.length) {
            MProcess process = MProcess.get((Properties)this.getCtx(), (int)278);
            MPInstance pInstance = new MPInstance(process, 0);
            ProcessInfo pi = new ProcessInfo(process.getName(), 278, 644, activities[i].getAD_WF_Activity_ID());
            pi.setParameter(pipParams);
            pi.setAD_User_ID(this.getAD_User_ID());
            pi.setAD_Client_ID(this.getAD_Client_ID());
            pi.setAD_PInstance_ID(pInstance.getAD_PInstance_ID());
            boolean isOK = process.processItWithoutTrxClose(pi, Trx.get((String)this.get_TrxName(), (boolean)false));
            if (!isOK) {
                ++failure;
            } else {
                ++success;
                String msg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"AD_WF_Process_ID")) + " " + Msg.getElement((Properties)this.getCtx(), (String)"TextMsg") + " => " + activities[i].getAD_WF_Process().getTextMsg();
                this.addBufferLog(0, null, null, msg, 644, activities[i].get_ID());
                if (processMonitor != null) {
                    processMonitor.statusUpdate(msg);
                } else {
                    processMonitor = Env.getProcessUI((Properties)this.getCtx());
                }
            }
            ++i;
        }
        return "Success = " + success + "    Failure" + " = " + failure;
    }
}

