/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import jpiere.base.plugin.org.adempiere.model.MInvValProfile;
import jpiere.base.plugin.org.adempiere.model.MInvValProfileOrg;
import jpiere.base.plugin.util.JPiereInvValUtil;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MCostElement;
import org.compiere.model.MPriceListVersion;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategoryAcct;
import org.compiere.model.MProductPrice;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class UpdateCostFromPriceList
extends SvrProcess {
    MInvValProfile m_InvValProfile = null;
    MInvValProfileOrg[] profileOrgs = null;
    int Record_ID = 0;
    Timestamp p_DateValue = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("DateValue")) {
                    this.p_DateValue = para[i].getParameterAsTimestamp();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.Record_ID = this.getRecord_ID();
        if (this.Record_ID > 0) {
            this.m_InvValProfile = new MInvValProfile(this.getCtx(), this.Record_ID, null);
            this.profileOrgs = this.m_InvValProfile.getOrgs();
        } else {
            this.log.log(Level.SEVERE, "Record_ID <= 0 ");
        }
    }

    protected String doIt() throws Exception {
        if (this.m_InvValProfile.getJP_UpdateCost() == null) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"JP_UpdateCost"));
        }
        if (this.m_InvValProfile.getM_PriceList_ID() == 0) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_ID"));
        }
        if (this.p_DateValue == null) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"FillMandatory")) + Msg.getElement((Properties)this.getCtx(), (String)"DateValue"));
        }
        MCostElement[] costElements = JPiereInvValUtil.getMaterialStandardCostElements(this.getCtx());
        int C_AcctSchema_ID = this.m_InvValProfile.getC_AcctSchema_ID();
        int M_CostType_ID = this.m_InvValProfile.getC_AcctSchema().getM_CostType_ID();
        int M_PriceList_ID = this.m_InvValProfile.getM_PriceList_ID();
        MPriceListVersion m_PriceList_Version = JPiereInvValUtil.getPriceListVersion(this.getCtx(), M_PriceList_ID, this.p_DateValue, this.get_TrxName());
        if (m_PriceList_Version == null) {
            throw new Exception(String.valueOf(Msg.getMsg((Properties)this.getCtx(), (String)"NotFound")) + " : " + Msg.getElement((Properties)this.getCtx(), (String)"M_PriceList_Version_ID"));
        }
        MProductPrice[] m_ProductPrices = m_PriceList_Version.getProductPrice(true);
        if (this.m_InvValProfile.getCostingLevel().equals("C")) {
            int i = 0;
            while (i < m_ProductPrices.length) {
                this.uppdateCostFromPriceList(m_ProductPrices[i], costElements, M_CostType_ID, C_AcctSchema_ID, 0);
                ++i;
            }
        } else if (this.m_InvValProfile.getCostingLevel().equals("O")) {
            int i = 0;
            while (i < this.profileOrgs.length) {
                int j = 0;
                while (j < m_ProductPrices.length) {
                    this.uppdateCostFromPriceList(m_ProductPrices[j], costElements, M_CostType_ID, C_AcctSchema_ID, this.profileOrgs[i].getAD_Org_ID());
                    ++j;
                }
                ++i;
            }
        } else if (this.m_InvValProfile.getCostingLevel().equals("B")) {
            // empty if block
        }
        return Msg.getMsg((Properties)this.getCtx(), (String)"Success");
    }

    private void uppdateCostFromPriceList(MProductPrice m_ProductPrice, MCostElement[] costElements, int M_CostType_ID, int C_AcctSchema_ID, int AD_Org_ID) {
        if (this.m_InvValProfile.getM_Product_Category_ID() != 0 && m_ProductPrice.getM_Product().getM_Product_Category_ID() != this.m_InvValProfile.getM_Product_Category_ID()) {
            return;
        }
        MProductCategoryAcct m_ProductCategoryAcct = MProductCategoryAcct.get((Properties)this.getCtx(), (int)m_ProductPrice.getM_Product().getM_Product_Category_ID(), (int)C_AcctSchema_ID, (String)this.get_TrxName());
        if (m_ProductCategoryAcct == null) {
            return;
        }
        if (!Util.isEmpty((String)m_ProductCategoryAcct.getCostingLevel()) && !m_ProductCategoryAcct.getCostingLevel().equals(this.m_InvValProfile.getCostingLevel())) {
            return;
        }
        int M_Product_ID = m_ProductPrice.getM_Product_ID();
        int i = 0;
        while (i < costElements.length) {
            MCost cost = MCost.get((Properties)this.getCtx(), (int)Env.getAD_Client_ID((Properties)this.getCtx()), (int)AD_Org_ID, (int)M_Product_ID, (int)M_CostType_ID, (int)C_AcctSchema_ID, (int)costElements[i].get_ID(), (int)0, (String)this.get_TrxName());
            if (cost == null) {
                cost = new MCost(new MProduct(this.getCtx(), M_Product_ID, this.get_TrxName()), 0, MAcctSchema.get((Properties)this.getCtx(), (int)C_AcctSchema_ID, (String)this.get_TrxName()), AD_Org_ID, costElements[i].getM_CostElement_ID());
            }
            if (this.m_InvValProfile.getJP_UpdateCost().equals("CC")) {
                cost.setCurrentCostPrice(m_ProductPrice.getPriceStd());
            } else if (this.m_InvValProfile.getJP_UpdateCost().equals("FC")) {
                cost.setFutureCostPrice(m_ProductPrice.getPriceStd());
            } else if (this.m_InvValProfile.getJP_UpdateCost().equals("BT")) {
                cost.setCurrentCostPrice(m_ProductPrice.getPriceStd());
                cost.setFutureCostPrice(m_ProductPrice.getPriceList());
            }
            cost.saveEx(this.get_TrxName());
            ++i;
        }
    }
}

