/*
 * Decompiled with CFR 0.152.
 */
package jpiere.base.plugin.org.adempiere.process;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.util.IProcessUI;
import org.adempiere.util.ProcessUtil;
import org.compiere.model.MElementValue;
import org.compiere.model.MTree_Base;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;

public class TrialBalanceBulkCreate
extends SvrProcess {
    private int p_C_ElementValue_ID = 0;
    private int p_AD_Tree_Account_ID = 0;
    private int successNum = 0;
    private int failureNum = 0;

    protected void prepare() {
        this.processUI = Env.getProcessUI((Properties)this.getCtx());
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("C_ElementValue_ID")) {
                this.p_C_ElementValue_ID = para[i].getParameterAsInt();
            } else if (name.equals("AD_Tree_ID")) {
                this.p_AD_Tree_Account_ID = para[i].getParameterAsInt();
            }
            ++i;
        }
    }

    protected String doIt() throws Exception {
        ArrayList<MElementValue> list = new ArrayList<MElementValue>();
        if (this.p_C_ElementValue_ID == 0) {
            this.loadAccount(list);
        } else {
            this.loadAccount(list, new MElementValue(this.getCtx(), this.p_C_ElementValue_ID, this.get_TrxName()));
        }
        String className = "org.compiere.report.TrialBalance";
        ProcessInfo pi = new ProcessInfo("Trial Balance Bulk Create", 0);
        pi.setClassName(className);
        pi.setAD_Client_ID(this.getAD_Client_ID());
        pi.setAD_User_ID(this.getAD_User_ID());
        pi.setAD_PInstance_ID(this.getAD_PInstance_ID());
        pi.setRecord_ID(0);
        for (MElementValue account : list) {
            if (this.processUI != null) {
                this.processUI.statusUpdate(String.valueOf(account.getValue()) + " -  " + account.getName());
            }
            this.setProcessInfoParameter(pi, account.getC_ElementValue_ID());
            if (ProcessUtil.startJavaProcess((Properties)this.getCtx(), (ProcessInfo)pi, (Trx)Trx.get((String)this.get_TrxName(), (boolean)true), (boolean)false, (IProcessUI)this.processUI)) {
                ++this.successNum;
                continue;
            }
            ++this.failureNum;
        }
        if (this.processUI != null) {
            this.processUI.statusUpdate(Msg.getMsg((Properties)this.getCtx(), (String)"Processing"));
        }
        int totalElementValue = this.successNum + this.failureNum;
        String msg = String.valueOf(Msg.getElement((Properties)this.getCtx(), (String)"Account_ID")) + " : " + totalElementValue + " " + " ( " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Success") + " : " + this.successNum + " + " + Msg.getMsg((Properties)this.getCtx(), (String)"JP_Failure") + " : " + this.failureNum + " ) ";
        this.addLog(msg);
        return msg;
    }

    private void loadAccount(ArrayList<MElementValue> list) {
        block6: {
            MTree_Base tree = MTree_Base.get((Properties)this.getCtx(), (int)this.p_AD_Tree_Account_ID, (String)this.get_TrxName());
            String sql = "SELECT * FROM C_ElementValue WHERE IsActive='Y' AND C_ElementValue_ID IN (SELECT Node_ID FROM " + tree.getNodeTableName() + " WHERE AD_Tree_ID=? AND (Parent_ID IS NULL OR Parent_ID = 0 ) AND IsActive='Y') ORDER BY Value";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, tree.getAD_Tree_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.loadAccount(list, new MElementValue(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private void loadAccount(ArrayList<MElementValue> list, MElementValue ev) {
        block8: {
            if (list.contains(ev)) {
                return;
            }
            if (!ev.isSummary()) {
                list.add(ev);
                return;
            }
            MTree_Base tree = MTree_Base.get((Properties)this.getCtx(), (int)this.p_AD_Tree_Account_ID, (String)this.get_TrxName());
            String sql = "SELECT * FROM C_ElementValue WHERE IsActive='Y' AND C_ElementValue_ID IN (SELECT Node_ID FROM " + tree.getNodeTableName() + " WHERE AD_Tree_ID=? AND Parent_ID=? AND IsActive='Y') ORDER BY Value";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, (String)this.get_TrxName());
                    pstmt.setInt(1, tree.getAD_Tree_ID());
                    pstmt.setInt(2, ev.getC_ElementValue_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        this.loadAccount(list, new MElementValue(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    break block8;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
    }

    private void setProcessInfoParameter(ProcessInfo pi, int Account_ID) throws Exception {
        ArrayList<ProcessInfoParameter> list = new ArrayList<ProcessInfoParameter>();
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (name.equals("C_AcctSchema_ID")) {
                list.add(para[i]);
            } else if (name.equals("C_Period_ID")) {
                list.add(para[i]);
            } else if (name.equals("DateAcct")) {
                list.add(para[i]);
            } else if (name.equals("PA_Hierarchy_ID")) {
                list.add(para[i]);
            } else if (name.equals("AD_Org_ID")) {
                list.add(para[i]);
            } else if (name.equals("C_ElementValue_ID")) {
                list.add(new ProcessInfoParameter("Account_ID", (Object)BigDecimal.valueOf(Account_ID), null, para[i].getInfo(), para[i].getInfo_To()));
            } else if (name.equals("AccountValue")) {
                list.add(para[i]);
            } else if (name.equals("C_BPartner_ID")) {
                list.add(para[i]);
            } else if (name.equals("M_Product_ID")) {
                list.add(para[i]);
            } else if (name.equals("C_Project_ID")) {
                list.add(para[i]);
            } else if (name.equals("C_Activity_ID")) {
                list.add(para[i]);
            } else if (name.equals("C_SalesRegion_ID")) {
                list.add(para[i]);
            } else if (name.equals("C_Campaign_ID")) {
                list.add(para[i]);
            } else if (name.equals("PostingType")) {
                list.add(para[i]);
            } else if (!name.equals("AD_Tree_ID")) {
                list.add(para[i]);
            }
            ++i;
        }
        ProcessInfoParameter[] pars = new ProcessInfoParameter[list.size()];
        list.toArray(pars);
        pi.setParameter(pars);
    }
}

